/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.adempiere.exceptions.DBException;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.Adempiere;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.AWindow;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.search.PAttributeInstance;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MOrder;
import org.compiere.model.MProduct;
import org.compiere.model.MQuery;
import org.compiere.model.MRefList;
import org.compiere.model.MRequisition;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_M_Forecast;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MPPMRP;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPProductPlanning;

public class VMRPDetailed
extends CPanel
implements FormPanel,
ActionListener,
VetoableChangeListener,
ChangeListener,
ListSelectionListener,
TableModelListener,
ASyncProcess {
    private static final long serialVersionUID = 1L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private StatusBar statusBar = new StatusBar();
    private int AD_Client_ID = Env.getAD_Client_ID(this.getCtx());
    private static CLogger log = CLogger.getCLogger(VMRPDetailed.class);
    protected int p_WindowNo;
    protected String p_keyColumn;
    protected boolean p_multiSelection = true;
    protected String p_whereClause = "";
    protected MiniTable p_table = new MiniTable();
    private int m_keyColumnIndex = -1;
    private boolean m_cancel = false;
    protected ColumnInfo[] p_layout;
    private String m_sqlMain;
    private String m_sqlAdd;
    private Worker m_worker = null;
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    ConfirmPanel confirmPanel = new ConfirmPanel(true, true, true, true, true, true, true);
    protected CPanel parameterPanel = new CPanel();
    private JScrollPane scrollPane = new JScrollPane();
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem calcMenu = new JMenuItem();
    static final int INFO_WIDTH = 800;
    private CLabel lProduct_ID = new CLabel(Msg.translate(this.getCtx(), "M_Product_ID"));
    private VLookup fProduct_ID;
    private CLabel lAttrSetInstance_ID = new CLabel(Msg.translate(this.getCtx(), "M_AttributeSetInstance_ID"));
    private CButton fAttrSetInstance_ID;
    private CLabel lResource_ID = new CLabel(Msg.translate(this.getCtx(), "S_Resource_ID"));
    private VLookup fResource_ID;
    private CLabel lWarehouse_ID = new CLabel(Msg.translate(this.getCtx(), "M_Warehouse_ID"));
    private VLookup fWarehouse_ID;
    private CLabel lPlanner_ID = new CLabel(Msg.translate(this.getCtx(), "Planner_ID"));
    private VLookup fPlanner_ID;
    private CLabel lDateFrom = new CLabel(Msg.translate(this.getCtx(), "DateFrom"));
    private VDate fDateFrom = new VDate("DateFrom", false, false, true, 15, Msg.translate(this.getCtx(), "DateFrom")){
        private static final long serialVersionUID = 1L;

        @Override
        public void setValue(Object object) {
            super.setValue(object);
        }
    };
    private CLabel lDateTo = new CLabel(Msg.translate(this.getCtx(), "DateTo"));
    private VDate fDateTo = new VDate("DateTo", false, false, true, 15, Msg.translate(this.getCtx(), "DateTo")){
        private static final long serialVersionUID = 1L;

        @Override
        public void setValue(Object object) {
            super.setValue(object);
        }
    };
    private CLabel lType = new CLabel();
    private CTextField fType = new CTextField(6);
    private CLabel lUOM = new CLabel();
    private CTextField fUOM = new CTextField(5);
    private CLabel lOrderPeriod = new CLabel();
    private VNumber fOrderPeriod = new VNumber();
    private CLabel lTimefence = new CLabel();
    private VNumber fTimefence = new VNumber();
    private CLabel lLeadtime = new CLabel();
    private VNumber fLeadtime = new VNumber();
    private CLabel lReplenishMin = new CLabel();
    private VNumber fReplenishMin = new VNumber();
    private CLabel lMinOrd = new CLabel();
    private VNumber fMinOrd = new VNumber();
    private CLabel lMaxOrd = new CLabel();
    private VNumber fMaxOrd = new VNumber();
    private CLabel lOrdMult = new CLabel();
    private VNumber fOrdMult = new VNumber();
    private CLabel lOrderQty = new CLabel();
    private VNumber fOrderQty = new VNumber();
    private CLabel lYield = new CLabel();
    private VNumber fYield = new VNumber();
    private CLabel lOnhand = new CLabel();
    private VNumber fOnhand = new VNumber();
    private CLabel lSafetyStock = new CLabel();
    private VNumber fSafetyStock = new VNumber();
    private CLabel lOrdered = new CLabel();
    private VNumber fOrdered = new VNumber();
    private CLabel lReserved = new CLabel();
    private VNumber fReserved = new VNumber();
    private CLabel lAvailable = new CLabel();
    private VNumber fAvailable = new VNumber();
    private CLabel lSupplyType = new CLabel(Msg.translate(this.getCtx(), "TypeMRP"));
    private VLookup fSupplyType = null;
    private VCheckBox fMaster = new VCheckBox("IsMPS", false, false, true, Msg.translate(this.getCtx(), "IsMPS"), "", false);
    private VCheckBox fMRPReq = new VCheckBox("IsRequiredMRP", false, false, true, Msg.translate(this.getCtx(), "IsRequiredMRP"), "", false);
    private VCheckBox fCreatePlan = new VCheckBox("IsCreatePlan", false, false, true, Msg.translate(this.getCtx(), "IsCreatePlan"), "", false);
    private static boolean isBaseLanguage;
    private static final ColumnInfo[] m_layout;
    private JTabbedPane OrderPlanning;
    private JPanel PanelBottom;
    private JPanel PanelCenter;
    private JPanel PanelFind;
    private JPanel PanelOrder;
    private JPanel Results;
    private JPanel mainPanel;

    public VMRPDetailed() {
        this.initComponents();
    }

    @Override
    public void init(int n, FormFrame formFrame) {
        this.m_WindowNo = n;
        this.m_frame = formFrame;
        Env.setContext(this.getCtx(), this.m_WindowNo, "IsSOTrx", "N");
        try {
            this.statInit();
            this.fillPicks();
            this.jbInit();
            this.m_frame.getContentPane().add((Component)this.mainPanel, "Center");
            this.m_frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "VMRPDetailed.init", exception);
        }
    }

    private void statInit() throws Exception {
        Language language = Language.getLoginLanguage();
        MLookup mLookup = MLookupFactory.get(this.getCtx(), this.p_WindowNo, MColumn.getColumn_ID("S_Resource", "S_Resource_ID"), 19, language, "S_Resource_ID", 0, false, "S_Resource.ManufacturingResourceType= 'PT'");
        this.fResource_ID = new VLookup("S_Resource_ID", false, false, true, mLookup){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValue(Object object) {
                super.setValue(object);
            }
        };
        this.lResource_ID.setLabelFor(this.fResource_ID);
        this.fResource_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fPlanner_ID = new VLookup("Planner_ID", false, false, true, MLookupFactory.get(this.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("PP_Product_Planning", "Planner_ID"), 18)){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValue(Object object) {
                super.setValue(object);
            }
        };
        this.lPlanner_ID.setLabelFor(this.fPlanner_ID);
        this.fPlanner_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fWarehouse_ID = new VLookup("M_Warehouse_ID", false, false, true, MLookupFactory.get(this.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("M_Warehouse", "M_Warehouse_ID"), 19)){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValue(Object object) {
                super.setValue(object);
            }
        };
        this.lWarehouse_ID.setLabelFor(this.fWarehouse_ID);
        this.fWarehouse_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fMaster.setSelected(false);
        this.fMaster.setReadWrite(false);
        this.fMRPReq.setSelected(false);
        this.fMRPReq.setReadWrite(false);
        this.fCreatePlan.setSelected(false);
        this.fCreatePlan.setReadWrite(false);
        this.lUOM.setText(Msg.translate(this.getCtx(), "C_UOM_ID"));
        this.fUOM.setBackground(AdempierePLAF.getInfoBackground());
        this.fUOM.setReadWrite(false);
        this.lType.setText(Msg.translate(this.getCtx(), "Order_Policy"));
        this.fType.setBackground(AdempierePLAF.getInfoBackground());
        this.fType.setReadWrite(false);
        this.lOrderPeriod.setText(Msg.translate(this.getCtx(), "Order_Period"));
        this.fOrderPeriod.setBackground(AdempierePLAF.getInfoBackground());
        this.fOrderPeriod.setReadWrite(false);
        this.lTimefence.setText(Msg.translate(this.getCtx(), "TimeFence"));
        this.fTimefence.setBackground(AdempierePLAF.getInfoBackground());
        this.fTimefence.setReadWrite(false);
        this.lLeadtime.setText(Msg.translate(this.getCtx(), "DeliveryTime_Promised"));
        this.fLeadtime.setBackground(AdempierePLAF.getInfoBackground());
        this.fLeadtime.setReadWrite(false);
        this.lMinOrd.setText(Msg.translate(this.getCtx(), "Order_Min"));
        this.fMinOrd.setBackground(AdempierePLAF.getInfoBackground());
        this.fMinOrd.setReadWrite(false);
        this.lMaxOrd.setText(Msg.translate(this.getCtx(), "Order_Max"));
        this.fMaxOrd.setBackground(AdempierePLAF.getInfoBackground());
        this.fMaxOrd.setReadWrite(false);
        this.lOrdMult.setText(Msg.translate(this.getCtx(), "Order_Pack"));
        this.fOrdMult.setBackground(AdempierePLAF.getInfoBackground());
        this.fOrdMult.setReadWrite(false);
        this.lOrderQty.setText(Msg.translate(this.getCtx(), "Order_Qty"));
        this.fOrderQty.setBackground(AdempierePLAF.getInfoBackground());
        this.fOrderQty.setReadWrite(false);
        this.lYield.setText(Msg.translate(this.getCtx(), "Yield"));
        this.fYield.setBackground(AdempierePLAF.getInfoBackground());
        this.fYield.setReadWrite(false);
        this.lOnhand.setText(Msg.translate(this.getCtx(), "QtyOnHand"));
        this.fOnhand.setBackground(AdempierePLAF.getInfoBackground());
        this.fOnhand.setReadWrite(false);
        this.lSafetyStock.setText(Msg.translate(this.getCtx(), "SafetyStock"));
        this.fSafetyStock.setBackground(AdempierePLAF.getInfoBackground());
        this.fSafetyStock.setReadWrite(false);
        this.lReserved.setText(Msg.translate(this.getCtx(), "QtyReserved"));
        this.fReserved.setBackground(AdempierePLAF.getInfoBackground());
        this.fReserved.setReadWrite(false);
        this.lAvailable.setText(Msg.translate(this.getCtx(), "QtyAvailable"));
        this.fAvailable.setBackground(AdempierePLAF.getInfoBackground());
        this.fAvailable.setReadWrite(false);
        this.lOrdered.setText(Msg.translate(this.getCtx(), "QtyOrdered"));
        this.fOrdered.setBackground(AdempierePLAF.getInfoBackground());
        this.fOrdered.setReadWrite(false);
        this.fProduct_ID = new VLookup("M_Product_ID", true, false, true, MLookupFactory.get(this.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("M_Product", "M_Product_ID"), 30)){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValue(Object object) {
                super.setValue(object);
                VMRPDetailed.this.fAttrSetInstance_ID.setValue(new Integer(0));
            }
        };
        this.fAttrSetInstance_ID = new CButton(){
            private static final long serialVersionUID = 1L;
            private Object value;

            @Override
            public void setText(String string) {
                if (string == null) {
                    string = "---";
                }
                if (string.length() > 23) {
                    string = string.substring(0, 20) + "...";
                }
                super.setText(string);
            }

            @Override
            public void setValue(Object object) {
                int n;
                this.value = object;
                int n2 = n = object instanceof Integer ? (Integer)object : 0;
                if (n == 0) {
                    this.setText(null);
                }
            }

            @Override
            public Object getValue() {
                return this.value;
            }
        };
        this.fAttrSetInstance_ID.setValue(new Integer(0));
        this.fAttrSetInstance_ID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VMRPDetailed.this.selectAttributeSetInstance();
            }
        });
        this.lProduct_ID.setLabelFor(this.fProduct_ID);
        this.fProduct_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.lDateFrom.setLabelFor(this.fDateFrom);
        this.fDateFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateFrom.setToolTipText(Msg.translate(this.getCtx(), "DateFrom"));
        this.lDateTo.setLabelFor(this.fDateTo);
        this.fDateTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateTo.setToolTipText(Msg.translate(this.getCtx(), "DateTo"));
        this.fSupplyType = new VLookup("TypeMRP", false, false, true, MLookupFactory.get(this.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("PP_MRP", "TypeMRP"), 17));
        this.lSupplyType.setLabelFor(this.fSupplyType);
        this.fSupplyType.setBackground(AdempierePLAF.getInfoBackground());
        this.parameterPanel.setLayout(new ALayout());
        this.parameterPanel.add((Component)this.lProduct_ID, new ALayoutConstraint(0, 0));
        this.parameterPanel.add((Component)this.fProduct_ID, new ALayoutConstraint(0, 1));
        this.parameterPanel.add((Component)this.lUOM, new ALayoutConstraint(0, 2));
        this.parameterPanel.add((Component)this.fUOM, new ALayoutConstraint(0, 3));
        this.parameterPanel.add((Component)this.lType, new ALayoutConstraint(0, 4));
        this.parameterPanel.add((Component)this.fType, new ALayoutConstraint(0, 5));
        this.parameterPanel.add((Component)this.lAttrSetInstance_ID, new ALayoutConstraint(1, 0));
        this.parameterPanel.add((Component)this.fAttrSetInstance_ID, new ALayoutConstraint(1, 1));
        this.parameterPanel.add((Component)this.lOnhand, new ALayoutConstraint(1, 2));
        this.parameterPanel.add((Component)this.fOnhand, new ALayoutConstraint(1, 3));
        this.parameterPanel.add((Component)this.lOrderPeriod, new ALayoutConstraint(1, 4));
        this.parameterPanel.add((Component)this.fOrderPeriod, new ALayoutConstraint(1, 5));
        this.parameterPanel.add((Component)this.lPlanner_ID, new ALayoutConstraint(2, 0));
        this.parameterPanel.add((Component)this.fPlanner_ID, new ALayoutConstraint(2, 1));
        this.parameterPanel.add((Component)this.lSafetyStock, new ALayoutConstraint(2, 2));
        this.parameterPanel.add((Component)this.fSafetyStock, new ALayoutConstraint(2, 3));
        this.parameterPanel.add((Component)this.lMinOrd, new ALayoutConstraint(2, 4));
        this.parameterPanel.add((Component)this.fMinOrd, new ALayoutConstraint(2, 5));
        this.parameterPanel.add((Component)this.lWarehouse_ID, new ALayoutConstraint(3, 0));
        this.parameterPanel.add((Component)this.fWarehouse_ID, new ALayoutConstraint(3, 1));
        this.parameterPanel.add((Component)this.lReserved, new ALayoutConstraint(3, 2));
        this.parameterPanel.add((Component)this.fReserved, new ALayoutConstraint(3, 3));
        this.parameterPanel.add((Component)this.lMaxOrd, new ALayoutConstraint(3, 4));
        this.parameterPanel.add((Component)this.fMaxOrd, new ALayoutConstraint(3, 5));
        this.parameterPanel.add((Component)this.lResource_ID, new ALayoutConstraint(4, 0));
        this.parameterPanel.add((Component)this.fResource_ID, new ALayoutConstraint(4, 1));
        this.parameterPanel.add((Component)this.lAvailable, new ALayoutConstraint(4, 2));
        this.parameterPanel.add((Component)this.fAvailable, new ALayoutConstraint(4, 3));
        this.parameterPanel.add((Component)this.lOrdMult, new ALayoutConstraint(4, 4));
        this.parameterPanel.add((Component)this.fOrdMult, new ALayoutConstraint(4, 5));
        this.parameterPanel.add((Component)this.lDateFrom, new ALayoutConstraint(5, 0));
        this.parameterPanel.add((Component)this.fDateFrom, new ALayoutConstraint(5, 1));
        this.parameterPanel.add((Component)this.lOrdered, new ALayoutConstraint(5, 2));
        this.parameterPanel.add((Component)this.fOrdered, new ALayoutConstraint(5, 3));
        this.parameterPanel.add((Component)this.lOrderQty, new ALayoutConstraint(5, 4));
        this.parameterPanel.add((Component)this.fOrderQty, new ALayoutConstraint(5, 5));
        this.parameterPanel.add((Component)this.lDateTo, new ALayoutConstraint(6, 0));
        this.parameterPanel.add((Component)this.fDateTo, new ALayoutConstraint(6, 1));
        this.parameterPanel.add((Component)this.lTimefence, new ALayoutConstraint(6, 4));
        this.parameterPanel.add((Component)this.fTimefence, new ALayoutConstraint(6, 5));
        this.parameterPanel.add((Component)this.fMaster, new ALayoutConstraint(7, 1));
        this.parameterPanel.add((Component)this.fCreatePlan, new ALayoutConstraint(7, 3));
        this.parameterPanel.add((Component)this.lLeadtime, new ALayoutConstraint(7, 4));
        this.parameterPanel.add((Component)this.fLeadtime, new ALayoutConstraint(7, 5));
        this.parameterPanel.add((Component)this.fMRPReq, new ALayoutConstraint(8, 3));
        this.parameterPanel.add((Component)this.lYield, new ALayoutConstraint(8, 4));
        this.parameterPanel.add((Component)this.fYield, new ALayoutConstraint(8, 5));
    }

    private void selectAttributeSetInstance() {
        int n = this.getM_Warehouse_ID();
        int n2 = this.getM_Product_ID();
        if (n2 <= 0) {
            return;
        }
        MProduct mProduct = MProduct.get(this.getCtx(), n2);
        MWarehouse mWarehouse = MWarehouse.get(this.getCtx(), n);
        String string = mProduct.get_Translation("Name") + " - " + mWarehouse.get_Translation("Name");
        PAttributeInstance pAttributeInstance = new PAttributeInstance(this.m_frame, string, n, 0, n2, 0);
        if (pAttributeInstance.getM_AttributeSetInstance_ID() != -1) {
            this.fAttrSetInstance_ID.setText(pAttributeInstance.getM_AttributeSetInstanceName());
            this.fAttrSetInstance_ID.setValue(new Integer(pAttributeInstance.getM_AttributeSetInstance_ID()));
        } else {
            this.fAttrSetInstance_ID.setValue(0);
        }
    }

    private boolean isAttributeSetInstance() {
        return this.getM_AttributeSetInstance_ID() > 0;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.OrderPlanning = new JTabbedPane();
        this.PanelOrder = new JPanel();
        this.PanelFind = new JPanel();
        this.PanelCenter = new JPanel();
        this.PanelBottom = new JPanel();
        this.Results = new JPanel();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.PanelOrder.setLayout(new BorderLayout());
        this.PanelOrder.add((Component)this.PanelFind, "North");
        this.PanelOrder.add((Component)this.PanelCenter, "Center");
        this.PanelOrder.add((Component)this.PanelBottom, "South");
        this.OrderPlanning.addTab("Order", this.PanelOrder);
        this.OrderPlanning.addTab("Results", this.Results);
        this.mainPanel.add((Component)this.OrderPlanning, "Center");
        this.add((Component)this.mainPanel, "Center");
    }

    protected void jbInit() throws Exception {
        this.mainPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.southPanel.setLayout(this.southLayout);
        this.southPanel.add((Component)this.confirmPanel, "Center");
        this.southPanel.add((Component)this.statusBar, "South");
        this.mainPanel.add((Component)this.southPanel, "South");
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.p_table, null);
        this.confirmPanel.addActionListener(this);
        this.confirmPanel.getResetButton().setVisible(this.hasReset());
        this.confirmPanel.getCustomizeButton().setVisible(this.hasCustomize());
        this.confirmPanel.getHistoryButton().setVisible(this.hasHistory());
        this.confirmPanel.getZoomButton().setVisible(this.hasZoom());
        CButton cButton = ConfirmPanel.createPrintButton(true);
        cButton.addActionListener(this);
        this.confirmPanel.addButton(cButton);
        this.popup.add(this.calcMenu);
        this.calcMenu.setText(Msg.getMsg(this.getCtx(), "Calculator"));
        this.calcMenu.setIcon(new ImageIcon(Adempiere.class.getResource("images/Calculator16.gif")));
        this.calcMenu.addActionListener(this);
        this.p_table.getSelectionModel().addListSelectionListener(this);
        this.enableButtons();
    }

    private void fillPicks() throws Exception {
        this.prepareTable(m_layout, VMRPDetailed.getTableName(), this.getSQLWhere(), "TypeMRP , ProductValue , DatePromised");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Ok")) {
            this.m_frame.dispose();
        } else if (string.equals("Cancel")) {
            this.m_cancel = true;
            this.m_frame.dispose();
        } else if (string.equals("Zoom")) {
            this.zoom();
        } else if (string.equals("Refresh")) {
            this.executeQuery();
        }
        this.m_frame.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void executeASync(ProcessInfo processInfo) {
    }

    @Override
    public boolean isUILocked() {
        return false;
    }

    @Override
    public void lockUI(ProcessInfo processInfo) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    @Override
    public void unlockUI(ProcessInfo processInfo) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
    }

    private String getSQLWhere() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fProduct_ID.getValue() != null) {
            stringBuffer.append(" AND " + VMRPDetailed.getTableName() + ".M_Product_ID=?");
            stringBuffer.append(" AND ((" + VMRPDetailed.getTableName() + ".OrderType IN ('SOO','MOP','POO','POR','STK','DOO')) OR (" + VMRPDetailed.getTableName() + ".OrderType='FCT' AND " + VMRPDetailed.getTableName() + ".DatePromised >= SYSDATE))");
            this.fillHead();
            this.setMRP();
        }
        if (this.isAttributeSetInstance()) {
            stringBuffer.append(" AND " + VMRPDetailed.getTableName() + ".M_AttributeSetInstance_ID=?");
            this.fillHead();
            this.setMRP();
        }
        if (this.fResource_ID.getValue() != null) {
            stringBuffer.append(" AND " + VMRPDetailed.getTableName() + ".S_Resource_ID=?");
        }
        if (this.fPlanner_ID.getValue() != null) {
            stringBuffer.append(" AND " + VMRPDetailed.getTableName() + ".Planner_ID=?");
        }
        if (this.fWarehouse_ID.getValue() != null) {
            stringBuffer.append(" AND " + VMRPDetailed.getTableName() + ".M_Warehouse_ID=?");
        }
        if (this.fDateFrom.getValue() != null || this.fDateFrom.getValue() != null) {
            Timestamp timestamp = (Timestamp)this.fDateFrom.getValue();
            Timestamp timestamp2 = (Timestamp)this.fDateTo.getValue();
            if (timestamp == null && timestamp2 != null) {
                stringBuffer.append(" AND TRUNC(" + VMRPDetailed.getTableName() + ".DatePromised) <= ?");
            } else if (timestamp != null && timestamp2 == null) {
                stringBuffer.append(" AND TRUNC(" + VMRPDetailed.getTableName() + ".DatePromised) >= ?");
            } else if (timestamp != null && timestamp2 != null) {
                stringBuffer.append(" AND TRUNC(" + VMRPDetailed.getTableName() + ".DatePromised) BETWEEN ? AND ?");
            }
        }
        log.fine("MRP Info.setWhereClause=" + stringBuffer.toString());
        return stringBuffer.toString();
    }

    private void fillHead() {
        MPPProductPlanning mPPProductPlanning = MPPProductPlanning.find(this.getCtx(), this.getAD_Org_ID(), this.getM_Warehouse_ID(), this.getS_Resource_ID(), this.getM_Product_ID(), null);
        if (mPPProductPlanning == null) {
            mPPProductPlanning = new MPPProductPlanning(this.getCtx(), 0, null);
        }
        this.fMaster.setSelected(mPPProductPlanning.isMPS());
        this.fMRPReq.setSelected(mPPProductPlanning.isRequiredMRP());
        this.fCreatePlan.setSelected(mPPProductPlanning.isCreatePlan());
        this.fOrderPeriod.setValue(mPPProductPlanning.getOrder_Period());
        this.fLeadtime.setValue(mPPProductPlanning.getDeliveryTime_Promised());
        this.fTimefence.setValue(mPPProductPlanning.getTimeFence());
        this.fMinOrd.setValue(mPPProductPlanning.getOrder_Min());
        this.fMaxOrd.setValue(mPPProductPlanning.getOrder_Max());
        this.fOrdMult.setValue(mPPProductPlanning.getOrder_Pack());
        this.fOrderQty.setValue(mPPProductPlanning.getOrder_Qty());
        this.fYield.setValue(mPPProductPlanning.getYield());
        this.fType.setText(MRefList.getListName(this.getCtx(), 53228, mPPProductPlanning.getOrder_Policy()));
        this.fSafetyStock.setValue(mPPProductPlanning.getSafetyStock());
    }

    private void setMRP() {
        int n = this.getM_Product_ID();
        int n2 = this.getM_AttributeSetInstance_ID();
        int n3 = this.getM_Warehouse_ID();
        if (n <= 0) {
            return;
        }
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            StringBuffer stringBuffer = new StringBuffer("SELECT ").append("BOMQtyOnHandASI(M_Product_ID,?,?,?) as qtyonhand, ").append("BOMQtyReservedASI(M_Product_ID,?,?,?) as qtyreserved, ").append("BOMQtyAvailableASI(M_Product_ID,?,?,?) as qtyavailable, ").append("BOMQtyOrderedASI(M_Product_ID,?,?,?) as qtyordered").append(" FROM M_Product WHERE M_Product_ID=?");
            cPreparedStatement = DB.prepareStatement(stringBuffer.toString(), null);
            DB.setParameters((PreparedStatement)cPreparedStatement, new Object[]{this.getM_AttributeSetInstance_ID(), this.getM_Warehouse_ID(), 0, this.getM_AttributeSetInstance_ID(), this.getM_Warehouse_ID(), 0, this.getM_AttributeSetInstance_ID(), this.getM_Warehouse_ID(), 0, this.getM_AttributeSetInstance_ID(), this.getM_Warehouse_ID(), 0, this.getM_Product_ID()});
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                this.fOnhand.setValue(resultSet.getBigDecimal(1));
                this.fReserved.setValue(resultSet.getBigDecimal(2));
                this.fAvailable.setValue(resultSet.getBigDecimal(3));
                this.fOrdered.setValue(resultSet.getBigDecimal(4));
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException(sQLException);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
        int n4 = MProduct.get(this.getCtx(), n).getC_UOM_ID();
        MUOM mUOM = MUOM.get(this.getCtx(), n4);
        KeyNamePair keyNamePair = new KeyNamePair(mUOM.getC_UOM_ID(), mUOM.get_Translation("Name"));
        this.fUOM.setText(keyNamePair.toString());
        BigDecimal bigDecimal = Env.ZERO;
        if (this.getM_Warehouse_ID() > 0) {
            String string = "SELECT Level_Min FROM M_Replenish WHERE AD_Client_ID=? AND M_Product_ID=? AND M_Warehouse_ID=?";
            bigDecimal = DB.getSQLValueBD(null, string, this.AD_Client_ID, n, n3);
        }
        this.fReplenishMin.setValue(bigDecimal);
    }

    void doReset() {
    }

    boolean hasReset() {
        return false;
    }

    void showHistory() {
    }

    boolean hasHistory() {
        return false;
    }

    void customize() {
    }

    boolean hasCustomize() {
        return false;
    }

    void zoom() {
        log.info("InfoMRPDeatiled.zoom");
        Integer n = this.getSelectedRowKey();
        int n2 = 0;
        if (n == null) {
            return;
        }
        MQuery mQuery = null;
        MPPMRP mPPMRP = new MPPMRP(this.getCtx(), n, null);
        String string = mPPMRP.getOrderType();
        if ("POO".equals(string)) {
            n2 = MTable.get(this.getCtx(), MOrder.Table_ID).getPO_Window_ID();
            mQuery = new MQuery("C_Order");
            mQuery.addRestriction("C_Order_ID", "=", mPPMRP.getC_Order_ID());
        } else if ("SOO".equals(string)) {
            n2 = MTable.get(this.getCtx(), MOrder.Table_ID).getAD_Window_ID();
            mQuery = new MQuery("C_Order");
            mQuery.addRestriction("C_Order_ID", "=", mPPMRP.getC_Order_ID());
        } else if ("MOP".equals(string)) {
            n2 = MTable.get(this.getCtx(), MPPOrder.Table_ID).getAD_Window_ID();
            mQuery = new MQuery("PP_Order");
            mQuery.addRestriction("PP_Order_ID", "=", mPPMRP.getPP_Order_ID());
        } else if ("POR".equals(string)) {
            n2 = MTable.get(this.getCtx(), MRequisition.Table_ID).getAD_Window_ID();
            mQuery = new MQuery("M_Requisition");
            mQuery.addRestriction("M_Requisition_ID", "=", mPPMRP.getM_Requisition_ID());
        } else if ("FCT".equals(string)) {
            n2 = MTable.get(this.getCtx(), X_M_Forecast.Table_ID).getAD_Window_ID();
            mQuery = new MQuery("M_Forecast");
            mQuery.addRestriction("M_Forecast_ID", "=", mPPMRP.getM_Forecast_ID());
        }
        if ("DOO".equals(string)) {
            n2 = MTable.get(this.getCtx(), MDDOrder.Table_ID).getAD_Window_ID();
            mQuery = new MQuery("DD_Order");
            mQuery.addRestriction("DD_Order_ID", "=", mPPMRP.getDD_Order_ID());
        }
        if (n2 == 0) {
            return;
        }
        log.info("AD_WindowNo " + n2);
        this.zoom(n2, mQuery);
    }

    void zoom(int n, MQuery mQuery) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        final AWindow aWindow = new AWindow();
        if (!aWindow.initWindow(n, mQuery)) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    9.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AEnv.showCenterScreen(aWindow);
            }
        }.start();
    }

    boolean hasZoom() {
        return true;
    }

    void enableButtons() {
        boolean bl = true;
        this.confirmPanel.getOKButton().setEnabled(true);
        if (this.hasHistory()) {
            this.confirmPanel.getHistoryButton().setEnabled(bl);
        }
        if (this.hasZoom()) {
            this.confirmPanel.getZoomButton().setEnabled(bl);
        }
    }

    void executeQuery() {
        if (this.m_worker != null && this.m_worker.isAlive()) {
            return;
        }
        this.m_worker = new Worker();
        this.m_worker.start();
    }

    protected void prepareTable(ColumnInfo[] columnInfoArray, String string, String string2, String string3) {
        int n;
        this.p_layout = columnInfoArray;
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        for (n = 0; n < columnInfoArray.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(columnInfoArray[n].getColSQL());
            if (columnInfoArray[n].isKeyPairCol()) {
                stringBuffer.append(",").append(columnInfoArray[n].getKeyPairColSQL());
            }
            this.p_table.addColumn(columnInfoArray[n].getColHeader());
            if (columnInfoArray[n].isColorColumn()) {
                this.p_table.setColorColumn(n);
            }
            if (columnInfoArray[n].getColClass() != IDColumn.class) continue;
            this.m_keyColumnIndex = n;
        }
        for (n = 0; n < columnInfoArray.length; ++n) {
            this.p_table.setColumnClass(n, columnInfoArray[n].getColClass(), columnInfoArray[n].isReadOnly(), columnInfoArray[n].getColHeader());
        }
        stringBuffer.append(" FROM ").append(string);
        StringBuffer stringBuffer2 = new StringBuffer("" + VMRPDetailed.getTableName() + ".DocStatus IN ('DR','IP','CO')  AND " + VMRPDetailed.getTableName() + ".IsActive='Y' and " + VMRPDetailed.getTableName() + ".Qty!=0 ");
        stringBuffer.append(" WHERE ").append(stringBuffer2.toString());
        if (!string2.equals("")) {
            stringBuffer.append(string2);
        }
        this.m_sqlMain = stringBuffer.toString();
        this.m_sqlAdd = "";
        if (string3 != null && string3.length() > 0) {
            this.m_sqlAdd = " ORDER BY " + string3;
        }
        if (this.m_keyColumnIndex == -1) {
            log.log(Level.SEVERE, "No KeyColumn - " + stringBuffer);
        }
        this.p_table.setRowSelectionAllowed(true);
        this.p_table.setMultiSelection(false);
        this.p_table.setEditingColumn(0);
        this.p_table.setSelectionMode(2);
        this.parameterPanel.setPreferredSize(new Dimension(800, this.parameterPanel.getPreferredSize().height));
        this.scrollPane.setPreferredSize(new Dimension(800, 400));
    }

    protected Integer getSelectedRowKey() {
        int n = this.p_table.getSelectedRow();
        if (n != -1 && this.m_keyColumnIndex != -1) {
            Object object = this.p_table.getModel().getValueAt(n, this.m_keyColumnIndex);
            if (object instanceof IDColumn) {
                object = ((IDColumn)object).getRecord_ID();
            }
            if (object instanceof Integer) {
                return (Integer)object;
            }
        }
        return null;
    }

    protected void setParameters(PreparedStatement preparedStatement, boolean bl) throws SQLException {
        int n;
        int n2 = 1;
        if (this.getM_Product_ID() > 0) {
            n = this.getM_Product_ID();
            preparedStatement.setInt(n2++, n);
            log.fine("Product=" + n);
        }
        if (this.isAttributeSetInstance()) {
            n = this.getM_AttributeSetInstance_ID();
            preparedStatement.setInt(n2++, n);
            log.fine("AttributeSetInstance=" + n);
        }
        if (this.getS_Resource_ID() > 0) {
            n = this.getS_Resource_ID();
            preparedStatement.setInt(n2++, n);
            log.fine("Resource=" + n);
        }
        if (this.getM_Warehouse_ID() > 0) {
            n = this.getM_Warehouse_ID();
            preparedStatement.setInt(n2++, this.getM_Warehouse_ID());
            log.fine("Warehouse=" + n);
        }
        if (this.getPlanner_ID() > 0) {
            n = this.getPlanner_ID();
            preparedStatement.setInt(n2++, n);
            log.fine("Planner=" + n);
        }
        if (this.getDueStart() != null || this.getDueEnd() != null) {
            Timestamp timestamp = this.getDueStart();
            Timestamp timestamp2 = this.getDueEnd();
            log.fine("Date From=" + timestamp + ", Date To=" + timestamp2);
            if (timestamp == null && timestamp2 != null) {
                preparedStatement.setTimestamp(n2++, timestamp2);
            } else if (timestamp != null && timestamp2 == null) {
                preparedStatement.setTimestamp(n2++, timestamp);
            } else if (timestamp != null && timestamp2 != null) {
                preparedStatement.setTimestamp(n2++, timestamp);
                preparedStatement.setTimestamp(n2++, timestamp2);
            }
        }
    }

    static String getTableName() {
        return "RV_PP_MRP";
    }

    protected Properties getCtx() {
        return Env.getCtx();
    }

    protected int getM_Product_ID() {
        Object object = this.fProduct_ID.getValue();
        return object != null && object instanceof Integer ? (Integer)object : Integer.valueOf(0);
    }

    protected int getM_AttributeSetInstance_ID() {
        Object object = this.fAttrSetInstance_ID.getValue();
        return object != null && object instanceof Integer ? (Integer)object : Integer.valueOf(0);
    }

    protected int getAD_Client_ID() {
        return Env.getAD_Client_ID(this.getCtx());
    }

    protected int getAD_Org_ID() {
        int n = this.getM_Warehouse_ID();
        if (n <= 0) {
            return 0;
        }
        return MWarehouse.get(this.getCtx(), n).getAD_Org_ID();
    }

    protected int getM_Warehouse_ID() {
        Object object = this.fWarehouse_ID.getValue();
        return object != null && object instanceof Integer ? (Integer)object : Integer.valueOf(0);
    }

    protected int getS_Resource_ID() {
        Object object = this.fResource_ID.getValue();
        return object != null && object instanceof Integer ? (Integer)object : Integer.valueOf(0);
    }

    protected int getPlanner_ID() {
        Object object = this.fPlanner_ID.getValue();
        return object != null && object instanceof Integer ? (Integer)object : Integer.valueOf(0);
    }

    protected Timestamp getDueStart() {
        return this.fDateFrom.getTimestamp();
    }

    protected Timestamp getDueEnd() {
        return this.fDateTo.getTimestamp();
    }

    protected BigDecimal getQtyOnHand() {
        BigDecimal bigDecimal = (BigDecimal)this.fOnhand.getValue();
        return bigDecimal != null ? bigDecimal : Env.ZERO;
    }

    static {
        Env.getLanguage(Env.getCtx());
        isBaseLanguage = Language.getBaseAD_Language().compareTo(Env.getLoginLanguage(Env.getCtx()).getAD_Language()) == 0;
        m_layout = new ColumnInfo[]{new ColumnInfo(" ", VMRPDetailed.getTableName() + ".PP_MRP_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Value"), "(Select Value from M_Product p where p.M_Product_ID=" + VMRPDetailed.getTableName() + ".M_Product_ID) AS ProductValue", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "(Select Name from M_Product p where p.M_Product_ID=" + VMRPDetailed.getTableName() + ".M_Product_ID)", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "S_Resource_ID"), "(Select Name from S_Resource sr where sr.S_Resource_ID=" + VMRPDetailed.getTableName() + ".S_Resource_ID)", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "M_Warehouse_ID"), "(Select Name from M_Warehouse wh where wh.M_Warehouse_ID=" + VMRPDetailed.getTableName() + ".M_Warehouse_ID)", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "DatePromised"), "" + VMRPDetailed.getTableName() + ".DatePromised", Timestamp.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyGrossReq"), "(CASE WHEN " + VMRPDetailed.getTableName() + ".TypeMRP='D' THEN " + VMRPDetailed.getTableName() + ".Qty ELSE NULL END)", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyScheduledReceipts"), "(CASE WHEN " + VMRPDetailed.getTableName() + ".TypeMRP='S' AND " + VMRPDetailed.getTableName() + ".DocStatus  IN ('IP','CO') THEN " + VMRPDetailed.getTableName() + ".Qty ELSE NULL END)", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "PlannedQty"), "(CASE WHEN " + VMRPDetailed.getTableName() + ".TypeMRP='S' AND " + VMRPDetailed.getTableName() + ".DocStatus ='DR' THEN " + VMRPDetailed.getTableName() + ".Qty ELSE NULL END)", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyOnHandProjected"), "bomQtyOnHand(" + VMRPDetailed.getTableName() + ".M_Product_ID , " + VMRPDetailed.getTableName() + ".M_Warehouse_ID, 0)", BigDecimal.class), isBaseLanguage ? new ColumnInfo(Msg.translate(Env.getCtx(), "TypeMRP"), "(SELECT Name FROM  AD_Ref_List WHERE AD_Reference_ID=53230 AND Value = " + VMRPDetailed.getTableName() + ".TypeMRP)", String.class) : new ColumnInfo(Msg.translate(Env.getCtx(), "TypeMRP"), "(SELECT rlt.Name FROM  AD_Ref_List rl INNER JOIN AD_Ref_List_Trl  rlt ON (rl.AD_Ref_List_ID=rlt.AD_Ref_List_ID)  WHERE rl.AD_Reference_ID=53230 AND rlt.AD_Language = '" + Env.getLoginLanguage(Env.getCtx()).getAD_Language() + "' AND Value = " + VMRPDetailed.getTableName() + ".TypeMRP)", String.class), isBaseLanguage ? new ColumnInfo(Msg.translate(Env.getCtx(), "OrderType"), "(SELECT Name FROM  AD_Ref_List WHERE AD_Reference_ID=53229 AND Value = " + VMRPDetailed.getTableName() + ".OrderType)", String.class) : new ColumnInfo(Msg.translate(Env.getCtx(), "OrderType"), "(SELECT rlt.Name FROM  AD_Ref_List rl INNER JOIN AD_Ref_List_Trl  rlt ON (rl.AD_Ref_List_ID=rlt.AD_Ref_List_ID)  WHERE rl.AD_Reference_ID=53229 AND rlt.AD_Language = '" + Env.getLoginLanguage(Env.getCtx()).getAD_Language() + "' AND Value = " + VMRPDetailed.getTableName() + ".OrderType)", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "DocumentNo"), "documentNo(" + VMRPDetailed.getTableName() + ".PP_MRP_ID)", String.class), isBaseLanguage ? new ColumnInfo(Msg.translate(Env.getCtx(), "DocStatus"), "(SELECT Name FROM  AD_Ref_List WHERE AD_Reference_ID=131 AND Value = " + VMRPDetailed.getTableName() + ".DocStatus)", String.class) : new ColumnInfo(Msg.translate(Env.getCtx(), "DocStatus"), "(SELECT rlt.Name FROM  AD_Ref_List rl INNER JOIN AD_Ref_List_Trl  rlt ON (rl.AD_Ref_List_ID=rlt.AD_Ref_List_ID)  WHERE rl.AD_Reference_ID=131 AND rlt.AD_Language = '" + Env.getLoginLanguage(Env.getCtx()).getAD_Language() + "' AND Value = " + VMRPDetailed.getTableName() + ".DocStatus)", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "DateStartSchedule"), "" + VMRPDetailed.getTableName() + ".DateStartSchedule", Timestamp.class), new ColumnInfo(Msg.translate(Env.getCtx(), "C_BPartner_ID"), "(SELECT cb.Name FROM C_BPartner cb WHERE cb.C_BPartner_ID=" + VMRPDetailed.getTableName() + ".C_BPartner_ID)", String.class)};
    }

    class Worker
    extends Thread {
        Worker() {
        }

        @Override
        public void run() {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            log.fine("Info.Worker.run");
            VMRPDetailed.this.setCursor(Cursor.getPredefinedCursor(3));
            VMRPDetailed.this.p_table.setRowCount(0);
            StringBuffer stringBuffer = new StringBuffer(VMRPDetailed.this.m_sqlMain);
            String string = VMRPDetailed.this.getSQLWhere();
            if (string.length() > 0) {
                System.out.println("where" + string);
                stringBuffer.append(string);
            }
            stringBuffer.append(VMRPDetailed.this.m_sqlAdd);
            String string2 = Msg.parseTranslation(VMRPDetailed.this.getCtx(), stringBuffer.toString());
            string2 = MRole.getDefault().addAccessSQL(string2, VMRPDetailed.getTableName(), true, false);
            try {
                object4 = DB.prepareStatement(string2, null);
                log.fine("SQL=" + string2);
                VMRPDetailed.this.setParameters((PreparedStatement)object4, false);
                ResultSet resultSet = object4.executeQuery();
                while (!this.isInterrupted() & resultSet.next()) {
                    int n = VMRPDetailed.this.p_table.getRowCount();
                    VMRPDetailed.this.p_table.setRowCount(n + 1);
                    int n2 = 1;
                    for (int i = 0; i < VMRPDetailed.this.p_layout.length; ++i) {
                        object3 = null;
                        object2 = VMRPDetailed.this.p_layout[i].getColClass();
                        int n3 = i + n2;
                        if (object2 == IDColumn.class) {
                            object = new IDColumn(resultSet.getInt(n3));
                            ((IDColumn)object).setSelected(true);
                            object3 = object;
                            VMRPDetailed.this.p_table.setColumnReadOnly(0, false);
                        } else if (object2 == Boolean.class) {
                            object3 = new Boolean("Y".equals(resultSet.getString(n3)));
                        } else if (object2 == Timestamp.class) {
                            object3 = resultSet.getTimestamp(n3);
                        } else if (object2 == BigDecimal.class) {
                            object3 = resultSet.getBigDecimal(n3);
                        } else if (object2 == Double.class) {
                            object3 = new Double(resultSet.getDouble(n3));
                        } else if (object2 == Integer.class) {
                            object3 = new Integer(resultSet.getInt(n3));
                        } else if (object2 == KeyNamePair.class) {
                            object = resultSet.getString(n3);
                            int n4 = resultSet.getInt(n3 + 1);
                            object3 = new KeyNamePair(n4, (String)object);
                            ++n2;
                        } else {
                            object3 = resultSet.getString(n3);
                        }
                        VMRPDetailed.this.p_table.setValueAt(object3, n, i);
                    }
                }
                log.fine("Info.Worker.run - interrupted=" + this.isInterrupted());
                resultSet.close();
                object4.close();
            }
            catch (SQLException sQLException) {
                log.log(Level.SEVERE, "Info.Worker.run - " + string2, sQLException);
            }
            VMRPDetailed.this.p_table.autoSize();
            VMRPDetailed.this.setCursor(Cursor.getDefaultCursor());
            if (VMRPDetailed.this.getM_Product_ID() > 0) {
                object4 = VMRPDetailed.this.getQtyOnHand();
                for (int i = 0; i < VMRPDetailed.this.p_table.getRowCount(); ++i) {
                    BigDecimal bigDecimal;
                    Timestamp timestamp = (Timestamp)VMRPDetailed.this.p_table.getValueAt(i, 5);
                    Timestamp timestamp2 = new Timestamp(System.currentTimeMillis());
                    IDColumn iDColumn = (IDColumn)VMRPDetailed.this.p_table.getValueAt(i, 0);
                    object3 = DB.getSQLValueString(null, "SELECT TypeMRP FROM " + VMRPDetailed.getTableName() + " WHERE PP_MRP_ID=?", iDColumn.getRecord_ID());
                    object2 = (String)VMRPDetailed.this.p_table.getValueAt(i, 11);
                    if ("D".equals(object3) || "FCT".equals(object2) && timestamp.after(timestamp2)) {
                        bigDecimal = (BigDecimal)VMRPDetailed.this.p_table.getValueAt(i, 6);
                        object4 = ((BigDecimal)object4).subtract(bigDecimal);
                        VMRPDetailed.this.p_table.setValueAt(object4, i, 9);
                    }
                    if (!"S".equals(object3)) continue;
                    bigDecimal = (BigDecimal)VMRPDetailed.this.p_table.getValueAt(i, 7);
                    object = (BigDecimal)VMRPDetailed.this.p_table.getValueAt(i, 8);
                    if (object == null) {
                        object = Env.ZERO;
                    }
                    if (bigDecimal == null) {
                        bigDecimal = Env.ZERO;
                    }
                    object4 = ((BigDecimal)object4).add(bigDecimal.add((BigDecimal)object));
                    VMRPDetailed.this.p_table.setValueAt(object4, i, 9);
                }
            }
        }
    }
}

