/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MResource;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.form.CAbstractForm;
import org.eevolution.form.CRPDetail;
import org.eevolution.form.action.ZoomMenuAction;
import org.eevolution.form.crp.CRPDatasetFactory;
import org.eevolution.form.crp.CRPModel;
import org.eevolution.model.MPPOrderNode;
import org.eevolution.tools.swing.SwingTool;
import org.eevolution.tools.worker.SingleWorker;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class VCRPDetail
extends CRPDetail
implements FormPanel {
    CAbstractForm m_form = new CAbstractForm(){};
    private VLookup resource;
    private VDate dateFrom;
    private VDate dateTo;
    private ChartPanel chartPanel;
    private JSplitPane contentPanel;
    private SingleWorker worker;
    protected CRPModel model;
    protected JPopupMenu popup;

    @Override
    public void init(int n, FormFrame formFrame) {
        this.m_form.init(n, formFrame);
        this.fillPicks();
        this.jbInit();
    }

    private void jbInit() {
        this.dateFrom = new VDate("DateFrom", true, false, true, 15, "DateFrom");
        this.dateTo = new VDate("DateTo", true, false, true, 15, "DateTo");
        CPanel cPanel = new CPanel();
        cPanel.setLayout(new GridBagLayout());
        cPanel.add((Component)new CLabel(Msg.translate(Env.getCtx(), "S_Resource_ID")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        cPanel.add((Component)this.resource, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        cPanel.add((Component)new CLabel(Msg.translate(Env.getCtx(), "DateFrom")), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        cPanel.add((Component)this.dateFrom, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        cPanel.add((Component)new CLabel(Msg.translate(Env.getCtx(), "DateTo")), new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        cPanel.add((Component)this.dateTo, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        ConfirmPanel confirmPanel = new ConfirmPanel(true);
        confirmPanel.addActionListener(new ActionHandler());
        this.contentPanel = new JSplitPane(1);
        this.contentPanel.setPreferredSize(new Dimension(800, 600));
        this.m_form.getWindow().getContentPane().add((Component)cPanel, "North");
        this.m_form.getWindow().getContentPane().add((Component)this.contentPanel, "Center");
        this.m_form.getWindow().getContentPane().add((Component)confirmPanel, "South");
    }

    private void fillPicks() {
        Properties properties = Env.getCtx();
        MLookup mLookup = MLookupFactory.get(properties, this.m_form.getWindowNo(), 0, MColumn.getColumn_ID("S_Resource", "S_Resource_ID"), 19);
        this.resource = new VLookup("S_Resource_ID", false, false, true, mLookup);
    }

    protected JPopupMenu createPopup(JTree jTree) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        ZoomMenuAction zoomMenuAction = null;
        try {
            zoomMenuAction = new ZoomMenuAction(jTree);
            jPopupMenu.add(zoomMenuAction);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jPopupMenu;
    }

    private void handleTreeEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            this.model.getTree().setSelectionPath(this.model.getTree().getPathForLocation(mouseEvent.getX(), mouseEvent.getY()));
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.model.getTree().getSelectionPath().getLastPathComponent();
            if (!(defaultMutableTreeNode.getUserObject() instanceof Date) && !(defaultMutableTreeNode.getUserObject() instanceof MPPOrderNode)) {
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
        SwingTool.setCursorsFromChild(mouseEvent.getComponent(), false);
    }

    private void handleActionEvent(ActionEvent actionEvent) {
        Timestamp timestamp = this.getDateFrom();
        Timestamp timestamp2 = this.getDateTo();
        MResource mResource = this.getResource(this.resource.getValue());
        if (timestamp != null && timestamp2 != null && mResource != null) {
            this.model = CRPDatasetFactory.get(timestamp, timestamp2, mResource);
            JFreeChart jFreeChart = this.createChart(this.model.getDataset(), this.getChartTitle(), this.getSourceUOM(this.resource.getValue()));
            this.chartPanel = new ChartPanel(jFreeChart, false);
            this.contentPanel.setLeftComponent((Component)this.chartPanel);
            JTree jTree = this.model.getTree();
            jTree.addMouseListener(new TreeHandler());
            this.contentPanel.setRightComponent(new JScrollPane(jTree));
            this.popup = this.createPopup(jTree);
            this.contentPanel.setDividerLocation(0.7);
            this.contentPanel.setVisible(true);
            this.contentPanel.validate();
            this.contentPanel.repaint();
        }
        SwingTool.setCursorsFromParent(this.m_form.getWindow(), false);
    }

    private String getChartTitle() {
        MResource mResource = this.getResource(this.resource.getValue());
        String string = mResource.getName() != null ? mResource.getName() : "";
        string = string + " " + mResource.getDescription() != null ? mResource.getDescription() : "";
        return string;
    }

    public Timestamp getDateFrom() {
        Timestamp timestamp = null;
        if (this.dateFrom.getValue() != null) {
            timestamp = (Timestamp)this.dateFrom.getValue();
        }
        return timestamp;
    }

    public Timestamp getDateTo() {
        Timestamp timestamp = null;
        if (this.dateTo.getValue() != null) {
            timestamp = (Timestamp)this.dateTo.getValue();
        }
        return timestamp;
    }

    @Override
    public void dispose() {
        this.m_form.dispose();
        if (this.resource != null) {
            this.resource.dispose();
        }
        this.resource = null;
        if (this.dateFrom != null) {
            this.dateFrom.dispose();
        }
        this.dateFrom = null;
        if (this.dateTo != null) {
            this.dateTo.dispose();
        }
        this.dateTo = null;
        if (this.worker != null) {
            this.worker.stop();
        }
        this.worker = null;
        this.chartPanel = null;
        this.contentPanel = null;
        this.popup = null;
    }

    class FrameHandler
    extends WindowAdapter {
        FrameHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            VCRPDetail.this.dispose();
        }
    }

    class TreeHandler
    extends MouseInputAdapter
    implements TreeSelectionListener {
        TreeHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (VCRPDetail.this.model.getTree().getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) == null) {
                return;
            }
            SwingTool.setCursorsFromChild(mouseEvent.getComponent(), true);
            final MouseEvent mouseEvent2 = mouseEvent;
            VCRPDetail.this.worker = new SingleWorker(){

                @Override
                protected Object doIt() {
                    VCRPDetail.this.handleTreeEvent(mouseEvent2);
                    return null;
                }
            };
            VCRPDetail.this.worker.start();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("Ok")) {
                SwingTool.setCursorsFromParent(VCRPDetail.this.m_form.getWindow(), true);
                final ActionEvent actionEvent2 = actionEvent;
                VCRPDetail.this.worker = new SingleWorker(){

                    @Override
                    protected Object doIt() {
                        VCRPDetail.this.handleActionEvent(actionEvent2);
                        return null;
                    }
                };
                VCRPDetail.this.worker.start();
            }
            if (actionEvent.getActionCommand().equals("Cancel")) {
                VCRPDetail.this.dispose();
            }
        }
    }
}

