/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MResource;
import org.compiere.model.MUOM;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.form.CRP;
import org.eevolution.form.crp.CRPModel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class VCRP
extends CRP
implements FormPanel,
ActionListener {
    static CLogger log = CLogger.getCLogger(VCRP.class);
    private FormFrame m_frame;
    private CPanel northPanel = new CPanel();
    private CPanel centerPanel = new CPanel();
    private BorderLayout centerLayout = new BorderLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private Hashtable hash = new Hashtable();
    private VLookup resource = null;
    private CLabel resourceLabel = new CLabel();
    private VDate dateFrom = new VDate("DateFrom", true, false, true, 15, "DateFrom");
    private CLabel dateFromLabel = new CLabel();
    private ChartPanel chartPanel = new ChartPanel(this.createChart((CategoryDataset)new DefaultCategoryDataset(), "", null));
    protected CRPModel model;

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Ok")) {
            Timestamp timestamp = null;
            if (this.dateFrom.getValue() != null) {
                timestamp = (Timestamp)this.dateFrom.getValue();
            }
            int n = 0;
            if (this.resource.getValue() != null) {
                n = (Integer)this.resource.getValue();
            }
            if (timestamp != null && n != 0) {
                MResource mResource = MResource.get(Env.getCtx(), n);
                int n2 = mResource.getResourceType().getC_UOM_ID();
                MUOM mUOM = MUOM.get(Env.getCtx(), n2);
                CategoryDataset categoryDataset = null;
                categoryDataset = mUOM.isHour() ? this.createDataset(timestamp, mResource) : this.createWeightDataset(timestamp, mResource);
                String string = mResource.getName() != null ? mResource.getName() : "";
                string = string + " " + mResource.getDescription() != null ? mResource.getDescription() : "";
                JFreeChart jFreeChart = this.createChart(categoryDataset, string, mUOM);
                this.centerPanel.removeAll();
                this.chartPanel = new ChartPanel(jFreeChart, false);
                this.centerPanel.add((Component)this.chartPanel, "Center");
                this.centerPanel.setVisible(true);
                this.m_frame.pack();
            }
        }
        if (actionEvent.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    private void fillPicks() throws Exception {
        Properties properties = Env.getCtx();
        MLookup mLookup = MLookupFactory.get(properties, this.m_WindowNo, 0, MColumn.getColumn_ID("M_Product", "S_Resource_ID"), 19);
        this.resource = new VLookup("S_Resource_ID", false, false, true, mLookup);
    }

    @Override
    public void init(int n, FormFrame formFrame) {
        log.info("VCRP.init");
        this.m_WindowNo = n;
        this.m_frame = formFrame;
        try {
            this.fillPicks();
            this.jbInit();
            formFrame.getContentPane().add((Component)this.northPanel, "North");
            formFrame.getContentPane().add((Component)this.centerPanel, "Center");
            formFrame.getContentPane().add((Component)this.confirmPanel, "South");
            formFrame.pack();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "VCRP.init", exception);
        }
    }

    private void jbInit() throws Exception {
        this.northPanel.setLayout(new GridBagLayout());
        this.resourceLabel.setText(Msg.translate(Env.getCtx(), "S_Resource_ID"));
        this.northPanel.add((Component)this.resourceLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.resource, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.dateFromLabel.setText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.northPanel.add((Component)this.dateFromLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.dateFrom, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.chartPanel.setPreferredSize(new Dimension(750, 550));
        this.centerPanel.add((Component)this.chartPanel, "Center");
        this.confirmPanel.addActionListener(this);
    }
}

