/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MBrowseField;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.AppsAction;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.ProcessParameterPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.grid.ed.VString;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MLookup;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.MRole;
import org.compiere.model.M_Element;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CFrame;
import org.compiere.swing.CLabel;
import org.compiere.util.ASyncProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.Splash;
import org.eevolution.form.Browser;

public class VBrowser
extends Browser
implements ActionListener,
VetoableChangeListener,
ChangeListener,
ListSelectionListener,
TableModelListener,
ASyncProcess {
    CFrame m_frame = new CFrame();
    private static final long serialVersionUID = -1022167449752851083L;
    private ProcessParameterPanel parameterPanel;
    protected StatusBar statusBar = new StatusBar();
    private Worker m_worker = null;
    private JButton bCancel;
    private JButton bDelete;
    private JButton bExport;
    private JButton bFind;
    private JButton bOk;
    private JButton bPrint;
    private JButton bSearch;
    private JToggleButton bZoom;
    private JPanel buttonSearchPanel;
    private JScrollPane centerPanel;
    private MiniTable detail;
    private JPanel footButtonPanel;
    private JPanel footPanel;
    private JPanel graphPanel;
    private JPanel processPanel;
    private JPanel searchPanel;
    private JPanel searchTab;
    private JTabbedPane tabsPanel;
    private JToolBar toolsBar;
    private JPanel topPanel;

    public VBrowser(Frame frame, boolean modal, int WindowNo, String value, MBrowse browse, String keyColumn, boolean multiSelection, String whereClause) {
        super(modal, WindowNo, value, browse, keyColumn, multiSelection, whereClause);
        this.m_frame.setTitle(this.m_Browse.getName());
        this.initComponents();
        this.statInit();
        this.p_loadedOK = this.initBrowser();
        this.m_frame.setPreferredSize(this.getPreferredSize());
        int no = this.detail.getRowCount();
        this.setStatusLine(String.valueOf(Integer.toString(no)) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
    }

    private void statInit() {
        this.searchPanel.setLayout(new ALayout());
        int cols = 0;
        int col = 2;
        int row = 0;
        for (MBrowseField field : this.m_Browse.getCriteriaFields()) {
            M_Element element = new M_Element(this.m_Browse.getCtx(), field.getAD_Element_ID(), null);
            String title = Msg.translate(Env.getCtx(), element.getColumnName());
            String name = field.getAD_View_Column().getAD_Column().getColumnName();
            this.addComponent(field, row, cols, field.getName(), title);
            cols += col;
            if (field.isRange()) {
                title = Msg.getMsg(Env.getCtx(), "To");
                this.addComponent(field, row, cols, String.valueOf(field.getName()) + "_To", title);
                cols += col;
            }
            if (cols < 4) continue;
            cols = 0;
            ++row;
        }
    }

    private void addComponent(MBrowseField field, int row, int col, String name, String title) {
        Component data = null;
        CLabel label = new CLabel(title);
        label.setName("L_" + name);
        if (20 == field.getAD_Reference_ID()) {
            data = new VCheckBox();
            data.setName(name);
            label.setLabelFor(data);
        } else if (10 == field.getAD_Reference_ID()) {
            data = new VString(name, field.isMandatory(), false, true, 30, 30, "", null);
            data.setName(name);
            label.setLabelFor(data);
        } else if (22 == field.getAD_Reference_ID() || 29 == field.getAD_Reference_ID() || 37 == field.getAD_Reference_ID() || 11 == field.getAD_Reference_ID() || 12 == field.getAD_Reference_ID()) {
            data = new VNumber(name, field.isMandatory(), false, true, field.getAD_Reference_ID(), title);
            data.setName(name);
            label.setLabelFor(data);
        } else if (15 == field.getAD_Reference_ID() || 16 == field.getAD_Reference_ID()) {
            data = new VDate();
            data.setName(name);
            label.setLabelFor(data);
        } else if (19 == field.getAD_Reference_ID() || 18 == field.getAD_Reference_ID() || 13 == field.getAD_Reference_ID() || 17 == field.getAD_Reference_ID() || 30 == field.getAD_Reference_ID()) {
            data = this.getLookup(field);
            label.setLabelFor(data);
        }
        this.searchPanel.add((Component)label, new ALayoutConstraint(row, col));
        this.searchPanel.add(data, new ALayoutConstraint(row, col + 1));
    }

    private Component getLookup(MBrowseField field) {
        try {
            MLookup dataL = this.getMLookup(field);
            VLookup data = new VLookup(field.getAD_View_Column().getAD_Column().getColumnName(), field.isMandatory(), false, true, dataL);
            data.addVetoableChangeListener(this);
            data.setName(field.getName());
            return data;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Browser.init", e);
            return null;
        }
    }

    private boolean initBrowser() {
        if (!this.initBrowserTable()) {
            return false;
        }
        StringBuffer where = new StringBuffer(String.valueOf(this.m_View.getParentEntityAliasName()) + ".IsActive='Y'");
        if (this.p_whereClause.length() > 0) {
            where.append(this.p_whereClause);
        }
        this.prepareTable(this.m_generalLayout, this.m_View.getFromClause(), where.toString(), "2");
        if (this.m_Browse.getAD_Process_ID() > 0) {
            this.m_process = MProcess.get(Env.getCtx(), this.m_Browse.getAD_Process_ID());
            this.m_pi = new ProcessInfo(this.m_process.getName(), this.m_Browse.getAD_Process_ID());
            this.m_pi.setAD_User_ID(Env.getAD_User_ID(Env.getCtx()));
            this.m_pi.setAD_Client_ID(Env.getAD_Client_ID(Env.getCtx()));
            this.parameterPanel = new ProcessParameterPanel(this.p_WindowNo, this.m_pi);
            this.parameterPanel.setMode(ProcessParameterPanel.MODE_HORIZONTAL);
            this.parameterPanel.init();
            this.processPanel.add((Component)this.parameterPanel, "Center");
        }
        return true;
    }

    private boolean initBrowserTable() {
        String title = Msg.translate(Env.getCtx(), this.m_Browse.getName());
        this.m_frame.setTitle(String.valueOf(this.m_frame.getTitle()) + " " + title);
        ArrayList<Info_Column> list = this.initBrowserData();
        if (list.size() == 0) {
            ADialog.error(this.p_WindowNo, this.m_frame, "Error", "No Browse Fields");
            this.log.log(Level.SEVERE, "No Brwose for view=" + this.m_View.getName());
            return false;
        }
        this.log.finest("Browse Fields #" + list.size());
        this.m_generalLayout = new Info_Column[list.size()];
        list.toArray(this.m_generalLayout);
        return true;
    }

    private boolean setParameters() {
        this.m_parameters = new ArrayList();
        this.m_values = new ArrayList();
        StringBuffer sb = new StringBuffer("");
        Component[] componentArray = this.searchPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            String name = c.getName();
            if (name != null && !name.startsWith("L_")) {
                MBrowseField field = this.m_Browse.getField(name);
                if (name.endsWith("_To")) {
                    field = this.m_Browse.getField(name.substring(0, name.indexOf("_To")));
                }
                if (field != null) {
                    JComponent component;
                    M_Element element = new M_Element(this.m_Browse.getCtx(), field.getAD_Element_ID(), null);
                    String title = Msg.translate(Env.getCtx(), element.getColumnName());
                    if (c instanceof VLookup) {
                        component = (VLookup)c;
                        this.addParameter(component.getName(), ((VLookup)component).getValue());
                        if (field.isMandatory() && ((VLookup)component).getValue() == null) {
                            sb.append(String.valueOf(title) + ", ");
                        }
                    } else if (c instanceof VString) {
                        component = (VString)c;
                        this.addParameter(component.getName(), ((VString)component).getValue());
                        if (field.isMandatory() && ((VString)component).getValue() == null) {
                            sb.append(String.valueOf(title) + ", ");
                        }
                    } else if (c instanceof VCheckBox) {
                        component = (VCheckBox)c;
                        this.addParameter(component.getName(), ((VCheckBox)component).getValue());
                        if (field.isMandatory() && ((VCheckBox)component).getValue() == null) {
                            sb.append(String.valueOf(title) + ", ");
                        }
                    } else if (c instanceof VDate) {
                        component = (VDate)c;
                        this.addParameter(component.getName(), ((VDate)component).getValue());
                        if (field.isMandatory() && ((VDate)component).getValue() == null) {
                            sb.append(String.valueOf(title) + ", ");
                        }
                    }
                }
            }
            ++n2;
        }
        if (sb.length() != 0) {
            ADialog.error(this.p_WindowNo, this.m_frame.getContentPane(), "FillMandatory", sb.toString());
            return false;
        }
        return true;
    }

    public void setStatusLine(String text, boolean error) {
        this.statusBar.setStatusLine(text, error);
        Thread.yield();
    }

    public void setStatusDB(String text) {
        this.statusBar.setStatusDB(text);
    }

    protected void executeQuery() {
        if (!this.setParameters()) {
            // empty if block
        }
        if (this.m_worker != null && this.m_worker.isAlive()) {
            return;
        }
        if (!this.testCount()) {
            return;
        }
        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
        this.setStatusLine(Msg.getMsg(Env.getCtx(), "StartSearch"), false);
        this.m_worker = new Worker();
        this.m_worker.start();
    }

    private void cmd_zoom() {
        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
        Integer record_ID = this.getSelectedRowKey();
        if (record_ID == null) {
            return;
        }
        AEnv.zoom(this.m_View.getParentViewDefinition().getAD_Table_ID(), record_ID);
        this.m_frame.setCursor(Cursor.getDefaultCursor());
    }

    protected void prepareTable(Info_Column[] layout, String from, String staticWhere, String orderBy) {
        this.p_layout = layout;
        StringBuffer sql = new StringBuffer("SELECT ");
        int i = 0;
        while (i < layout.length) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(layout[i].getColSQL());
            if (layout[i].isIDcol()) {
                sql.append(",").append(layout[i].getIDcolSQL());
            }
            this.detail.addColumn(layout[i].getColHeader());
            if (layout[i].isColorColumn()) {
                this.detail.setColorColumn(i);
            }
            if (layout[i].getColClass() == IDColumn.class) {
                this.m_keyColumnIndex = i;
            }
            ++i;
        }
        this.detail.setRowSelectionAllowed(true);
        this.detail.setMultiSelection(this.p_multiSelection);
        this.detail.setShowTotals(true);
        i = 0;
        while (i < layout.length) {
            this.detail.setColumnClass(i, layout[i].getColClass(), layout[i].isReadOnly(), layout[i].getColHeader());
            ++i;
        }
        sql.append(" FROM ").append(from);
        sql.append(" WHERE ").append(staticWhere);
        this.m_sqlMain = sql.toString();
        this.m_sqlCount = "SELECT COUNT(*) FROM " + from + " WHERE " + staticWhere;
        this.m_sqlOrder = "";
        if (orderBy != null && orderBy.length() > 0) {
            this.m_sqlOrder = " ORDER BY " + orderBy;
        }
        if (this.m_keyColumnIndex == -1) {
            this.log.log(Level.SEVERE, "No KeyColumn - " + sql);
        }
    }

    private boolean testCount() {
        int no = -1;
        no = this.getCount();
        MRole role = MRole.getDefault();
        if (role.isQueryMax(no)) {
            return ADialog.ask(this.p_WindowNo, this.m_frame, "InfoHighRecordCount", String.valueOf(no));
        }
        return true;
    }

    protected void saveSelection() {
        if (this.detail == null) {
            return;
        }
        this.log.config("OK=" + this.m_ok);
        if (!this.m_ok) {
            this.m_results.clear();
            this.detail.removeAll();
            this.detail = null;
            return;
        }
        if (this.p_multiSelection) {
            this.m_results.addAll(this.getSelectedRowKeys());
        } else {
            Integer data = this.getSelectedRowKey();
            if (data != null) {
                this.m_results.add(data);
            }
        }
        this.log.config(this.getSelectedSQL());
        this.detail.removeAll();
        this.detail = null;
    }

    protected void saveSelectionDetail() {
    }

    @Override
    public ArrayList<Integer> getSelectedRowKeys() {
        int row;
        ArrayList<Integer> selectedDataList = new ArrayList<Integer>();
        if (this.m_keyColumnIndex == -1) {
            return selectedDataList;
        }
        if (this.p_multiSelection) {
            int rows = this.detail.getRowCount();
            int row2 = 0;
            while (row2 < rows) {
                IDColumn dataColumn;
                Object data = this.detail.getModel().getValueAt(row2, this.m_keyColumnIndex);
                if (data instanceof IDColumn && (dataColumn = (IDColumn)data).isSelected()) {
                    selectedDataList.add(dataColumn.getRecord_ID());
                }
                ++row2;
            }
        }
        if (selectedDataList.size() == 0 && (row = this.detail.getSelectedRow()) != -1 && this.m_keyColumnIndex != -1) {
            Object data = this.detail.getModel().getValueAt(row, this.m_keyColumnIndex);
            if (data instanceof IDColumn) {
                selectedDataList.add(((IDColumn)data).getRecord_ID());
            }
            if (data instanceof Integer) {
                selectedDataList.add((Integer)data);
            }
        }
        return selectedDataList;
    }

    public void dispose(boolean ok) {
        this.log.config("OK=" + ok);
        this.m_ok = ok;
        if (this.m_worker != null) {
            if (this.m_worker.isAlive()) {
                this.m_worker.interrupt();
            }
            this.log.config("Worker alive=" + this.m_worker.isAlive());
        }
        this.m_worker = null;
        this.saveSelection();
        this.m_frame.removeAll();
        this.m_frame.dispose();
        if (this.m_Browse.getAD_Process_ID() <= 0) {
            return;
        }
        MPInstance instance = new MPInstance(Env.getCtx(), this.m_Browse.getAD_Process_ID(), 0);
        instance.saveEx();
        DB.createT_Selection(instance.getAD_PInstance_ID(), this.getSelectedKeys(), null);
        this.m_pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        this.parameterPanel.saveParameters();
        ProcessCtl worker = new ProcessCtl(this, Env.getWindowNo(this.m_frame), this.m_pi, null);
        worker.start();
    }

    private void setupToolBar() {
        AppsAction a = new AppsAction("Ok", null, "Ok");
        this.bOk = new JButton(a);
        a = new AppsAction("Cancel", null, "Cancel");
        this.bCancel = new JButton(a);
        this.toolsBar = new JToolBar();
        a = new AppsAction("Print", null, "Print");
        this.bPrint = new JButton(a);
        a = new AppsAction("Zoom", null, "Zoom");
        this.bZoom = new JToggleButton(a);
        a = new AppsAction("Export", null, "Export");
        this.bExport = new JButton(a);
        a = new AppsAction("Delete", null, "Delete");
        this.bDelete = new JButton(a);
        a = new AppsAction("Find", null, "Find");
        this.bFind = new JButton(a);
    }

    private void initComponents() {
        this.toolsBar = new JToolBar();
        this.bPrint = new JButton();
        this.bZoom = new JToggleButton();
        this.bExport = new JButton();
        this.bDelete = new JButton();
        this.bFind = new JButton();
        this.tabsPanel = new JTabbedPane();
        this.searchTab = new JPanel();
        this.topPanel = new JPanel();
        this.searchPanel = new JPanel();
        this.buttonSearchPanel = new JPanel();
        this.bSearch = new JButton();
        this.centerPanel = new JScrollPane();
        this.detail = new MiniTable();
        this.footPanel = new JPanel();
        this.footButtonPanel = new JPanel();
        this.bCancel = new JButton();
        this.bOk = new JButton();
        this.processPanel = new JPanel();
        this.graphPanel = new JPanel();
        this.setupToolBar();
        this.toolsBar.setRollover(true);
        this.bPrint.setText("Print");
        this.bPrint.setFocusable(false);
        this.bPrint.setHorizontalTextPosition(0);
        this.bPrint.setVerticalTextPosition(3);
        this.bPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VBrowser.this.bPrintActionPerformed(evt);
            }
        });
        this.toolsBar.add(this.bPrint);
        this.bZoom.setText("Zoom");
        this.bZoom.setFocusable(false);
        this.bZoom.setHorizontalTextPosition(0);
        this.bZoom.setVerticalTextPosition(3);
        this.bZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VBrowser.this.bZoomActionPerformed(evt);
            }
        });
        this.toolsBar.add(this.bZoom);
        this.bExport.setText("Export");
        this.bExport.setFocusable(false);
        this.bExport.setHorizontalTextPosition(0);
        this.bExport.setVerticalTextPosition(3);
        this.bExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VBrowser.this.bExportActionPerformed(evt);
            }
        });
        this.toolsBar.add(this.bExport);
        this.bDelete.setText("Delete");
        this.bDelete.setFocusable(false);
        this.bDelete.setHorizontalTextPosition(0);
        this.bDelete.setVerticalTextPosition(3);
        this.bDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VBrowser.this.bDeleteActionPerformed(evt);
            }
        });
        this.toolsBar.add(this.bDelete);
        this.bFind.setText("Find");
        this.bFind.setFocusable(false);
        this.bFind.setHorizontalTextPosition(0);
        this.bFind.setVerticalTextPosition(3);
        this.bFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VBrowser.this.bFindActionPerformed(evt);
            }
        });
        this.toolsBar.add(this.bFind);
        AppsAction selectAllAction = new AppsAction("SelectAll", null, "Select All");
        JButton bSelectAll = new JButton(selectAllAction);
        bSelectAll.setHorizontalTextPosition(0);
        bSelectAll.setVerticalTextPosition(3);
        bSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!VBrowser.this.isAllSelected) {
                    int topIndex = VBrowser.this.detail.getShowTotals() ? 2 : 1;
                    ListSelectionModel selectionModel = VBrowser.this.detail.getSelectionModel();
                    selectionModel.setSelectionInterval(0, VBrowser.this.detail.getRowCount() - topIndex);
                    int rows = VBrowser.this.detail.getRowCount();
                    int row = 0;
                    while (row <= rows - topIndex) {
                        Object data = VBrowser.this.detail.getModel().getValueAt(row, VBrowser.this.m_keyColumnIndex);
                        if (data instanceof IDColumn) {
                            IDColumn dataColumn = (IDColumn)data;
                            dataColumn.setSelected(true);
                        }
                        ++row;
                    }
                } else {
                    VBrowser.this.detail.clearSelection();
                }
                VBrowser.this.isAllSelected = !VBrowser.this.isAllSelected;
            }
        });
        this.toolsBar.add(bSelectAll);
        this.m_frame.getContentPane().add((Component)this.toolsBar, "First");
        this.searchTab.setLayout(new BorderLayout());
        this.topPanel.setLayout(new BorderLayout());
        this.searchPanel.setLayout(new GridBagLayout());
        this.topPanel.add((Component)this.searchPanel, "North");
        this.bSearch.setText("Search");
        this.bSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VBrowser.this.bSearchActionPerformed(evt);
            }
        });
        this.buttonSearchPanel.add(this.bSearch);
        this.topPanel.add((Component)this.buttonSearchPanel, "Center");
        this.searchTab.add((Component)this.topPanel, "North");
        this.centerPanel.setViewportView(this.detail);
        this.searchTab.add((Component)this.centerPanel, "Center");
        this.footPanel.setLayout(new BorderLayout());
        this.bCancel.setText("Cancel");
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VBrowser.this.bCancelActionPerformed(evt);
            }
        });
        this.footButtonPanel.add(this.bCancel);
        this.bOk.setText("Ok");
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VBrowser.this.bOkActionPerformed(evt);
            }
        });
        this.footButtonPanel.add(this.bOk);
        this.footPanel.add((Component)this.footButtonPanel, "South");
        this.processPanel.setLayout(new BorderLayout());
        this.footPanel.add((Component)this.processPanel, "Center");
        this.searchTab.add((Component)this.footPanel, "South");
        this.tabsPanel.addTab("Search", this.searchTab);
        this.graphPanel.setLayout(new BorderLayout());
        this.tabsPanel.addTab("Graph", this.graphPanel);
        this.m_frame.getContentPane().add((Component)this.tabsPanel, "Center");
    }

    private void bZoomActionPerformed(ActionEvent evt) {
        this.cmd_zoom();
    }

    private void bOkActionPerformed(ActionEvent evt) {
        this.dispose(true);
    }

    private void bCancelActionPerformed(ActionEvent evt) {
        this.m_frame.dispose();
    }

    private void bSearchActionPerformed(ActionEvent evt) {
        this.executeQuery();
    }

    private void bFindActionPerformed(ActionEvent evt) {
    }

    private void bExportActionPerformed(ActionEvent evt) {
    }

    private void bDeleteActionPerformed(ActionEvent evt) {
    }

    private void bPrintActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        Splash.getSplash();
        Adempiere.startup(true);
        Ini.setProperty("ApplicationUserID", "SuperUser");
        Ini.setProperty("ApplicationPassword", "System");
        Ini.setProperty("Role", "GardenWorld Admin");
        Ini.setProperty("Client", "GardenWorld");
        Ini.setProperty("Organization", "HQ");
        Ini.setProperty("Warehouse", "HQ Warehouse");
        Ini.setProperty("Language", "English");
        Login login = new Login(Env.getCtx());
        login.batchLogin();
        Properties m_ctx = Env.getCtx();
        MBrowse browse = new MBrowse(m_ctx, 1000002, null);
        JFrame frame = new JFrame();
        boolean modal = true;
        int WindowNo = 0;
        String value = "";
        String keyColumn = "";
        boolean multiSelection = true;
        String whereClause = "";
        VBrowser browser = new VBrowser(frame, modal, WindowNo, value, browse, keyColumn, multiSelection, whereClause);
        browser.getFrame().setVisible(true);
        browser.getFrame().pack();
    }

    public CFrame getFrame() {
        return this.m_frame;
    }

    public Dimension getPreferredSize() {
        Dimension size = this.m_frame.getPreferredSize();
        if (size.width > 1024) {
            size.width = 994;
        }
        return size;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    @Override
    public void executeASync(ProcessInfo pi) {
    }

    @Override
    public boolean isUILocked() {
        return false;
    }

    @Override
    public void lockUI(ProcessInfo pi) {
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
    }

    class Worker
    extends Thread {
        private PreparedStatement m_pstmt = null;
        private ResultSet m_rs = null;

        Worker() {
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            VBrowser.this.detail.setRowCount(0);
            String dynWhere = VBrowser.this.getSQLWhere();
            StringBuffer sql = new StringBuffer(VBrowser.this.m_sqlMain);
            if (dynWhere.length() > 0) {
                sql.append(dynWhere);
            }
            sql.append(VBrowser.this.m_sqlOrder);
            String dataSql = Msg.parseTranslation(Env.getCtx(), sql.toString());
            dataSql = MRole.getDefault().addAccessSQL(dataSql, VBrowser.this.m_View.getParentEntityAliasName(), true, false);
            VBrowser.this.log.finer(dataSql);
            try {
                this.m_pstmt = DB.prepareStatement(dataSql, null);
                if (VBrowser.this.getParametersValues().size() > 0) {
                    DB.setParameters(this.m_pstmt, VBrowser.this.getParametersValues());
                }
                VBrowser.this.setParameters(this.m_pstmt, false);
                VBrowser.this.log.fine("Start query - " + (System.currentTimeMillis() - start) + "ms");
                this.m_rs = this.m_pstmt.executeQuery();
                VBrowser.this.log.fine("End query - " + (System.currentTimeMillis() - start) + "ms");
                while (this.m_rs.next()) {
                    if (this.isInterrupted()) {
                        VBrowser.this.log.finer("Interrupted");
                        this.close();
                        return;
                    }
                    int row = VBrowser.this.detail.getRowCount();
                    VBrowser.this.detail.setRowCount(row + 1);
                    int colOffset = 1;
                    int col = 0;
                    while (col < VBrowser.this.p_layout.length) {
                        Object data = null;
                        Class<?> c = VBrowser.this.p_layout[col].getColClass();
                        int colIndex = col + colOffset;
                        if (c == IDColumn.class) {
                            data = new IDColumn(this.m_rs.getInt(colIndex));
                        } else if (c == Boolean.class) {
                            data = new Boolean("Y".equals(this.m_rs.getString(colIndex)));
                        } else if (c == Timestamp.class) {
                            data = this.m_rs.getTimestamp(colIndex);
                        } else if (c == BigDecimal.class) {
                            data = this.m_rs.getBigDecimal(colIndex);
                        } else if (c == Double.class) {
                            data = new Double(this.m_rs.getDouble(colIndex));
                        } else if (c == Integer.class) {
                            data = new Integer(this.m_rs.getInt(colIndex));
                        } else if (c == KeyNamePair.class) {
                            String display = this.m_rs.getString(colIndex);
                            int key = this.m_rs.getInt(colIndex + 1);
                            data = new KeyNamePair(key, display);
                            ++colOffset;
                        } else {
                            data = this.m_rs.getString(colIndex);
                        }
                        VBrowser.this.detail.setValueAt(data, row, col);
                        ++col;
                    }
                }
            }
            catch (SQLException e) {
                VBrowser.this.log.log(Level.SEVERE, dataSql, e);
            }
            this.close();
            int no = VBrowser.this.detail.getRowCount();
            VBrowser.this.log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
            if (VBrowser.this.detail.getShowTotals()) {
                VBrowser.this.detail.addTotals(VBrowser.this.p_layout);
            }
            VBrowser.this.detail.autoSize();
            VBrowser.this.m_frame.setCursor(Cursor.getDefaultCursor());
            VBrowser.this.setStatusLine(String.valueOf(Integer.toString(no)) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
            VBrowser.this.setStatusDB(Integer.toString(no));
            if (no == 0) {
                VBrowser.this.log.fine(dataSql);
            } else {
                VBrowser.this.detail.getSelectionModel().setSelectionInterval(0, 0);
                VBrowser.this.detail.requestFocus();
            }
        }

        private void close() {
            DB.close(this.m_rs, this.m_pstmt);
            this.m_rs = null;
            this.m_pstmt = null;
        }
    }
}

