/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.adempiere.exceptions.DBException;
import org.compiere.apps.form.GenForm;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderBOMLine;

public class OrderReceiptIssue
extends GenForm {
    private static CLogger log = CLogger.getCLogger(OrderReceiptIssue.class);
    String m_sql = "";
    private boolean m_isOnlyReceipt = false;
    private boolean m_OnlyIssue = false;
    protected boolean m_IsBackflush = false;
    protected Timestamp m_movementDate = null;
    protected BigDecimal m_orderedQty = Env.ZERO;
    protected BigDecimal m_DeliveredQty = Env.ZERO;
    protected BigDecimal m_toDeliverQty = Env.ZERO;
    protected BigDecimal m_scrapQty = Env.ZERO;
    protected BigDecimal m_rejectQty = Env.ZERO;
    protected BigDecimal m_openQty = Env.ZERO;
    protected BigDecimal m_qtyBatchs = Env.ZERO;
    protected BigDecimal m_qtyBatchSize = Env.ZERO;
    protected int m_M_AttributeSetInstance_ID = 0;
    protected int m_M_Locator_ID = 0;
    private int m_PP_Order_ID = 0;
    private MPPOrder m_PP_order = null;

    @Override
    public void configureMiniTable(IMiniTable iMiniTable) {
        iMiniTable.addColumn("PP_Order_BOMLine_ID");
        iMiniTable.addColumn("IsCritical");
        iMiniTable.addColumn("Value");
        iMiniTable.addColumn("M_Product_ID");
        iMiniTable.addColumn("C_UOM_ID");
        iMiniTable.addColumn("M_AttributeSetInstance_ID");
        iMiniTable.addColumn("QtyRequiered");
        iMiniTable.addColumn("QtyDelivered");
        iMiniTable.addColumn("QtyToDeliver");
        iMiniTable.addColumn("QtyScrap");
        iMiniTable.addColumn("QtyOnHand");
        iMiniTable.addColumn("QtyReserved");
        iMiniTable.addColumn("QtyAvailable");
        iMiniTable.addColumn("M_Locator_ID");
        iMiniTable.addColumn("M_Warehouse_ID");
        iMiniTable.addColumn("QtyBOM");
        iMiniTable.addColumn("IsQtyPercentage");
        iMiniTable.addColumn("QtyBatch");
        iMiniTable.setMultiSelection(true);
        iMiniTable.setColumnClass(0, IDColumn.class, false, " ");
        iMiniTable.setColumnClass(1, Boolean.class, true, Msg.translate(Env.getCtx(), "IsCritical"));
        iMiniTable.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "Value"));
        iMiniTable.setColumnClass(3, KeyNamePair.class, true, Msg.translate(Env.getCtx(), "M_Product_ID"));
        iMiniTable.setColumnClass(4, KeyNamePair.class, true, Msg.translate(Env.getCtx(), "C_UOM_ID"));
        iMiniTable.setColumnClass(5, String.class, true, Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID"));
        iMiniTable.setColumnClass(6, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyRequired"));
        iMiniTable.setColumnClass(7, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyDelivered"));
        iMiniTable.setColumnClass(8, BigDecimal.class, false, Msg.translate(Env.getCtx(), "QtyToDeliver"));
        iMiniTable.setColumnClass(9, BigDecimal.class, false, Msg.translate(Env.getCtx(), "QtyScrap"));
        iMiniTable.setColumnClass(10, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyOnHand"));
        iMiniTable.setColumnClass(11, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyReserved"));
        iMiniTable.setColumnClass(12, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyAvailable"));
        iMiniTable.setColumnClass(13, String.class, true, Msg.translate(Env.getCtx(), "M_Locator_ID"));
        iMiniTable.setColumnClass(14, KeyNamePair.class, true, Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        iMiniTable.setColumnClass(15, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyBom"));
        iMiniTable.setColumnClass(16, Boolean.class, true, Msg.translate(Env.getCtx(), "IsQtyPercentage"));
        iMiniTable.setColumnClass(17, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyBatch"));
        iMiniTable.autoSize();
        iMiniTable.setRowCount(0);
        this.m_sql = "SELECT obl.PP_Order_BOMLine_ID,obl.IsCritical,p.Value,obl.M_Product_ID,p.Name,p.C_UOM_ID,u.Name,obl.QtyRequired,obl.QtyReserved,bomQtyAvailable(obl.M_Product_ID,obl.M_Warehouse_ID,0 ) AS QtyAvailable,bomQtyOnHand(obl.M_Product_ID,obl.M_Warehouse_ID,0) AS QtyOnHand,p.M_Locator_ID,obl.M_Warehouse_ID,w.Name,obl.QtyBom,obl.isQtyPercentage,obl.QtyBatch,obl.ComponentType,obl.QtyRequired - QtyDelivered AS QtyOpen,obl.QtyDelivered FROM PP_Order_BOMLine obl INNER JOIN M_Product p ON (obl.M_Product_ID = p.M_Product_ID)  INNER JOIN C_UOM u ON (p.C_UOM_ID = u.C_UOM_ID)  INNER JOIN M_Warehouse w ON (w.M_Warehouse_ID = obl.M_Warehouse_ID)  WHERE obl.PP_Order_ID = ? ORDER BY obl.Line";
    }

    private String createHTMLTable(String[][] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("<table width=\"100%\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            stringBuffer.append("<tr>");
            for (int j = 0; j < stringArray[i].length; ++j) {
                stringBuffer.append("<td>");
                if (stringArray[i][j] != null) {
                    stringBuffer.append(stringArray[i][j]);
                }
                stringBuffer.append("</td>");
            }
            stringBuffer.append("</tr>");
        }
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    public void createIssue(MPPOrder mPPOrder, IMiniTable iMiniTable) {
        Comparable comparable;
        Serializable serializable;
        int n;
        Timestamp timestamp;
        Timestamp timestamp2 = timestamp = this.getMovementDate();
        boolean bl = false;
        ArrayList[][] arrayListArray = new ArrayList[iMiniTable.getRowCount()][1];
        int n2 = 0;
        for (n = 0; n < iMiniTable.getRowCount(); ++n) {
            serializable = new ArrayList();
            IDColumn iDColumn = (IDColumn)iMiniTable.getValueAt(n, 0);
            comparable = new KeyNamePair(iDColumn.getRecord_ID(), iDColumn.isSelected() ? "Y" : "N");
            ((ArrayList)serializable).add(comparable);
            ((ArrayList)serializable).add(iMiniTable.getValueAt(n, 1));
            ((ArrayList)serializable).add(iMiniTable.getValueAt(n, 2));
            ((ArrayList)serializable).add(iMiniTable.getValueAt(n, 3));
            ((ArrayList)serializable).add(this.getValueBigDecimal(iMiniTable, n, 8));
            ((ArrayList)serializable).add(this.getValueBigDecimal(iMiniTable, n, 9));
            arrayListArray[n2][0] = serializable;
            ++n2;
        }
        bl = MPPOrder.isQtyAvailable(mPPOrder, arrayListArray, timestamp2);
        for (n = 0; n < arrayListArray.length; ++n) {
            serializable = (KeyNamePair)arrayListArray[n][0].get(0);
            boolean bl2 = ((NamePair)serializable).getName().equals("Y");
            if (serializable == null || !bl2) continue;
            comparable = (Boolean)arrayListArray[n][0].get(1);
            String string = (String)arrayListArray[n][0].get(2);
            KeyNamePair keyNamePair = (KeyNamePair)arrayListArray[n][0].get(3);
            int n3 = keyNamePair.getKey();
            MPPOrderBOMLine mPPOrderBOMLine = null;
            int n4 = 0;
            int n5 = 0;
            BigDecimal bigDecimal = (BigDecimal)arrayListArray[n][0].get(4);
            BigDecimal bigDecimal2 = (BigDecimal)arrayListArray[n][0].get(5);
            MProduct mProduct = MProduct.get(mPPOrder.getCtx(), n3);
            if (mProduct == null || mProduct.get_ID() == 0 || !mProduct.isStocked()) continue;
            if (string == null && bl2) {
                n5 = ((KeyNamePair)serializable).getKey();
                mPPOrderBOMLine = MPPOrderBOMLine.forM_Product_ID(Env.getCtx(), mPPOrder.get_ID(), n3, mPPOrder.get_TrxName());
                if (mPPOrderBOMLine != null) {
                    n4 = mPPOrderBOMLine.get_ID();
                }
            } else if (string != null && bl2 && (n4 = Integer.valueOf(((KeyNamePair)serializable).getKey()).intValue()) > 0) {
                mPPOrderBOMLine = new MPPOrderBOMLine(mPPOrder.getCtx(), n4, mPPOrder.get_TrxName());
                n5 = mPPOrderBOMLine.getM_AttributeSetInstance_ID();
            }
            MStorage[] mStorageArray = MPPOrder.getStorages(Env.getCtx(), n3, mPPOrder.getM_Warehouse_ID(), n5, timestamp2, mPPOrder.get_TrxName());
            MPPOrder.createIssue(mPPOrder, n4, timestamp, bigDecimal, bigDecimal2, Env.ZERO, mStorageArray, false);
        }
    }

    public void executeQuery(IMiniTable iMiniTable) {
        int n = 0;
        iMiniTable.setRowCount(n);
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement("SELECT obl.PP_Order_BOMLine_ID,obl.IsCritical,p.Value,obl.M_Product_ID,p.Name,p.C_UOM_ID,u.Name,obl.QtyRequired,obl.QtyReserved,bomQtyAvailable(obl.M_Product_ID,obl.M_Warehouse_ID,0 ) AS QtyAvailable,bomQtyOnHand(obl.M_Product_ID,obl.M_Warehouse_ID,0) AS QtyOnHand,p.M_Locator_ID,obl.M_Warehouse_ID,w.Name,obl.QtyBom,obl.isQtyPercentage,obl.QtyBatch,obl.ComponentType,obl.QtyRequired - QtyDelivered AS QtyOpen,obl.QtyDelivered FROM PP_Order_BOMLine obl INNER JOIN M_Product p ON (obl.M_Product_ID = p.M_Product_ID)  INNER JOIN C_UOM u ON (p.C_UOM_ID = u.C_UOM_ID)  INNER JOIN M_Warehouse w ON (w.M_Warehouse_ID = obl.M_Warehouse_ID)  WHERE obl.PP_Order_ID = ? ORDER BY obl.Line", null);
            cPreparedStatement.setInt(1, this.getPP_Order_ID());
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                iMiniTable.setRowCount(n + 1);
                IDColumn iDColumn = new IDColumn(resultSet.getInt(1));
                BigDecimal bigDecimal = resultSet.getBigDecimal(15);
                Boolean bl = resultSet.getString(16).equals("Y");
                Boolean bl2 = resultSet.getString(2).equals("Y");
                BigDecimal bigDecimal2 = resultSet.getBigDecimal(17);
                BigDecimal bigDecimal3 = resultSet.getBigDecimal(8);
                BigDecimal bigDecimal4 = resultSet.getBigDecimal(11);
                BigDecimal bigDecimal5 = resultSet.getBigDecimal(19);
                BigDecimal bigDecimal6 = resultSet.getBigDecimal(20);
                String string = resultSet.getString(18);
                BigDecimal bigDecimal7 = this.getToDeliverQty();
                BigDecimal bigDecimal8 = this.getOpenQty();
                BigDecimal bigDecimal9 = this.getScrapQty();
                BigDecimal bigDecimal10 = Env.ZERO;
                BigDecimal bigDecimal11 = Env.ZERO;
                BigDecimal bigDecimal12 = Env.ZERO;
                BigDecimal bigDecimal13 = Env.ZERO;
                iDColumn.setSelected(this.isOnlyReceipt());
                iMiniTable.setValueAt(iDColumn, n, 0);
                iMiniTable.setValueAt(bl2, n, 1);
                iMiniTable.setValueAt(resultSet.getString(3), n, 2);
                iMiniTable.setValueAt(new KeyNamePair(resultSet.getInt(4), resultSet.getString(5)), n, 3);
                iMiniTable.setValueAt(new KeyNamePair(resultSet.getInt(6), resultSet.getString(7)), n, 4);
                iMiniTable.setValueAt(bigDecimal3, n, 6);
                iMiniTable.setValueAt(bigDecimal6, n, 7);
                iMiniTable.setValueAt(bigDecimal4, n, 10);
                iMiniTable.setValueAt(resultSet.getBigDecimal(9), n, 11);
                iMiniTable.setValueAt(resultSet.getBigDecimal(10), n, 12);
                iMiniTable.setValueAt(new KeyNamePair(resultSet.getInt(13), resultSet.getString(14)), n, 14);
                iMiniTable.setValueAt(bigDecimal, n, 15);
                iMiniTable.setValueAt(bl, n, 16);
                iMiniTable.setValueAt(bigDecimal2, n, 17);
                if (string.equals("CO") || string.equals("PK")) {
                    iDColumn.setSelected(bigDecimal4.signum() > 0 && bigDecimal3.signum() > 0);
                    iMiniTable.setValueAt(iDColumn, n, 0);
                    if (bl.booleanValue()) {
                        BigDecimal bigDecimal14 = bigDecimal2.divide(Env.ONEHUNDRED, 8, RoundingMode.HALF_UP);
                        if (this.isBackflush()) {
                            if (bigDecimal3.signum() == 0 || bigDecimal5.signum() == 0) {
                                bigDecimal10 = Env.ZERO;
                            } else {
                                bigDecimal10 = bigDecimal7.multiply(bigDecimal14);
                                if (bigDecimal3.subtract(bigDecimal6).signum() < 0 | bigDecimal10.signum() == 0) {
                                    bigDecimal10 = bigDecimal3.subtract(bigDecimal6);
                                }
                            }
                            if (bigDecimal10.signum() != 0) {
                                bigDecimal13 = bigDecimal10.setScale(4, 4);
                                iMiniTable.setValueAt(bigDecimal10, n, 8);
                            }
                        } else {
                            bigDecimal10 = bigDecimal5;
                            if (bigDecimal10.signum() != 0) {
                                bigDecimal12 = bigDecimal8.multiply(bigDecimal14);
                                bigDecimal13 = bigDecimal10.setScale(4, 4);
                                iMiniTable.setValueAt(bigDecimal10.setScale(8, 4), n, 8);
                                iMiniTable.setValueAt(bigDecimal8.multiply(bigDecimal14), n, 6);
                            }
                        }
                        if (bigDecimal9.signum() != 0) {
                            bigDecimal11 = bigDecimal9.multiply(bigDecimal14);
                            if (bigDecimal11.signum() != 0) {
                                iMiniTable.setValueAt(bigDecimal11, n, 9);
                            }
                        } else {
                            iMiniTable.setValueAt(bigDecimal11, n, 9);
                        }
                    } else {
                        if (this.isBackflush()) {
                            bigDecimal10 = bigDecimal7.multiply(bigDecimal);
                            if (bigDecimal10.signum() != 0) {
                                bigDecimal12 = bigDecimal7.multiply(bigDecimal);
                                bigDecimal13 = bigDecimal10;
                                iMiniTable.setValueAt(bigDecimal12, n, 6);
                                iMiniTable.setValueAt(bigDecimal10, n, 8);
                            }
                        } else {
                            bigDecimal10 = bigDecimal5;
                            if (bigDecimal10.signum() != 0) {
                                bigDecimal12 = bigDecimal8.multiply(bigDecimal);
                                bigDecimal13 = bigDecimal10;
                                iMiniTable.setValueAt(bigDecimal12, n, 6);
                                iMiniTable.setValueAt(bigDecimal10, n, 8);
                            }
                        }
                        if (bigDecimal9.signum() != 0) {
                            bigDecimal11 = bigDecimal9.multiply(bigDecimal);
                            if (bigDecimal11.signum() != 0) {
                                iMiniTable.setValueAt(bigDecimal11, n, 9);
                            }
                        } else {
                            iMiniTable.setValueAt(bigDecimal11, n, 9);
                        }
                    }
                } else if (string.equals("TL")) {
                    bigDecimal10 = bigDecimal;
                    if (bigDecimal10.signum() != 0) {
                        bigDecimal12 = bigDecimal;
                        bigDecimal13 = bigDecimal10;
                        iMiniTable.setValueAt(bigDecimal, n, 6);
                        iMiniTable.setValueAt(bigDecimal10, n, 8);
                    }
                } else {
                    iMiniTable.setValueAt(Env.ZERO, n, 6);
                }
                ++n;
                if (!this.isOnlyIssue() && !this.isBackflush()) continue;
                int n2 = resultSet.getInt(13);
                int n3 = resultSet.getInt(4);
                n += this.lotes(n, iDColumn, n2, n3, bigDecimal12, bigDecimal13, iMiniTable);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException(sQLException);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
        iMiniTable.autoSize();
    }

    public String generateSummaryTable(IMiniTable iMiniTable, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2, boolean bl3) {
        String[][] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<b>");
        stringBuffer.append(Msg.translate(Env.getCtx(), "IsShipConfirm"));
        stringBuffer.append("</b>");
        stringBuffer.append("<br />");
        if (bl3 || bl) {
            stringArray = new String[][]{{Msg.translate(Env.getCtx(), "Name"), Msg.translate(Env.getCtx(), "C_UOM_ID"), Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID"), Msg.translate(Env.getCtx(), "QtyToDeliver"), Msg.translate(Env.getCtx(), "QtyDelivered"), Msg.translate(Env.getCtx(), "QtyScrap")}, {string, string2, string3, string4, string5, string6}};
            stringBuffer.append(this.createHTMLTable(stringArray));
        }
        if (bl || bl2) {
            stringBuffer.append("<br /><br />");
            stringArray = new ArrayList();
            stringArray.add(new String[]{Msg.translate(Env.getCtx(), "Value"), Msg.translate(Env.getCtx(), "Name"), Msg.translate(Env.getCtx(), "C_UOM_ID"), Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID"), Msg.translate(Env.getCtx(), "QtyToDeliver"), Msg.translate(Env.getCtx(), "QtyDelivered"), Msg.translate(Env.getCtx(), "QtyScrap")});
            block0: for (int i = 0; i < iMiniTable.getRowCount(); ++i) {
                String[] stringArray2;
                IDColumn iDColumn = (IDColumn)iMiniTable.getValueAt(i, 0);
                if (iDColumn == null || !iDColumn.isSelected()) continue;
                KeyNamePair keyNamePair = (KeyNamePair)iMiniTable.getValueAt(i, 3);
                int n = keyNamePair.getKey();
                KeyNamePair keyNamePair2 = (KeyNamePair)iMiniTable.getValueAt(i, 4);
                if (iMiniTable.getValueAt(i, 5) == null) {
                    String[] stringArray3 = stringArray2 = this.getMovementDate();
                    MStorage[] mStorageArray = MPPOrder.getStorages(Env.getCtx(), n, this.getPP_Order().getM_Warehouse_ID(), 0, (Timestamp)stringArray3, null);
                    BigDecimal bigDecimal = this.getValueBigDecimal(iMiniTable, i, 8);
                    BigDecimal bigDecimal2 = this.getValueBigDecimal(iMiniTable, i, 9);
                    BigDecimal bigDecimal3 = bigDecimal.add(bigDecimal2);
                    for (MStorage mStorage : mStorageArray) {
                        if (mStorage.getQtyOnHand().signum() == 0) continue;
                        BigDecimal bigDecimal4 = bigDecimal3;
                        if (bigDecimal4.compareTo(mStorage.getQtyOnHand()) > 0) {
                            bigDecimal4 = mStorage.getQtyOnHand();
                        }
                        bigDecimal3 = bigDecimal3.subtract(bigDecimal4);
                        String string7 = new MAttributeSetInstance(Env.getCtx(), mStorage.getM_AttributeSetInstance_ID(), null).getDescription();
                        String[] stringArray4 = new String[]{"", "", "", "", "0.00", "0.00", "0.00"};
                        stringArray4[0] = iMiniTable.getValueAt(i, 2) != null ? iMiniTable.getValueAt(i, 2).toString() : "";
                        stringArray4[1] = keyNamePair.toString();
                        stringArray4[2] = keyNamePair2 != null ? keyNamePair2.toString() : "";
                        stringArray4[3] = string7 != null ? string7 : "";
                        stringArray4[4] = bigDecimal4.setScale(2, 4).toString();
                        stringArray4[5] = this.getValueBigDecimal(iMiniTable, i, 7).setScale(2, 4).toString();
                        stringArray4[6] = this.getValueBigDecimal(iMiniTable, i, 9).toString();
                        stringArray.add(stringArray4);
                        if (bigDecimal3.signum() <= 0) continue block0;
                    }
                    continue;
                }
                stringArray2 = new String[]{"", "", "", "", "0.00", "0.00", "0.00"};
                stringArray2[0] = iMiniTable.getValueAt(i, 2) != null ? iMiniTable.getValueAt(i, 2).toString() : "";
                stringArray2[1] = keyNamePair.toString();
                stringArray2[2] = keyNamePair2 != null ? keyNamePair2.toString() : "";
                stringArray2[3] = iMiniTable.getValueAt(i, 5) != null ? iMiniTable.getValueAt(i, 5).toString() : "";
                stringArray2[4] = this.getValueBigDecimal(iMiniTable, i, 8).toString();
                stringArray2[5] = this.getValueBigDecimal(iMiniTable, i, 7).toString();
                stringArray2[6] = this.getValueBigDecimal(iMiniTable, i, 9).toString();
                stringArray.add(stringArray2);
            }
            String[][] stringArray5 = (String[][])stringArray.toArray((T[])new String[stringArray.size()][]);
            stringBuffer.append(this.createHTMLTable(stringArray5));
        }
        return stringBuffer.toString();
    }

    protected BigDecimal getDeliveredQty() {
        return this.m_DeliveredQty;
    }

    protected int getM_AttributeSetInstance_ID() {
        return this.m_M_AttributeSetInstance_ID;
    }

    protected int getM_Locator_ID() {
        return this.m_M_Locator_ID;
    }

    protected Timestamp getMovementDate() {
        return this.m_movementDate;
    }

    protected BigDecimal getOpenQty() {
        return this.m_openQty;
    }

    protected BigDecimal getOrderedQty() {
        return this.m_orderedQty;
    }

    protected MPPOrder getPP_Order() {
        int n = this.getPP_Order_ID();
        if (n <= 0) {
            this.m_PP_order = null;
            return null;
        }
        if (this.m_PP_order == null || this.m_PP_order.get_ID() != n) {
            this.m_PP_order = new MPPOrder(Env.getCtx(), n, null);
        }
        return this.m_PP_order;
    }

    protected int getPP_Order_ID() {
        return this.m_PP_Order_ID;
    }

    protected BigDecimal getQtyBatchs() {
        return this.m_qtyBatchs;
    }

    protected BigDecimal getQtyBatchSize() {
        return this.m_qtyBatchSize;
    }

    protected BigDecimal getRejectQty() {
        return this.m_rejectQty;
    }

    protected BigDecimal getScrapQty() {
        return this.m_scrapQty;
    }

    protected BigDecimal getToDeliverQty() {
        return this.m_toDeliverQty;
    }

    private BigDecimal getValueBigDecimal(IMiniTable iMiniTable, int n, int n2) {
        BigDecimal bigDecimal = (BigDecimal)iMiniTable.getValueAt(n, n2);
        return bigDecimal == null ? Env.ZERO : bigDecimal;
    }

    protected boolean isBackflush() {
        return this.m_IsBackflush;
    }

    protected boolean isOnlyIssue() {
        return this.m_OnlyIssue;
    }

    protected boolean isOnlyReceipt() {
        return this.m_isOnlyReceipt;
    }

    private int lotes(int n, IDColumn iDColumn, int n2, int n3, BigDecimal bigDecimal, BigDecimal bigDecimal2, IMiniTable iMiniTable) {
        int n4 = 0;
        BigDecimal bigDecimal3 = bigDecimal;
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement("SELECT s.M_Product_ID , s.QtyOnHand, s.M_AttributeSetInstance_ID, p.Name, masi.Description, l.Value, w.Value, w.M_warehouse_ID,p.Value  FROM M_Storage s  INNER JOIN M_Product p ON (s.M_Product_ID = p.M_Product_ID)  INNER JOIN C_UOM u ON (u.C_UOM_ID = p.C_UOM_ID)  INNER JOIN M_AttributeSetInstance masi ON (masi.M_AttributeSetInstance_ID = s.M_AttributeSetInstance_ID)  INNER JOIN M_Warehouse w ON (w.M_Warehouse_ID = ?)  INNER JOIN M_Locator l ON(l.M_Warehouse_ID=w.M_Warehouse_ID and s.M_Locator_ID=l.M_Locator_ID)  WHERE s.M_Product_ID = ? and s.QtyOnHand > 0  and s.M_AttributeSetInstance_ID <> 0  ORDER BY s.Created ", null);
            cPreparedStatement.setInt(1, n2);
            cPreparedStatement.setInt(2, n3);
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                iMiniTable.setRowCount(n + 1);
                BigDecimal bigDecimal4 = resultSet.getBigDecimal(2);
                IDColumn iDColumn2 = new IDColumn(resultSet.getInt(3));
                iDColumn2.setSelected(false);
                iMiniTable.setValueAt(iDColumn2, n, 0);
                KeyNamePair keyNamePair = new KeyNamePair(resultSet.getInt(1), resultSet.getString(4));
                iMiniTable.setValueAt(keyNamePair, n, 3);
                iMiniTable.setValueAt(bigDecimal4, n, 10);
                iMiniTable.setValueAt(resultSet.getString(5), n, 5);
                iMiniTable.setValueAt(resultSet.getString(6), n, 13);
                KeyNamePair keyNamePair2 = new KeyNamePair(resultSet.getInt(8), resultSet.getString(7));
                iMiniTable.setValueAt(keyNamePair2, n, 14);
                iMiniTable.setValueAt(Env.ZERO, n, 6);
                iMiniTable.setValueAt(Env.ZERO, n, 8);
                iMiniTable.setValueAt(Env.ZERO, n, 9);
                if (bigDecimal3.compareTo(bigDecimal4) < 0) {
                    iMiniTable.setValueAt(bigDecimal3.signum() > 0 ? bigDecimal3 : Env.ZERO, n, 6);
                } else {
                    iMiniTable.setValueAt(bigDecimal4, n, 6);
                }
                bigDecimal3 = bigDecimal3.subtract(bigDecimal4);
                ++n4;
                ++n;
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException(sQLException);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
        return n4;
    }

    @Override
    public void saveSelection(IMiniTable iMiniTable) {
        log.info("");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.setSelection(null);
        int n = iMiniTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            IDColumn iDColumn = (IDColumn)iMiniTable.getValueAt(i, 0);
            if (iDColumn == null || !iDColumn.isSelected()) continue;
            arrayList.add(iDColumn.getRecord_ID());
        }
        if (arrayList.size() == 0) {
            return;
        }
        log.config("Selected #" + arrayList.size());
        this.setSelection(arrayList);
    }

    protected void setDeliveredQty(BigDecimal bigDecimal) {
        this.m_DeliveredQty = bigDecimal;
    }

    protected void setIsBackflush(boolean bl) {
        this.m_IsBackflush = bl;
    }

    protected void setIsOnlyIssue(boolean bl) {
        this.m_OnlyIssue = bl;
    }

    protected void setIsOnlyReceipt(boolean bl) {
        this.m_isOnlyReceipt = bl;
    }

    protected void setM_AttributeSetInstance_ID(int n) {
        this.m_M_AttributeSetInstance_ID = n;
    }

    protected void setM_Locator_ID(int n) {
        this.m_M_Locator_ID = n;
    }

    protected void setMovementDate(Timestamp timestamp) {
        this.m_movementDate = timestamp;
    }

    protected void setOpenQty(BigDecimal bigDecimal) {
        this.m_openQty = bigDecimal;
    }

    protected void setOrderedQty(BigDecimal bigDecimal) {
        this.m_orderedQty = bigDecimal;
    }

    protected void setPP_Order_ID(int n) {
        this.m_PP_Order_ID = n;
    }

    protected void setQtyBatchs(BigDecimal bigDecimal) {
        this.m_qtyBatchs = bigDecimal;
    }

    protected void setQtyBatchSize(BigDecimal bigDecimal) {
        this.m_qtyBatchSize = bigDecimal;
    }

    protected void setRejectQty(BigDecimal bigDecimal) {
        this.m_rejectQty = bigDecimal;
    }

    protected void setScrapQty(BigDecimal bigDecimal) {
        this.m_scrapQty = bigDecimal;
    }

    protected void setToDeliverQty(BigDecimal bigDecimal) {
        this.m_toDeliverQty = bigDecimal;
    }

    public void showMessage(String string, boolean bl) {
    }
}

