/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.apps.IStatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.GenForm;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.print.MPrintFormat;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;

public class OrderDistributionReceipt
extends GenForm {
    public FormFrame m_frame;
    public Object m_DD_Order_ID = null;
    public Object m_MovementDate = null;
    private static CLogger log = CLogger.getCLogger(OrderDistributionReceipt.class);

    @Override
    public void dynInit() throws Exception {
        this.setTitle("MovementGenerateInfo");
        MPrintFormat mPrintFormat = MPrintFormat.get(Env.getCtx(), MPrintFormat.getPrintFormat_ID("Inventory Move Hdr (Example)", MMovement.Table_ID, 0), false);
        this.setPrintFormat(mPrintFormat);
        this.setAskPrintMsg("PrintMovements");
    }

    @Override
    public void configureMiniTable(IMiniTable iMiniTable) {
        iMiniTable.addColumn("DD_Order_ID");
        iMiniTable.addColumn("QtyInTransit");
        iMiniTable.addColumn("C_UOM_ID");
        iMiniTable.addColumn("Value");
        iMiniTable.addColumn("M_Product_ID");
        iMiniTable.addColumn("M_WarehouseSource_ID");
        iMiniTable.setMultiSelection(true);
        iMiniTable.setColumnClass(0, IDColumn.class, false, " ");
        iMiniTable.setColumnClass(1, BigDecimal.class, false, Msg.translate(Env.getCtx(), "QtyInTransit"));
        iMiniTable.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "C_UOM_ID"));
        iMiniTable.setColumnClass(3, String.class, true, Msg.translate(Env.getCtx(), "M_Product_ID"));
        iMiniTable.setColumnClass(4, String.class, true, Msg.translate(Env.getCtx(), "Value"));
        iMiniTable.setColumnClass(5, String.class, true, Msg.translate(Env.getCtx(), "WarehouseSource"));
        iMiniTable.autoSize();
    }

    private String getOrderSQL() {
        StringBuffer stringBuffer = new StringBuffer("SELECT ol.DD_OrderLine_ID, ol.QtyInTransit , uom.Name , p.Value ,p.Name  , w.Name FROM DD_OrderLine ol INNER JOIN DD_Order o ON (o.DD_Order_ID=ol.DD_Order_ID) INNER JOIN M_Product p ON (p.M_Product_ID=ol.M_Product_ID)  INNER JOIN C_UOM uom  ON (uom.C_UOM_ID=ol.C_UOM_ID) INNER JOIN M_Locator  l ON (l.M_Locator_ID = ol.M_Locator_ID) INNER JOIN M_Warehouse  w ON (w.M_Warehouse_ID = l.M_Warehouse_ID) WHERE o.DocStatus= 'CO' AND  ol.QtyInTransit > 0  AND  o.DD_Order_ID = ? ");
        return stringBuffer.toString();
    }

    public void executeQuery(IMiniTable iMiniTable) {
        log.info("");
        String string = "";
        if (this.m_DD_Order_ID == null) {
            return;
        }
        string = this.getOrderSQL();
        log.fine(string);
        int n = 0;
        iMiniTable.setRowCount(n);
        try {
            CPreparedStatement cPreparedStatement = DB.prepareStatement(string.toString(), null);
            cPreparedStatement.setInt(1, Integer.parseInt(this.m_DD_Order_ID.toString()));
            ResultSet resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                iMiniTable.setRowCount(n + 1);
                iMiniTable.setValueAt(new IDColumn(resultSet.getInt(1)), n, 0);
                iMiniTable.setValueAt(resultSet.getBigDecimal(2), n, 1);
                iMiniTable.setValueAt(resultSet.getString(3), n, 2);
                iMiniTable.setValueAt(resultSet.getString(4), n, 4);
                iMiniTable.setValueAt(resultSet.getString(5), n, 3);
                iMiniTable.setValueAt(resultSet.getString(6), n, 5);
                ++n;
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, string.toString(), sQLException);
        }
        iMiniTable.autoSize();
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void saveSelection(IMiniTable iMiniTable) {
        log.info("");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.setSelection(null);
        int n = iMiniTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            IDColumn iDColumn = (IDColumn)iMiniTable.getValueAt(i, 0);
            if (iDColumn == null || !iDColumn.isSelected()) continue;
            arrayList.add(iDColumn.getRecord_ID());
        }
        if (arrayList.size() == 0) {
            return;
        }
        log.config("Selected #" + arrayList.size());
        this.setSelection(arrayList);
    }

    public String generate(MiniTable miniTable, IStatusBar iStatusBar, String string) {
        String string2 = "";
        log.info("DD_Order_ID=" + this.m_DD_Order_ID);
        log.info("MovementDate" + this.m_MovementDate);
        String string3 = Trx.createTrxName("MVG");
        Trx trx = Trx.get(string3, true);
        this.setSelectionActive(false);
        iStatusBar.setStatusLine(Msg.translate(Env.getCtx(), "M_Movement_ID"));
        iStatusBar.setStatusDB(String.valueOf(this.getSelection().size()));
        Properties properties = Env.getCtx();
        Timestamp timestamp = (Timestamp)this.m_MovementDate;
        MDDOrder mDDOrder = new MDDOrder(properties, Integer.parseInt(this.m_DD_Order_ID.toString()), string3);
        MMovement mMovement = new MMovement(properties, 0, string3);
        mMovement.setDD_Order_ID(mDDOrder.getDD_Order_ID());
        mMovement.setAD_User_ID(mDDOrder.getAD_User_ID());
        mMovement.setPOReference(mDDOrder.getPOReference());
        mMovement.setReversal_ID(0);
        mMovement.setM_Shipper_ID(mDDOrder.getM_Shipper_ID());
        mMovement.setDescription(mDDOrder.getDescription());
        mMovement.setC_BPartner_ID(mDDOrder.getC_BPartner_ID());
        mMovement.setC_BPartner_Location_ID(mDDOrder.getC_BPartner_Location_ID());
        mMovement.setAD_Org_ID(mDDOrder.getAD_Org_ID());
        mMovement.setAD_OrgTrx_ID(mDDOrder.getAD_OrgTrx_ID());
        mMovement.setAD_User_ID(mDDOrder.getAD_User_ID());
        mMovement.setC_Activity_ID(mDDOrder.getC_Activity_ID());
        mMovement.setC_Campaign_ID(mDDOrder.getC_Campaign_ID());
        mMovement.setC_Project_ID(mDDOrder.getC_Project_ID());
        mMovement.setMovementDate(timestamp);
        mMovement.setDeliveryRule(mDDOrder.getDeliveryRule());
        mMovement.setDeliveryViaRule(mDDOrder.getDeliveryViaRule());
        mMovement.setDocAction("PR");
        mMovement.setDocStatus("DR");
        mMovement.saveEx();
        ArrayList<Integer> arrayList = this.getSelection();
        int n = 0;
        for (int n2 : arrayList) {
            MDDOrderLine mDDOrderLine = new MDDOrderLine(properties, n2, string3);
            MMovementLine mMovementLine = new MMovementLine(mMovement);
            mMovementLine.setM_Product_ID(mDDOrderLine.getM_Product_ID());
            BigDecimal bigDecimal = (BigDecimal)miniTable.getValueAt(n, 1);
            if (bigDecimal == null | bigDecimal.compareTo(mDDOrderLine.getQtyInTransit()) > 0) {
                throw new AdempiereException("Error in Qty");
            }
            mMovementLine.setOrderLine(mDDOrderLine, bigDecimal, true);
            mMovementLine.saveEx();
            ++n;
        }
        if (!mMovement.processIt("CO")) {
            log.warning("Failed: " + mMovement);
        }
        mMovement.setDocStatus("CO");
        mMovement.setDocAction("CL");
        mMovement.saveEx();
        return string2;
    }
}

