/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.apps.IStatusBar;
import org.compiere.apps.form.GenForm;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MPrivateAccess;
import org.compiere.model.MProcess;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.model.MDDOrder;

public class OrderDistribution
extends GenForm {
    private static final long serialVersionUID = 1L;
    private static CLogger log = CLogger.getCLogger(OrderDistribution.class);
    public Object m_M_Locator_ID = null;
    public Object m_M_LocatorTo_ID = null;
    public Object m_C_BPartner_ID = null;

    @Override
    public void dynInit() throws Exception {
        this.setTitle("MovementGenerateInfo");
        MPrintFormat mPrintFormat = MPrintFormat.get(Env.getCtx(), MPrintFormat.getPrintFormat_ID("Inventory Move Hdr (Example)", MMovement.Table_ID, 0), false);
        this.setPrintFormat(mPrintFormat);
        this.setAskPrintMsg("PrintMovements");
    }

    @Override
    public void configureMiniTable(IMiniTable iMiniTable) {
        iMiniTable.addColumn("C_Order_ID");
        iMiniTable.addColumn("AD_Org_ID");
        iMiniTable.addColumn("C_DocType_ID");
        iMiniTable.addColumn("DocumentNo");
        iMiniTable.addColumn("C_BPartner_ID");
        iMiniTable.addColumn("DateOrdered");
        iMiniTable.addColumn("TotalLines");
        iMiniTable.setMultiSelection(true);
        iMiniTable.setColumnClass(0, IDColumn.class, false, " ");
        iMiniTable.setColumnClass(1, String.class, true, Msg.translate(Env.getCtx(), "AD_Org_ID"));
        iMiniTable.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "C_DocType_ID"));
        iMiniTable.setColumnClass(3, String.class, true, Msg.translate(Env.getCtx(), "DocumentNo"));
        iMiniTable.setColumnClass(4, String.class, true, Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        iMiniTable.setColumnClass(5, Timestamp.class, true, Msg.translate(Env.getCtx(), "DateOrdered"));
        iMiniTable.setColumnClass(6, BigDecimal.class, true, Msg.translate(Env.getCtx(), "TotalLines"));
        iMiniTable.autoSize();
    }

    private String getOrderSQL() {
        int n;
        String string;
        StringBuffer stringBuffer = new StringBuffer("SELECT DD_Order_ID, o.Name, dt.Name, DocumentNo, bp.Name, DateOrdered FROM M_Movement_Candidate_v ic, AD_Org o, C_BPartner bp, C_DocType dt WHERE ic.AD_Org_ID=o.AD_Org_ID AND ic.C_BPartner_ID=bp.C_BPartner_ID AND ic.C_DocType_ID=dt.C_DocType_ID AND ic.AD_Client_ID=?");
        if (this.m_M_Locator_ID != null) {
            stringBuffer.append(" AND ic.M_Locator_ID=").append(this.m_M_Locator_ID);
        }
        if (this.m_M_LocatorTo_ID != null) {
            stringBuffer.append(" AND ic.M_LocatorTo_ID=").append(this.m_M_LocatorTo_ID);
        }
        if (this.m_C_BPartner_ID != null) {
            stringBuffer.append(" AND ic.C_BPartner_ID=").append(this.m_C_BPartner_ID);
        }
        if ((string = MPrivateAccess.getLockedRecordWhere(MDDOrder.Table_ID, n = Env.getContextAsInt(Env.getCtx(), "#AD_User_ID"))) != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append("DD_Order_ID").append(string);
        }
        stringBuffer.append(" ORDER BY o.Name,bp.Name,DateOrdered");
        return stringBuffer.toString();
    }

    public void executeQuery(IMiniTable iMiniTable) {
        int n = Env.getAD_Client_ID(Env.getCtx());
        String string = "";
        string = this.getOrderSQL();
        log.fine(string);
        int n2 = 0;
        iMiniTable.setRowCount(n2);
        try {
            CPreparedStatement cPreparedStatement = DB.prepareStatement(string.toString(), null);
            cPreparedStatement.setInt(1, n);
            ResultSet resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                iMiniTable.setRowCount(n2 + 1);
                iMiniTable.setValueAt(new IDColumn(resultSet.getInt(1)), n2, 0);
                iMiniTable.setValueAt(resultSet.getString(2), n2, 1);
                iMiniTable.setValueAt(resultSet.getString(3), n2, 2);
                iMiniTable.setValueAt(resultSet.getString(4), n2, 3);
                iMiniTable.setValueAt(resultSet.getString(5), n2, 4);
                ++n2;
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, string.toString(), sQLException);
        }
        iMiniTable.autoSize();
    }

    @Override
    public void saveSelection(IMiniTable iMiniTable) {
        log.info("");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.setSelection(null);
        int n = iMiniTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            IDColumn iDColumn = (IDColumn)iMiniTable.getValueAt(i, 0);
            if (iDColumn == null || !iDColumn.isSelected()) continue;
            arrayList.add(iDColumn.getRecord_ID());
        }
        if (arrayList.size() == 0) {
            return;
        }
        log.config("Selected #" + arrayList.size());
        this.setSelection(arrayList);
    }

    public String generate(IStatusBar iStatusBar, String string) {
        String string2 = "";
        log.info("M_Locator_ID=" + this.m_M_Locator_ID);
        String string3 = Trx.createTrxName("IMG");
        Trx trx = Trx.get(string3, true);
        this.setSelectionActive(false);
        iStatusBar.setStatusLine(Msg.translate(Env.getCtx(), "M_Movement_ID"));
        iStatusBar.setStatusDB(String.valueOf(this.getSelection().size()));
        int n = MProcess.getProcess_ID("M_Generate Movement", string3);
        MPInstance mPInstance = new MPInstance(Env.getCtx(), n, 0);
        if (!mPInstance.save()) {
            string2 = Msg.getMsg(Env.getCtx(), "ProcessNoInstance");
            return string2;
        }
        DB.createT_Selection(mPInstance.getAD_PInstance_ID(), this.getSelection(), null);
        ProcessInfo processInfo = new ProcessInfo("VOrderDistribution", n);
        processInfo.setAD_PInstance_ID(mPInstance.getAD_PInstance_ID());
        MPInstancePara mPInstancePara = new MPInstancePara(mPInstance, 10);
        mPInstancePara.setParameter("Selection", "Y");
        mPInstancePara.saveEx();
        MLocator mLocator = MLocator.get(Env.getCtx(), Integer.parseInt(this.m_M_Locator_ID.toString()));
        mPInstancePara = new MPInstancePara(mPInstance, 20);
        mPInstancePara.setParameter("M_Warehouse_ID", mLocator.getM_Warehouse_ID());
        mPInstancePara.saveEx();
        this.setTrx(trx);
        this.setProcessInfo(processInfo);
        return string2;
    }
}

