/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.Color;
import java.awt.Paint;
import org.compiere.model.MResource;
import org.compiere.model.MUOM;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.tools.worker.SingleWorker;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.TextAnchor;

public class CRPDetail {
    public SingleWorker worker;
    public static CLogger log = CLogger.getCLogger(CRPDetail.class);

    public JFreeChart createChart(CategoryDataset categoryDataset, String string, MUOM mUOM) {
        JFreeChart jFreeChart = ChartFactory.createBarChart3D((String)string, (String)Msg.translate(Env.getCtx(), "Day"), (String)Msg.translate(Env.getCtx(), mUOM == null ? "" : mUOM.getName()), (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        jFreeChart.setBackgroundPaint((Paint)Color.WHITE);
        jFreeChart.setAntiAlias(true);
        jFreeChart.setBorderVisible(true);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setRangeGridlinesVisible(true);
        categoryPlot.setRangeGridlinePaint((Paint)Color.GRAY);
        categoryPlot.setDomainGridlinesVisible(true);
        categoryPlot.setDomainGridlinePaint((Paint)Color.GRAY);
        BarRenderer3D barRenderer3D = (BarRenderer3D)categoryPlot.getRenderer();
        barRenderer3D.setDrawBarOutline(false);
        barRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new LabelGenerator());
        barRenderer3D.setBaseItemLabelsVisible(true);
        barRenderer3D.setSeriesPaint(0, (Paint)new Color(10, 80, 150, 128));
        barRenderer3D.setSeriesPaint(1, (Paint)new Color(180, 60, 50, 128));
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.TOP_CENTER);
        barRenderer3D.setPositiveItemLabelPosition(itemLabelPosition);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.5235987755982988));
        return jFreeChart;
    }

    public MUOM getSourceUOM(Object object) {
        MResource mResource = this.getResource(object);
        int n = mResource.getResourceType().getC_UOM_ID();
        return n > 0 ? MUOM.get(Env.getCtx(), n) : null;
    }

    public MResource getResource(Object object) {
        MResource mResource = null;
        if (object != null) {
            mResource = MResource.get(Env.getCtx(), (Integer)object);
        }
        return mResource;
    }

    public MUOM getTargetUOM(Object object) {
        MUOM mUOM = null;
        if (object != null) {
            mUOM = MUOM.get(Env.getCtx(), (Integer)object);
        }
        return mUOM;
    }

    class LabelGenerator
    extends StandardCategoryItemLabelGenerator {
        LabelGenerator() {
        }

        public String generateItemLabel(CategoryDataset categoryDataset, int n, int n2) {
            return categoryDataset.getRowKey(n).toString();
        }
    }
}

