/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.compiere.model.MResource;
import org.compiere.model.MResourceType;
import org.compiere.model.MUOM;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.form.crp.CRPDatasetFactory;
import org.eevolution.form.crp.CRPModel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class CRP {
    public int m_WindowNo = 0;
    public static CLogger log = CLogger.getCLogger(CRP.class);
    public int AD_Client_ID = Integer.parseInt(Env.getContext(Env.getCtx(), "#AD_Client_ID"));
    protected CRPModel model;

    protected JFreeChart createChart(CategoryDataset categoryDataset, String string, MUOM mUOM) {
        JFreeChart jFreeChart = ChartFactory.createBarChart3D((String)string, (String)" ", (String)" ", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        jFreeChart = mUOM == null || mUOM.isHour() ? ChartFactory.createBarChart3D((String)string, (String)Msg.translate(Env.getCtx(), "Days"), (String)Msg.translate(Env.getCtx(), "Hours"), (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false) : ChartFactory.createBarChart3D((String)string, (String)Msg.translate(Env.getCtx(), "Days"), (String)Msg.translate(Env.getCtx(), "Kilo"), (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        return jFreeChart;
    }

    protected CategoryDataset createDataset(Timestamp timestamp, MResource mResource) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(timestamp.getTime());
        gregorianCalendar.clear(14);
        gregorianCalendar.clear(13);
        gregorianCalendar.clear(12);
        gregorianCalendar.clear(11);
        Timestamp timestamp2 = timestamp;
        String string = Msg.translate(Env.getCtx(), "Capacity");
        String string2 = Msg.translate(Env.getCtx(), "Load");
        String string3 = Msg.translate(Env.getCtx(), "Summary");
        MResourceType mResourceType = MResourceType.get(Env.getCtx(), mResource.getS_ResourceType_ID());
        int n = 1;
        long l = mResourceType.getTimeSlotHours();
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        int n2 = DB.getSQLValue(null, "SELECT C_UOM_ID FROM M_Product WHERE S_Resource_ID = ? ", mResource.getS_Resource_ID());
        MUOM mUOM = MUOM.get(Env.getCtx(), n2);
        if (!mUOM.isHour()) {
            return defaultCategoryDataset;
        }
        long l2 = 0L;
        while (n < 32) {
            String string4 = new String(new Integer(timestamp2.getDate()).toString());
            long l3 = this.getLoad(mResource, timestamp2).longValue();
            Long l4 = new Long(l);
            switch (gregorianCalendar.get(7)) {
                case 1: {
                    ++n;
                    if (mResourceType.isOnSunday()) {
                        defaultCategoryDataset.addValue((double)l, (Comparable)((Object)string), (Comparable)((Object)string4));
                        defaultCategoryDataset.addValue((double)l3, (Comparable)((Object)string2), (Comparable)((Object)string4));
                        defaultCategoryDataset.addValue((double)l2, (Comparable)((Object)string3), (Comparable)((Object)string4));
                        l2 = l2 + (long)l4.intValue() - l3;
                        gregorianCalendar.add(5, 1);
                        timestamp2 = new Timestamp(gregorianCalendar.getTimeInMillis());
                        break;
                    }
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string), (Comparable)((Object)string4));
                    defaultCategoryDataset.addValue((double)l3, (Comparable)((Object)string2), (Comparable)((Object)string4));
                    defaultCategoryDataset.addValue((double)l2, (Comparable)((Object)string3), (Comparable)((Object)string4));
                    l2 -= l3;
                    gregorianCalendar.add(5, 1);
                    timestamp2 = new Timestamp(gregorianCalendar.getTimeInMillis());
                    break;
                }
                case 2: {
                    ++n;
                    if (mResourceType.isOnMonday()) {
                        defaultCategoryDataset.addValue((double)l, (Comparable)((Object)string), (Comparable)((Object)string4));
                        defaultCategoryDataset.addValue((double)l3, (Comparable)((Object)string2), (Comparable)((Object)string4));
                        defaultCategoryDataset.addValue((double)l2, (Comparable)((Object)string3), (Comparable)((Object)string4));
                        l2 = l2 + (long)l4.intValue() - l3;
                        gregorianCalendar.add(5, 1);
                        timestamp2 = new Timestamp(gregorianCalendar.getTimeInMillis());
                        break;
                    }
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string), (Comparable)((Object)string4));
                    defaultCategoryDataset.addValue((double)l3, (Comparable)((Object)string2), (Comparable)((Object)string4));
                    defaultCategoryDataset.addValue((double)l2, (Comparable)((Object)string3), (Comparable)((Object)string4));
                    l2 -= l3;
                    gregorianCalendar.add(5, 1);
                    timestamp2 = new Timestamp(gregorianCalendar.getTimeInMillis());
                    break;
                }
                case 3: {
                    ++n;
                    if (mResourceType.isOnTuesday()) {
                        defaultCategoryDataset.addValue((double)l, (Comparable)((Object)string), (Comparable)((Object)string4));
                        defaultCategoryDataset.addValue((double)l3, (Comparable)((Object)string2), (Comparable)((Object)string4));
                        defaultCategoryDataset.addValue((double)l2, (Comparable)((Object)string3), (Comparable)((Object)string4));
                        l2 = l2 + (long)l4.intValue() - l3;
                        gregorianCalendar.add(5, 1);
                        timestamp2 = new Timestamp(gregorianCalendar.getTimeInMillis());
                        break;
                    }
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string), (Comparable)((Object)string4));
                    defaultCategoryDataset.addValue((double)l3, (Comparable)((Object)string2), (Comparable)((Object)string4));
                    defaultCategoryDataset.addValue((double)l2, (Comparable)((Object)string3), (Comparable)((Object)string4));
                    l2 -= l3;
                    gregorianCalendar.add(5, 1);
                    timestamp2 = new Timestamp(gregorianCalendar.getTimeInMillis());
                    break;
                }
                case 4: {
                    ++n;
                    if (mResourceType.isOnWednesday()) {
                        defaultCategoryDataset.addValue((double)l, (Comparable)((Object)string), (Comparable)((Object)string4));
                        defaultCategoryDataset.addValue((double)l3, (Comparable)((Object)string2), (Comparable)((Object)string4));
                        defaultCategoryDataset.addValue((double)l2, (Comparable)((Object)string3), (Comparable)((Object)string4));
                        l2 = l2 + (long)l4.intValue() - l3;
                        gregorianCalendar.add(5, 1);
                        timestamp2 = new Timestamp(gregorianCalendar.getTimeInMillis());
                        break;
                    }
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string), (Comparable)((Object)string4));
                    defaultCategoryDataset.addValue((double)l3, (Comparable)((Object)string2), (Comparable)((Object)string4));
                    defaultCategoryDataset.addValue((double)l2, (Comparable)((Object)string3), (Comparable)((Object)string4));
                    l2 -= l3;
                    gregorianCalendar.add(5, 1);
                    timestamp2 = new Timestamp(gregorianCalendar.getTimeInMillis());
                    break;
                }
                case 5: {
                    ++n;
                    if (mResourceType.isOnThursday()) {
                        defaultCategoryDataset.addValue((double)l, (Comparable)((Object)string), (Comparable)((Object)string4));
                        defaultCategoryDataset.addValue((double)l3, (Comparable)((Object)string2), (Comparable)((Object)string4));
                        defaultCategoryDataset.addValue((double)l2, (Comparable)((Object)string3), (Comparable)((Object)string4));
                        l2 = l2 + (long)l4.intValue() - l3;
                        gregorianCalendar.add(5, 1);
                        timestamp2 = new Timestamp(gregorianCalendar.getTimeInMillis());
                        break;
                    }
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string), (Comparable)((Object)string4));
                    defaultCategoryDataset.addValue((double)l3, (Comparable)((Object)string2), (Comparable)((Object)string4));
                    defaultCategoryDataset.addValue((double)l2, (Comparable)((Object)string3), (Comparable)((Object)string4));
                    l2 -= l3;
                    gregorianCalendar.add(5, 1);
                    timestamp2 = new Timestamp(gregorianCalendar.getTimeInMillis());
                    break;
                }
                case 6: {
                    ++n;
                    if (mResourceType.isOnFriday()) {
                        defaultCategoryDataset.addValue((double)l, (Comparable)((Object)string), (Comparable)((Object)string4));
                        defaultCategoryDataset.addValue((double)l3, (Comparable)((Object)string2), (Comparable)((Object)string4));
                        defaultCategoryDataset.addValue((double)l2, (Comparable)((Object)string3), (Comparable)((Object)string4));
                        l2 = l2 + (long)l4.intValue() - l3;
                        gregorianCalendar.add(5, 1);
                        timestamp2 = new Timestamp(gregorianCalendar.getTimeInMillis());
                        break;
                    }
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string), (Comparable)((Object)string4));
                    defaultCategoryDataset.addValue((double)l3, (Comparable)((Object)string2), (Comparable)((Object)string4));
                    defaultCategoryDataset.addValue((double)l2, (Comparable)((Object)string3), (Comparable)((Object)string4));
                    l2 -= l3;
                    gregorianCalendar.add(5, 1);
                    timestamp2 = new Timestamp(gregorianCalendar.getTimeInMillis());
                    break;
                }
                case 7: {
                    ++n;
                    if (mResourceType.isOnSaturday()) {
                        defaultCategoryDataset.addValue((double)l, (Comparable)((Object)string), (Comparable)((Object)string4));
                        defaultCategoryDataset.addValue((double)l3, (Comparable)((Object)string2), (Comparable)((Object)string4));
                        defaultCategoryDataset.addValue((double)l2, (Comparable)((Object)string3), (Comparable)((Object)string4));
                        l2 = l2 + (long)l4.intValue() - l3;
                        gregorianCalendar.add(5, 1);
                        timestamp2 = new Timestamp(gregorianCalendar.getTimeInMillis());
                        break;
                    }
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string), (Comparable)((Object)string4));
                    defaultCategoryDataset.addValue((double)l3, (Comparable)((Object)string2), (Comparable)((Object)string4));
                    defaultCategoryDataset.addValue((double)l2, (Comparable)((Object)string3), (Comparable)((Object)string4));
                    l2 -= l3;
                    gregorianCalendar.add(5, 1);
                    timestamp2 = new Timestamp(gregorianCalendar.getTimeInMillis());
                }
            }
        }
        return defaultCategoryDataset;
    }

    protected CategoryDataset createWeightDataset(Timestamp timestamp, MResource mResource) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(timestamp.getTime());
        gregorianCalendar.clear(14);
        gregorianCalendar.clear(13);
        gregorianCalendar.clear(12);
        gregorianCalendar.clear(11);
        String string = Msg.translate(Env.getCtx(), "Capacity");
        String string2 = Msg.translate(Env.getCtx(), "Load");
        String string3 = Msg.translate(Env.getCtx(), "Summary");
        String string4 = "Possible Capacity";
        MResourceType mResourceType = MResourceType.get(Env.getCtx(), mResource.getS_ResourceType_ID());
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        double d = DB.getSQLValue(null, "SELECT SUM( (mo.qtyordered-mo.qtydelivered)*(SELECT mp.weight FROM M_Product mp WHERE  mo.m_product_id=mp.m_product_id )) FROM PP_Order mo WHERE AD_Client_ID=?", mResource.getAD_Client_ID());
        double d2 = mResource.getDailyCapacity().doubleValue();
        double d3 = mResource.getPercentUtilization().doubleValue();
        double d4 = 0.0;
        int n = 0;
        while (n < 32) {
            ++n;
            switch (gregorianCalendar.get(7)) {
                case 1: {
                    if (mResourceType.isOnSunday()) {
                        d -= d2 * d3 / 100.0;
                        d4 += d2 * d3 / 100.0;
                        defaultCategoryDataset.addValue(d2, (Comparable)((Object)string4), (Comparable)new Integer(n));
                        defaultCategoryDataset.addValue(d2 * d3 / 100.0, (Comparable)((Object)string), (Comparable)new Integer(n));
                        break;
                    }
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string4), (Comparable)new Integer(n));
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string), (Comparable)new Integer(n));
                    break;
                }
                case 2: {
                    if (mResourceType.isOnMonday()) {
                        d -= d2 * d3 / 100.0;
                        d4 += d2 * d3 / 100.0;
                        defaultCategoryDataset.addValue(d2, (Comparable)((Object)string4), (Comparable)new Integer(n));
                        defaultCategoryDataset.addValue(d2 * d3 / 100.0, (Comparable)((Object)string), (Comparable)new Integer(n));
                        break;
                    }
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string4), (Comparable)new Integer(n));
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string), (Comparable)new Integer(n));
                    break;
                }
                case 3: {
                    if (mResourceType.isOnTuesday()) {
                        d -= d2 * d3 / 100.0;
                        d4 += d2 * d3 / 100.0;
                        defaultCategoryDataset.addValue(d2, (Comparable)((Object)string4), (Comparable)new Integer(n));
                        defaultCategoryDataset.addValue(d2 * d3 / 100.0, (Comparable)((Object)string), (Comparable)new Integer(n));
                        break;
                    }
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string4), (Comparable)new Integer(n));
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string), (Comparable)new Integer(n));
                    break;
                }
                case 4: {
                    if (mResourceType.isOnWednesday()) {
                        d -= d2 * d3 / 100.0;
                        d4 += d2 * d3 / 100.0;
                        defaultCategoryDataset.addValue(d2, (Comparable)((Object)string4), (Comparable)new Integer(n));
                        defaultCategoryDataset.addValue(d2 * d3 / 100.0, (Comparable)((Object)string), (Comparable)new Integer(n));
                        break;
                    }
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string4), (Comparable)new Integer(n));
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string), (Comparable)new Integer(n));
                    break;
                }
                case 5: {
                    if (mResourceType.isOnThursday()) {
                        d -= d2 * d3 / 100.0;
                        d4 += d2 * d3 / 100.0;
                        defaultCategoryDataset.addValue(d2, (Comparable)((Object)string4), (Comparable)new Integer(n));
                        defaultCategoryDataset.addValue(d2 * d3 / 100.0, (Comparable)((Object)string), (Comparable)new Integer(n));
                        break;
                    }
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string4), (Comparable)new Integer(n));
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string), (Comparable)new Integer(n));
                    break;
                }
                case 6: {
                    if (mResourceType.isOnFriday()) {
                        d -= d2 * d3 / 100.0;
                        d4 += d2 * d3 / 100.0;
                        defaultCategoryDataset.addValue(d2, (Comparable)((Object)string4), (Comparable)new Integer(n));
                        defaultCategoryDataset.addValue(d2 * d3 / 100.0, (Comparable)((Object)string), (Comparable)new Integer(n));
                        break;
                    }
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string4), (Comparable)new Integer(n));
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string), (Comparable)new Integer(n));
                    break;
                }
                case 7: {
                    if (mResourceType.isOnSaturday()) {
                        d -= d2 * d3 / 100.0;
                        d4 += d2 * d3 / 100.0;
                        defaultCategoryDataset.addValue(d2, (Comparable)((Object)string4), (Comparable)new Integer(n));
                        defaultCategoryDataset.addValue(d2 * d3 / 100.0, (Comparable)((Object)string), (Comparable)new Integer(n));
                        break;
                    }
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string4), (Comparable)new Integer(n));
                    defaultCategoryDataset.addValue(0.0, (Comparable)((Object)string), (Comparable)new Integer(n));
                }
            }
            defaultCategoryDataset.addValue(d, (Comparable)((Object)string2), (Comparable)new Integer(n));
            defaultCategoryDataset.addValue(d4, (Comparable)((Object)string3), (Comparable)new Integer(n));
            gregorianCalendar.add(5, 1);
        }
        return defaultCategoryDataset;
    }

    private BigDecimal getLoad(MResource mResource, Timestamp timestamp) {
        this.model = CRPDatasetFactory.get(timestamp, timestamp, mResource);
        return this.model.calculateLoad(timestamp, mResource, null);
    }
}

