/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.compiere.apps.form.FormFrame;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProduct;
import org.compiere.model.PO;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.form.CAbstractForm;
import org.eevolution.form.action.PopupAction;
import org.eevolution.form.action.ZoomMenuAction;
import org.eevolution.form.bom.BOMTreeFactory;
import org.eevolution.form.bom.BOMTreeModel;
import org.eevolution.form.bom.action.ChangeASIAction;
import org.eevolution.form.bom.action.CreateRfQAction;
import org.eevolution.form.bom.action.DeleteBOMAction;
import org.eevolution.form.bom.action.MergeBOMAction;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.reasoner.StorageReasoner;
import org.eevolution.model.wrapper.BOMLineWrapper;
import org.eevolution.model.wrapper.BOMWrapper;
import org.eevolution.tools.swing.SwingTool;
import org.eevolution.tools.worker.SingleWorker;

public abstract class CAbstractBOMTree
extends CAbstractForm
implements PropertyChangeListener {
    private SingleWorker worker;
    private BOMTreeModel model;
    private CPanel northPanel;
    private VLookup lookup;
    private JSplitPane contentPane;
    private CPanel southPanel;
    private JEditorPane nodeDescription;
    protected JPopupMenu popupRoot;
    protected JPopupMenu popupBOM;
    protected JPopupMenu popupBOMLine;
    protected StorageReasoner reasoner;

    private void handleTreeEvent(MouseEvent mouseEvent) {
        String string = this.model.getBOMMessenger().getToolTipText(mouseEvent);
        if (string != null) {
            this.nodeDescription.setText(string);
        }
        if (mouseEvent.getButton() == 3) {
            this.model.getTree().setSelectionPath(this.model.getTree().getPathForLocation(mouseEvent.getX(), mouseEvent.getY()));
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.model.getTree().getSelectionPath().getLastPathComponent();
            if (defaultMutableTreeNode.getUserObject() instanceof BOMLineWrapper) {
                this.popupBOMLine.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (defaultMutableTreeNode.getUserObject() instanceof BOMWrapper) {
                this.popupBOM.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (defaultMutableTreeNode.getUserObject() instanceof MProduct) {
                this.popupRoot.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (defaultMutableTreeNode.getUserObject() instanceof MPPOrder) {
                this.popupRoot.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
        SwingTool.setCursorsFromChild(mouseEvent.getComponent(), false);
    }

    protected abstract String type();

    protected String idColumn() {
        return this.type() + "_ID";
    }

    @Override
    public void init(int n, FormFrame formFrame) {
        super.init(n, formFrame);
        this.reasoner = new StorageReasoner();
        try {
            this.preInit();
            this.jbInit();
            this.getWindow().getContentPane().add((Component)this, "Center");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void preInit() {
        this.northPanel = new CPanel();
        this.southPanel = new CPanel();
        this.contentPane = new JSplitPane(1);
        this.nodeDescription = new JEditorPane("text/html", "");
        this.nodeDescription.setOpaque(false);
        this.nodeDescription.setEditable(false);
        String string = null;
        int n = -1;
        if ("productBOM".equals(this.type())) {
            string = "M_Product_ID";
            n = MColumn.getColumn_ID("M_Product", string);
        } else if ("orderBOM".equals(this.type())) {
            string = "PP_Order_ID";
            n = MColumn.getColumn_ID("PP_Order", string);
        }
        MLookup mLookup = MLookupFactory.get(Env.getCtx(), this.getWindowNo(), 0, n, 30);
        this.lookup = new VLookup(string, false, false, true, mLookup){

            @Override
            public void setValue(Object object) {
                super.setValue(object);
                CAbstractBOMTree.this.dispatchPropertyChange();
            }
        };
    }

    private void jbInit() {
        CLabel cLabel = null;
        if ("productBOM".equals(this.type())) {
            cLabel = new CLabel(Msg.translate(Env.getCtx(), "M_Product_ID"));
        } else if ("orderBOM".equals(this.type())) {
            cLabel = new CLabel(Msg.translate(Env.getCtx(), "PP_Order_ID"));
        }
        cLabel.setLabelFor(this.lookup);
        this.northPanel.setLayout(new FlowLayout(0));
        this.northPanel.add((Component)cLabel, null);
        this.northPanel.add((Component)this.lookup, null);
        this.southPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.nodeDescription);
        jScrollPane.setBorder(null);
        this.contentPane.add((Component)jScrollPane, "right");
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(1000, 600));
        this.add((Component)this.northPanel, "North");
        this.add((Component)this.contentPane, "Center");
        this.add((Component)this.southPanel, "South");
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.worker != null) {
            this.worker.stop();
        }
        this.worker = null;
        if (this.lookup != null) {
            this.lookup.dispose();
        }
        this.lookup = null;
        this.northPanel = null;
        this.contentPane = null;
        this.southPanel = null;
        this.nodeDescription = null;
        this.popupRoot = null;
        this.popupBOM = null;
        this.popupBOMLine = null;
        this.reasoner = null;
    }

    private void handleActionEvent() {
        Integer n = (Integer)this.lookup.getValue();
        if (n == null || n == 0) {
            return;
        }
        this.nodeDescription.setText("");
        int n2 = n;
        PO pO = null;
        if ("productBOM".equals(this.type())) {
            pO = new MProduct(Env.getCtx(), n2, "M_Product");
        } else if ("orderBOM".equals(this.type())) {
            pO = new MPPOrder(Env.getCtx(), n2, null);
        }
        this.model = BOMTreeFactory.get(this.type(), pO, this.reasoner);
        this.configureTree();
        this.contentPane.add((Component)new JScrollPane(this.model.getTree()), "left");
        this.contentPane.setDividerLocation(0.25);
    }

    protected void configureTree() {
        this.model.getTree().addPropertyChangeListener(this);
        TreeHandler treeHandler = new TreeHandler();
        this.model.getTree().addMouseMotionListener(treeHandler);
        this.model.getTree().addMouseListener(treeHandler);
        this.model.getTree().addKeyListener(treeHandler);
        this.model.getTree().addTreeSelectionListener(treeHandler);
        this.popupRoot = new JPopupMenu();
        this.popupBOM = new JPopupMenu();
        this.popupBOMLine = new JPopupMenu();
        try {
            this.configurePopup(this.popupRoot, this.model.getTree(), MProduct.class);
            this.configurePopup(this.popupBOM, this.model.getTree(), BOMWrapper.class);
            this.configurePopup(this.popupBOMLine, this.model.getTree(), BOMLineWrapper.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void configurePopup(JPopupMenu jPopupMenu, JTree jTree, Class clazz) throws Exception {
        PopupAction popupAction = null;
        if (MPPOrder.class.equals((Object)clazz) || MProduct.class.equals((Object)clazz)) {
            popupAction = new ZoomMenuAction(jTree);
            jPopupMenu.add(popupAction);
        } else if (BOMWrapper.class.equals((Object)clazz)) {
            if ("productBOM".equals(this.type())) {
                popupAction = new ZoomMenuAction(jTree);
                jPopupMenu.add(popupAction);
                popupAction = new MergeBOMAction(jTree);
                popupAction.addPropertyChangeListener(this);
                jPopupMenu.add(popupAction);
                popupAction = new DeleteBOMAction(jTree);
                popupAction.addPropertyChangeListener(this);
                jPopupMenu.add(popupAction);
            }
            if ("orderBOM".equals(this.type())) {
                popupAction = new CreateRfQAction(jTree, (JFrame)this.getWindow());
                popupAction.addPropertyChangeListener(this);
                jPopupMenu.add(popupAction);
            }
        } else if (BOMLineWrapper.class.equals((Object)clazz)) {
            if ("productBOM".equals(this.type())) {
                popupAction = new DeleteBOMAction(jTree);
                popupAction.addPropertyChangeListener(this);
                jPopupMenu.add(popupAction);
            }
            popupAction = new ChangeASIAction(jTree, (JFrame)this.getWindow());
            popupAction.addPropertyChangeListener(this);
            jPopupMenu.add(popupAction);
        }
    }

    protected void dispatchPropertyChange() {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.lookup, "changeASI", null, null);
        this.propertyChange(propertyChangeEvent);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("mergeBOM".equals(propertyChangeEvent.getPropertyName()) || "changeASI".equals(propertyChangeEvent.getPropertyName()) || "deleteBOM".equals(propertyChangeEvent.getPropertyName())) {
            SwingTool.setCursorsFromParent(this.getWindow(), true);
            SingleWorker singleWorker = new SingleWorker(){

                @Override
                protected Object doIt() {
                    CAbstractBOMTree.this.handleActionEvent();
                    SwingTool.setCursorsFromParent(CAbstractBOMTree.this.getWindow(), false);
                    return null;
                }
            };
            this.runWorker(singleWorker);
        }
    }

    protected void runWorker(SingleWorker singleWorker) {
        this.worker = singleWorker;
        this.worker.start();
    }

    class TreeHandler
    extends MouseInputAdapter
    implements TreeSelectionListener,
    KeyListener {
        TreeHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (CAbstractBOMTree.this.model.getTree().getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) == null) {
                return;
            }
            SwingTool.setCursorsFromChild(mouseEvent.getComponent(), true);
            final MouseEvent mouseEvent2 = mouseEvent;
            CAbstractBOMTree.this.worker = new SingleWorker(){

                @Override
                protected Object doIt() {
                    CAbstractBOMTree.this.handleTreeEvent(mouseEvent2);
                    return null;
                }
            };
            CAbstractBOMTree.this.worker.start();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                TreePath treePath = CAbstractBOMTree.this.model.getTree().getSelectionModel().getSelectionPath();
                String string = CAbstractBOMTree.this.model.getBOMMessenger().getToolTipText(treePath);
                if (string != null) {
                    CAbstractBOMTree.this.nodeDescription.setText(string);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        }
    }
}

