/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MBrowseField;
import org.adempiere.model.MView;
import org.adempiere.model.MViewColumn;
import org.compiere.apps.search.Info_Column;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProcess;
import org.compiere.model.MRole;
import org.compiere.model.M_Element;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public abstract class Browser {
    public MBrowse m_Browse = null;
    public MView m_View = null;
    public static final int WINDOW_WIDTH = 1024;
    public Info_Column[] m_generalLayout;
    public ArrayList<String> m_queryColumns = new ArrayList();
    public ArrayList<String> m_queryColumnsSql = new ArrayList();
    public ArrayList<String> m_parameters;
    public ArrayList<Object> m_values;
    public MProcess m_process = null;
    public ProcessInfo m_pi = null;
    public boolean p_loadedOK = false;
    public int m_keyColumnIndex = -1;
    public boolean m_ok = false;
    public boolean m_cancel = false;
    public ArrayList<Integer> m_results = new ArrayList(3);
    public CLogger log = CLogger.getCLogger(this.getClass());
    public Info_Column[] p_layout;
    public String m_sqlMain;
    public String m_sqlCount;
    public String m_sqlOrder;
    public int p_WindowNo;
    public String p_FromClause;
    public String p_keyColumn;
    public boolean p_multiSelection;
    public String p_whereClause = "";
    public static final int INFO_WIDTH = 800;
    public boolean isAllSelected = false;

    public Browser(boolean modal, int WindowNo, String value, MBrowse browse, String keyColumn, boolean multiSelection, String whereClause) {
        this.m_Browse = browse;
        this.m_View = browse.getAD_View();
        this.p_WindowNo = WindowNo;
        this.p_keyColumn = keyColumn;
        this.p_multiSelection = multiSelection;
        if (whereClause == null || whereClause.indexOf(64) == -1) {
            this.p_whereClause = whereClause;
        } else {
            this.p_whereClause = Env.parseContext(Env.getCtx(), this.p_WindowNo, whereClause, false, false);
            if (this.p_whereClause.length() == 0) {
                this.log.log(Level.SEVERE, "Cannot parse context= " + whereClause);
            }
        }
        this.log.info(String.valueOf(this.m_Browse.getName()) + " - " + keyColumn + " - " + whereClause);
    }

    public MLookup getMLookup(MBrowseField field) throws Exception {
        MViewColumn column = field.getAD_View_Column();
        Language language = Language.getLoginLanguage();
        return MLookupFactory.get(this.m_Browse.getCtx(), this.p_WindowNo, column.getAD_Column_ID(), field.getAD_Reference_ID(), language, column.getAD_Column().getColumnName(), field.getAD_Reference_Value_ID(), false, "");
    }

    public ArrayList<Info_Column> initBrowserData() {
        Collection<MBrowseField> fields = this.m_Browse.getFields();
        ArrayList<Info_Column> list = new ArrayList<Info_Column>();
        for (MBrowseField field : fields) {
            MViewColumn vcol = field.getAD_View_Column();
            M_Element element = new M_Element(this.m_Browse.getCtx(), field.getAD_Element_ID(), null);
            String columnName = element.getColumnName();
            if (field.isQueryCriteria()) {
                this.m_queryColumns.add(columnName);
            }
            this.m_queryColumnsSql.add(vcol.getColumnSQL());
            Language language = Language.getLanguage(Env.getAD_Language(this.m_Browse.getCtx()));
            int displayType = field.getAD_Reference_ID();
            boolean isKey = field.isKey();
            boolean isDisplayed = field.isDisplayed();
            String columnSql = String.valueOf(vcol.getColumnSQL()) + " AS " + vcol.getColumnName();
            if (columnSql == null || columnSql.length() == 0) {
                columnSql = columnName;
            }
            StringBuffer colSql = new StringBuffer(columnSql);
            Class colClass = null;
            if (isKey) {
                colClass = IDColumn.class;
            } else if (isDisplayed) {
                String alias;
                if (20 == displayType) {
                    colClass = Boolean.class;
                } else if (12 == displayType) {
                    colClass = BigDecimal.class;
                } else if (22 == displayType || 29 == displayType) {
                    colClass = Double.class;
                } else if (11 == displayType) {
                    colClass = Integer.class;
                } else if (19 == displayType || 30 == displayType) {
                    alias = vcol.getAD_View_Definition().getTableAlias();
                    colSql = new StringBuffer("(" + MLookupFactory.getLookup_TableDirEmbed(language, columnName, alias) + ") AS " + vcol.getColumnName());
                    colClass = String.class;
                } else if (18 == displayType) {
                    alias = vcol.getAD_View_Definition().getTableAlias();
                    colSql = new StringBuffer("(" + MLookupFactory.getLookup_TableEmbed(language, columnName, alias, field.getAD_Reference_Value_ID()) + ") AS " + vcol.getColumnName());
                    colClass = String.class;
                } else if (10 == displayType || 14 == displayType || 34 == displayType) {
                    colClass = String.class;
                } else if (DisplayType.isDate(displayType)) {
                    colClass = Timestamp.class;
                } else if (17 == displayType) {
                    colSql = new StringBuffer("(" + MLookupFactory.getLookup_ListEmbed(language, field.getAD_Reference_Value_ID(), vcol.getColumnSQL()) + ")");
                    colClass = String.class;
                }
            }
            if (colClass != null) {
                Info_Column infocol = new Info_Column(Msg.translate(Env.getCtx(), columnName), colSql.toString(), colClass);
                list.add(infocol);
                this.log.finest("Added Column=" + columnName);
                continue;
            }
            this.log.finest("Not Added Column=" + columnName);
        }
        return list;
    }

    public String getSQLWhere() {
        StringBuffer sql = new StringBuffer(this.m_Browse.getWhereClause() == null ? "" : " AND " + this.m_Browse.getWhereClause());
        if (this.getParameters().size() > 0) {
            sql.append(" AND ");
        }
        Iterator<String> parameters = this.getParameters().iterator();
        while (parameters.hasNext()) {
            String parameter = parameters.next();
            MBrowseField field = this.m_Browse.getField(parameter);
            if (field != null) {
                MViewColumn column;
                if (field.isRange()) {
                    column = field.getAD_View_Column();
                    sql.append(column.getColumnSQL()).append(" BETWEEN ? AND ? ");
                    continue;
                }
                column = field.getAD_View_Column();
                sql.append(column.getColumnSQL()).append("=? ");
                if (!parameters.hasNext()) continue;
                sql.append(" AND ");
                continue;
            }
            if (!parameters.hasNext()) continue;
            sql.append(" AND ");
        }
        return sql.toString();
    }

    public ArrayList<String> getParameters() {
        return this.m_parameters;
    }

    public ArrayList<Object> getParametersValues() {
        return this.m_values;
    }

    public void addParameter(String name, Object value) {
        if (value != null && value.toString().length() > 0) {
            this.m_parameters.add(name);
            this.m_values.add(value);
        }
    }

    public void addSQLWhere(StringBuffer sql, int index, String value) {
        if (!value.equals("") && !value.equals("%") && index < this.m_queryColumns.size()) {
            sql.append(" UPPER(").append(this.m_queryColumnsSql.get(index).toString()).append(") LIKE '");
            sql.append(value);
            if (value.endsWith("%")) {
                sql.append("'");
            } else {
                sql.append("%'");
            }
        }
    }

    public void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        boolean index = true;
    }

    public int getCount() {
        int no;
        long start;
        block8: {
            start = System.currentTimeMillis();
            String dynWhere = this.getSQLWhere();
            StringBuffer sql = new StringBuffer(this.m_sqlCount);
            if (dynWhere.length() > 0) {
                sql.append(dynWhere);
            }
            String countSql = Msg.parseTranslation(Env.getCtx(), sql.toString());
            countSql = MRole.getDefault().addAccessSQL(countSql, this.m_View.getParentEntityAliasName(), true, false);
            this.log.finer(countSql);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            no = -1;
            try {
                try {
                    pstmt = DB.prepareStatement(countSql, null);
                    if (this.getParametersValues().size() > 0) {
                        DB.setParameters((PreparedStatement)pstmt, this.getParametersValues());
                    }
                    this.setParameters(pstmt, true);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        no = rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, countSql, e);
                    no = -2;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
        return no;
    }

    public abstract ArrayList<Integer> getSelectedRowKeys();

    public String getSelectedSQL() {
        Collection keys = this.getSelectedKeys();
        if (keys == null || keys.size() == 0) {
            this.log.config("No Results - OK=" + this.m_ok + ", Cancel=" + this.m_cancel);
            return "";
        }
        StringBuffer sb = new StringBuffer(this.getKeyColumn());
        if (keys.size() > 1) {
            sb.append(" IN (");
        } else {
            sb.append("=");
        }
        for (Integer key : keys) {
            if (this.getKeyColumn().endsWith("_ID")) {
                sb.append(key.toString()).append(",");
                continue;
            }
            sb.append("'").append(key.toString()).append("',");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        if (keys.size() > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    public String getKeyColumn() {
        return this.p_keyColumn;
    }

    public Integer getSelectedRowKey() {
        ArrayList<Integer> selectedDataList = this.getSelectedRowKeys();
        if (selectedDataList.size() == 0) {
            return null;
        }
        return selectedDataList.get(0);
    }

    public Collection getSelectedKeys() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results;
    }

    public Object getSelectedKey() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results.get(0);
    }

    public int getAD_Browse_ID() {
        return this.m_Browse.getAD_Browse_ID();
    }
}

