/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MSession;
import org.compiere.util.CLogger;
import org.compiere.util.WebInfo;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;

public class WebLogin {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private static final String COOKIE_NAME = "CompiereWebUser";
    private String P_ForwardTo = "ForwardTo";
    private String P_SalesRep_ID = "SalesRep_ID";
    private String P_EMail = "EMail";
    private String P_Password = "Password";
    private String P_Action = "Mode";
    private String m_login_page = "/login.jsp";
    private String m_update_page = "/update.jsp";
    private String m_message = null;
    private Properties m_ctx;
    private HttpServletRequest m_request;
    private HttpServletResponse m_response;
    private HttpSession m_session;
    private boolean m_addressConfirm;
    private String m_forward;
    private String m_salesRep;
    private String m_email;
    private String m_password;
    private WebUser m_wu;
    private String m_mode;

    public WebLogin(HttpServletRequest t_request, HttpServletResponse t_response, Properties t_ctx) {
        this.m_request = t_request;
        this.m_response = t_response;
        this.m_ctx = t_ctx;
        if (this.m_request.getParameter("P_ForwardTo") != null) {
            this.setP_ForwardTo(this.m_request.getParameter("P_ForwardTo"));
        }
        if (this.m_request.getParameter("SalesRep_ID") != null) {
            this.setP_SalesRep_ID(this.m_request.getParameter("SalesRep_ID"));
        }
        if (this.m_request.getParameter("P_EMail") != null) {
            this.setP_EMail(this.m_request.getParameter("P_EMail"));
        }
        if (this.m_request.getParameter("P_Password") != null) {
            this.setP_Password(this.m_request.getParameter("P_Password"));
        }
        if (this.m_request.getParameter("P_Action") != null) {
            this.setP_Action(this.m_request.getParameter("P_Action"));
        }
        if (this.m_request.getParameter("LOGIN_RelURL") != null) {
            this.setLogin_RelURL(this.m_request.getParameter("LOGIN_RelURL"));
        }
        if (this.m_request.getParameter("update_page") != null) {
            this.setLogin_RelURL(this.m_request.getParameter("update_page"));
        }
    }

    public boolean init() {
        this.m_session = this.m_request.getSession(true);
        this.m_forward = WebUtil.getParameter(this.m_request, this.P_ForwardTo);
        if (this.m_forward != null) {
            this.m_session.setAttribute(this.P_ForwardTo, (Object)this.m_forward);
        } else {
            this.m_forward = "";
        }
        this.m_salesRep = WebUtil.getParameter(this.m_request, this.P_SalesRep_ID);
        if (this.m_salesRep != null) {
            this.m_session.setAttribute(this.P_SalesRep_ID, (Object)this.m_salesRep);
        }
        this.m_email = WebUtil.getParameter(this.m_request, this.P_EMail);
        if (this.m_email == null) {
            this.m_email = "";
        }
        this.m_email = this.m_email.trim();
        if (this.m_email != null) {
            this.m_session.setAttribute(this.P_EMail, (Object)this.m_email);
        }
        this.m_password = WebUtil.getParameter(this.m_request, this.P_Password);
        if (this.m_password == null) {
            this.m_password = "";
        }
        this.m_password = this.m_password.trim();
        if (this.m_session.getAttribute("info") != null) {
            WebInfo wi = (WebInfo)this.m_session.getAttribute("info");
            this.m_wu = wi.getWebUser();
        }
        return true;
    }

    public boolean action() throws IOException, ServletException {
        boolean logout;
        boolean deleteCookie;
        if (this.getMode() == null) {
            String s = WebUtil.getParameter(this.m_request, this.P_Action);
            this.setMode(s);
        }
        if (deleteCookie = "deleteCookie".equals(this.m_mode)) {
            this.log.fine("** deleteCookie");
            WebUtil.deleteCookieWebUser(this.m_request, this.m_response, COOKIE_NAME);
        }
        if ((logout = "logout".equals(this.m_mode)) || deleteCookie) {
            this.log.fine("** logout");
            if (this.m_session != null) {
                MSession cSession = MSession.get(this.m_ctx, false);
                if (cSession != null) {
                    cSession.logout();
                }
                this.m_wu = (WebUser)this.m_session.getAttribute("webUser");
                if (this.m_wu != null) {
                    this.m_wu.logout();
                }
                this.m_session.removeAttribute("webUser");
                this.m_session.setMaxInactiveInterval(1);
                this.m_session.invalidate();
            }
            WebUtil.createForwardPage(this.m_response, "Logout", "http://" + this.m_request.getServerName() + "/", 2);
        } else if ("SendEMail".equals(this.m_mode)) {
            this.log.info("** send mail");
            this.m_wu = WebUser.get(this.m_ctx, this.m_email);
            if (!this.m_wu.isEMailValid()) {
                this.m_wu.setPasswordMessage("EMail not found in system");
            } else {
                this.m_wu.setPassword();
                String msg = WebUtil.sendEMail(this.m_request, this.m_wu, "UP", new Object[]{this.m_request.getServerName(), this.m_wu.getName(), WebUtil.getFrom(this.m_request), this.m_wu.getPassword()});
                if ("OK".equals(msg)) {
                    this.m_wu.setPasswordMessage("EMail sent");
                } else {
                    this.m_wu.setPasswordMessage("Problem sending EMail: " + msg);
                }
            }
            this.m_forward = this.getLogin_RelURL();
        } else if ("Login".equals(this.m_mode)) {
            this.log.info("** login " + this.m_email + "/" + this.m_password);
            WebUtil.addCookieWebUser(this.m_request, this.m_response, this.m_email, COOKIE_NAME);
            this.m_wu = WebUser.get(this.m_ctx, this.m_email, this.m_password, false);
            this.m_wu.login(this.m_password);
            if (this.m_wu.isLoggedIn()) {
                MSession cSession;
                if (this.m_forward == null || this.m_forward.equals(this.getLogin_RelURL())) {
                    this.m_forward = "/index.jsp";
                }
                if ((cSession = MSession.get(this.m_ctx, this.m_request.getRemoteAddr(), this.m_request.getRemoteHost(), this.m_session.getId())) != null) {
                    cSession.setWebStoreSession(true);
                }
            } else {
                this.m_forward = this.getLogin_RelURL();
                this.log.fine("- PasswordMessage=" + this.m_wu.getPasswordMessage());
            }
            if (this.m_session == null) {
                this.m_session = this.m_request.getSession(true);
            }
            this.m_session.setAttribute("info", (Object)new WebInfo(this.m_ctx, this.m_wu));
        } else if ("LoginNew".equals(this.m_mode)) {
            this.log.info("** loginNew");
            WebUtil.addCookieWebUser(this.m_request, this.m_response, "", COOKIE_NAME);
            this.m_wu = WebUser.get(this.m_ctx, "");
            this.m_forward = this.getLogin_RelURL();
        } else if ("Submit".equals(this.m_mode)) {
            this.log.info("** submit " + this.m_email + "/" + this.m_password + " - AddrConf=" + this.m_addressConfirm);
            if (this.m_wu == null || !this.m_wu.isLoggedIn() || !this.m_addressConfirm) {
                this.m_wu = WebUser.get(this.m_ctx, this.m_email, null, false);
            }
            if (this.m_wu.getAD_User_ID() != 0) {
                boolean passwordChange;
                String passwordNew = WebUtil.getParameter(this.m_request, "PasswordNew");
                if (passwordNew == null) {
                    passwordNew = "";
                }
                boolean bl = passwordChange = passwordNew.length() > 0 && !passwordNew.equals(this.m_password);
                if (this.m_addressConfirm || this.m_wu.login(this.m_password)) {
                    MSession cSession;
                    if (this.m_wu.isLoggedIn() && (cSession = MSession.get(this.m_ctx, this.m_request.getRemoteAddr(), this.m_request.getRemoteHost(), this.m_session.getId())) != null) {
                        cSession.setWebStoreSession(true);
                    }
                    if (passwordChange) {
                        this.log.fine("- update Pwd " + this.m_email + ", Old=" + this.m_password + ", DB=" + this.m_wu.getPassword() + ", New=" + passwordNew);
                    }
                    if (WebUtil.updateFields(this.m_request, this.m_wu, passwordChange)) {
                        if (passwordChange) {
                            this.m_session.setAttribute("hdrMessage", (Object)"Password changed");
                        }
                    } else {
                        this.m_forward = this.getLogin_RelURL();
                        this.log.warning(" - update not done");
                    }
                } else {
                    this.m_forward = this.getLogin_RelURL();
                    this.m_session.setAttribute("hdrMessage", (Object)"Email/Password not correct");
                    this.log.warning(" - update not confirmed");
                }
            } else {
                this.log.fine("** new " + this.m_email + "/" + this.m_password);
                this.m_wu.setEmail(this.m_email);
                this.m_wu.setPassword(this.m_password);
                if (WebUtil.updateFields(this.m_request, this.m_wu, true)) {
                    if (this.m_wu.login(this.m_password)) {
                        this.m_session.setAttribute("info", (Object)new WebInfo(this.m_ctx, this.m_wu));
                        MSession cSession = MSession.get(this.m_ctx, this.m_request.getRemoteAddr(), this.m_request.getRemoteHost(), this.m_session.getId());
                        if (cSession != null) {
                            cSession.setWebStoreSession(true);
                        }
                        WebUtil.resendCode(this.m_request, this.m_wu);
                    } else {
                        this.m_forward = this.getLogin_RelURL();
                    }
                } else {
                    this.log.fine("- failed - " + this.m_wu.getSaveErrorMessage() + " - " + this.m_wu.getPasswordMessage());
                    this.m_forward = this.getLogin_RelURL();
                }
            }
            if (this.m_wu != null) {
                this.m_session.setAttribute("info", (Object)new WebInfo(this.m_ctx, this.m_wu));
            }
        } else if ("email".equals(this.m_mode)) {
            String email = WebUtil.getParameter(this.m_request, "EMail");
            if (email == null) {
                email = "";
            }
            email = email.trim();
            String emailNew = WebUtil.getParameter(this.m_request, "EMailNew");
            if (emailNew == null) {
                emailNew = "";
            }
            email = email.trim();
            if (emailNew.length() == 0 || emailNew.equals(email)) {
                this.setMessage("New EMail invalid.");
                return false;
            }
            if (!WebUtil.isEmailValid(emailNew)) {
                this.setMessage("New EMail invalid.");
                return false;
            }
            this.m_wu.setEmail(emailNew);
            this.m_wu.save();
            this.m_session.setAttribute("hdrMessage", (Object)"EMail Address Changed");
            this.m_session.setAttribute("info", (Object)new WebInfo(this.m_ctx, this.m_wu));
        } else if ("password".equals(this.m_mode)) {
            String passwordNew;
            if (this.m_wu == null) {
                this.log.warning("No web user");
                return false;
            }
            String password = WebUtil.getParameter(this.m_request, "Password");
            if (password == null) {
                password = "";
            }
            if (!this.m_wu.login(password = password.trim())) {
                this.setMessage("Email/Password not correct");
                return false;
            }
            MSession cSession = MSession.get(this.m_ctx, this.m_request.getRemoteAddr(), this.m_request.getRemoteHost(), this.m_session.getId());
            if (cSession != null) {
                cSession.setWebStoreSession(true);
            }
            if ((passwordNew = WebUtil.getParameter(this.m_request, "PasswordNew")) == null) {
                passwordNew = "";
            }
            password = password.trim();
            if (passwordNew.length() == 0 || passwordNew.equals(password)) {
                this.setMessage("New Password invalid.");
                return false;
            }
            this.m_wu.setPasswordMessage(null);
            this.m_wu.setPassword(passwordNew);
            if (this.m_wu.getPasswordMessage() != null) {
                this.setMessage("New Password invalid.");
                return false;
            }
            this.m_wu.save();
            if (this.m_forward == null || this.m_forward.equals(this.getLogin_RelURL())) {
                this.m_forward = "/index.jsp";
            }
            this.m_session.setAttribute("hdrMessage", (Object)"Password Changed");
            this.m_session.setAttribute("info", (Object)new WebInfo(this.m_ctx, this.m_wu));
        } else if ("address".equals(this.m_mode)) {
            this.m_wu.setC_Country_ID(WebUtil.getParamOrNull(this.m_request, "C_Country_ID"));
            this.m_wu.setC_Region_ID(WebUtil.getParamOrNull(this.m_request, "C_Region_ID"));
            this.m_wu.setRegionName(WebUtil.getParamOrNull(this.m_request, "RegionName"));
            this.m_wu.setName(WebUtil.getParamOrNull(this.m_request, "Name"));
            this.m_wu.setCompany(WebUtil.getParamOrNull(this.m_request, "Company"));
            this.m_wu.setTitle(WebUtil.getParamOrNull(this.m_request, "Title"));
            this.m_wu.setAddress(WebUtil.getParamOrNull(this.m_request, "Address"));
            this.m_wu.setAddress2(WebUtil.getParamOrNull(this.m_request, "Address2"));
            this.m_wu.setCity(WebUtil.getParamOrNull(this.m_request, "City"));
            this.m_wu.setPostal(WebUtil.getParamOrNull(this.m_request, "Postal"));
            this.m_wu.setPhone(WebUtil.getParamOrNull(this.m_request, "Phone"));
            this.m_wu.setFax(WebUtil.getParamOrNull(this.m_request, "Fax"));
            this.m_wu.save();
            this.m_session.setAttribute("hdrMessage", (Object)"Contact Information Changed");
            this.m_session.setAttribute("info", (Object)new WebInfo(this.m_ctx, this.m_wu));
        } else if ("EMailVerify".equals(this.m_mode)) {
            if (this.m_wu == null) {
                this.log.warning("No web user");
                return false;
            }
            this.log.info(this.m_forward + " - " + this.m_wu.toString());
            String cmd = WebUtil.getParameter(this.m_request, "ReSend");
            if (cmd != null && cmd.length() > 1) {
                WebUtil.resendCode(this.m_request, this.m_wu);
            } else {
                this.m_wu.setEMailVerifyCode(WebUtil.getParameter(this.m_request, "VerifyCode"), this.m_request.getRemoteAddr());
            }
        } else if ("bankaccountach".equals(this.m_mode)) {
            if (this.m_wu == null) {
                this.log.warning("No web user");
                return false;
            }
            this.log.info(this.m_forward + " - " + this.m_wu.toString());
            MBPBankAccount thisBPBankAccount = this.m_wu.getBankAccount(true);
            thisBPBankAccount.setIsACH(true);
            thisBPBankAccount.setA_City(WebUtil.getParamOrNull(this.m_request, "A_City"));
            thisBPBankAccount.setA_Name(WebUtil.getParamOrNull(this.m_request, "A_Name"));
            thisBPBankAccount.setAccountNo(WebUtil.getParamOrNull(this.m_request, "AccountNo"));
            thisBPBankAccount.setRoutingNo(WebUtil.getParamOrNull(this.m_request, "RoutingNo"));
            thisBPBankAccount.save();
        } else {
            this.log.log(Level.WARNING, "Unknown request='" + this.m_mode + "'");
        }
        return true;
    }

    public void setMessage(String newVal) {
        if (newVal != null) {
            this.m_message = newVal;
        }
    }

    public String getMessage() {
        return this.m_message;
    }

    public void setP_ForwardTo(String newVal) {
        if (newVal != null) {
            this.P_ForwardTo = newVal;
        }
    }

    public String getP_ForwardTo() {
        return this.P_ForwardTo;
    }

    public void setP_EMail(String newVal) {
        if (newVal != null) {
            this.P_EMail = newVal;
        }
    }

    public String getP_EMail() {
        return this.P_EMail;
    }

    public void setP_Password(String newVal) {
        if (newVal != null) {
            this.P_Password = newVal;
        }
    }

    public String getP_Password() {
        return this.P_Password;
    }

    public void setP_SalesRep_ID(String newVal) {
        if (newVal != null) {
            this.P_SalesRep_ID = newVal;
        }
    }

    public String getP_SalesRep_ID() {
        return this.P_SalesRep_ID;
    }

    public void setP_Action(String newVal) {
        if (newVal != null) {
            this.P_Action = newVal;
        }
    }

    public String getP_Action() {
        return this.P_Action;
    }

    public void setLogin_RelURL(String newVal) {
        if (newVal != null) {
            this.m_login_page = newVal;
        }
    }

    public String getLogin_RelURL() {
        return this.m_login_page;
    }

    public void setUpdate_page(String newVal) {
        if (newVal != null) {
            this.m_update_page = newVal;
        }
    }

    public String getUpdate_page() {
        return this.m_update_page;
    }

    public void setForward(String newVal) {
        if (newVal != null) {
            this.m_forward = newVal;
        }
    }

    public String getForward() {
        return this.m_forward;
    }

    public String getSalesRep_ID() {
        return this.m_salesRep;
    }

    public void setAddressConfirm(boolean newVal) {
        this.m_addressConfirm = newVal;
    }

    public boolean getAddressConfirm() {
        return this.m_addressConfirm;
    }

    public WebUser getWebUser() {
        return this.m_wu;
    }

    public void setMode(String t_mode) {
        this.m_mode = t_mode;
    }

    public String getMode() {
        return this.m_mode;
    }
}

