/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.compiere.util.Language;

public class TimeUtil {
    public static final String TRUNC_DAY = "D";
    public static final String TRUNC_WEEK = "W";
    public static final String TRUNC_MONTH = "MM";
    public static final String TRUNC_QUARTER = "Q";
    public static final String TRUNC_YEAR = "Y";

    public static Timestamp getDay(long time) {
        if (time == 0L) {
            time = System.currentTimeMillis();
        }
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.setTimeInMillis(time);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp getDay(Timestamp dayTime) {
        if (dayTime == null) {
            return TimeUtil.getDay(System.currentTimeMillis());
        }
        return TimeUtil.getDay(dayTime.getTime());
    }

    public static Timestamp getDay(int year, int month, int day) {
        if (year < 50) {
            year += 2000;
        } else if (year < 100) {
            year += 1900;
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid Month: " + month);
        }
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("Invalid Day: " + month);
        }
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Calendar getToday() {
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Timestamp getNextDay(Timestamp day) {
        if (day == null) {
            day = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.setTimeInMillis(day.getTime());
        cal.add(6, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp getMonthLastDay(Timestamp day) {
        if (day == null) {
            day = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.setTimeInMillis(day.getTime());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(2, 1);
        cal.set(5, 1);
        cal.add(6, -1);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp getDayTime(Timestamp day, Timestamp time) {
        GregorianCalendar cal_1 = new GregorianCalendar();
        cal_1.setTimeInMillis(day.getTime());
        GregorianCalendar cal_2 = new GregorianCalendar();
        cal_2.setTimeInMillis(time.getTime());
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.set(cal_1.get(1), cal_1.get(2), cal_1.get(5), cal_2.get(11), cal_2.get(12), cal_2.get(13));
        cal.set(14, 0);
        Timestamp retValue = new Timestamp(cal.getTimeInMillis());
        return retValue;
    }

    public static boolean inRange(Timestamp start_1, Timestamp end_1, Timestamp start_2, Timestamp end_2) {
        if (end_1.before(start_1)) {
            throw new UnsupportedOperationException("TimeUtil.inRange End_1=" + end_1 + " before Start_1=" + start_1);
        }
        if (end_2.before(start_2)) {
            throw new UnsupportedOperationException("TimeUtil.inRange End_2=" + end_2 + " before Start_2=" + start_2);
        }
        if (!end_2.after(start_1)) {
            return false;
        }
        return start_2.before(end_1);
    }

    public static boolean inRange(Timestamp start, Timestamp end, boolean OnMonday, boolean OnTuesday, boolean OnWednesday, boolean OnThursday, boolean OnFriday, boolean OnSaturday, boolean OnSunday) {
        if (OnSaturday && OnSunday && OnMonday && OnTuesday && OnWednesday && OnThursday && OnFriday) {
            return false;
        }
        GregorianCalendar calStart = new GregorianCalendar();
        calStart.setTimeInMillis(start.getTime());
        int dayStart = calStart.get(7);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.setTimeInMillis(end.getTime());
        calEnd.add(6, -1);
        int dayEnd = calEnd.get(7);
        if (calStart.get(1) == calEnd.get(1) && calStart.get(2) == calEnd.get(2) && calStart.get(5) == calEnd.get(6)) {
            return !OnSaturday && dayStart == 7 || !OnSunday && dayStart == 1 || !OnMonday && dayStart == 2 || !OnTuesday && dayStart == 3 || !OnWednesday && dayStart == 4 || !OnThursday && dayStart == 5 || !OnFriday && dayStart == 6;
        }
        BitSet days = new BitSet(8);
        if (dayEnd <= dayStart) {
            dayEnd += 7;
        }
        for (int i = dayStart; i < dayEnd; ++i) {
            int index = i;
            if (index > 7) {
                index -= 7;
            }
            days.set(index);
        }
        return !OnSaturday && days.get(7) || !OnSunday && days.get(1) || !OnMonday && days.get(2) || !OnTuesday && days.get(3) || !OnWednesday && days.get(4) || !OnThursday && days.get(5) || !OnFriday && days.get(6);
    }

    public static boolean isSameDay(Timestamp one, Timestamp two) {
        GregorianCalendar calOne = new GregorianCalendar();
        if (one != null) {
            calOne.setTimeInMillis(one.getTime());
        }
        GregorianCalendar calTwo = new GregorianCalendar();
        if (two != null) {
            calTwo.setTimeInMillis(two.getTime());
        }
        return calOne.get(1) == calTwo.get(1) && calOne.get(2) == calTwo.get(2) && calOne.get(5) == calTwo.get(5);
    }

    public static boolean isSameHour(Timestamp one, Timestamp two) {
        GregorianCalendar calOne = new GregorianCalendar();
        if (one != null) {
            calOne.setTimeInMillis(one.getTime());
        }
        GregorianCalendar calTwo = new GregorianCalendar();
        if (two != null) {
            calTwo.setTimeInMillis(two.getTime());
        }
        return calOne.get(1) == calTwo.get(1) && calOne.get(2) == calTwo.get(2) && calOne.get(5) == calTwo.get(5) && calOne.get(11) == calTwo.get(11);
    }

    public static boolean isAllDay(Timestamp start, Timestamp end) {
        GregorianCalendar calStart = new GregorianCalendar();
        calStart.setTimeInMillis(start.getTime());
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.setTimeInMillis(end.getTime());
        return calStart.get(11) == calEnd.get(11) && calStart.get(12) == calEnd.get(12) && calStart.get(13) == calEnd.get(13) && calStart.get(14) == calEnd.get(14) && calStart.get(11) == 0 && calStart.get(12) == 0 && calStart.get(13) == 0 && calStart.get(14) == 0 && start.before(end);
    }

    public static int getDaysBetween(Timestamp start, Timestamp end) {
        boolean negative = false;
        if (end.before(start)) {
            negative = true;
            Timestamp temp = start;
            start = end;
            end = temp;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(start);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.setTime(end);
        calEnd.set(11, 0);
        calEnd.set(12, 0);
        calEnd.set(13, 0);
        calEnd.set(14, 0);
        if (cal.get(1) == calEnd.get(1)) {
            if (negative) {
                return (calEnd.get(6) - cal.get(6)) * -1;
            }
            return calEnd.get(6) - cal.get(6);
        }
        int counter = 0;
        while (calEnd.after(cal)) {
            cal.add(6, 1);
            ++counter;
        }
        if (negative) {
            return counter * -1;
        }
        return counter;
    }

    public static Timestamp addDays(Timestamp day, int offset) {
        if (offset == 0) {
            return day;
        }
        if (day == null) {
            day = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (offset == 0) {
            return new Timestamp(cal.getTimeInMillis());
        }
        cal.add(6, offset);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp addMinutess(Timestamp dateTime, int offset) {
        if (dateTime == null) {
            dateTime = new Timestamp(System.currentTimeMillis());
        }
        if (offset == 0) {
            return dateTime;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dateTime);
        cal.add(12, offset);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static String formatElapsed(Timestamp start, Timestamp end) {
        long startTime = 0L;
        startTime = start == null ? System.currentTimeMillis() : start.getTime();
        long endTime = 0L;
        endTime = end == null ? System.currentTimeMillis() : end.getTime();
        return TimeUtil.formatElapsed(endTime - startTime);
    }

    public static String formatElapsed(Timestamp start) {
        if (start == null) {
            return "NoStartTime";
        }
        long startTime = start.getTime();
        long endTime = System.currentTimeMillis();
        return TimeUtil.formatElapsed(endTime - startTime);
    }

    public static String formatElapsed(long elapsedMS) {
        if (elapsedMS == 0L) {
            return "0";
        }
        StringBuffer sb = new StringBuffer();
        if (elapsedMS < 0L) {
            elapsedMS = -elapsedMS;
            sb.append("-");
        }
        long miliSeconds = elapsedMS % 1000L;
        long seconds = (elapsedMS /= 1000L) % 60L;
        long minutes = (elapsedMS /= 60L) % 60L;
        long hours = (elapsedMS /= 60L) % 24L;
        long days = elapsedMS / 24L;
        if (days != 0L) {
            sb.append(days).append("'");
        }
        if (hours != 0L) {
            sb.append(TimeUtil.get2digits(hours)).append(":");
        } else if (days != 0L) {
            sb.append("00:");
        }
        if (minutes != 0L) {
            sb.append(TimeUtil.get2digits(minutes)).append(":");
        } else if (hours != 0L || days != 0L) {
            sb.append("00:");
        }
        sb.append(TimeUtil.get2digits(seconds)).append(".").append(miliSeconds);
        return sb.toString();
    }

    private static String get2digits(long no) {
        String s = String.valueOf(no);
        if (s.length() > 1) {
            return s;
        }
        return "0" + s;
    }

    public static boolean isValid(Timestamp validFrom, Timestamp validTo) {
        return TimeUtil.isValid(validFrom, validTo, new Timestamp(System.currentTimeMillis()));
    }

    public static boolean isValid(Timestamp validFrom, Timestamp validTo, Timestamp testDate) {
        if (testDate == null) {
            return true;
        }
        if (validFrom == null && validTo == null) {
            return true;
        }
        if (validFrom != null && validFrom.after(testDate)) {
            return false;
        }
        return validTo == null || !validTo.before(testDate);
    }

    public static Timestamp max(Timestamp ts1, Timestamp ts2) {
        if (ts1 == null) {
            return ts2;
        }
        if (ts2 == null) {
            return ts1;
        }
        if (ts2.after(ts1)) {
            return ts2;
        }
        return ts1;
    }

    public static Timestamp trunc(Timestamp dayTime, String trunc) {
        if (dayTime == null) {
            dayTime = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.setTimeInMillis(dayTime.getTime());
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        if (trunc == null || trunc.equals(TRUNC_DAY)) {
            return new Timestamp(cal.getTimeInMillis());
        }
        if (trunc.equals(TRUNC_WEEK)) {
            cal.set(7, cal.getFirstDayOfWeek());
            return new Timestamp(cal.getTimeInMillis());
        }
        cal.set(5, 1);
        if (trunc.equals(TRUNC_MONTH)) {
            return new Timestamp(cal.getTimeInMillis());
        }
        if (trunc.equals(TRUNC_QUARTER)) {
            int mm = cal.get(2);
            mm = mm < 4 ? 1 : (mm < 7 ? 4 : (mm < 10 ? 7 : 10));
            cal.set(2, mm);
            return new Timestamp(cal.getTimeInMillis());
        }
        cal.set(6, 1);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp getDayBorder(Timestamp dateTime, Timestamp timeSlot, boolean end) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(dateTime.getTime());
        dateTime.setNanos(0);
        if (timeSlot != null) {
            timeSlot.setNanos(0);
            GregorianCalendar gcTS = new GregorianCalendar();
            gcTS.setTimeInMillis(timeSlot.getTime());
            gc.set(11, gcTS.get(11));
            gc.set(12, gcTS.get(12));
            gc.set(13, gcTS.get(13));
            gc.set(14, gcTS.get(14));
        } else if (end) {
            gc.set(11, 23);
            gc.set(12, 59);
            gc.set(13, 59);
            gc.set(14, 999);
        } else {
            gc.set(14, 0);
            gc.set(13, 0);
            gc.set(12, 0);
            gc.set(11, 0);
        }
        return new Timestamp(gc.getTimeInMillis());
    }

    public static void main(String[] args) {
        Timestamp t1 = TimeUtil.getDay(1, 1, 1);
        Timestamp t2 = TimeUtil.getDay(2, 2, 2);
        Timestamp t3 = TimeUtil.getDay(3, 3, 3);
        Timestamp t4 = TimeUtil.getDay(1, 1, 1);
        Timestamp t5 = TimeUtil.getDay(2, 2, 2);
        System.out.println(t1 + " - " + t3);
        System.out.println(t2 + " - " + TimeUtil.isValid(t1, t3, t2));
        System.out.println(TimeUtil.isSameDay(t1, t4) + " == true");
        System.out.println(TimeUtil.isSameDay(t2, t5) + " == true");
        System.out.println(TimeUtil.isSameDay(t3, t5) + " == false");
    }

    public static Calendar getCalendar(Timestamp date) {
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        if (date != null) {
            cal.setTimeInMillis(date.getTime());
        }
        return cal;
    }

    public static Timestamp getMonthFirstDay(Timestamp day) {
        if (day == null) {
            day = new Timestamp(System.currentTimeMillis());
        }
        Calendar cal = TimeUtil.getCalendar(day);
        cal.setTimeInMillis(day.getTime());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(5, 1);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static Timestamp addMonths(Timestamp day, int offset) {
        if (day == null) {
            day = new Timestamp(System.currentTimeMillis());
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (offset == 0) {
            return new Timestamp(cal.getTimeInMillis());
        }
        cal.add(2, offset);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static int getMonthsBetween(Timestamp start, Timestamp end) {
        Calendar startCal = TimeUtil.getCalendar(start);
        Calendar endCal = TimeUtil.getCalendar(end);
        return endCal.get(1) * 12 + endCal.get(2) - (startCal.get(1) * 12 + startCal.get(2));
    }
}

