/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.security.Principal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCountry;
import org.compiere.model.MRole;
import org.compiere.model.MSystem;
import org.compiere.model.MTree_Base;
import org.compiere.model.ModelValidationEngine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.SecureEngine;

public class Login {
    private static CLogger log = CLogger.getCLogger(Login.class);
    private Properties m_ctx = null;
    private String m_connectionProfile = null;

    public static Properties initTest(boolean isClient) {
        KeyNamePair[] orgs;
        KeyNamePair[] clients;
        Properties ctx;
        Login login;
        KeyNamePair[] roles;
        if (!Adempiere.startupEnvironment(true)) {
            System.exit(1);
        }
        if ((roles = (login = new Login(ctx = Env.getCtx())).getRoles(CConnection.get(), "System", "System", true)) != null && roles.length > 0 && (clients = login.getClients(roles[0])) != null && clients.length > 0 && (orgs = login.getOrgs(clients[0])) != null && orgs.length > 0) {
            KeyNamePair[] whs = login.getWarehouses(orgs[0]);
            login.loadPreferences(orgs[0], null, null, null);
        }
        Env.setContext(ctx, "#Date", "2000-01-01");
        return ctx;
    }

    public static boolean isJavaOK(boolean isClient) {
        String jVersion = System.getProperty("java.version");
        if (jVersion.startsWith("1.5.0")) {
            return true;
        }
        if (jVersion.startsWith("1.6.0")) {
            return true;
        }
        if (jVersion.startsWith("1.7.0")) {
            return true;
        }
        boolean ok = false;
        StringBuffer msg = new StringBuffer();
        msg.append(System.getProperty("java.vm.name")).append(" - ").append(jVersion);
        if (ok) {
            msg.append("(untested)");
        }
        msg.append("  <>  1.5.0");
        if (isClient) {
            JOptionPane.showMessageDialog(null, msg.toString(), String.valueOf(Adempiere.getName()) + " - Java Version Check", ok ? 2 : 0);
        } else {
            log.severe(msg.toString());
        }
        return ok;
    }

    public Login(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Context missing");
        }
        this.m_ctx = ctx;
    }

    protected KeyNamePair[] getRoles(CConnection cc, String app_user, String app_pwd, boolean force) {
        DB.setDBTarget(cc);
        Env.setContext(this.m_ctx, "#Host", cc.getAppsHost());
        Env.setContext(this.m_ctx, "#Database", cc.getDbName());
        Connection conn = DB.getConnectionRO();
        if (conn == null) {
            log.saveError("NoDatabase", "");
            return null;
        }
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (app_pwd == null) {
            return null;
        }
        return this.getRoles(app_user, app_pwd, force);
    }

    public KeyNamePair[] getRoles(Principal app_user) {
        if (app_user == null) {
            return null;
        }
        return this.getRoles(app_user.getName(), null, false);
    }

    public KeyNamePair[] getRoles(String app_user, String app_pwd) {
        return this.getRoles(app_user, app_pwd, false);
    }

    private KeyNamePair[] getRoles(String app_user, String app_pwd, boolean force) {
        ResultSet rs;
        CPreparedStatement pstmt;
        StringBuffer sql;
        ArrayList<KeyNamePair> list;
        KeyNamePair[] retValue;
        long start;
        block20: {
            block21: {
                MSystem system;
                log.info("User=" + app_user);
                start = System.currentTimeMillis();
                if (app_user == null) {
                    log.warning("No Apps User");
                    return null;
                }
                boolean authenticated = false;
                if (Ini.isClient()) {
                    CConnection.get().setAppServerCredential(app_user, app_pwd);
                }
                if ((system = MSystem.get(this.m_ctx)) == null) {
                    throw new IllegalStateException("No System Info");
                }
                if (app_pwd == null || app_pwd.length() == 0) {
                    log.warning("No Apps Password");
                    return null;
                }
                if (system.isLDAP() && (authenticated = system.isLDAP(app_user, app_pwd))) {
                    app_pwd = null;
                }
                retValue = null;
                list = new ArrayList<KeyNamePair>();
                sql = new StringBuffer("SELECT u.AD_User_ID, r.AD_Role_ID,r.Name,").append(" u.ConnectionProfile ").append("FROM AD_User u").append(" INNER JOIN AD_User_Roles ur ON (u.AD_User_ID=ur.AD_User_ID AND ur.IsActive='Y')").append(" INNER JOIN AD_Role r ON (ur.AD_Role_ID=r.AD_Role_ID AND r.IsActive='Y') ").append("WHERE COALESCE(u.LDAPUser,u.Name)=?").append(" AND u.IsActive='Y'").append(" AND EXISTS (SELECT * FROM AD_Client c WHERE u.AD_Client_ID=c.AD_Client_ID AND c.IsActive='Y')");
                if (app_pwd != null) {
                    sql.append(" AND ((u.Password=? AND (SELECT IsEncrypted FROM AD_Column WHERE AD_Column_ID=417)='N') OR (u.Password=? AND (SELECT IsEncrypted FROM AD_Column WHERE AD_Column_ID=417)='Y'))");
                }
                sql.append(" ORDER BY r.Name");
                pstmt = null;
                rs = null;
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setString(1, app_user);
                if (app_pwd != null) {
                    pstmt.setString(2, app_pwd);
                    pstmt.setString(3, SecureEngine.encrypt(app_pwd));
                }
                if ((rs = pstmt.executeQuery()).next()) break block20;
                if (!force) break block21;
                Env.setContext(this.m_ctx, "#AD_User_Name", "System");
                Env.setContext(this.m_ctx, "#AD_User_ID", "0");
                Env.setContext(this.m_ctx, "#AD_User_Description", "System Forced Login");
                Env.setContext(this.m_ctx, "#User_Level", "S  ");
                Env.setContext(this.m_ctx, "#User_Client", "0");
                Env.setContext(this.m_ctx, "#User_Org", "0");
                rs.close();
                pstmt.close();
                KeyNamePair[] keyNamePairArray = retValue = new KeyNamePair[]{new KeyNamePair(0, "System Administrator")};
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return keyNamePairArray;
            }
            rs.close();
            pstmt.close();
            log.saveError("UserPwdError", app_user, false);
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return null;
        }
        try {
            try {
                Env.setContext(this.m_ctx, "#AD_User_Name", app_user);
                Env.setContext(this.m_ctx, "#AD_User_ID", rs.getInt(1));
                Env.setContext(this.m_ctx, "#SalesRep_ID", rs.getInt(1));
                if (Ini.isClient()) {
                    CConnection cc;
                    if (MSystem.isSwingRememberUserAllowed()) {
                        Ini.setProperty("ApplicationUserID", app_user);
                    } else {
                        Ini.setProperty("ApplicationUserID", "");
                    }
                    if (Ini.isPropertyBool("StorePassword") && MSystem.isSwingRememberPasswordAllowed()) {
                        Ini.setProperty("ApplicationPassword", app_pwd);
                    }
                    this.m_connectionProfile = rs.getString(4);
                    if (this.m_connectionProfile != null && !(cc = CConnection.get()).getConnectionProfile().equals(this.m_connectionProfile)) {
                        cc.setConnectionProfile(this.m_connectionProfile);
                        Ini.setProperty("Connection", cc.toStringLong());
                        Ini.saveProperties(false);
                    }
                }
                do {
                    int AD_Role_ID;
                    if ((AD_Role_ID = rs.getInt(2)) == 0) {
                        Env.setContext(this.m_ctx, "#SysAdmin", "Y");
                    }
                    String Name2 = rs.getString(3);
                    KeyNamePair p2 = new KeyNamePair(AD_Role_ID, Name2);
                    list.add(p2);
                } while (rs.next());
                retValue = new KeyNamePair[list.size()];
                list.toArray(retValue);
                log.fine("User=" + app_user + " - roles #" + retValue.length);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, sql.toString(), ex);
                log.saveError("DBLogin", ex);
                retValue = null;
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        long ms = System.currentTimeMillis() - start;
        return retValue;
    }

    public KeyNamePair[] getClients(KeyNamePair role) {
        ResultSet rs;
        CPreparedStatement pstmt;
        String sql;
        KeyNamePair[] retValue;
        ArrayList<KeyNamePair> list;
        block9: {
            if (role == null) {
                throw new IllegalArgumentException("Role missing");
            }
            list = new ArrayList<KeyNamePair>();
            retValue = null;
            sql = "SELECT DISTINCT r.UserLevel, r.ConnectionProfile,  c.AD_Client_ID,c.Name FROM AD_Role r INNER JOIN AD_Client c ON (r.AD_Client_ID=c.AD_Client_ID) WHERE r.AD_Role_ID=? AND r.IsActive='Y' AND c.IsActive='Y'";
            pstmt = null;
            rs = null;
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, role.getKey());
            rs = pstmt.executeQuery();
            if (rs.next()) break block9;
            rs.close();
            pstmt.close();
            log.log(Level.SEVERE, "No Clients for Role: " + role.toStringX());
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return null;
        }
        try {
            try {
                Env.setContext(this.m_ctx, "#AD_Role_ID", role.getKey());
                Env.setContext(this.m_ctx, "#AD_Role_Name", role.getName());
                Ini.setProperty("Role", role.getName());
                Env.setContext(this.m_ctx, "#User_Level", rs.getString(1));
                CConnection cc = CConnection.get();
                if (this.m_connectionProfile == null) {
                    this.m_connectionProfile = rs.getString(2);
                    if (this.m_connectionProfile != null && !cc.getConnectionProfile().equals(this.m_connectionProfile)) {
                        cc.setConnectionProfile(this.m_connectionProfile);
                        Ini.setProperty("Connection", cc.toStringLong());
                        Ini.saveProperties(false);
                    }
                }
                do {
                    int AD_Client_ID = rs.getInt(3);
                    String Name2 = rs.getString(4);
                    KeyNamePair p2 = new KeyNamePair(AD_Client_ID, Name2);
                    list.add(p2);
                } while (rs.next());
                rs.close();
                pstmt.close();
                pstmt = null;
                retValue = new KeyNamePair[list.size()];
                list.toArray(retValue);
                log.fine("Role: " + role.toStringX() + " - clients #" + retValue.length);
            }
            catch (SQLException ex) {
                log.log(Level.SEVERE, sql, ex);
                retValue = null;
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return retValue;
    }

    public KeyNamePair[] getOrgs(KeyNamePair client) {
        KeyNamePair[] retValue;
        int AD_User_ID;
        int AD_Role_ID;
        block11: {
            if (client == null) {
                throw new IllegalArgumentException("Client missing");
            }
            if (Env.getContext(this.m_ctx, "#AD_Role_ID").length() == 0) {
                throw new UnsupportedOperationException("Missing Context #AD_Role_ID");
            }
            AD_Role_ID = Env.getContextAsInt(this.m_ctx, "#AD_Role_ID");
            AD_User_ID = Env.getContextAsInt(this.m_ctx, "#AD_User_ID");
            ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
            retValue = null;
            String sql = "SELECT o.AD_Org_ID,o.Name,o.IsSummary FROM AD_Role r, AD_Client c INNER JOIN AD_Org o ON (c.AD_Client_ID=o.AD_Client_ID OR o.AD_Org_ID=0) WHERE r.AD_Role_ID=? AND c.AD_Client_ID=? AND o.IsActive='Y' AND o.IsSummary='N' AND (r.IsAccessAllOrgs='Y' OR (r.IsUseUserOrgAccess='N' AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_Role_OrgAccess ra WHERE ra.AD_Role_ID=r.AD_Role_ID AND ra.IsActive='Y')) OR (r.IsUseUserOrgAccess='Y' AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_User_OrgAccess ua WHERE ua.AD_User_ID=? AND ua.IsActive='Y'))) ORDER BY o.Name";
            CPreparedStatement pstmt = null;
            MRole role = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Role_ID);
                    pstmt.setInt(2, client.getKey());
                    pstmt.setInt(3, AD_User_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int AD_Org_ID = rs.getInt(1);
                        String Name2 = rs.getString(2);
                        boolean summary = "Y".equals(rs.getString(3));
                        if (summary) {
                            if (role == null) {
                                role = MRole.get(this.m_ctx, AD_Role_ID);
                            }
                            this.getOrgsAddSummary(list, AD_Org_ID, Name2, role);
                            continue;
                        }
                        KeyNamePair p2 = new KeyNamePair(AD_Org_ID, Name2);
                        if (list.contains(p2)) continue;
                        list.add(p2);
                    }
                    retValue = new KeyNamePair[list.size()];
                    list.toArray(retValue);
                    log.fine("Client: " + client.toStringX() + ", AD_Role_ID=" + AD_Role_ID + ", AD_User_ID=" + AD_User_ID + " - orgs #" + retValue.length);
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, sql, ex);
                    retValue = null;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null || retValue.length == 0) {
            log.log(Level.WARNING, "No Org for Client: " + client.toStringX() + ", AD_Role_ID=" + AD_Role_ID + ", AD_User_ID=" + AD_User_ID);
            return null;
        }
        Env.setContext(this.m_ctx, "#AD_Client_ID", client.getKey());
        Env.setContext(this.m_ctx, "#AD_Client_Name", client.getName());
        Ini.setProperty("Client", client.getName());
        return retValue;
    }

    private void getOrgsAddSummary(ArrayList<KeyNamePair> list, int Summary_Org_ID, String Summary_Name, MRole role) {
        block9: {
            if (role == null) {
                log.warning("Summary Org=" + Summary_Name + "(" + Summary_Org_ID + ") - No Role");
                return;
            }
            if (role.getAD_Tree_Org_ID() == 0) {
                log.config("Summary Org=" + Summary_Name + "(" + Summary_Org_ID + ") - No Org Tree: " + role);
                return;
            }
            MTree_Base tree = MTree_Base.get(this.m_ctx, role.getAD_Tree_Org_ID(), null);
            String sql = "SELECT AD_Client_ID, AD_Org_ID, Name, IsSummary FROM AD_Org WHERE IsActive='Y' AND AD_Org_ID IN (SELECT Node_ID FROM " + tree.getNodeTableName() + " WHERE AD_Tree_ID=? AND Parent_ID=? AND IsActive='Y') " + "ORDER BY Name";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, tree.getAD_Tree_ID());
                    pstmt.setInt(2, Summary_Org_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int AD_Client_ID = rs.getInt(1);
                        int AD_Org_ID = rs.getInt(2);
                        String Name2 = rs.getString(3);
                        boolean summary = "Y".equals(rs.getString(4));
                        if (summary) {
                            this.getOrgsAddSummary(list, AD_Org_ID, Name2, role);
                            continue;
                        }
                        KeyNamePair p2 = new KeyNamePair(AD_Org_ID, Name2);
                        if (list.contains(p2)) continue;
                        list.add(p2);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public KeyNamePair[] getWarehouses(KeyNamePair org) {
        ResultSet rs;
        CPreparedStatement pstmt;
        KeyNamePair[] retValue;
        ArrayList<KeyNamePair> list;
        block7: {
            if (org == null) {
                throw new IllegalArgumentException("Org missing");
            }
            list = new ArrayList<KeyNamePair>();
            retValue = null;
            String sql = "SELECT M_Warehouse_ID, Name FROM M_Warehouse WHERE AD_Org_ID=? AND IsActive='Y'  AND IsInTransit='N' ORDER BY Name";
            pstmt = null;
            rs = null;
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, org.getKey());
            rs = pstmt.executeQuery();
            if (rs.next()) break block7;
            rs.close();
            pstmt.close();
            log.info("No Warehouses for Org: " + org.toStringX());
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return null;
        }
        try {
            try {
                do {
                    int AD_Warehouse_ID = rs.getInt(1);
                    String Name2 = rs.getString(2);
                    KeyNamePair p2 = new KeyNamePair(AD_Warehouse_ID, Name2);
                    list.add(p2);
                } while (rs.next());
                rs.close();
                pstmt.close();
                pstmt = null;
                retValue = new KeyNamePair[list.size()];
                list.toArray(retValue);
                log.fine("Org: " + org.toStringX() + " - warehouses #" + retValue.length);
            }
            catch (SQLException ex) {
                log.log(Level.SEVERE, "getWarehouses", ex);
                retValue = null;
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return retValue;
    }

    public String validateLogin(KeyNamePair org) {
        int AD_Client_ID = Env.getAD_Client_ID(this.m_ctx);
        int AD_Org_ID = org.getKey();
        int AD_Role_ID = Env.getAD_Role_ID(this.m_ctx);
        int AD_User_ID = Env.getAD_User_ID(this.m_ctx);
        String error = ModelValidationEngine.get().loginComplete(AD_Client_ID, AD_Org_ID, AD_Role_ID, AD_User_ID);
        if (error != null && error.length() > 0) {
            log.severe("Refused: " + error);
            return error;
        }
        return null;
    }

    public String loadPreferences(KeyNamePair org, KeyNamePair warehouse, Timestamp timestamp, String printerName) {
        String retValue;
        block25: {
            log.info("Org: " + org.toStringX());
            if (this.m_ctx == null || org == null) {
                throw new IllegalArgumentException("Required parameter missing");
            }
            if (Env.getContext(this.m_ctx, "#AD_Client_ID").length() == 0) {
                throw new UnsupportedOperationException("Missing Context #AD_Client_ID");
            }
            if (Env.getContext(this.m_ctx, "#AD_User_ID").length() == 0) {
                throw new UnsupportedOperationException("Missing Context #AD_User_ID");
            }
            if (Env.getContext(this.m_ctx, "#AD_Role_ID").length() == 0) {
                throw new UnsupportedOperationException("Missing Context #AD_Role_ID");
            }
            Env.setContext(this.m_ctx, "#AD_Org_ID", org.getKey());
            Env.setContext(this.m_ctx, "#AD_Org_Name", org.getName());
            Ini.setProperty("Organization", org.getName());
            if (warehouse != null) {
                Env.setContext(this.m_ctx, "#M_Warehouse_ID", warehouse.getKey());
                Ini.setProperty("Warehouse", warehouse.getName());
            }
            long today = System.currentTimeMillis();
            if (timestamp != null) {
                today = timestamp.getTime();
            }
            Env.setContext(this.m_ctx, "#Date", new Timestamp(today));
            if (printerName == null) {
                printerName = "";
            }
            Env.setContext(this.m_ctx, "#Printer", printerName);
            Ini.setProperty("Printer", printerName);
            MRole.getDefault(this.m_ctx, true);
            Env.setAutoCommit(this.m_ctx, Ini.isPropertyBool("AutoCommit"));
            Env.setAutoNew(this.m_ctx, Ini.isPropertyBool("AutoNew"));
            if (MRole.getDefault(this.m_ctx, false).isShowAcct()) {
                Env.setContext(this.m_ctx, "#ShowAcct", Ini.getProperty("ShowAcct"));
            } else {
                Env.setContext(this.m_ctx, "#ShowAcct", "N");
            }
            Env.setContext(this.m_ctx, "#ShowTrl", Ini.getProperty("ShowTrl"));
            Env.setContext(this.m_ctx, "#ShowAdvanced", Ini.getProperty("ShowAdvanced"));
            retValue = "";
            int AD_Client_ID = Env.getContextAsInt(this.m_ctx, "#AD_Client_ID");
            int AD_Org_ID = org.getKey();
            int AD_User_ID = Env.getContextAsInt(this.m_ctx, "#AD_User_ID");
            int AD_Role_ID = Env.getContextAsInt(this.m_ctx, "#AD_Role_ID");
            Env.setContext(this.m_ctx, "#YYYY", "Y");
            Env.setContext(this.m_ctx, "#StdPrecision", 2);
            String sql = "SELECT * FROM C_AcctSchema a, AD_ClientInfo c WHERE a.C_AcctSchema_ID=c.C_AcctSchema1_ID AND c.AD_Client_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    int C_AcctSchema_ID = 0;
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        if (AD_Role_ID != 0) {
                            retValue = "NoValidAcctInfo";
                        }
                    } else {
                        C_AcctSchema_ID = rs.getInt("C_AcctSchema_ID");
                        Env.setContext(this.m_ctx, "$C_AcctSchema_ID", C_AcctSchema_ID);
                        Env.setContext(this.m_ctx, "$C_Currency_ID", rs.getInt("C_Currency_ID"));
                        Env.setContext(this.m_ctx, "$HasAlias", rs.getString("HasAlias"));
                    }
                    rs.close();
                    pstmt.close();
                    MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(Env.getCtx(), AD_Client_ID);
                    if (ass != null && ass.length > 1) {
                        MAcctSchema[] mAcctSchemaArray = ass;
                        int n = ass.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MAcctSchema as = mAcctSchemaArray[n2];
                            C_AcctSchema_ID = MClientInfo.get(Env.getCtx(), AD_Client_ID).getC_AcctSchema1_ID();
                            if (as.getAD_OrgOnly_ID() != 0 && !as.isSkipOrg(AD_Org_ID)) {
                                C_AcctSchema_ID = as.getC_AcctSchema_ID();
                                Env.setContext(this.m_ctx, "$C_AcctSchema_ID", C_AcctSchema_ID);
                                Env.setContext(this.m_ctx, "$C_Currency_ID", as.getC_Currency_ID());
                                Env.setContext(this.m_ctx, "$HasAlias", as.isHasAlias());
                                break;
                            }
                            ++n2;
                        }
                    }
                    sql = "SELECT ElementType FROM C_AcctSchema_Element WHERE C_AcctSchema_ID=? AND IsActive='Y'";
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, C_AcctSchema_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Env.setContext(this.m_ctx, "$Element_" + rs.getString("ElementType"), "Y");
                    }
                    rs.close();
                    pstmt.close();
                    sql = "SELECT Attribute, Value, AD_Window_ID FROM AD_Preference WHERE AD_Client_ID IN (0, @#AD_Client_ID@) AND AD_Org_ID IN (0, @#AD_Org_ID@) AND (AD_User_ID IS NULL OR AD_User_ID=0 OR AD_User_ID=@#AD_User_ID@) AND IsActive='Y' ORDER BY Attribute, AD_Client_ID, AD_User_ID DESC, AD_Org_ID";
                    sql = Env.parseContext(this.m_ctx, 0, sql, false);
                    if (sql.length() == 0) {
                        log.log(Level.SEVERE, "loadPreferences - Missing Environment");
                    } else {
                        pstmt = DB.prepareStatement(sql, null);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            int AD_Window_ID = rs.getInt(3);
                            String at = "";
                            at = rs.wasNull() ? "P|" + rs.getString(1) : "P" + AD_Window_ID + "|" + rs.getString(1);
                            String va = rs.getString(2);
                            Env.setContext(this.m_ctx, at, va);
                        }
                        rs.close();
                        pstmt.close();
                    }
                    log.info("Default Values ...");
                    sql = "SELECT t.TableName, c.ColumnName FROM AD_Column c  INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE c.IsKey='Y' AND t.IsActive='Y' AND EXISTS (SELECT * FROM AD_Column cc  WHERE ColumnName = 'IsDefault' AND t.AD_Table_ID=cc.AD_Table_ID AND cc.IsActive='Y')";
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.loadDefault(rs.getString(1), rs.getString(2));
                    }
                    rs.close();
                    pstmt.close();
                    pstmt = null;
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, "loadPreferences", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block25;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        Ini.saveProperties(Ini.isClient());
        Env.setContext(this.m_ctx, "#C_Country_ID", MCountry.getDefault(this.m_ctx).getC_Country_ID());
        ModelValidationEngine.get().afterLoadPreferences(this.m_ctx);
        return retValue;
    }

    private void loadDefault(String TableName, String ColumnName) {
        if (TableName.startsWith("AD_Window") || TableName.startsWith("AD_PrintFormat") || TableName.startsWith("AD_Workflow")) {
            return;
        }
        String value = null;
        String sql = "SELECT " + ColumnName + " FROM " + TableName + " WHERE IsDefault='Y' AND IsActive='Y' ORDER BY AD_Client_ID DESC, AD_Org_ID DESC";
        sql = MRole.getDefault(this.m_ctx, false).addAccessSQL(sql, TableName, false, false);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    value = rs.getString(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, String.valueOf(TableName) + " (" + sql + ")", e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (value != null && value.length() != 0) {
            if (TableName.equals("C_DocType")) {
                Env.setContext(this.m_ctx, "#C_DocTypeTarget_ID", value);
            } else {
                Env.setContext(this.m_ctx, "#" + ColumnName, value);
            }
        }
    }

    public boolean batchLogin(Timestamp loginDate) {
        String pwd;
        String uid = Ini.getProperty("ApplicationUserID");
        KeyNamePair[] roles = this.getRoles(uid, pwd = Ini.getProperty("ApplicationPassword"));
        if (roles == null || roles.length == 0) {
            log.severe("User/Password invalid: " + uid);
            return false;
        }
        log.info("User: " + uid);
        String role = Ini.getProperty("Role");
        KeyNamePair rolePP = null;
        int i2 = 0;
        while (i2 < roles.length) {
            KeyNamePair pair = roles[i2];
            if (pair.getName().equalsIgnoreCase(role)) {
                rolePP = pair;
                break;
            }
            ++i2;
        }
        if (rolePP == null) {
            log.severe("Role invalid: " + role);
            i2 = 0;
            while (i2 < roles.length) {
                log.info("Option: " + roles[i2]);
                ++i2;
            }
            return false;
        }
        log.info("Role: " + role);
        String client = Ini.getProperty("Client");
        KeyNamePair[] clients = this.getClients(rolePP);
        if (clients == null || clients.length == 0) {
            log.severe("No Clients for Role: " + role);
            return false;
        }
        KeyNamePair clientPP = null;
        int i3 = 0;
        while (i3 < clients.length) {
            KeyNamePair pair = clients[i3];
            if (pair.getName().equalsIgnoreCase(client)) {
                clientPP = pair;
                break;
            }
            ++i3;
        }
        if (clientPP == null) {
            log.severe("Client invalid: " + client);
            i3 = 0;
            while (i3 < clients.length) {
                log.info("Option: " + clients[i3]);
                ++i3;
            }
            return false;
        }
        String org = Ini.getProperty("Organization");
        KeyNamePair[] orgs = this.getOrgs(clientPP);
        if (orgs == null || orgs.length == 0) {
            log.severe("No Orgs for Client: " + client);
            return false;
        }
        KeyNamePair orgPP = null;
        int i4 = 0;
        while (i4 < orgs.length) {
            KeyNamePair pair = orgs[i4];
            if (pair.getName().equalsIgnoreCase(org)) {
                orgPP = pair;
                break;
            }
            ++i4;
        }
        if (orgPP == null) {
            log.severe("Org invalid: " + org);
            i4 = 0;
            while (i4 < orgs.length) {
                log.info("Option: " + orgs[i4]);
                ++i4;
            }
            return false;
        }
        String error = this.validateLogin(orgPP);
        if (error != null && error.length() > 0) {
            return false;
        }
        String wh = Ini.getProperty("Warehouse");
        KeyNamePair[] whs = this.getWarehouses(orgPP);
        if (whs == null || whs.length == 0) {
            log.severe("No Warehouses for Org: " + org);
            return false;
        }
        KeyNamePair whPP = null;
        int i5 = 0;
        while (i5 < whs.length) {
            KeyNamePair pair = whs[i5];
            if (pair.getName().equalsIgnoreCase(wh)) {
                whPP = pair;
                break;
            }
            ++i5;
        }
        if (whPP == null) {
            log.severe("Warehouse invalid: " + wh);
            i5 = 0;
            while (i5 < whs.length) {
                log.info("Option: " + whs[i5]);
                ++i5;
            }
            return false;
        }
        String langName = Ini.getProperty("Language");
        Language language = Language.getLanguage(langName);
        Language.setLoginLanguage(language);
        Env.verifyLanguage(this.m_ctx, language);
        Env.setContext(this.m_ctx, "#AD_Language", language.getAD_Language());
        Locale loc = language.getLocale();
        Locale.setDefault(loc);
        Msg.getMsg(this.m_ctx, "0");
        String printerName = Ini.getProperty("Printer");
        if (loginDate == null) {
            loginDate = new Timestamp(System.currentTimeMillis());
        }
        this.loadPreferences(orgPP, whPP, loginDate, printerName);
        log.info("complete");
        return true;
    }

    public boolean batchLogin() {
        return this.batchLogin(new Timestamp(System.currentTimeMillis()));
    }

    public Principal getPrincipal() {
        return null;
    }
}

