/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.awt.ComponentOrientation;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Logger;
import javax.print.attribute.standard.MediaSize;

public class Language
implements Serializable {
    private static final long serialVersionUID = -964846521004545703L;
    public static final String AD_Language_en_US = "en_US";
    private static final String AD_Language_en_GB = "en_GB";
    private static final String AD_Language_en_AU = "en_AU";
    private static final String AD_Language_ca_ES = "ca_ES";
    private static final String AD_Language_hr_HR = "hr_HR";
    private static final String AD_Language_de_DE = "de_DE";
    private static final String AD_Language_it_IT = "it_IT";
    private static final String AD_Language_es_ES = "es_ES";
    private static final String AD_Language_es_MX = "es_MX";
    private static final String AD_Language_es_CO = "es_CO";
    private static final String AD_Language_es_DO = "es_DO";
    private static final String AD_Language_fr_FR = "fr_FR";
    private static final String AD_Language_fr_CA = "fr_CA";
    private static final String AD_Language_bg_BG = "bg_BG";
    private static final String AD_Language_th_TH = "th_TH";
    private static final String AD_Language_pl_PL = "pl_PL";
    private static final String AD_Language_zh_TW = "zh_TW";
    private static final String AD_Language_nl_NL = "nl_NL";
    private static final String AD_Language_no_NO = "no_NO";
    private static final String AD_Language_pt_BR = "pt_BR";
    private static final String AD_Language_ru_RU = "ru_RU";
    private static final String AD_Language_sl_SI = "sl_SI";
    private static final String AD_Language_sr_RS = "sr_RS";
    private static final String AD_Language_sv_SE = "sv_SE";
    private static final String AD_Language_vi_VN = "vi_VN";
    private static final String AD_Language_zh_CN = "zh_CN";
    private static final String AD_Language_da_DK = "da_DK";
    private static final String AD_Language_ms_MY = "ms_MY";
    private static final String AD_Language_fa_IR = "fa_IR";
    private static final String AD_Language_fi_FI = "fi_FI";
    private static final String AD_Language_ro_RO = "ro_RO";
    private static final String AD_Language_ja_JP = "ja_JP";
    private static final String AD_Language_in_ID = "in_ID";
    private static final String AD_Language_ar_TN = "ar_TN";
    private static final String AD_Language_hu_HU = "hu_HU";
    private static final String AD_Language_el_GR = "el_GR";
    private static Language[] s_languages = new Language[]{new Language("English", "en_US", Locale.US, null, null, MediaSize.NA.LETTER), new Language("\ufe94\ufef4\ufe91\ufeae\ufecc\ufedf\ufe8d (AR)", "ar_TN", new Locale("ar", "TN"), new Boolean(true), "dd.MM.yyyy", MediaSize.ISO.A4), new Language("\u0411\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438 (BG)", "bg_BG", new Locale("bg", "BG"), new Boolean(false), "dd/MM/yyyy", MediaSize.ISO.A4), new Language("Catal\u00e0", "ca_ES", new Locale("ca", "ES"), null, "dd/MM/yyyy", MediaSize.ISO.A4), new Language("Deutsch", "de_DE", Locale.GERMANY, null, null, MediaSize.ISO.A4), new Language("Dansk", "da_DK", new Locale("da", "DK"), new Boolean(false), "dd-MM-yyyy", MediaSize.ISO.A4), new Language("English (AU)", "en_AU", new Locale("en", "AU"), null, "dd/MM/yyyy", MediaSize.ISO.A4), new Language("English (UK)", "en_GB", Locale.UK, null, null, MediaSize.ISO.A4), new Language("Espa\u00f1ol", "es_ES", new Locale("es", "ES"), new Boolean(false), "dd/MM/yyyy", MediaSize.ISO.A4), new Language("Espa\u00f1ol (MX)", "es_MX", new Locale("es", "MX"), new Boolean(true), "dd/MM/yyyy", MediaSize.NA.LETTER), new Language("Espa\u00f1ol (CO)", "es_CO", new Locale("es", "ES"), new Boolean(false), "dd/MM/yyyy", MediaSize.NA.LETTER), new Language("Espa\u00f1ol (VE)", "es_ES", new Locale("es", "ES"), new Boolean(false), "dd/MM/yyyy", MediaSize.ISO.A4), new Language("Espa\u00f1ol (EC)", "es_ES", new Locale("es", "ES"), new Boolean(false), "dd/MM/yyyy", MediaSize.ISO.A4), new Language("Espa\u00f1ol (DO)", "es_DO", new Locale("es", "DO"), new Boolean(true), "dd/MM/yyyy", MediaSize.ISO.A4), new Language("\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac (GR)", "el_GR", new Locale("el", "GR"), new Boolean(false), "dd/MM/yyyy", MediaSize.ISO.A4), new Language("Farsi", "fa_IR", new Locale("fa", "IR"), new Boolean(false), "dd-MM-yyyy", MediaSize.ISO.A4), new Language("Finnish", "fi_FI", new Locale("fi", "FI"), new Boolean(true), "dd.MM.yyyy", MediaSize.ISO.A4), new Language("Fran\u00e7ais", "fr_FR", Locale.FRANCE, null, null, MediaSize.ISO.A4), new Language("Fran\u00e7ais (CA)", "fr_CA", new Locale("fr", "CA"), new Boolean(true), "MM/dd/yyyy", MediaSize.NA.LETTER), new Language("Hrvatski", "hr_HR", new Locale("hr", "HR"), null, "dd.MM.yyyy", MediaSize.ISO.A4), new Language("Indonesia Bahasa", "in_ID", new Locale("in", "ID"), new Boolean(false), "dd-MM-yyyy", MediaSize.ISO.A4), new Language("Italiano", "it_IT", Locale.ITALY, null, null, MediaSize.ISO.A4), new Language("\u65e5\u672c\u8a9e (JP)", "ja_JP", Locale.JAPAN, null, null, MediaSize.ISO.A4), new Language("Malaysian", "ms_MY", new Locale("ms", "MY"), new Boolean(false), "dd-MM-yyyy", MediaSize.ISO.A4), new Language("Magyar (HU)", "hu_HU", new Locale("hu", "HU"), new Boolean(false), "yyyy.MM.dd", MediaSize.ISO.A4), new Language("Nederlands", "nl_NL", new Locale("nl", "NL"), new Boolean(false), "dd-MM-yyyy", MediaSize.ISO.A4), new Language("Norsk", "no_NO", new Locale("no", "NO"), new Boolean(false), "dd/MM/yyyy", MediaSize.ISO.A4), new Language("Polski", "pl_PL", new Locale("pl", "PL"), new Boolean(false), "dd-MM-yyyy", MediaSize.ISO.A4), new Language("Portuguese (BR)", "pt_BR", new Locale("pt", "BR"), new Boolean(false), "dd/MM/yyyy", MediaSize.ISO.A4), new Language("Rom\u00e2n\u0103", "ro_RO", new Locale("ro", "RO"), new Boolean(false), "dd.MM.yyyy", MediaSize.ISO.A4), new Language("\u0420\u0443\u0441\u0441\u043a\u0438\u0439 (Russian)", "ru_RU", new Locale("ru", "RU"), new Boolean(false), "dd-MM-yyyy", MediaSize.ISO.A4), new Language("Slovenski", "sl_SI", new Locale("sl", "SI"), null, "dd.MM.yyyy", MediaSize.ISO.A4), new Language("\u0421\u0440\u043f\u0441\u043a\u0438 (RS)", "sr_RS", new Locale("sr", "RS"), null, "dd.MM.yyyy", MediaSize.ISO.A4), new Language("Svenska", "sv_SE", new Locale("sv", "SE"), new Boolean(false), "yyyy-MM-dd", MediaSize.ISO.A4), new Language("\u0e44\u0e17\u0e22 (TH)", "th_TH", new Locale("th", "TH"), new Boolean(false), "dd/MM/yyyy", MediaSize.ISO.A4), new Language("Vi\u1ec7t Nam", "vi_VN", new Locale("vi", "VN"), new Boolean(false), "dd-MM-yyyy", MediaSize.ISO.A4), new Language("\u7b80\u4f53\u4e2d\u6587 (CN)", "zh_CN", Locale.CHINA, null, "yyyy-MM-dd", MediaSize.ISO.A4), new Language("\u7e41\u9ad4\u4e2d\u6587 (TW)", "zh_TW", Locale.TAIWAN, null, null, MediaSize.ISO.A4)};
    private static Language s_loginLanguage = s_languages[0];
    private static Logger log = Logger.getLogger(Language.class.getName());
    private String m_name;
    private String m_AD_Language;
    private Locale m_locale;
    private Boolean m_decimalPoint;
    private Boolean m_leftToRight;
    private SimpleDateFormat m_dateFormat;
    private MediaSize m_mediaSize = MediaSize.ISO.A4;

    public static int getLanguageCount() {
        return s_languages.length;
    }

    public static Language getLanguage(int index) {
        if (index < 0 || index >= s_languages.length) {
            return s_loginLanguage;
        }
        return s_languages[index];
    }

    public static void addLanguage(Language language) {
        if (language == null) {
            return;
        }
        ArrayList<Language> list = new ArrayList<Language>(Arrays.asList(s_languages));
        list.add(language);
        s_languages = new Language[list.size()];
        list.toArray(s_languages);
    }

    public static Language getLanguage(String langInfo) {
        String lang = langInfo;
        if (lang == null || lang.length() == 0) {
            lang = System.getProperty("user.language", "");
        }
        for (int i2 = 0; i2 < s_languages.length; ++i2) {
            if (!lang.equals(s_languages[i2].getName()) && !lang.equals(s_languages[i2].getLanguageCode()) && !lang.equals(s_languages[i2].getAD_Language())) continue;
            return s_languages[i2];
        }
        if (lang.length() == 5) {
            String language = lang.substring(0, 2);
            String country = lang.substring(3);
            Locale locale = new Locale(language, country);
            log.info("Adding Language=" + language + ", Country=" + country + ", Locale=" + locale);
            Language ll = new Language(lang, lang, locale);
            ArrayList<Language> list = new ArrayList<Language>(Arrays.asList(s_languages));
            list.add(ll);
            s_languages = new Language[list.size()];
            list.toArray(s_languages);
            return ll;
        }
        return s_loginLanguage;
    }

    public static boolean isBaseLanguage(String langInfo) {
        return langInfo == null || langInfo.length() == 0 || langInfo.equals(s_languages[0].getName()) || langInfo.equals(s_languages[0].getLanguageCode()) || langInfo.equals(s_languages[0].getAD_Language());
    }

    public static Language getBaseLanguage() {
        return s_languages[0];
    }

    public static String getBaseAD_Language() {
        return s_languages[0].getAD_Language();
    }

    public static Locale getLocale(String langInfo) {
        return Language.getLanguage(langInfo).getLocale();
    }

    public static String getAD_Language(String langInfo) {
        return Language.getLanguage(langInfo).getAD_Language();
    }

    public static String getAD_Language(Locale locale) {
        if (locale != null) {
            for (int i2 = 0; i2 < s_languages.length; ++i2) {
                if (!locale.getLanguage().equals(s_languages[i2].getLocale().getLanguage())) continue;
                return s_languages[i2].getAD_Language();
            }
        }
        return s_loginLanguage.getAD_Language();
    }

    public static String getName(String langInfo) {
        return Language.getLanguage(langInfo).getName();
    }

    public static boolean isDecimalPoint(String langInfo) {
        return Language.getLanguage(langInfo).isDecimalPoint();
    }

    public static String[] getNames() {
        String[] retValue = new String[s_languages.length];
        for (int i2 = 0; i2 < s_languages.length; ++i2) {
            retValue[i2] = s_languages[i2].getName();
        }
        return retValue;
    }

    public static Language getLoginLanguage() {
        return s_loginLanguage;
    }

    public static void setLoginLanguage(Language language) {
        if (language != null) {
            s_loginLanguage = language;
            log.config(s_loginLanguage.toString());
        }
    }

    public Language(String name, String AD_Language, Locale locale, Boolean decimalPoint, String javaDatePattern, MediaSize mediaSize) {
        if (name == null || AD_Language == null || locale == null) {
            throw new IllegalArgumentException("Language - parameter is null");
        }
        this.m_name = name;
        this.m_AD_Language = AD_Language;
        this.m_locale = locale;
        this.m_decimalPoint = decimalPoint;
        this.setDateFormat(javaDatePattern);
        this.setMediaSize(mediaSize);
    }

    public Language(String name, String AD_Language, Locale locale) {
        this(name, AD_Language, locale, null, null, null);
    }

    public String getName() {
        return this.m_name;
    }

    public String getAD_Language() {
        return this.m_AD_Language;
    }

    public void setAD_Language(String AD_Language) {
        if (AD_Language != null) {
            this.m_AD_Language = AD_Language;
            log.config(this.toString());
        }
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        this.m_locale = locale;
        this.m_decimalPoint = null;
    }

    public String getLanguageCode() {
        return this.m_locale.getLanguage();
    }

    public boolean isLeftToRight() {
        if (this.m_leftToRight == null) {
            this.m_leftToRight = new Boolean(ComponentOrientation.getOrientation(this.m_locale).isLeftToRight());
        }
        return this.m_leftToRight;
    }

    public boolean isDecimalPoint() {
        if (this.m_decimalPoint == null) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols(this.m_locale);
            this.m_decimalPoint = new Boolean(dfs.getDecimalSeparator() == '.');
        }
        return this.m_decimalPoint;
    }

    public boolean isBaseLanguage() {
        return this.equals(Language.getBaseLanguage());
    }

    public void setDateFormat(String javaDatePattern) {
        if (javaDatePattern == null) {
            return;
        }
        this.m_dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, this.m_locale);
        try {
            this.m_dateFormat.applyPattern(javaDatePattern);
        }
        catch (Exception e) {
            log.severe(javaDatePattern + " - " + e);
            this.m_dateFormat = null;
        }
    }

    public SimpleDateFormat getDateFormat() {
        if (this.m_dateFormat == null) {
            this.m_dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, this.m_locale);
            String sFormat = this.m_dateFormat.toPattern();
            if (sFormat.indexOf("MM") == -1 || sFormat.indexOf("dd") == -1) {
                sFormat = sFormat.replaceFirst("d+", "dd");
                sFormat = sFormat.replaceFirst("M+", "MM");
                this.m_dateFormat.applyPattern(sFormat);
            }
            if (this.m_dateFormat.toPattern().length() != 8) {
                this.m_dateFormat.applyPattern("yyyy-MM-dd");
            }
            if (this.m_dateFormat.toPattern().indexOf("yyyy") == -1) {
                sFormat = this.m_dateFormat.toPattern();
                String nFormat = "";
                for (int i2 = 0; i2 < sFormat.length(); ++i2) {
                    nFormat = sFormat.charAt(i2) == 'y' ? nFormat + "yy" : nFormat + sFormat.charAt(i2);
                }
                this.m_dateFormat.applyPattern(nFormat);
            }
            this.m_dateFormat.setLenient(true);
        }
        return this.m_dateFormat;
    }

    public SimpleDateFormat getDateTimeFormat() {
        SimpleDateFormat retValue = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 1, this.m_locale);
        return retValue;
    }

    public SimpleDateFormat getTimeFormat() {
        return (SimpleDateFormat)DateFormat.getTimeInstance(1, this.m_locale);
    }

    public String getDBdatePattern() {
        return this.getDateFormat().toPattern().toUpperCase(this.m_locale);
    }

    public MediaSize getMediaSize() {
        return this.m_mediaSize;
    }

    public void setMediaSize(MediaSize size) {
        if (size != null) {
            this.m_mediaSize = size;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Language=[");
        sb.append(this.m_name).append(",Locale=").append(this.m_locale.toString()).append(",AD_Language=").append(this.m_AD_Language).append(",DatePattern=").append(this.getDBdatePattern()).append(",DecimalPoint=").append(this.isDecimalPoint()).append("]");
        return sb.toString();
    }

    public int hashCode() {
        return this.m_AD_Language.hashCode();
    }

    public boolean equals(Object obj) {
        Language cmp;
        return obj instanceof Language && (cmp = (Language)obj).getAD_Language().equals(this.m_AD_Language);
    }

    public static void main(String[] args) {
        System.out.println(Locale.TRADITIONAL_CHINESE);
        System.out.println(Locale.TAIWAN);
        System.out.println(Locale.SIMPLIFIED_CHINESE);
        System.out.println(Locale.CHINESE);
        System.out.println(Locale.PRC);
    }
}

