/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CLogMgtLog4J {
    private static Level s_currentLevelLog4J = Level.INFO;

    protected static void initialize(boolean isClient) {
        if (isClient) {
            LogManager.resetConfiguration();
            Logger rootLogger = LogManager.getRootLogger();
            BasicConfigurator.configure();
            rootLogger.setLevel(s_currentLevelLog4J);
        } else {
            CLogMgtLog4J.setLevel(s_currentLevelLog4J);
        }
    }

    public static void enable(boolean enableLogging) {
        Logger rootLogger = LogManager.getRootLogger();
        if (enableLogging) {
            rootLogger.setLevel(s_currentLevelLog4J);
        } else {
            Level level = rootLogger.getLevel();
            rootLogger.setLevel(Level.OFF);
            s_currentLevelLog4J = level;
        }
    }

    public static void setLevel(String slevel) {
        if (slevel.equalsIgnoreCase("OFF")) {
            CLogMgtLog4J.setLevel(Level.OFF);
        } else if (slevel.equalsIgnoreCase("SEVERE")) {
            CLogMgtLog4J.setLevel(Level.ERROR);
        } else if (slevel.equalsIgnoreCase("WARNING")) {
            CLogMgtLog4J.setLevel(Level.WARN);
        } else if (slevel.equalsIgnoreCase("INFO") || slevel.equalsIgnoreCase("CONFIG")) {
            CLogMgtLog4J.setLevel(Level.INFO);
        } else if (slevel.equalsIgnoreCase("FINE") || slevel.equalsIgnoreCase("FINER")) {
            CLogMgtLog4J.setLevel(Level.DEBUG);
        } else if (slevel.equalsIgnoreCase("FINEST")) {
            CLogMgtLog4J.setLevel(Level.TRACE);
        } else if (slevel.equalsIgnoreCase("ALL")) {
            CLogMgtLog4J.setLevel(Level.ALL);
        } else {
            CLogMgtLog4J.setLevel(Level.toLevel((String)slevel));
        }
    }

    public static void setLevel(Level level) {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(level);
        s_currentLevelLog4J = level;
    }
}

