/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import javax.activation.DataSource;
import org.compiere.util.CLogger;

public class ByteArrayDataSource
implements DataSource {
    private byte[] m_data = null;
    private String m_type = "text/plain";
    private String m_name = null;
    private static CLogger log = CLogger.getCLogger(ByteArrayDataSource.class);

    public ByteArrayDataSource(InputStream is, String type) {
        try {
            int ch;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            this.m_data = os.toByteArray();
        }
        catch (IOException ioex) {
            log.log(Level.WARNING, "", ioex);
        }
        if (type != null && type.length() > 0) {
            this.m_type = type;
        }
    }

    public ByteArrayDataSource(byte[] data, String type) {
        this.m_data = data;
        if (type != null && type.length() > 0) {
            this.m_type = type;
        }
    }

    public ByteArrayDataSource(String stringData, String charSetName, String type) {
        if (charSetName == null || charSetName.length() == 0) {
            charSetName = "UTF-8";
        }
        try {
            this.m_data = stringData.getBytes(charSetName);
        }
        catch (UnsupportedEncodingException uex) {
            log.log(Level.WARNING, "CharSetName=" + charSetName, uex);
        }
        if (type != null && type.length() > 0) {
            this.m_type = type;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.m_data == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.m_data);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("cannot do this");
    }

    @Override
    public String getContentType() {
        return this.m_type;
    }

    public ByteArrayDataSource setName(String name) {
        this.m_name = name;
        return this;
    }

    @Override
    public String getName() {
        if (this.m_name != null) {
            return this.m_name;
        }
        return "ByteArrayDataStream " + this.m_type;
    }
}

