/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_PL
implements AmtInWords {
    private static final String[][] majorNames = new String[][]{{"", "", ""}, {"tysi\u00c4\u2026c", "tysi\u00c4\u2026ce", "tysi\u00c4\u2122cy"}, {"milion", "miliony", "milion\u00c3\u00b3w"}, {"miliard", "miliardy", "miliard\u00c3\u00b3w"}, {"bilion", "biliony", "bilion\u00c3\u00b3w"}, {"trylion", "tryliony", "trylion\u00c3\u00b3w"}, {"quadrylion", "quadryliony", "quadrylion\u00c3\u00b3w"}};
    private static final String[] tensNames = new String[]{"", "dziesi\u00c4\u2122\u00c4\u2021", "dwadzie\u00c5\u203acia", "trzydzie\u00c5\u203aci", "czterdzie\u00c5\u203aci", "pi\u00c4\u2122\u00c4\u2021dziesi\u00c4\u2026t", "sze\u00c5\u203a\u00c4\u2021dziesi\u00c4\u2026t", "siedemdziesi\u00c4\u2026t", "osiemdziesi\u00c4\u2026t", "dziewi\u00c4\u2122\u00c4\u2021dziesi\u00c4\u2026t"};
    private static final String[] hundredNames = new String[]{"", "sto", "dwie\u00c5\u203acie", "trzysta", "czterysta", "pi\u00c4\u2122\u00c4\u2021set", "sze\u00c5\u203a\u00c4\u2021set", "siedemset", "osiemset", "dziewi\u00c4\u2122\u00c4\u2021set"};
    private static final String[] numNames = new String[]{"", "jeden", "dwa", "trzy", "cztery", "pi\u00c4\u2122\u00c4\u2021", "sze\u00c5\u203a\u00c4\u2021", "siedem", "osiem", "dzieiwi\u00c4\u2122\u00c4\u2021", "dziesi\u00c4\u2122\u00c4\u2021", "jedena\u00c5\u203acie", "dwana\u00c5\u203acie", "trzyna\u00c5\u203acie", "czterna\u00c5\u203acie", "pietna\u00c5\u203acie", "szescna\u00c5\u203acie", "siedemna\u00c5\u203acie", "osiemna\u00c5\u203acie", "dziewi\u00c4\u2122tna\u00c5\u203acie"};

    private String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            soFar = tensNames[(number /= 10) % 10] + " " + soFar;
            number /= 10;
        }
        soFar = hundredNames[number % 10] + " " + soFar;
        number /= 10;
        return soFar;
    }

    private String convert(long number) {
        if (number == 0L) {
            return "zero";
        }
        String prefix = "";
        if (number < 0L) {
            number = -number;
            prefix = "minus ";
        }
        String soFar = "";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = this.convertLessThanOneThousand((int)n);
                int pos = number % 10L == 1L ? 0 : (number % 10L < 5L ? 1 : 2);
                if (number > 9L && number < 20L) {
                    pos = 2;
                }
                soFar = s + " " + majorNames[place][pos] + " " + soFar;
            }
            ++place;
        } while ((number /= 1000L) > 0L);
        return (prefix + soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        amount = amount.replaceAll(",", "");
        int newpos = amount.lastIndexOf(46);
        long dollars = Long.parseLong(amount.substring(0, newpos));
        sb.append(this.convert(dollars));
        for (int i2 = 0; i2 < oldamt.length(); ++i2) {
            if (pos != i2) continue;
            String cents = oldamt.substring(i2 + 1);
            sb.append(' ').append(cents).append("/100");
            break;
        }
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_PL aiw = new AmtInWords_PL();
        aiw.print("0.23");
        aiw.print("1.23");
        aiw.print("12.345");
        aiw.print("123.45");
        aiw.print("1234.56");
        aiw.print("12345.78");
        aiw.print("10345.78");
        aiw.print("123457.89");
        aiw.print("323457.89");
        aiw.print("23457.89");
        aiw.print("1,234,578.90");
    }
}

