/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_FA
implements AmtInWords {
    private static final String[] majorNames = new String[]{"", "\u00d9\u2021\u00d8\u00b2\u00d8\u00a7\u00d8\u00b1", "\u00d9\u2026\u00d9\u0160\u00d9\u201e\u00d9\u0160\u00d9\u02c6\u00d9\u2020", "\u00d9\u2026\u00d9\u0160\u00d9\u201e\u00d9\u0160\u00d8\u00a7\u00d8\u00b1\u00d8\u00af", "\u00d8\u00aa\u00d8\u00b1\u00d9\u0160\u00d9\u201e\u00d9\u0160\u00d9\u02c6\u00d9\u2020", "\u00da\u00a9\u00d9\u02c6\u00d8\u00a2\u00d8\u00af\u00d8\u00b1\u00d9\u0160\u00d9\u201e\u00d9\u0160\u00d9\u02c6\u00d9\u2020", "\u00d9\u2021\u00d8\u00b2\u00d8\u00a7\u00d8\u00b1 \u00da\u00a9\u00d9\u02c6\u00d8\u00a2\u00d8\u00af\u00d8\u00b1\u00d9\u0160\u00d9\u201e\u00d9\u0160\u00d9\u02c6\u00d9\u2020"};
    private static final String[] hundredsNames = new String[]{"", "\u00d9\u0160\u00da\u00a9\u00d8\u00b5\u00d8\u00af", "\u00d8\u00af\u00d9\u02c6\u00d9\u0160\u00d8\u00b3\u00d8\u00aa", "\u00d8\u00b3\u00d9\u0160\u00d8\u00b5\u00d8\u00af", "\u00da\u2020\u00d9\u2021\u00d8\u00a7\u00d8\u00b1\u00d8\u00b5\u00d8\u00af", "\u00d9\u00be\u00d8\u00a7\u00d9\u2020\u00d8\u00b5\u00d8\u00af", "\u00d8\u00b4\u00d8\u00b4\u00d8\u00b5\u00d8\u00af", "\u00d9\u2021\u00d9\ufffd\u00d8\u00aa\u00d8\u00b5\u00d8\u00af", "\u00d9\u2021\u00d8\u00b4\u00d8\u00aa\u00d8\u00b5\u00d8\u00af", "\u00d9\u2020\u00d9\u2021\u00d8\u00b5\u00d8\u00af"};
    private static final String[] tensNames = new String[]{"", "\u00d8\u00af\u00d9\u2021", "\u00d8\u00a8\u00d9\u0160\u00d8\u00b3\u00d8\u00aa", "\u00d8\u00b3\u00d9\u0160", "\u00da\u2020\u00d9\u2021\u00d9\u201e", "\u00d9\u00be\u00d9\u2020\u00d8\u00ac\u00d8\u00a7\u00d9\u2021", "\u00d8\u00b4\u00d8\u00b5\u00d8\u00aa", "\u00d9\u2021\u00d9\ufffd\u00d8\u00aa\u00d8\u00a7\u00d8\u00af", "\u00d9\u2021\u00d8\u00b4\u00d8\u00aa\u00d8\u00a7\u00d8\u00af", "\u00d9\u2020\u00d9\u02c6\u00d8\u00af"};
    private static final String[] numNames = new String[]{"", "\u00d9\u0160\u00da\u00a9", "\u00d8\u00af\u00d9\u02c6", "\u00d8\u00b3\u00d9\u2021", "\u00da\u2020\u00d9\u2021\u00d8\u00a7\u00d8\u00b1", "\u00d9\u00be\u00d9\u2020\u00d8\u00ac", "\u00d8\u00b4\u00d8\u00b4", "\u00d9\u2021\u00d9\ufffd\u00d8\u00aa", "\u00d9\u2021\u00d8\u00b4\u00d8\u00aa", "\u00d9\u2020\u00d9\u2021", "\u00d8\u00af\u00d9\u2021", "\u00d9\u0160\u00d8\u00a7\u00d8\u00b2\u00d8\u00af\u00d9\u2021", "\u00d8\u00af\u00d9\u02c6\u00d8\u00a7\u00d8\u00b2\u00d8\u00af\u00d9\u2021", "\u00d8\u00b3\u00d9\u0160\u00d8\u00b2\u00d8\u00af\u00d9\u2021", "\u00da\u2020\u00d9\u2021\u00d8\u00a7\u00d8\u00b1\u00d8\u00af\u00d9\u2021", "\u00d9\u00be\u00d8\u00a7\u00d9\u2020\u00d8\u00b2\u00d8\u00af\u00d9\u2021", "\u00d8\u00b4\u00d8\u00a7\u00d9\u2020\u00d8\u00b2\u00d8\u00af\u00d9\u2021", "\u00d9\u2021\u00d9\ufffd\u00d8\u00af\u00d9\u2021", "\u00d9\u2021\u00d8\u00ac\u00d8\u00af\u00d9\u2021", "\u00d9\u2020\u00d9\u02c6\u00d8\u00b2\u00d8\u00af\u00d9\u2021"};

    private String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            soFar = hundredsNames[number /= 100] + ("".equals(soFar) || hundredsNames[number].equals("") ? soFar : " \u00d9\u02c6 " + soFar);
        } else {
            soFar = numNames[number % 10];
            soFar = tensNames[(number /= 10) % 10] + (tensNames[number % 10].equals("") ? soFar : " \u00d9\u02c6 " + soFar);
            soFar = hundredsNames[(number /= 10) % 10] + (hundredsNames[number % 10].equals("") ? soFar : " \u00d9\u02c6 " + soFar);
        }
        return soFar;
    }

    private String convert(long number) {
        if (number == 0L) {
            return "\u00d8\u00b5\u00d9\ufffd\u00d8\u00b1";
        }
        String prefix = "";
        if (number < 0L) {
            number = -number;
            prefix = "\u00d9\u2026\u00d9\u2020\u00d9\ufffd\u00d9\u0160 ";
        }
        String soFar = "";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = this.convertLessThanOneThousand((int)n);
                soFar = !soFar.equals("") ? s + " " + majorNames[place] + (s.equals("") || majorNames[place].equals("") ? soFar : " \u00d9\u02c6 " + soFar) : s + " " + majorNames[place];
            }
            ++place;
        } while ((number /= 1000L) > 0L);
        return (prefix + soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuffer sb = new StringBuffer();
        int pos = amount.lastIndexOf(46);
        int pos2 = amount.lastIndexOf(44);
        if (pos2 > pos) {
            pos = pos2;
        }
        String oldamt = amount;
        amount = amount.replaceAll(",", "");
        int newpos = amount.lastIndexOf(46);
        long dollars = Long.parseLong(amount.substring(0, newpos));
        sb.append(this.convert(dollars));
        for (int i2 = 0; i2 < oldamt.length(); ++i2) {
            if (pos != i2) continue;
            String cents = oldamt.substring(i2 + 1);
            sb.append(' ').append(cents).append("/100");
            break;
        }
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(amt + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_FA aiw = new AmtInWords_FA();
        aiw.print("0.23");
        aiw.print("1.23");
        aiw.print("12.345");
        aiw.print("123.45");
        aiw.print("103.00");
        aiw.print("100.00");
        aiw.print("523.45");
        aiw.print("1000.00");
        aiw.print("1234.56");
        aiw.print("12345.78");
        aiw.print("123457.89");
        aiw.print("1,234,578.90");
    }
}

