/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.im.InputMethodRequests;
import javax.swing.InputVerifier;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.StyledDocument;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.swing.CEditor;

public class CTextPane
extends JScrollPane
implements CEditor {
    private static final long serialVersionUID = -6702310899755509377L;
    private JTextPane m_textPane = null;
    private boolean m_mandatory = false;

    public CTextPane() {
        this(new JTextPane());
    }

    public CTextPane(StyledDocument doc) {
        this(new JTextPane(doc));
    }

    public CTextPane(JTextPane textPane) {
        super(textPane);
        this.m_textPane = textPane;
        super.setOpaque(false);
        super.getViewport().setOpaque(false);
        this.m_textPane.setContentType("text/html");
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setReadWrite(boolean rw) {
        if (this.m_textPane.isEditable() != rw) {
            this.m_textPane.setEditable(rw);
        }
        this.setBackground(false);
    }

    @Override
    public boolean isReadWrite() {
        return this.m_textPane.isEditable();
    }

    @Override
    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(AdempierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        } else if (this.m_mandatory) {
            this.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        }
    }

    @Override
    public void setBackground(Color color) {
        if (color.equals(this.getBackground())) {
            return;
        }
        if (this.m_textPane == null) {
            super.setBackground(color);
        } else {
            this.m_textPane.setBackground(color);
        }
    }

    @Override
    public Color getBackground() {
        if (this.m_textPane == null) {
            return super.getBackground();
        }
        return this.m_textPane.getBackground();
    }

    @Override
    public void setForeground(Color color) {
        if (this.m_textPane == null) {
            super.setForeground(color);
        } else {
            this.m_textPane.setForeground(color);
        }
    }

    @Override
    public Color getForeground() {
        if (this.m_textPane == null) {
            return super.getForeground();
        }
        return this.m_textPane.getForeground();
    }

    public void setContentType(String type) {
        if (this.m_textPane != null) {
            this.m_textPane.setContentType(type);
        }
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.m_textPane.setText("");
        } else {
            this.m_textPane.setText(value.toString());
        }
    }

    @Override
    public Object getValue() {
        return this.m_textPane.getText();
    }

    @Override
    public String getDisplay() {
        return this.m_textPane.getText();
    }

    public void setText(String text) {
        this.m_textPane.setText(text);
        this.m_textPane.setCaretPosition(0);
    }

    public String getText() {
        return this.m_textPane.getText();
    }

    public void setCaretPosition(int pos) {
        this.m_textPane.setCaretPosition(pos);
    }

    public int getCaretPosition() {
        return this.m_textPane.getCaretPosition();
    }

    public void setEditable(boolean edit) {
        this.m_textPane.setEditable(edit);
    }

    public boolean isEditable() {
        return this.m_textPane.isEditable();
    }

    public void setMargin(Insets m) {
        if (this.m_textPane != null) {
            this.m_textPane.setMargin(m);
        }
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        if (this.m_textPane == null) {
            super.setOpaque(isOpaque);
        } else {
            this.m_textPane.setOpaque(isOpaque);
        }
    }

    @Override
    public void addFocusListener(FocusListener l) {
        if (this.m_textPane == null) {
            super.addFocusListener(l);
        } else {
            this.m_textPane.addFocusListener(l);
        }
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.m_textPane.addMouseListener(l);
    }

    @Override
    public void addKeyListener(KeyListener l) {
        this.m_textPane.addKeyListener(l);
    }

    @Override
    public void addInputMethodListener(InputMethodListener l) {
        this.m_textPane.addInputMethodListener(l);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.m_textPane.getInputMethodRequests();
    }

    @Override
    public void setInputVerifier(InputVerifier l) {
        this.m_textPane.setInputVerifier(l);
    }
}

