/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.swing.CEditor;

public class CTextField
extends JTextField
implements CEditor,
KeyListener {
    private static final long serialVersionUID = 460529728891168659L;
    private boolean m_mandatory = false;

    public CTextField() {
        this.init();
    }

    public CTextField(String text) {
        super(text);
        this.init();
    }

    public CTextField(int columns) {
        super(columns);
        this.init();
    }

    public CTextField(String text, int columns) {
        super(text, columns);
        this.init();
    }

    public CTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.init();
    }

    private void init() {
        this.setBackground(false);
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setReadWrite(boolean rw) {
        if (super.isEditable() != rw) {
            super.setEditable(rw);
        }
        this.setBackground(false);
    }

    @Override
    public boolean isReadWrite() {
        return super.isEditable();
    }

    @Override
    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(AdempierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        } else if (this.m_mandatory) {
            this.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
    }

    @Override
    public Object getValue() {
        return this.getText();
    }

    @Override
    public String getDisplay() {
        return this.getText();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

