/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import javax.swing.JPasswordField;
import javax.swing.text.Document;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.swing.CEditor;

public class CPassword
extends JPasswordField
implements CEditor {
    private static final long serialVersionUID = 6516269177469866775L;
    private boolean m_mandatory = false;

    public CPassword() {
        this.init();
    }

    public CPassword(String text) {
        super(text);
        this.init();
    }

    public CPassword(int columns) {
        super(columns);
        this.init();
    }

    public CPassword(String text, int columns) {
        super(text, columns);
        this.init();
    }

    public CPassword(Document doc, String txt, int columns) {
        super(doc, txt, columns);
        this.init();
    }

    private void init() {
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setReadWrite(boolean rw) {
        if (super.isEditable() != rw) {
            super.setEditable(rw);
        }
        this.setBackground(false);
    }

    @Override
    public boolean isReadWrite() {
        return super.isEditable();
    }

    @Override
    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(AdempierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite()) {
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        } else if (this.m_mandatory) {
            this.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
    }

    @Override
    public Object getValue() {
        return new String(super.getPassword());
    }

    @Override
    public String getDisplay() {
        return new String(super.getPassword());
    }
}

