/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;

public class CLabel
extends JLabel {
    private static final long serialVersionUID = 3836688834452881595L;
    public static int DEFAULT_ALIGNMENT = 11;
    private char m_savedMnemonic = '\u0000';

    public CLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.init();
    }

    public CLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.init();
    }

    public CLabel(String text) {
        super(text, DEFAULT_ALIGNMENT);
        this.init();
    }

    public CLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.init();
    }

    public CLabel(Icon image) {
        super(image, DEFAULT_ALIGNMENT);
        this.init();
    }

    public CLabel() {
        super("", DEFAULT_ALIGNMENT);
        this.init();
    }

    public CLabel(String label, String toolTip) {
        super(label, DEFAULT_ALIGNMENT);
        if (toolTip != null && toolTip.length() > 0) {
            super.setToolTipText(toolTip);
        }
        this.init();
    }

    public CLabel(String label, Component field) {
        this(label, 11);
        this.setLabelFor(field);
    }

    private void init() {
        this.setFocusable(false);
        this.setOpaque(false);
        if (this.getToolTipText() == null) {
            this.setToolTipText(this.getText());
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
    }

    public void setFontBold(boolean bold) {
        Font font = this.getFont();
        if (bold != font.isBold()) {
            font = new Font(font.getName(), bold ? 1 : 0, font.getSize());
            this.setFont(font);
        }
    }

    @Override
    public void setText(String mnemonicLabel) {
        String text = this.createMnemonic(mnemonicLabel);
        super.setText(text);
        if (text != null && this.getName() == null) {
            this.setName(text);
        }
        if (this.getLabelFor() != null && this.getLabelFor() instanceof JTextComponent) {
            if (this.m_savedMnemonic > '\u0000') {
                ((JTextComponent)this.getLabelFor()).setFocusAccelerator(this.m_savedMnemonic);
            } else {
                ((JTextComponent)this.getLabelFor()).setFocusAccelerator('\u0000');
            }
        }
    }

    private String createMnemonic(String text) {
        char ch;
        this.m_savedMnemonic = '\u0000';
        if (text == null) {
            return text;
        }
        int pos = text.indexOf(38);
        if (pos != -1 && (ch = text.charAt(pos + 1)) != ' ') {
            this.setDisplayedMnemonic(ch);
            this.setSavedMnemonic(ch);
            return text.substring(0, pos) + text.substring(pos + 1);
        }
        return text;
    }

    public void setReadWrite(boolean rw) {
        this.setEnabled(rw);
    }

    @Override
    public void setLabelFor(Component c) {
        if (this.getLabelFor() != null && this.getLabelFor() instanceof JTextComponent) {
            ((JTextComponent)this.getLabelFor()).setFocusAccelerator('\u0000');
        }
        super.setLabelFor(c);
        if (c.getName() == null) {
            c.setName(this.getName());
        }
        if (c instanceof JTextComponent && this.m_savedMnemonic > '\u0000') {
            ((JTextComponent)c).setFocusAccelerator(this.m_savedMnemonic);
        }
    }

    public char getSavedMnemonic() {
        return this.m_savedMnemonic;
    }

    public void setSavedMnemonic(char savedMnemonic) {
        this.m_savedMnemonic = savedMnemonic;
    }
}

