/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.sqlj;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import org.compiere.sqlj.Adempiere;
import org.compiere.sqlj.Currency;

public class PaymentTerm {
    public static final String SQL_PAYTERM = "SELECT * FROM C_PaymentTerm WHERE C_PaymentTerm_ID=?";

    public static int dueDays(int p_C_PaymentTerm_ID, Timestamp p_DocDate, Timestamp p_PayDate) throws SQLException {
        if (p_C_PaymentTerm_ID == 0 || p_DocDate == null) {
            return 0;
        }
        Timestamp PayDate = p_PayDate;
        if (PayDate == null) {
            PayDate = new Timestamp(System.currentTimeMillis());
        }
        PayDate = Adempiere.trunc(PayDate);
        Timestamp DueDate = null;
        String sql = SQL_PAYTERM;
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_C_PaymentTerm_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            boolean IsDueFixed = "Y".equals(rs.getString("IsDueFixed"));
            if (IsDueFixed) {
                int FixMonthDay = rs.getInt("FixMonthDay");
                int FixMonthOffset = rs.getInt("FixMonthOffset");
                int FixMonthCutoff = rs.getInt("FixMonthCutoff");
                boolean bLastDayMonth = "Y".equals(rs.getString("F3P_islastmonthday"));
                DueDate = PaymentTerm.calculateDateDue(p_DocDate, FixMonthDay, FixMonthOffset, FixMonthCutoff, bLastDayMonth);
            } else {
                int NetDays = rs.getInt("NetDays");
                DueDate = Adempiere.addDays(p_DocDate, NetDays);
            }
        }
        rs.close();
        pstmt.close();
        if (DueDate == null) {
            return 0;
        }
        return Adempiere.getDaysBetween(DueDate, PayDate);
    }

    public static int invoiceDueDays(int p_C_Invoice_ID, Timestamp p_PayDate) throws SQLException {
        if (p_C_Invoice_ID == 0) {
            return 0;
        }
        int retValue = 0;
        String sql = "SELECT C_PaymentTerm_ID, DateInvoiced FROM C_Invoice WHERE C_Invoice_ID=?";
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_C_Invoice_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            int C_PaymentTerm_ID = rs.getInt(1);
            Timestamp DocDate = rs.getTimestamp(2);
            retValue = PaymentTerm.dueDays(C_PaymentTerm_ID, DocDate, p_PayDate);
        }
        rs.close();
        pstmt.close();
        return retValue;
    }

    public static Timestamp dueDate(int p_C_PaymentTerm_ID, Timestamp p_DocDate) throws SQLException {
        PreparedStatement pstmt = Adempiere.prepareStatement(SQL_PAYTERM);
        return PaymentTerm.dueDate(p_C_PaymentTerm_ID, p_DocDate, pstmt);
    }

    public static Timestamp dueDate(int p_C_PaymentTerm_ID, Timestamp p_DocDate, PreparedStatement pstmt) throws SQLException {
        if (p_C_PaymentTerm_ID == 0 || p_DocDate == null) {
            return null;
        }
        Timestamp DueDate = Adempiere.trunc(p_DocDate);
        pstmt.setInt(1, p_C_PaymentTerm_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            boolean IsDueFixed = "Y".equals(rs.getString("IsDueFixed"));
            if (IsDueFixed) {
                int FixMonthDay = rs.getInt("FixMonthDay");
                int FixMonthOffset = rs.getInt("FixMonthOffset");
                int FixMonthCutoff = rs.getInt("FixMonthCutoff");
                boolean bLastDayMonth = "Y".equals(rs.getString("F3P_islastmonthday"));
                DueDate = PaymentTerm.calculateDateDue(p_DocDate, FixMonthDay, FixMonthOffset, FixMonthCutoff, bLastDayMonth);
            } else {
                int NetDays = rs.getInt("NetDays");
                if (NetDays != 0) {
                    DueDate = Adempiere.addDays(DueDate, NetDays);
                }
            }
        }
        rs.close();
        pstmt.close();
        return DueDate;
    }

    public static Timestamp invoiceDueDate(int p_C_Invoice_ID) throws SQLException {
        if (p_C_Invoice_ID == 0) {
            return null;
        }
        Timestamp DueDate = null;
        String sql = "SELECT C_PaymentTerm_ID, DateInvoiced FROM C_Invoice WHERE C_Invoice_ID=?";
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_C_Invoice_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            int C_PaymentTerm_ID = rs.getInt(1);
            Timestamp DocDate = rs.getTimestamp(2);
            DueDate = PaymentTerm.dueDate(C_PaymentTerm_ID, DocDate);
        }
        rs.close();
        pstmt.close();
        return DueDate;
    }

    private static Timestamp calculateDateDue(Timestamp DocDate, int FixMonthDay, int FixMonthOffset, int FixMonthCutoff, boolean bLastDayMonth) {
        int maxDayCut;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DocDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (bLastDayMonth) {
            cal.set(5, 1);
            cal.add(2, FixMonthOffset);
            maxDayCut = cal.getActualMaximum(5);
            cal.set(5, maxDayCut);
        } else {
            maxDayCut = cal.getActualMaximum(5);
            if (FixMonthCutoff > maxDayCut) {
                cal.set(5, maxDayCut);
            } else {
                cal.set(5, FixMonthCutoff);
            }
            if (DocDate.after(cal.getTime())) {
                ++FixMonthOffset;
            }
            cal.add(2, FixMonthOffset);
            int maxDay = cal.getActualMaximum(5);
            if (FixMonthDay > maxDay) {
                cal.set(5, maxDay);
            } else if (FixMonthDay >= 30 && maxDay > FixMonthDay) {
                cal.set(5, maxDay);
            } else {
                cal.set(5, FixMonthDay);
            }
        }
        Date temp = cal.getTime();
        return new Timestamp(temp.getTime());
    }

    public static BigDecimal discount(BigDecimal p_Amount, int p_C_Currency_ID, int p_C_PaymentTerm_ID, Timestamp p_DocDate, Timestamp p_PayDate) throws SQLException {
        if (p_Amount == null || p_C_PaymentTerm_ID == 0 || p_DocDate == null) {
            return null;
        }
        if (p_Amount.signum() == 0) {
            return Adempiere.ZERO;
        }
        Timestamp PayDate = p_PayDate;
        if (PayDate == null) {
            PayDate = new Timestamp(System.currentTimeMillis());
        }
        PayDate = Adempiere.trunc(PayDate);
        BigDecimal discount = null;
        String sql = SQL_PAYTERM;
        PreparedStatement pstmt = Adempiere.prepareStatement(sql);
        pstmt.setInt(1, p_C_PaymentTerm_ID);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            int DiscountDays = rs.getInt("DiscountDays");
            int DiscountDays2 = rs.getInt("DiscountDays2");
            int GraceDays = rs.getInt("GraceDays");
            boolean IsNextBusinessDay = "Y".equals(rs.getString("IsNextBusinessDay"));
            BigDecimal Discount = rs.getBigDecimal("Discount");
            BigDecimal Discount2 = rs.getBigDecimal("Discount2");
            Timestamp Discount1Date = Adempiere.addDays(p_DocDate, DiscountDays + GraceDays);
            Timestamp Discount2Date = Adempiere.addDays(p_DocDate, DiscountDays2 + GraceDays);
            if (IsNextBusinessDay) {
                Discount1Date = Adempiere.nextBusinessDay(Discount1Date);
                Discount2Date = Adempiere.nextBusinessDay(Discount2Date);
            }
            if ((discount = !PayDate.after(Discount1Date) ? p_Amount.multiply(Discount) : (!PayDate.after(Discount2Date) ? p_Amount.multiply(Discount2) : Adempiere.ZERO)).signum() != 0) {
                discount = discount.divide(Adempiere.HUNDRED, 6, 4);
                discount = Currency.round((BigDecimal)discount, (int)p_C_Currency_ID, (String)"N");
            }
        }
        rs.close();
        pstmt.close();
        return discount;
    }
}

