/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.sla;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MSLACriteria;
import org.compiere.model.MSLAGoal;
import org.compiere.model.MSLAMeasure;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.sla.SLACriteria;
import org.compiere.util.AdempiereUserError;

public class SLAMeasureProcess
extends SvrProcess {
    private int p_PA_SLA_Measure_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.p_PA_SLA_Measure_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("PA_SLA_Measure_ID=" + this.p_PA_SLA_Measure_ID);
        MSLAMeasure measure = new MSLAMeasure(this.getCtx(), this.p_PA_SLA_Measure_ID, this.get_TrxName());
        if (measure.get_ID() == 0) {
            throw new AdempiereUserError("@PA_SLA_Measure_ID@ " + this.p_PA_SLA_Measure_ID);
        }
        MSLAGoal goal = new MSLAGoal(this.getCtx(), measure.getPA_SLA_Goal_ID(), this.get_TrxName());
        if (goal.get_ID() == 0) {
            throw new AdempiereUserError("@PA_SLA_Goal_ID@ " + measure.getPA_SLA_Goal_ID());
        }
        MSLACriteria criteria = MSLACriteria.get(this.getCtx(), goal.getPA_SLA_Criteria_ID(), this.get_TrxName());
        if (criteria.get_ID() == 0) {
            throw new AdempiereUserError("@PA_SLA_Criteria_ID@ " + goal.getPA_SLA_Criteria_ID());
        }
        SLACriteria pgm = criteria.newInstance();
        goal.setMeasureActual(pgm.calculateMeasure(goal));
        goal.setDateLastRun(new Timestamp(System.currentTimeMillis()));
        goal.save();
        return "@MeasureActual@=" + goal.getMeasureActual();
    }
}

