/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.session;

import java.io.ObjectStreamClass;
import java.util.Properties;
import java.util.logging.Level;
import javax.annotation.PostConstruct;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.CreateException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.adempiere.util.ProcessUtil;
import org.compiere.Adempiere;
import org.compiere.acct.Doc;
import org.compiere.interfaces.ServerLocal;
import org.compiere.interfaces.ServerRemote;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MTask;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CacheMgt;
import org.compiere.util.EMail;
import org.compiere.util.Env;

@Stateless(mappedName="adempiere/Server", name="adempiereServer")
@Local(value={ServerLocal.class})
@Remote(value={ServerRemote.class})
@DeclareRoles(value={"adempiereUsers"})
@RolesAllowed(value={"adempiereUsers"})
public class ServerBean
implements ServerRemote,
ServerLocal {
    private static CLogger log = CLogger.getCLogger(ServerBean.class);
    private static int s_no = 0;
    private int m_no = 0;
    private int m_windowCount = 0;
    private int m_postCount = 0;
    private int m_processCount = 0;
    private int m_workflowCount = 0;
    private int m_paymentCount = 0;
    private int m_nextSeqCount = 0;
    private int m_stmt_rowSetCount = 0;
    private int m_stmt_updateCount = 0;
    private int m_cacheResetCount = 0;
    private int m_updateLOBCount = 0;

    @Override
    public String postImmediate(Properties ctx, int AD_Client_ID, int AD_Table_ID, int Record_ID, boolean force, String trxName) {
        log.info("[" + this.m_no + "] Table=" + AD_Table_ID + ", Record=" + Record_ID);
        ++this.m_postCount;
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(ctx, AD_Client_ID);
        return Doc.postImmediate(ass, AD_Table_ID, Record_ID, force, null);
    }

    @Override
    public ProcessInfo process(Properties ctx, ProcessInfo pi) {
        ++this.m_processCount;
        ProcessUtil.startJavaProcess(ctx, pi, null);
        return pi;
    }

    @Override
    public ProcessInfo workflow(Properties ctx, ProcessInfo pi, int AD_Workflow_ID) {
        log.info("[" + this.m_no + "] " + AD_Workflow_ID);
        ++this.m_workflowCount;
        ProcessUtil.startWorkFlow(ctx, pi, AD_Workflow_ID);
        return pi;
    }

    @Override
    public EMail createEMail(Properties ctx, int AD_Client_ID, String to, String subject, String message) {
        MClient client = MClient.get(ctx, AD_Client_ID);
        boolean html = false;
        if (message != null && message.startsWith("ContentType=text/html;")) {
            html = true;
            message = message.substring("ContentType=text/html;".length());
        }
        return client.createEMail(to, subject, message, html);
    }

    @Override
    public EMail createEMail(Properties ctx, int AD_Client_ID, int AD_User_ID, String to, String subject, String message) {
        MClient client = MClient.get(ctx, AD_Client_ID);
        MUser from = new MUser(ctx, AD_User_ID, null);
        boolean html = false;
        if (message != null && message.startsWith("ContentType=text/html;")) {
            html = true;
            message = message.substring("ContentType=text/html;".length());
        }
        return client.createEMail(from, to, subject, message, html);
    }

    @Override
    public String sendEMail(EMail aMail) {
        return aMail.send();
    }

    @Override
    public String executeTask(int AD_Task_ID) {
        MTask task = new MTask(Env.getCtx(), AD_Task_ID, null);
        return task.execute();
    }

    @Override
    public int cacheReset(String tableName, int Record_ID) {
        log.config(String.valueOf(tableName) + " - " + Record_ID);
        ++this.m_cacheResetCount;
        return CacheMgt.get().reset(tableName, Record_ID);
    }

    @Override
    @PermitAll
    public String getStatus() {
        StringBuffer sb = new StringBuffer("ServerBean[");
        sb.append(this.m_no).append("-Window=").append(this.m_windowCount).append(",Post=").append(this.m_postCount).append(",Process=").append(this.m_processCount).append(",NextSeq=").append(this.m_nextSeqCount).append(",Workflow=").append(this.m_workflowCount).append(",Payment=").append(this.m_paymentCount).append(",RowSet=").append(this.m_stmt_rowSetCount).append(",Update=").append(this.m_stmt_updateCount).append(",CacheReset=").append(this.m_cacheResetCount).append(",UpdateLob=").append(this.m_updateLOBCount).append("]");
        return sb.toString();
    }

    @Override
    public ProcessInfo dbProcess(ProcessInfo processInfo, String procedureName) {
        ProcessUtil.startDatabaseProcedure(processInfo, procedureName, null);
        return processInfo;
    }

    public String toString() {
        return this.getStatus();
    }

    @PostConstruct
    public void ejbCreate() {
        this.m_no = ++s_no;
        try {
            if (!Adempiere.startup(false)) {
                throw new CreateException("Adempiere could not start");
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "ejbCreate", ex);
        }
        log.info("#" + this.getStatus());
    }

    protected static void dumpSVUID(Class<?> clazz) {
        String s = String.valueOf(clazz.getName()) + " ==\nstatic final long serialVersionUID = " + ObjectStreamClass.lookup(clazz).getSerialVersionUID() + "L;\n";
        System.out.println(s);
    }

    public static void main(String[] args) {
        ServerBean.dumpSVUID(ProcessInfo.class);
    }
}

