/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import com.f3p.adempiere.workreq.model.F3PMWFResponsible;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.MClient;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MUserRoles;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.server.AdempiereServer;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWFResponsible;
import org.compiere.wf.MWorkflowProcessor;
import org.compiere.wf.MWorkflowProcessorLog;

public class WorkflowProcessor
extends AdempiereServer {
    private MWorkflowProcessor m_model = null;
    private StringBuffer m_summary = new StringBuffer();
    private MClient m_client = null;

    public WorkflowProcessor(MWorkflowProcessor model) {
        super((AdempiereProcessor)model, 120);
        this.m_model = model;
        this.m_client = MClient.get(model.getCtx(), model.getAD_Client_ID());
    }

    protected void doWork() {
        this.m_summary = new StringBuffer();
        this.wakeup();
        this.dynamicPriority();
        this.sendAlerts();
        int no = this.m_model.deleteLog();
        this.m_summary.append("Logs deleted=").append(no);
        MWorkflowProcessorLog pLog = new MWorkflowProcessorLog(this.m_model, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed(new Timestamp(this.p_startWork)));
        pLog.save();
    }

    private void wakeup() {
        int count;
        block6: {
            String sql = "SELECT * FROM AD_WF_Activity a WHERE Processed='N' AND WFState='OS' AND EndWaitTime > SysDate AND AD_Client_ID=? AND EXISTS (SELECT * FROM AD_Workflow wf  INNER JOIN AD_WF_Node wfn ON (wf.AD_Workflow_ID=wfn.AD_Workflow_ID) WHERE a.AD_WF_Node_ID=wfn.AD_WF_Node_ID AND wfn.Action='Z' AND (wf.AD_WorkflowProcessor_ID IS NULL OR wf.AD_WorkflowProcessor_ID=?))";
            CPreparedStatement pstmt = null;
            count = 0;
            boolean countEMails = false;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.m_model.getAD_Client_ID());
                    pstmt.setInt(2, this.m_model.getAD_WorkflowProcessor_ID());
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MWFActivity activity = new MWFActivity(this.getCtx(), rs, null);
                        activity.setWFState("CC");
                        ++count;
                    }
                    rs.close();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "wakeup", e);
                    DB.close(pstmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(pstmt);
                throw throwable;
            }
            DB.close(pstmt);
        }
        this.m_summary.append("Wakeup #").append(count).append(" - ");
    }

    private void dynamicPriority() {
        int count;
        block7: {
            String sql = "SELECT * FROM AD_WF_Activity a WHERE Processed='N' AND WFState='OS' AND EXISTS (SELECT * FROM AD_Workflow wf INNER JOIN AD_WF_Node wfn ON (wf.AD_Workflow_ID=wfn.AD_Workflow_ID) WHERE a.AD_WF_Node_ID=wfn.AD_WF_Node_ID AND wf.AD_WorkflowProcessor_ID=? AND wfn.DynPriorityUnit IS NOT NULL AND wfn.DynPriorityChange IS NOT NULL)";
            CPreparedStatement pstmt = null;
            count = 0;
            boolean countEMails = false;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.m_model.getAD_WorkflowProcessor_ID());
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MWFActivity activity = new MWFActivity(this.getCtx(), rs, null);
                        if (activity.getDynPriorityStart() == 0) {
                            activity.setDynPriorityStart(activity.getPriority());
                        }
                        long ms = System.currentTimeMillis() - activity.getCreated().getTime();
                        MWFNode node = activity.getNode();
                        int prioDiff = node.calculateDynamicPriority((int)(ms / 1000L));
                        activity.setPriority(activity.getDynPriorityStart() + prioDiff);
                        activity.save();
                        ++count;
                    }
                    rs.close();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(pstmt);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(pstmt);
                throw throwable;
            }
            DB.close(pstmt);
        }
        this.m_summary.append("DynPriority #").append(count).append(" - ");
    }

    private void sendAlerts() {
        int countEMails;
        int count;
        CPreparedStatement pstmt;
        boolean escalate;
        MWFActivity activity;
        ResultSet rs;
        String sql;
        block26: {
            if (this.m_model.getAlertOverPriority() > 0) {
                int countEMails2;
                int count2;
                block24: {
                    sql = "SELECT * FROM AD_WF_Activity a WHERE Processed='N' AND WFState='OS' AND Priority >= ? AND (DateLastAlert IS NULL";
                    if (this.m_model.getRemindDays() > 0) {
                        sql = String.valueOf(sql) + " OR (DateLastAlert+" + this.m_model.getRemindDays() + ") < SysDate";
                    }
                    sql = String.valueOf(sql) + ") AND EXISTS (SELECT * FROM AD_Workflow wf  INNER JOIN AD_WF_Node wfn ON (wf.AD_Workflow_ID=wfn.AD_Workflow_ID) WHERE a.AD_WF_Node_ID=wfn.AD_WF_Node_ID AND (wf.AD_WorkflowProcessor_ID IS NULL OR wf.AD_WorkflowProcessor_ID=?))";
                    count2 = 0;
                    countEMails2 = 0;
                    CPreparedStatement pstmt2 = null;
                    try {
                        try {
                            pstmt2 = DB.prepareStatement(sql, null);
                            pstmt2.setInt(1, this.m_model.getAlertOverPriority());
                            pstmt2.setInt(2, this.m_model.getAD_WorkflowProcessor_ID());
                            rs = pstmt2.executeQuery();
                            while (rs.next()) {
                                activity = new MWFActivity(this.getCtx(), rs, null);
                                escalate = activity.getDateLastAlert() != null;
                                countEMails2 += this.sendEmail(activity, "ActivityOverPriority", escalate, true);
                                activity.setDateLastAlert(new Timestamp(System.currentTimeMillis()));
                                activity.save();
                                ++count2;
                            }
                            rs.close();
                            pstmt2.close();
                        }
                        catch (SQLException e) {
                            this.log.log(Level.SEVERE, "(Priority) - " + sql, e);
                            DB.close(pstmt2);
                            break block24;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(pstmt2);
                        throw throwable;
                    }
                    DB.close(pstmt2);
                }
                this.m_summary.append("OverPriority #").append(count2);
                if (countEMails2 > 0) {
                    this.m_summary.append(" (").append(countEMails2).append(" EMail)");
                }
                this.m_summary.append(" - ");
            }
            sql = "SELECT * FROM AD_WF_Activity a WHERE Processed='N' AND WFState='OS' AND EndWaitTime > SysDate AND (DateLastAlert IS NULL";
            if (this.m_model.getRemindDays() > 0) {
                sql = String.valueOf(sql) + " OR (DateLastAlert+" + this.m_model.getRemindDays() + ") < SysDate";
            }
            sql = String.valueOf(sql) + ") AND EXISTS (SELECT * FROM AD_Workflow wf  INNER JOIN AD_WF_Node wfn ON (wf.AD_Workflow_ID=wfn.AD_Workflow_ID) WHERE a.AD_WF_Node_ID=wfn.AD_WF_Node_ID AND wfn.Action<>'Z' AND (wf.AD_WorkflowProcessor_ID IS NULL OR wf.AD_WorkflowProcessor_ID=?))";
            pstmt = null;
            count = 0;
            countEMails = 0;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.m_model.getAD_WorkflowProcessor_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        activity = new MWFActivity(this.getCtx(), rs, null);
                        escalate = activity.getDateLastAlert() != null;
                        countEMails += this.sendEmail(activity, "ActivityEndWaitTime", escalate, false);
                        activity.setDateLastAlert(new Timestamp(System.currentTimeMillis()));
                        activity.save();
                        ++count;
                    }
                    rs.close();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "(EndWaitTime) - " + sql, e);
                    DB.close(pstmt);
                    break block26;
                }
            }
            catch (Throwable throwable) {
                DB.close(pstmt);
                throw throwable;
            }
            DB.close(pstmt);
        }
        this.m_summary.append("EndWaitTime #").append(count);
        if (countEMails > 0) {
            this.m_summary.append(" (").append(countEMails).append(" EMail)");
        }
        this.m_summary.append(" - ");
        if (this.m_model.getInactivityAlertDays() > 0) {
            block28: {
                sql = "SELECT * FROM AD_WF_Activity a WHERE Processed='N' AND WFState='OS' AND (Updated+" + this.m_model.getInactivityAlertDays() + ") < SysDate" + " AND (DateLastAlert IS NULL";
                if (this.m_model.getRemindDays() > 0) {
                    sql = String.valueOf(sql) + " OR (DateLastAlert+" + this.m_model.getRemindDays() + ") < SysDate";
                }
                sql = String.valueOf(sql) + ") AND EXISTS (SELECT * FROM AD_Workflow wf  INNER JOIN AD_WF_Node wfn ON (wf.AD_Workflow_ID=wfn.AD_Workflow_ID) WHERE a.AD_WF_Node_ID=wfn.AD_WF_Node_ID AND (wf.AD_WorkflowProcessor_ID IS NULL OR wf.AD_WorkflowProcessor_ID=?))";
                count = 0;
                countEMails = 0;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setInt(1, this.m_model.getAD_WorkflowProcessor_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            activity = new MWFActivity(this.getCtx(), rs, null);
                            escalate = activity.getDateLastAlert() != null;
                            countEMails += this.sendEmail(activity, "ActivityInactivity", escalate, false);
                            activity.setDateLastAlert(new Timestamp(System.currentTimeMillis()));
                            activity.save();
                            ++count;
                        }
                        rs.close();
                        pstmt.close();
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, "(Inactivity): " + sql, e);
                        DB.close(pstmt);
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(pstmt);
                    throw throwable;
                }
                DB.close(pstmt);
            }
            this.m_summary.append("Inactivity #").append(count);
            if (countEMails > 0) {
                this.m_summary.append(" (").append(countEMails).append(" EMail)");
            }
            this.m_summary.append(" - ");
        }
    }

    private int sendEmail(MWFActivity activity, String AD_Message, boolean toProcess, boolean toSupervisor) {
        if (this.m_client == null || this.m_client.getAD_Client_ID() != activity.getAD_Client_ID()) {
            this.m_client = MClient.get(this.getCtx(), activity.getAD_Client_ID());
        }
        MWFProcess process = new MWFProcess(this.getCtx(), activity.getAD_WF_Process_ID(), null);
        String subjectVar = activity.getNode().getName();
        String message = activity.getTextMsg();
        if (message == null || message.length() == 0) {
            message = process.getTextMsg();
        }
        File pdf = null;
        PO po = activity.getPO();
        if (po instanceof DocAction) {
            message = String.valueOf(((DocAction)((Object)po)).getDocumentInfo()) + "\n" + message;
            pdf = ((DocAction)((Object)po)).createPDF();
        }
        String subject = Msg.getMsg(this.m_client.getAD_Language(), AD_Message, new Object[]{subjectVar});
        ArrayList<Integer> list = new ArrayList<Integer>();
        int counter = 0;
        if (this.m_client.sendEMail(activity.getAD_User_ID(), subject, message, pdf)) {
            ++counter;
        }
        list.add(new Integer(activity.getAD_User_ID()));
        if (toProcess && process.getAD_User_ID() != activity.getAD_User_ID()) {
            if (this.m_client.sendEMail(process.getAD_User_ID(), subject, message, pdf)) {
                ++counter;
            }
            list.add(new Integer(process.getAD_User_ID()));
        }
        MWFResponsible responsible = MWFResponsible.get(this.getCtx(), activity.getAD_WF_Responsible_ID());
        counter += this.sendAlertToResponsible(responsible, list, process, activity, subject, message, pdf);
        if (toProcess && process.getAD_WF_Responsible_ID() != activity.getAD_WF_Responsible_ID()) {
            responsible = MWFResponsible.get(this.getCtx(), process.getAD_WF_Responsible_ID());
            counter += this.sendAlertToResponsible(responsible, list, process, null, subject, message, pdf);
        }
        if (toSupervisor && this.m_model.getSupervisor_ID() != 0 && !list.contains(new Integer(this.m_model.getSupervisor_ID()))) {
            if (this.m_client.sendEMail(this.m_model.getSupervisor_ID(), subject, message, pdf)) {
                ++counter;
            }
            list.add(new Integer(this.m_model.getSupervisor_ID()));
        }
        return counter;
    }

    private int sendAlertToResponsible(MWFResponsible responsible, ArrayList<Integer> list, MWFProcess process, MWFActivity activity, String subject, String message, File pdf) {
        int counter = 0;
        if (!responsible.isInvoker()) {
            if ("H".equals(responsible.getResponsibleType()) && responsible.getAD_User_ID() != 0 && !list.contains(new Integer(responsible.getAD_User_ID()))) {
                if (this.m_client.sendEMail(responsible.getAD_User_ID(), subject, message, pdf)) {
                    ++counter;
                }
                list.add(new Integer(responsible.getAD_User_ID()));
            } else if ("O".equals(responsible.getResponsibleType())) {
                MOrgInfo org;
                PO document = process.getPO();
                if (document != null && (org = MOrgInfo.get(this.getCtx(), document.getAD_Org_ID(), null)).getSupervisor_ID() != 0 && !list.contains(new Integer(org.getSupervisor_ID()))) {
                    if (this.m_client.sendEMail(org.getSupervisor_ID(), subject, message, pdf)) {
                        ++counter;
                    }
                    list.add(new Integer(org.getSupervisor_ID()));
                }
            } else if ("R".equals(responsible.getResponsibleType()) && responsible.getAD_Role_ID() != 0) {
                MUserRoles[] userRoles = MUserRoles.getOfRole(this.getCtx(), responsible.getAD_Role_ID());
                int i = 0;
                while (i < userRoles.length) {
                    int AD_User_ID;
                    MUserRoles roles = userRoles[i];
                    if (roles.isActive() && !list.contains(new Integer(AD_User_ID = roles.getAD_User_ID()))) {
                        if (this.m_client.sendEMail(AD_User_ID, subject, message, pdf)) {
                            ++counter;
                        }
                        list.add(new Integer(AD_User_ID));
                    }
                    ++i;
                }
            } else if (F3PMWFResponsible.isRule(responsible)) {
                int AD_User_ID = -1;
                AD_User_ID = activity != null ? activity.getAD_User_ID() : process.getAD_User_ID();
                if (AD_User_ID >= 0 && !list.contains(new Integer(AD_User_ID))) {
                    if (this.m_client.sendEMail(AD_User_ID, subject, message, pdf)) {
                        ++counter;
                    }
                    list.add(new Integer(AD_User_ID));
                }
            }
        }
        return counter;
    }

    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }
}

