/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MField;
import org.compiere.model.MTab;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;

public class TabCopy
extends SvrProcess {
    private int p_AD_TabTo_ID = 0;
    private int p_AD_TabFrom_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Tab_ID")) {
                this.p_AD_TabFrom_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_AD_TabTo_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("To AD_Tab_ID=" + this.p_AD_TabTo_ID + ", From=" + this.p_AD_TabFrom_ID);
        MTab from = new MTab(this.getCtx(), this.p_AD_TabFrom_ID, this.get_TrxName());
        if (from.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ (from->) @AD_Tab_ID@");
        }
        MTab to = new MTab(this.getCtx(), this.p_AD_TabTo_ID, this.get_TrxName());
        if (to.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ (to<-) @AD_Tab_ID@");
        }
        if (from.getAD_Table_ID() != to.getAD_Table_ID()) {
            throw new AdempiereUserError("@Error@ @AD_Table_ID@");
        }
        int count = 0;
        MField[] oldFields = from.getFields(false, this.get_TrxName());
        for (int i2 = 0; i2 < oldFields.length; ++i2) {
            MField oldField = oldFields[i2];
            MField newField = new MField(to, oldField);
            if (newField.save()) {
                ++count;
                continue;
            }
            throw new AdempiereUserError("@Error@ @AD_Field_ID@");
        }
        return "@Copied@ #" + count;
    }
}

