/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import com.ancientprogramming.fixedformat4j.annotation.Align;
import com.ancientprogramming.fixedformat4j.annotation.Field;
import com.ancientprogramming.fixedformat4j.annotation.FixedFormatDecimal;
import com.ancientprogramming.fixedformat4j.annotation.FixedFormatPattern;
import com.ancientprogramming.fixedformat4j.annotation.Record;
import com.ancientprogramming.fixedformat4j.format.FixedFormatManager;
import com.ancientprogramming.fixedformat4j.format.impl.FixedFormatManagerImpl;
import com.f3p.adempiere.riba.model.MEffects;
import java.io.File;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MBank;
import org.compiere.model.MLocation;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class LIT_CBI_Generate_RIBA
extends SvrProcess {
    private int noLines = 0;
    private int nPayment = 0;
    private FileWriter fw = null;
    private String m_sia = null;
    private int m_bankaccount_id = 0;
    private BigDecimal totale = Env.ZERO;
    private Timestamp a_datetrx = null;
    private MOrg m_Org = null;
    private MOrgInfo m_OrgInfo = null;
    private MLocation m_OrgLoc = null;
    private MBPBankAccount m_ToBank = null;
    private MBank m_FromBank = null;
    private Properties m_ctx = null;
    private static FixedFormatManager ffmanager = new FixedFormatManagerImpl();
    private static char[] eol = new char[]{'\r', '\n'};
    private CBI_RIBA_RB m_cbi_rb;
    private CBI_RIBA_EF m_cbi_ef;
    private int p_AD_Org_ID;
    private int p_C_Bank_ID;
    private int p_RB_distinct_number;
    private String p_WSC_CodiceSia;
    private String p_FileName = "Riba.txt";
    private boolean p_Consolidate = false;
    private BigDecimal cumulatedAmt = BigDecimal.ZERO;
    private ArrayList<Object> cbiRecord = null;
    private SimpleDateFormat dateDDMMYYYY = new SimpleDateFormat("dd/MM/yyyy");
    protected CLogger log = CLogger.getCLogger(this.getClass());

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Bank_ID")) {
                    this.p_C_Bank_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("RB_distinct_number")) {
                    this.p_RB_distinct_number = para[i].getParameterAsInt();
                } else if (name.equals("WSC_CodiceSia")) {
                    this.p_WSC_CodiceSia = (String)para[i].getParameter();
                } else if (name.equals("FileName")) {
                    this.p_FileName = (String)para[i].getParameter();
                } else if (name.equals("ConsolidateDocument")) {
                    this.p_Consolidate = para[i].getParameterAsBoolean();
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.a_datetrx = new Timestamp(System.currentTimeMillis());
        this.m_ctx = this.getCtx();
        this.m_Org = new MOrg(this.m_ctx, Env.getAD_Org_ID(this.m_ctx), this.get_TrxName());
        this.m_OrgInfo = MOrgInfo.get(this.m_ctx, this.m_Org.getAD_Org_ID(), this.get_TrxName());
        this.m_OrgLoc = new MLocation(this.m_ctx, this.m_OrgInfo.getC_Location_ID(), this.get_TrxName());
        File file = null;
        try {
            file = new File(this.p_FileName);
            this.m_sia = this.p_WSC_CodiceSia == null || this.p_C_Bank_ID == 0 ? " " : this.p_WSC_CodiceSia;
            this.m_bankaccount_id = this.p_C_Bank_ID;
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, String.valueOf(Msg.getMsg(this.m_ctx, "FileCannotCreate", true)) + file.getAbsolutePath(), e);
            throw new Exception(String.valueOf(Msg.getMsg(this.m_ctx, "FileCannotCreate", true)) + file.getAbsolutePath());
        }
        try {
            this.fw = new FileWriter(file);
            this.m_FromBank = new MBank(this.m_ctx, this.m_bankaccount_id, null);
            this.m_cbi_rb = new CBI_RIBA_RB();
            this.noLines = 1;
            this.m_cbi_rb.setSIAMittente(this.m_sia);
            String[] sABICAB = this.m_FromBank.getRoutingNo().split("-");
            this.m_cbi_rb.setABIRicevente(sABICAB[0]);
            this.m_cbi_rb.setDataCreazione(this.a_datetrx);
            this.m_cbi_rb.setNomeditta(this.m_Org.getName());
            this.fw.write(ffmanager.export(this.m_cbi_rb));
            this.fw.write(eol);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
            throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
        }
        String whereClause = "C_BANK_ID = ? AND RB_DISTINCT_NUMBER = ? AND AD_ORG_ID = ? ";
        String orderBy = "C_BPARTNER_ID, C_BP_BANKACCOUNT_ID, DUEDATE";
        List effects = new Query(this.m_ctx, "RB_Effects", whereClause, this.get_TrxName()).setParameters(this.p_C_Bank_ID, this.p_RB_distinct_number, this.p_AD_Org_ID).setOrderBy(orderBy).list();
        int last_bpartner_id = 0;
        int last_bp_bankaccount_id = 0;
        Timestamp last_duedate = null;
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        StringBuilder reference = null;
        for (MEffects effect : effects) {
            if (!this.p_Consolidate || last_bpartner_id != effect.getC_BPartner_ID() || last_bp_bankaccount_id != effect.getC_BP_BankAccount_ID() || last_duedate != null && !fmt.format(last_duedate).equals(fmt.format(effect.getDueDate()))) {
                if (this.cumulatedAmt.signum() > 0) {
                    this.writeRecord(this.cumulatedAmt, reference.toString());
                }
                this.cumulatedAmt = BigDecimal.ZERO;
                reference = new StringBuilder();
                last_bpartner_id = effect.getC_BPartner_ID();
                last_bp_bankaccount_id = effect.getC_BP_BankAccount_ID();
                last_duedate = effect.getDueDate();
                this.fillRecord(effect);
            }
            this.addReference(effect.getC_Invoice_ID(), reference);
            this.cumulatedAmt = this.cumulatedAmt.add(effect.getDiscountAmt());
            effect.setRB_progress_invoice(this.nPayment);
            effect.saveEx(this.get_TrxName());
        }
        if (this.cumulatedAmt.signum() > 0) {
            this.writeRecord(this.cumulatedAmt, reference.toString());
        }
        this.writeTail();
        return "File creato: " + file.getCanonicalPath();
    }

    private void writeRecord(BigDecimal amount, String reference) {
        if (this.cbiRecord == null || amount.signum() == 0) {
            return;
        }
        this.totale = this.totale.add(amount);
        try {
            for (Object cbi : this.cbiRecord) {
                if (cbi instanceof CBI_RIBA_14) {
                    CBI_RIBA_14 cbi14 = (CBI_RIBA_14)cbi;
                    cbi14.setImporto(amount);
                }
                if (cbi instanceof CBI_RIBA_50) {
                    CBI_RIBA_50 cbi50 = (CBI_RIBA_50)cbi;
                    cbi50.setRiferimento(reference);
                }
                this.fw.write(ffmanager.export(cbi));
                this.fw.write(eol);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
        }
        this.cbiRecord.clear();
        this.cbiRecord = null;
    }

    private void addReference(int invoice_id, StringBuilder reference) {
        block6: {
            String sql = "SELECT I.DOCUMENTNO,I.DATEINVOICED FROM C_INVOICE I WHERE I.C_INVOICE_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, invoice_id);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        reference.append(String.format("%1$s %2$s; ", rs.getString(1), this.dateDDMMYYYY.format(rs.getTimestamp(2))));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private void fillRecord(MEffects effect) {
        this.cbiRecord = new ArrayList();
        this.m_ToBank = new MBPBankAccount(this.m_ctx, effect.getC_BP_BankAccount_ID(), this.get_TrxName());
        MBPartner bp = new MBPartner(this.m_ctx, effect.getC_BPartner_ID(), this.get_TrxName());
        MBPartnerLocation[] bpls = bp.getLocations(false);
        MLocation bpl = null;
        String bpIban = this.m_ToBank.get_ValueAsString("IBAN");
        if (bpIban.length() < 5) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "BankBPIban", true), effect.getC_BP_BankAccount_ID());
        }
        if (bpls.length == 1) {
            bpl = new MLocation(this.m_ctx, bpls[0].getC_Location_ID(), this.get_TrxName());
        } else {
            MBPartnerLocation abpl;
            MBPartnerLocation[] mBPartnerLocationArray = bpls;
            if (bpls.length != 0 && (abpl = mBPartnerLocationArray[0]).isRemitTo()) {
                bpl = new MLocation(this.m_ctx, abpl.getC_Location_ID(), null);
            }
        }
        if (bpl == null) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "BankBPRemit", true), bp);
        }
        CBI_RIBA_14 m_cbi_14 = new CBI_RIBA_14();
        ++this.nPayment;
        ++this.noLines;
        m_cbi_14.setNumeroProgressivo(this.nPayment);
        m_cbi_14.setDatascadenza(effect.getDueDate());
        m_cbi_14.setImporto(effect.getDiscountAmt());
        String[] sABICAB = this.m_FromBank.getRoutingNo().split("-");
        m_cbi_14.setABICABContoOrdinante(String.valueOf(sABICAB[0]) + sABICAB[1]);
        m_cbi_14.setABICABDestinataria(bpIban.substring(5, 15));
        m_cbi_14.setCodiceBeneficiario(bp.getTaxID());
        this.cbiRecord.add(m_cbi_14);
        ++this.noLines;
        CBI_RIBA_20 m_cbi_20 = new CBI_RIBA_20();
        m_cbi_20.setNumeroProgressivo(this.nPayment);
        m_cbi_20.setNomeOrdinante(this.m_Org.getName());
        m_cbi_20.setIndirizzo(this.m_OrgLoc.getAddress1());
        m_cbi_20.setLocalita(this.m_OrgLoc.getCity());
        this.cbiRecord.add(m_cbi_20);
        ++this.noLines;
        CBI_RIBA_30 m_cbi_30 = new CBI_RIBA_30();
        m_cbi_30.setNumeroProgressivo(this.nPayment);
        m_cbi_30.setNomeBeneficiario(bp.getName());
        if (bp.getTaxID() != null && bp.getTaxID().length() > 0) {
            m_cbi_30.setCodiceFiscale(bp.getTaxID());
        } else {
            m_cbi_30.setCodiceFiscale(bp.get_ValueAsString("Fiscalcode"));
        }
        this.cbiRecord.add(m_cbi_30);
        ++this.noLines;
        CBI_RIBA_40 m_cbi_40 = new CBI_RIBA_40();
        m_cbi_40.setNumeroProgressivo(this.nPayment);
        m_cbi_40.setIndirizzo(bpl.getAddress1());
        m_cbi_40.setComuneProvincia(String.valueOf(bpl.getCity()) + " " + bpl.getRegionName());
        m_cbi_40.setCAP(bpl.getPostal());
        this.cbiRecord.add(m_cbi_40);
        ++this.noLines;
        CBI_RIBA_50 m_cbi_50 = new CBI_RIBA_50();
        m_cbi_50.setNumeroProgressivo(this.nPayment);
        m_cbi_50.setRiferimento("");
        this.cbiRecord.add(m_cbi_50);
        ++this.noLines;
        CBI_RIBA_51 m_cbi_51 = new CBI_RIBA_51();
        m_cbi_51.setNumeroProgressivo(this.nPayment);
        m_cbi_51.setNRicevuta(this.nPayment);
        m_cbi_51.setDenominazioneCreditore(this.m_Org.getName());
        this.cbiRecord.add(m_cbi_51);
        ++this.noLines;
        CBI_RIBA_70 m_cbi_70 = new CBI_RIBA_70();
        m_cbi_70.setNumeroProgressivo(this.nPayment);
        this.cbiRecord.add(m_cbi_70);
    }

    public int writeTail() {
        try {
            this.m_cbi_ef = new CBI_RIBA_EF();
            ++this.noLines;
            this.m_cbi_ef.setSIAMittente(this.m_cbi_rb.getSIAMittente());
            this.m_cbi_ef.setABIRicevente(this.m_cbi_rb.getABIRicevente());
            this.m_cbi_ef.setDataCreazione(this.m_cbi_rb.getDataCreazione());
            this.m_cbi_ef.setNomeditta(this.m_cbi_rb.getNomeditta());
            this.m_cbi_ef.setNumeroDisposizioni(this.nPayment);
            this.m_cbi_ef.setNumeroRecord(this.noLines);
            this.m_cbi_ef.setTotImporti(this.totale);
            this.fw.write(ffmanager.export(this.m_cbi_ef));
            this.fw.write(eol);
            this.fw.flush();
            this.fw.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        return this.noLines;
    }

    @Record(length=120, paddingChar=32)
    public class CBI_RIBA_14 {
        public static final String CAUSALE_Riba = "30000";
        private int numeroprogressivo;
        private Date datascadenza;
        private BigDecimal importo;
        private String ABICABContoordinante;
        private String ABICABContodestinataria;
        private String SIAordinante;
        private String codicebeneficiario;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "14";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        private void setDatascadenza(Date datascadenza) {
            this.datascadenza = datascadenza;
        }

        @Field(offset=23, length=6)
        @FixedFormatPattern(value="ddMMyy")
        public Date getDatascadenza() {
            return this.datascadenza;
        }

        @Field(offset=29, length=5)
        public String getCausale() {
            return CAUSALE_Riba;
        }

        private void setImporto(BigDecimal importo) {
            this.importo = importo;
        }

        @Field(offset=34, length=13, align=Align.RIGHT, paddingChar=48)
        @FixedFormatDecimal(decimals=2, useDecimalDelimiter=false)
        public BigDecimal getImporto() {
            return this.importo;
        }

        @Field(offset=47, length=1)
        public String getSegno() {
            return "-";
        }

        private void setABICABContoOrdinante(String ABICABConto_Ordinante) {
            this.ABICABContoordinante = ABICABConto_Ordinante;
        }

        @Field(offset=48, length=22)
        public String getABICABContoOrdinante() {
            return this.ABICABContoordinante;
        }

        private void setABICABDestinataria(String ABICABConto_Destinataria) {
            this.ABICABContodestinataria = ABICABConto_Destinataria;
        }

        @Field(offset=70, length=10)
        public String getABICABDestinataria() {
            return this.ABICABContodestinataria;
        }

        private void setSIAOrdinante(String SIA_Ordinante) {
            this.SIAordinante = SIA_Ordinante;
        }

        @Field(offset=92, length=5)
        public String getSIAOrdinante() {
            return this.SIAordinante;
        }

        @Field(offset=97, length=1)
        public String getTipocodice() {
            return "4";
        }

        private void setCodiceBeneficiario(String codiceBeneficiario) {
            this.codicebeneficiario = codiceBeneficiario;
        }

        @Field(offset=98, length=16)
        public String getCodiceBeneficiario() {
            return this.codicebeneficiario;
        }

        @Field(offset=120, length=1)
        public String getDivisa() {
            return "E";
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_RIBA_20 {
        private int numeroprogressivo;
        private String IBANbeneficiario;
        private String nomeordinante;
        private String indirizzo;
        private String localita;
        private String codicefiscale;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "20";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        private void setNomeOrdinante(String nomeOrdinante) {
            this.nomeordinante = nomeOrdinante;
        }

        @Field(offset=11, length=48)
        public String getNomeOrdinante() {
            return this.nomeordinante;
        }

        private void setIndirizzo(String indirizzo) {
            this.indirizzo = indirizzo;
        }

        @Field(offset=59, length=24)
        public String getIndirizzo() {
            return this.indirizzo;
        }

        private void setLocalita(String localita) {
            this.localita = localita;
        }

        @Field(offset=83, length=24)
        public String getLocalita() {
            return this.localita;
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_RIBA_30 {
        private int numeroprogressivo;
        private String nomebeneficiario;
        private String nomebeneficiario2;
        private String codicefiscale;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "30";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        private void setNomeBeneficiario(String nomeBeneficiario) {
            this.nomebeneficiario = nomeBeneficiario;
        }

        @Field(offset=11, length=30)
        public String getNomeBeneficiario() {
            return this.nomebeneficiario;
        }

        private void setNomeBeneficiario2(String nomeBeneficiario) {
            this.nomebeneficiario2 = nomeBeneficiario;
        }

        @Field(offset=41, length=30)
        public String getNomeBeneficiario2() {
            return this.nomebeneficiario2;
        }

        private void setCodiceFiscale(String codicefiscale) {
            this.codicefiscale = codicefiscale;
        }

        @Field(offset=71, length=16)
        public String getCodiceFiscale() {
            return this.codicefiscale;
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_RIBA_40 {
        private int numeroprogressivo;
        private String indirizzo;
        private String cap;
        private String comuneprovincia;
        private String banca;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "40";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        private void setIndirizzo(String indirizzo) {
            this.indirizzo = indirizzo;
        }

        @Field(offset=11, length=30)
        public String getIndirizzo() {
            return this.indirizzo;
        }

        private void setCAP(String CAP) {
            this.cap = CAP;
        }

        @Field(offset=41, length=5)
        public String getCAP() {
            return this.cap;
        }

        private void setComuneProvincia(String comuneProvincia) {
            this.comuneprovincia = comuneProvincia;
        }

        @Field(offset=46, length=25)
        public String getComuneProvincia() {
            return this.comuneprovincia;
        }

        private void setBanca(String banca) {
            this.banca = banca;
        }

        @Field(offset=71, length=50)
        public String getBanca() {
            return this.banca;
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_RIBA_50 {
        private int numeroprogressivo;
        private String riferimento;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "50";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        private void setRiferimento(String Riferimento) {
            this.riferimento = Riferimento;
        }

        @Field(offset=11, length=80)
        public String getRiferimento() {
            return this.riferimento;
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_RIBA_51 {
        private int numeroprogressivo;
        private int nRicevuta;
        private String denominazioneCreditore;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "51";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        private void setNRicevuta(int nRicevuta) {
            this.nRicevuta = nRicevuta;
        }

        @Field(offset=11, length=10, align=Align.RIGHT, paddingChar=48)
        public int getNRicevuta() {
            return this.nRicevuta;
        }

        private void setDenominazioneCreditore(String denominazioneCreditore) {
            this.denominazioneCreditore = denominazioneCreditore;
        }

        @Field(offset=21, length=20)
        public String getDenominazioneCreditore() {
            return this.denominazioneCreditore;
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_RIBA_70 {
        private int numeroprogressivo;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "70";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_RIBA_EF {
        private String mittente;
        private String abiricevente;
        private Date datacreazione;
        private String nomeditta;
        private String campolibero;
        private int numerodisposizioni;
        private BigDecimal totimporti;
        private int numerorecord;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "EF";
        }

        void setSIAMittente(String SIA_Mittente) {
            this.mittente = SIA_Mittente;
        }

        @Field(offset=4, length=5)
        public String getSIAMittente() {
            return this.mittente;
        }

        void setABIRicevente(String ABI_Ricevente) {
            this.abiricevente = ABI_Ricevente;
        }

        @Field(offset=9, length=5)
        public String getABIRicevente() {
            return this.abiricevente;
        }

        void setDataCreazione(Date dataCreazione) {
            this.datacreazione = dataCreazione;
        }

        @Field(offset=14, length=6)
        @FixedFormatPattern(value="ddMMyy")
        public Date getDataCreazione() {
            return this.datacreazione;
        }

        void setNomeditta(String nomeditta) {
            this.nomeditta = nomeditta;
        }

        @Field(offset=20, length=20)
        public String getNomeditta() {
            return this.nomeditta;
        }

        void setCampoLibero(String campoLibero) {
            this.campolibero = campoLibero;
        }

        @Field(offset=40, length=6)
        public String getCampoLibero() {
            return this.campolibero;
        }

        void setNumeroDisposizioni(int numeroDisposizioni) {
            this.numerodisposizioni = numeroDisposizioni;
        }

        @Field(offset=46, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroDisposizioni() {
            return this.numerodisposizioni;
        }

        @Field(offset=68, length=15, align=Align.RIGHT, paddingChar=48)
        public int getTotImportiZero() {
            return 0;
        }

        private void setTotImporti(BigDecimal totImporti) {
            this.totimporti = totImporti;
        }

        @Field(offset=53, length=15, align=Align.RIGHT, paddingChar=48)
        @FixedFormatDecimal(decimals=2, useDecimalDelimiter=false)
        public BigDecimal getTotImporti() {
            return this.totimporti;
        }

        private void setNumeroRecord(int numeroRecord) {
            this.numerorecord = numeroRecord;
        }

        @Field(offset=83, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroRecord() {
            return this.numerorecord;
        }

        @Field(offset=114, length=1)
        public String getDivisa() {
            return "E";
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_RIBA_RB {
        private String mittente;
        private String abiricevente;
        private Date datacreazione;
        private String nomeditta;
        private String campolibero;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "IB";
        }

        void setSIAMittente(String SIA_Mittente) {
            this.mittente = SIA_Mittente;
        }

        @Field(offset=4, length=5)
        public String getSIAMittente() {
            return this.mittente;
        }

        void setABIRicevente(String ABI_Ricevente) {
            this.abiricevente = ABI_Ricevente;
        }

        @Field(offset=9, length=5)
        public String getABIRicevente() {
            return this.abiricevente;
        }

        void setDataCreazione(Date dataCreazione) {
            this.datacreazione = dataCreazione;
        }

        @Field(offset=14, length=6)
        @FixedFormatPattern(value="ddMMyy")
        public Date getDataCreazione() {
            return this.datacreazione;
        }

        void setNomeditta(String nomeditta) {
            this.nomeditta = nomeditta;
        }

        @Field(offset=20, length=26)
        public String getNomeditta() {
            return this.nomeditta;
        }

        void setCampoLibero(String campoLibero) {
            this.campolibero = campoLibero;
        }

        @Field(offset=46, length=68)
        public String getCampoLibero() {
            return this.campolibero;
        }

        @Field(offset=114, length=1)
        public String getDivisa() {
            return "E";
        }
    }
}

