/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import com.f3p.adempiere.util.STDSysConfig;
import com.f3p.adempiere.util.Utils;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_M_PriceList;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceSchedule;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;

public class InvoiceGenerate
extends SvrProcess {
    private static final String COLUMNNAME_C_BP_BANKACCOUNT_ID = "C_BP_BankAccount_ID";
    private static final String COLUMNNAME_C_BankAccount_ID = "C_BankAccount_ID";
    private static final String KEY_SEP = "|";
    public static final String ORDER_BY = "bp.Name,o.Bill_BPartner_ID,o.Bill_Location_ID,o.Bill_User_ID,o.C_BankAccount_ID,o.C_BP_BankAccount_ID,o.M_PriceList_ID,o.C_ConversionType_ID,o.PaymentRule,o.C_PaymentTerm_ID,o.DocumentNo";
    private boolean p_Selection = false;
    private Timestamp p_DateInvoiced = null;
    private int p_AD_Org_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_C_Order_ID = 0;
    private boolean p_ConsolidateDocument = true;
    private String p_docAction = "CO";
    private boolean p_OmitShipmentComment = false;
    private MInvoice m_invoice = null;
    private MInOut m_ship = null;
    private int m_created = 0;
    private int m_line = 0;
    private MBPartner m_bp = null;
    public static final String SYSCFG_OVERRIDE_LINE_NO = "F3P_OVERRIDE_GENERATED_INVOICE_LINE_NO";
    private boolean p_overrideLineNo = false;
    private SortedMap<String, ArrayList<MInvoiceLine>> mapLine = new TreeMap<String, ArrayList<MInvoiceLine>>();

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("Selection")) {
                    this.p_Selection = "Y".equals(para[i].getParameter());
                } else if (name.equals("DateInvoiced")) {
                    this.p_DateInvoiced = (Timestamp)para[i].getParameter();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Order_ID")) {
                    this.p_C_Order_ID = para[i].getParameterAsInt();
                } else if (name.equals("ConsolidateDocument")) {
                    this.p_ConsolidateDocument = "Y".equals(para[i].getParameter());
                } else if (name.equals("OmitShipmentComment")) {
                    this.p_OmitShipmentComment = "Y".equals(para[i].getParameter());
                } else if (name.equals("DocAction")) {
                    this.p_docAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = new Timestamp(System.currentTimeMillis());
        }
        if (!"CO".equals(this.p_docAction)) {
            this.p_docAction = "PR";
        }
        this.p_overrideLineNo = MSysConfig.getBooleanValue(SYSCFG_OVERRIDE_LINE_NO, false, this.getAD_Client_ID());
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("Selection=" + this.p_Selection + ", DateInvoiced=" + this.p_DateInvoiced + ", AD_Org_ID=" + this.p_AD_Org_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", C_Order_ID=" + this.p_C_Order_ID + ", DocAction=" + this.p_docAction + ", Consolidate=" + this.p_ConsolidateDocument);
        String sql = null;
        if (this.p_Selection) {
            sql = "SELECT o.* FROM C_Order o, T_Selection, C_BPartner bp WHERE o.DocStatus IN ('CO','CL') AND o.IsSOTrx='Y' AND o.C_Order_ID = T_Selection.T_Selection_ID AND bp.C_BPartner_ID = o.Bill_BPartner_ID AND T_Selection.AD_PInstance_ID=? ORDER BY bp.Name,o.Bill_BPartner_ID,o.Bill_Location_ID,o.Bill_User_ID,o.C_BankAccount_ID,o.C_BP_BankAccount_ID,o.M_PriceList_ID,o.C_ConversionType_ID,o.PaymentRule,o.C_PaymentTerm_ID,o.DocumentNo";
        } else {
            sql = "SELECT o.* FROM C_Order o, C_BPartner bp  WHERE DocStatus IN('CO','CL') AND IsSOTrx='Y' AND bp.C_BPartner_ID = o.Bill_BPartner_ID ";
            if (this.p_AD_Org_ID != 0) {
                sql = String.valueOf(sql) + " AND o.AD_Org_ID=?";
            }
            if (this.p_C_BPartner_ID != 0) {
                sql = String.valueOf(sql) + " AND o.Bill_BPartner_ID=?";
            }
            if (this.p_C_Order_ID != 0) {
                sql = String.valueOf(sql) + " AND o.C_Order_ID=?";
            }
            sql = String.valueOf(sql) + " AND EXISTS (SELECT * FROM C_OrderLine ol WHERE o.C_Order_ID=ol.C_Order_ID AND ol.QtyOrdered<>ol.QtyInvoiced) AND o.C_DocType_ID IN (SELECT C_DocType_ID FROM C_DocType WHERE DocBaseType='SOO' AND DocSubTypeSO NOT IN ('ON','OB','WR')) ORDER BY bp.Name,o.Bill_BPartner_ID,o.Bill_Location_ID,o.Bill_User_ID,o.C_BankAccount_ID,o.C_BP_BankAccount_ID,o.M_PriceList_ID,o.C_ConversionType_ID,o.PaymentRule,o.C_PaymentTerm_ID,o.DocumentNo";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            int index = 1;
            if (this.p_Selection) {
                pstmt.setInt(index, this.getAD_PInstance_ID());
            } else {
                if (this.p_AD_Org_ID != 0) {
                    pstmt.setInt(index++, this.p_AD_Org_ID);
                }
                if (this.p_C_BPartner_ID != 0) {
                    pstmt.setInt(index++, this.p_C_BPartner_ID);
                }
                if (this.p_C_Order_ID != 0) {
                    pstmt.setInt(index++, this.p_C_Order_ID);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return this.generate(pstmt);
    }

    private String generate(PreparedStatement pstmt) {
        int clientC_Currency_ID = Utils.getCurrencyOf(this.getProcessInfo().getAD_Client_ID(), this.p_AD_Org_ID);
        try {
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MInOutLine shipLine;
                int j;
                MInOutLine[] shipLines;
                MInOut ship;
                int i;
                MInOut[] shipments;
                MOrder order = new MOrder(this.getCtx(), rs, this.get_TrxName());
                if (!this.p_ConsolidateDocument || this.m_invoice != null && this.isNewInvoiceNeeded(order, this.m_invoice, clientC_Currency_ID)) {
                    this.completeInvoice();
                }
                boolean completeOrder = "O".equals(order.getInvoiceRule());
                boolean doInvoice = false;
                if ("S".equals(order.getInvoiceRule())) {
                    this.m_bp = new MBPartner(this.getCtx(), order.getBill_BPartner_ID(), null);
                    if (this.m_bp.getC_InvoiceSchedule_ID() == 0) {
                        this.log.warning("BPartner has no Schedule - set to After Delivery");
                        order.setInvoiceRule("D");
                        order.save();
                    } else {
                        MInvoiceSchedule is = MInvoiceSchedule.get(this.getCtx(), this.m_bp.getC_InvoiceSchedule_ID(), this.get_TrxName());
                        if (!is.canInvoice(order.getDateOrdered(), order.getGrandTotal())) continue;
                        doInvoice = true;
                    }
                }
                if (doInvoice || "D".equals(order.getInvoiceRule())) {
                    shipments = order.getShipments();
                    i = 0;
                    while (i < shipments.length) {
                        ship = shipments[i];
                        if (ship.isComplete() && !ship.getDocStatus().equals("RE")) {
                            shipLines = ship.getLines(false);
                            j = 0;
                            while (j < shipLines.length) {
                                shipLine = shipLines[j];
                                if (order.isOrderLine(shipLine.getC_OrderLine_ID()) && !shipLine.isInvoiced() && (this.p_DateInvoiced.after(ship.getMovementDate()) || this.p_DateInvoiced.compareTo(ship.getMovementDate()) == 0)) {
                                    this.createLine(order, ship, shipLine);
                                }
                                ++j;
                            }
                            if (!this.p_overrideLineNo) {
                                this.m_line += 1000;
                            }
                        }
                        ++i;
                    }
                } else {
                    MOrderLine[] oLines = order.getLines(true, null);
                    i = 0;
                    while (i < oLines.length) {
                        MOrderLine oLine = oLines[i];
                        BigDecimal toInvoice = oLine.getQtyOrdered().subtract(oLine.getQtyInvoiced());
                        if (toInvoice.compareTo(Env.ZERO) != 0 || oLine.getM_Product_ID() == 0) {
                            boolean fullyDelivered;
                            boolean bl = fullyDelivered = oLine.getQtyOrdered().compareTo(oLine.getQtyDelivered()) == 0;
                            if (completeOrder && !fullyDelivered) {
                                this.log.fine("Failed CompleteOrder - " + oLine);
                                this.addLog("Failed CompleteOrder - " + oLine);
                                completeOrder = false;
                                break;
                            }
                            if ("I".equals(order.getInvoiceRule())) {
                                this.log.fine("Immediate - ToInvoice=" + toInvoice + " - " + oLine);
                                BigDecimal qtyEntered = toInvoice;
                                if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                                    qtyEntered = toInvoice.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 12, 4);
                                }
                                this.createLine(order, oLine, toInvoice, qtyEntered);
                            } else {
                                this.log.fine("Failed: " + order.getInvoiceRule() + " - ToInvoice=" + toInvoice + " - " + oLine);
                                this.addLog("Failed: " + order.getInvoiceRule() + " - ToInvoice=" + toInvoice + " - " + oLine);
                            }
                        }
                        ++i;
                    }
                    if ("I".equals(order.getInvoiceRule()) && !this.p_overrideLineNo) {
                        this.m_line += 1000;
                    }
                }
                if (!completeOrder || !"O".equals(order.getInvoiceRule())) continue;
                shipments = order.getShipments();
                i = 0;
                while (i < shipments.length) {
                    ship = shipments[i];
                    if (ship.isComplete() && !ship.getDocStatus().equals("RE")) {
                        shipLines = ship.getLines(false);
                        j = 0;
                        while (j < shipLines.length) {
                            shipLine = shipLines[j];
                            if (order.isOrderLine(shipLine.getC_OrderLine_ID()) && !shipLine.isInvoiced()) {
                                this.createLine(order, ship, shipLine);
                            }
                            ++j;
                        }
                        if (!this.p_overrideLineNo) {
                            this.m_line += 1000;
                        }
                    }
                    ++i;
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.orderInvoiceLines();
        this.completeInvoice();
        return "@Created@ = " + this.m_created;
    }

    private void createLine(MOrder order, MOrderLine orderLine, BigDecimal qtyInvoiced, BigDecimal qtyEntered) {
        if (this.m_invoice == null) {
            this.m_invoice = new MInvoice(order, 0, this.p_DateInvoiced);
            this.m_invoice.set_CustomColumn("VATLedgerDate", this.p_DateInvoiced);
            if (!this.m_invoice.save()) {
                throw new IllegalStateException("Could not create Invoice (o)");
            }
        }
        MInvoiceLine line = new MInvoiceLine(this.m_invoice);
        line.setOrderLine(orderLine);
        line.setQtyInvoiced(qtyInvoiced);
        line.setQtyEntered(qtyEntered);
        this.copyAccountingDimensions(order, this.m_invoice, orderLine, line);
        if (this.p_overrideLineNo) {
            this.m_line += 10;
            line.setLine(this.m_line);
        } else {
            line.setLine(this.m_line + orderLine.getLine());
        }
        if (!line.save()) {
            throw new IllegalStateException("Could not create Invoice Line (o)");
        }
        if (this.p_overrideLineNo) {
            ArrayList lstLines = null;
            String sKey = this.getMapLinesKey(this.m_invoice, null);
            if (this.mapLine.containsKey(sKey)) {
                lstLines = (ArrayList)this.mapLine.get(sKey);
            } else {
                lstLines = new ArrayList();
                this.mapLine.put(sKey, lstLines);
            }
            lstLines.add(line);
        }
        this.log.fine(line.toString());
    }

    private void createLine(MOrder order, MInOut ship, MInOutLine sLine) {
        if (this.m_invoice == null) {
            this.m_invoice = new MInvoice(order, 0, this.p_DateInvoiced);
            this.m_invoice.set_CustomColumn("VATLedgerDate", this.p_DateInvoiced);
            if (!this.m_invoice.save()) {
                throw new IllegalStateException("Could not create Invoice (s)");
            }
        }
        boolean bCreateLine = true;
        ArrayList lstLines = null;
        if (this.p_overrideLineNo) {
            String sKey = this.getMapLinesKey(this.m_invoice, ship);
            if (this.mapLine.containsKey(sKey)) {
                bCreateLine = false;
                lstLines = (ArrayList)this.mapLine.get(sKey);
            } else {
                bCreateLine = true;
                lstLines = new ArrayList();
                this.mapLine.put(sKey, lstLines);
            }
        }
        if (bCreateLine && !this.p_OmitShipmentComment && (this.m_ship == null || this.m_ship.getM_InOut_ID() != ship.getM_InOut_ID())) {
            MDocType dt = MDocType.get(this.getCtx(), ship.getC_DocType_ID());
            if (this.m_bp == null || this.m_bp.getC_BPartner_ID() != ship.getC_BPartner_ID()) {
                this.m_bp = new MBPartner(this.getCtx(), ship.getC_BPartner_ID(), this.get_TrxName());
            }
            MClient client = MClient.get(this.getCtx(), order.getAD_Client_ID());
            String AD_Language = client.getAD_Language();
            if (client.isMultiLingualDocument() && this.m_bp.getAD_Language() != null) {
                AD_Language = this.m_bp.getAD_Language();
            }
            if (AD_Language == null) {
                AD_Language = Language.getBaseAD_Language();
            }
            SimpleDateFormat format = DisplayType.getDateFormat(15, Language.getLanguage(AD_Language));
            String reference = String.valueOf(dt.getPrintName(this.m_bp.getAD_Language())) + ": " + ship.getDocumentNo() + " - " + format.format(ship.getMovementDate());
            this.m_ship = ship;
            MInvoiceLine line = new MInvoiceLine(this.m_invoice);
            line.setIsDescription(true);
            line.setDescription(reference);
            if (this.p_overrideLineNo) {
                this.m_line += 10;
                line.setLine(this.m_line);
            } else {
                line.setLine(this.m_line + sLine.getLine() - 2);
            }
            if (!line.save()) {
                throw new IllegalStateException("Could not create Invoice Comment Line (sh)");
            }
            if (this.p_overrideLineNo) {
                Utils.addToArrayListAndScroll(lstLines, 0, line);
            }
            if (order.getBill_Location_ID() != ship.getC_BPartner_Location_ID()) {
                MLocation addr = MLocation.getBPLocation(this.getCtx(), ship.getC_BPartner_Location_ID(), null);
                line = new MInvoiceLine(this.m_invoice);
                line.setIsDescription(true);
                line.setDescription(addr.toString());
                if (this.p_overrideLineNo) {
                    this.m_line += 10;
                    line.setLine(this.m_line);
                } else {
                    line.setLine(this.m_line + sLine.getLine() - 1);
                }
                if (!line.save()) {
                    throw new IllegalStateException("Could not create Invoice Comment Line 2 (sh)");
                }
                if (this.p_overrideLineNo) {
                    Utils.addToArrayListAndScroll(lstLines, 1, line);
                }
            }
        }
        MInvoiceLine line = new MInvoiceLine(this.m_invoice);
        line.setShipLine(sLine);
        if (sLine.sameOrderLineUOM()) {
            line.setQtyEntered(sLine.getQtyEntered());
        } else {
            line.setQtyEntered(sLine.getMovementQty());
        }
        line.setQtyInvoiced(sLine.getMovementQty());
        this.copyAccountingDimensions(ship, this.m_invoice, sLine, line);
        if (this.p_overrideLineNo) {
            this.m_line += 10;
            line.setLine(this.m_line);
        } else {
            line.setLine(this.m_line + sLine.getLine());
        }
        if (!line.save()) {
            throw new IllegalStateException("Could not create Invoice Line (s)");
        }
        if (this.p_overrideLineNo) {
            if (lstLines.size() == 0) {
                throw new IllegalStateException("Shipment not found.");
            }
            Utils.addToArrayListAndScroll(lstLines, sLine.getLine(), line);
        }
        sLine.setIsInvoiced(true);
        if (!sLine.save()) {
            throw new IllegalStateException("Could not update Shipment Line");
        }
        this.log.fine(line.toString());
    }

    private void completeInvoice() {
        if (this.m_invoice != null) {
            try {
                Trx.run(this.get_TrxName(), new TrxRunnable(){

                    @Override
                    public void run(String trxName) {
                        if (!InvoiceGenerate.this.m_invoice.processIt(InvoiceGenerate.this.p_docAction)) {
                            throw new AdempiereException("completeInvoice - failed: " + InvoiceGenerate.this.m_invoice);
                        }
                    }
                });
            }
            catch (Exception e) {
                String sWarning = e.getMessage();
                this.log.warning(sWarning);
                this.addLog(sWarning);
            }
            this.m_invoice.save();
            this.addLog(this.m_invoice.getC_Invoice_ID(), this.m_invoice.getDateInvoiced(), null, this.m_invoice.getDocumentNo());
            ++this.m_created;
        }
        this.m_invoice = null;
        this.m_ship = null;
        this.m_line = 0;
    }

    private void orderInvoiceLines() {
        ArrayList<String> lstInvAndInout = new ArrayList<String>(this.mapLine.keySet());
        Collections.sort(lstInvAndInout);
        int lineNo = 0;
        int curC_Invoice_ID = -1;
        for (String sKey : lstInvAndInout) {
            int C_Invoice_ID = this.getKeyC_Invoice_ID(sKey);
            if (C_Invoice_ID != curC_Invoice_ID) {
                lineNo = 0;
                curC_Invoice_ID = C_Invoice_ID;
            }
            ArrayList arInvLines = (ArrayList)this.mapLine.get(sKey);
            for (MInvoiceLine line : arInvLines) {
                if (line == null) continue;
                line.setLine(lineNo += 10);
                line.saveEx();
            }
        }
    }

    private void copyAccountingDimensions(PO mOrder, MInvoice mInvoice, PO mOrderLine, MInvoiceLine mInvLine) {
        this.copyValue(mOrder, mInvoice, mOrderLine, mInvLine, "C_Project_ID");
        this.copyValue(mOrder, mInvoice, mOrderLine, mInvLine, "C_Activity_ID");
        this.copyValue(mOrder, mInvoice, mOrderLine, mInvLine, "C_Campaign_ID");
        this.copyValue(mOrder, mInvoice, mOrderLine, mInvLine, "AD_OrgTrx_ID");
        this.copyValue(mOrder, mInvoice, mOrderLine, mInvLine, "User1_ID");
        this.copyValue(mOrder, mInvoice, mOrderLine, mInvLine, "User2_ID");
    }

    private void copyValue(PO mSrcHeader, MInvoice mInvoice, PO mSourceLine, MInvoiceLine mInvLine, String sColumnName) {
        int iInvLineValue = mInvLine.get_ValueAsInt(sColumnName);
        if (iInvLineValue > 0) {
            return;
        }
        int iOrderValue = mSrcHeader.get_ValueAsInt(sColumnName);
        int iInvValue = mInvoice.get_ValueAsInt(sColumnName);
        if (iOrderValue > 0 && iOrderValue != iInvValue) {
            mInvLine.set_ValueOfColumn(sColumnName, (Object)iOrderValue);
        }
    }

    private int getC_BankAccount_ID(PO mPO) {
        if (mPO.get_ColumnIndex(COLUMNNAME_C_BankAccount_ID) >= 0) {
            return mPO.get_ValueAsInt(COLUMNNAME_C_BankAccount_ID);
        }
        return 0;
    }

    private int getC_BP_BankAccount_ID(PO mPO) {
        if (mPO.get_ColumnIndex(COLUMNNAME_C_BP_BANKACCOUNT_ID) >= 0) {
            return mPO.get_ValueAsInt(COLUMNNAME_C_BP_BANKACCOUNT_ID);
        }
        return 0;
    }

    private boolean isNewInvoiceNeeded(MOrder order, MInvoice mCurrentInvoice, int iClient_Currency_ID) {
        if (mCurrentInvoice.getC_BPartner_Location_ID() != order.getBill_Location_ID() || this.getC_BankAccount_ID(mCurrentInvoice) != this.getC_BankAccount_ID(order) || this.getC_BP_BankAccount_ID(mCurrentInvoice) != this.getC_BP_BankAccount_ID(order) || mCurrentInvoice.getM_PriceList_ID() != order.getM_PriceList_ID() || mCurrentInvoice.getC_PaymentTerm_ID() != order.getC_PaymentTerm_ID() || !mCurrentInvoice.getPaymentRule().equals(order.getPaymentRule())) {
            return true;
        }
        if (STDSysConfig.isUserBreakInvoice(mCurrentInvoice.getAD_Client_ID(), this.p_AD_Org_ID) && mCurrentInvoice.getAD_User_ID() != order.getBill_User_ID()) {
            return true;
        }
        I_M_PriceList mPriceList = order.getM_PriceList();
        return mPriceList.getC_Currency_ID() != iClient_Currency_ID && mCurrentInvoice.getC_ConversionType_ID() != order.getC_ConversionType_ID();
    }

    private String getMapLinesKey(MInvoice mInvoice, MInOut mInout) {
        StringBuilder sbKey = new StringBuilder();
        sbKey.append(mInvoice.getC_Invoice_ID()).append('|');
        if (mInout != null) {
            sbKey.append(mInout.getM_InOut_ID());
        }
        return sbKey.toString();
    }

    private int getKeyC_Invoice_ID(String sKey) {
        int iSep = sKey.indexOf(KEY_SEP);
        if (iSep >= 0) {
            String sID = sKey.substring(0, iSep);
            return Integer.parseInt(sID);
        }
        return -1;
    }
}

