/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBankAccount;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_BankAccount;
import org.compiere.model.X_I_Payment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ImportPayment
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private int p_C_BankAccount_ID = 0;
    private boolean p_deleteOldImported = false;
    private String m_docAction = null;
    private boolean m_IsValidateOnly = false;
    private boolean m_IsImportOnlyNoErrors = true;
    private Properties m_ctx;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_BankAccount_ID")) {
                    this.p_C_BankAccount_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("IsValidateOnly")) {
                    this.m_IsValidateOnly = "Y".equals(para[i].getParameter());
                } else if (name.equals("IsImportOnlyNoErrors")) {
                    this.m_IsImportOnlyNoErrors = "Y".equals(para[i].getParameter());
                } else if (name.equals("DeleteOldImported")) {
                    this.p_deleteOldImported = "Y".equals(para[i].getParameter());
                } else if (name.equals("DocAction")) {
                    this.m_docAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.m_ctx = Env.getCtx();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("C_BankAccount_ID=" + this.p_C_BankAccount_ID + " IsValidateOnly=" + this.m_IsValidateOnly + ", IsImportOnlyNoErrors=" + this.m_IsImportOnlyNoErrors);
        MBankAccount ba = MBankAccount.get(this.getCtx(), this.p_C_BankAccount_ID);
        if (this.p_C_BankAccount_ID == 0 || ba.get_ID() != this.p_C_BankAccount_ID) {
            throw new AdempiereUserError("@NotFound@ @C_BankAccount_ID@ - " + this.p_C_BankAccount_ID);
        }
        if (this.p_AD_Org_ID != ba.getAD_Org_ID() && ba.getAD_Org_ID() != 0) {
            this.p_AD_Org_ID = ba.getAD_Org_ID();
        }
        this.log.info("AD_Org_ID=" + this.p_AD_Org_ID);
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + ba.getAD_Client_ID();
        if (this.p_deleteOldImported) {
            sql = new StringBuffer("DELETE I_Payment WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_Payment SET AD_Client_ID = COALESCE (AD_Client_ID,").append(ba.getAD_Client_ID()).append("), AD_Org_ID = COALESCE (AD_Org_ID,").append(this.p_AD_Org_ID).append("),");
        sql.append(" IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL OR AD_Client_ID IS NULL OR AD_Org_ID IS NULL OR AD_Client_ID=0 OR AD_Org_ID=0");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.info("Reset=" + no);
        sql = new StringBuffer("UPDATE I_Payment o SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, 'WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0 OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N'))) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Org=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment i SET C_BankAccount_ID=(  SELECT C_BankAccount_ID  FROM C_BankAccount a, C_Bank b  WHERE b.IsOwnBank='Y'  AND a.AD_Client_ID=i.AD_Client_ID  AND a.C_Bank_ID=b.C_Bank_ID  AND a.AccountNo=i.BankAccountNo  AND b.RoutingNo=i.RoutingNo  OR b.SwiftCode=i.RoutingNo ) WHERE i.C_BankAccount_ID IS NULL AND i.I_IsImported<>'Y' OR i.I_IsImported IS NULL").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Bank Account (With Routing No)=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment i SET C_BankAccount_ID=(  SELECT C_BankAccount_ID  FROM C_BankAccount a, C_Bank b  WHERE b.IsOwnBank='Y'  AND a.C_Bank_ID=b.C_Bank_ID  AND a.AccountNo=i.BankAccountNo  AND a.AD_Client_ID=i.AD_Client_ID ) WHERE i.C_BankAccount_ID IS NULL AND i.I_isImported<>'Y' OR i.I_isImported IS NULL").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Bank Account (Without Routing No)=" + no);
        }
        sql = new StringBuffer("UPDATE I_Payment i SET C_BankAccount_ID=(SELECT C_BankAccount_ID FROM C_BankAccount a WHERE a.C_BankAccount_ID=").append(this.p_C_BankAccount_ID);
        sql.append(" and a.AD_Client_ID=i.AD_Client_ID) WHERE i.C_BankAccount_ID IS NULL AND i.BankAccountNo IS NULL AND i.I_isImported<>'Y' OR i.I_isImported IS NULL").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.info("Bank Account=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET I_isImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Bank Account, ' WHERE C_BankAccount_ID IS NULL AND I_isImported<>'Y' OR I_isImported IS NULL").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("Invalid Bank Account=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment i SET C_Currency_ID=(SELECT C_Currency_ID FROM C_Currency c WHERE i.ISO_Code=c.ISO_Code AND c.AD_Client_ID IN (0,i.AD_Client_ID)) WHERE C_Currency_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Set Currency=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment i SET C_Currency_ID=(SELECT C_Currency_ID FROM C_BankAccount WHERE C_BankAccount_ID=i.C_BankAccount_ID) WHERE i.C_Currency_ID IS NULL AND i.ISO_Code IS NULL").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Set Currency=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Currency,' WHERE C_Currency_ID IS NULL AND I_IsImported<>'E'  AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("No Currency=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET ChargeAmt=0 WHERE ChargeAmt IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Charge Amount=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET TaxAmt=0 WHERE TaxAmt IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Tax Amount=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET WriteOffAmt=0 WHERE WriteOffAmt IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("WriteOff Amount=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET DiscountAmt=0 WHERE DiscountAmt IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Discount Amount=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET DateTrx=Created WHERE DateTrx IS NULL AND I_isImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Trx Date=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET DateAcct=DateTrx WHERE DateAcct IS NULL AND I_isImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Acct Date=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment i SET C_BPartner_ID=(SELECT MAX(C_BPartner_ID) FROM C_BPartner bp WHERE i.BPartnerValue=bp.Value AND i.AD_Client_ID=bp.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.fine("Set BP from Value=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment i SET C_Invoice_ID=(SELECT MAX(C_Invoice_ID) FROM C_Invoice ii WHERE i.InvoiceDocumentNo=ii.DocumentNo AND i.AD_Client_ID=ii.AD_Client_ID AND i.C_BPartner_ID = ii.C_BPartner_ID) WHERE C_Invoice_ID IS NULL AND InvoiceDocumentNo IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.fine("Set Invoice from DocumentNo=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment i SET C_BPartner_ID=(SELECT MAX(C_BPartner_ID) FROM C_Invoice ii WHERE i.C_Invoice_ID=ii.C_Invoice_ID AND i.AD_Client_ID=ii.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND C_Invoice_ID IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.fine("Set BP from Invoice=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No BPartner,' WHERE C_BPartner_ID IS NULL AND I_IsImported<>'E'  AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("No BPartner=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Payment<->Invoice, ' WHERE I_Payment_ID IN (SELECT I_Payment_ID FROM I_Payment i INNER JOIN C_Payment p ON (i.C_Payment_ID=p.C_Payment_ID) WHERE i.C_Invoice_ID IS NOT NULL  AND p.C_Invoice_ID IS NOT NULL  AND p.C_Invoice_ID<>i.C_Invoice_ID) ").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Payment<->Invoice Mismatch=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Payment<->BPartner, ' WHERE I_Payment_ID IN (SELECT I_Payment_ID FROM I_Payment i INNER JOIN C_Payment p ON (i.C_Payment_ID=p.C_Payment_ID) WHERE i.C_BPartner_ID IS NOT NULL  AND p.C_BPartner_ID IS NOT NULL  AND p.C_BPartner_ID<>i.C_BPartner_ID) ").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Payment<->BPartner Mismatch=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Invoice<->BPartner, ' WHERE I_Payment_ID IN (SELECT I_Payment_ID FROM I_Payment i INNER JOIN C_Invoice v ON (i.C_Invoice_ID=v.C_Invoice_ID) WHERE i.C_BPartner_ID IS NOT NULL  AND v.C_BPartner_ID IS NOT NULL  AND v.C_BPartner_ID<>i.C_BPartner_ID) ").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Invoice<->BPartner Mismatch=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'Err=Invalid Invoice.BPartner<->Payment.BPartner, ' WHERE I_Payment_ID IN (SELECT I_Payment_ID FROM I_Payment i INNER JOIN C_Invoice v ON (i.C_Invoice_ID=v.C_Invoice_ID) INNER JOIN C_Payment p ON (i.C_Payment_ID=p.C_Payment_ID) WHERE p.C_Invoice_ID<>v.C_Invoice_ID AND v.C_BPartner_ID<>p.C_BPartner_ID) ").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("Invoice.BPartner<->Payment.BPartner Mismatch=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET TrxType='S' WHERE TrxType IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("TrxType Default=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET TenderType='K' WHERE TenderType IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.info("TenderType Default=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment i SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=i.DocTypeName AND d.DocBaseType IN ('ARR','APP') AND i.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.fine("Set DocType=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid DocTypeName, ' WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("Invalid DocTypeName=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Payment SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No DocType, ' WHERE C_DocType_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("No DocType=" + no);
        }
        this.commitEx();
        int errors = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(*) FROM I_Payment WHERE I_IsImported NOT IN ('Y','N')" + clientCheck);
        if (errors != 0) {
            if (this.m_IsValidateOnly || this.m_IsImportOnlyNoErrors) {
                throw new Exception("@Errors@=" + errors);
            }
        } else if (this.m_IsValidateOnly) {
            return "@Errors@=" + errors;
        }
        this.log.info("Validation Errors=" + errors);
        sql = new StringBuffer("SELECT * FROM I_Payment WHERE I_IsImported='N' ORDER BY C_BankAccount_ID, CheckNo, DateTrx, R_AuthCode");
        X_C_BankAccount account = null;
        CPreparedStatement pstmt = null;
        int noInsert = 0;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_I_Payment imp = new X_I_Payment(this.m_ctx, rs, this.get_TrxName());
                if (account == null || account.getC_BankAccount_ID() != imp.getC_BankAccount_ID()) {
                    account = MBankAccount.get(this.m_ctx, imp.getC_BankAccount_ID());
                    this.log.info("New Account=" + account.getAccountNo());
                }
                MPayment payment = new MPayment(this.m_ctx, 0, this.get_TrxName());
                payment.setAD_Org_ID(imp.getAD_Org_ID());
                payment.setDocumentNo(imp.getDocumentNo());
                payment.setPONum(imp.getPONum());
                payment.setTrxType(imp.getTrxType());
                payment.setTenderType(imp.getTenderType());
                payment.setC_BankAccount_ID(imp.getC_BankAccount_ID());
                payment.setRoutingNo(imp.getRoutingNo());
                payment.setAccountNo(imp.getAccountNo());
                payment.setCheckNo(imp.getCheckNo());
                payment.setMicr(imp.getMicr());
                if (imp.getCreditCardType() != null) {
                    payment.setCreditCardType(imp.getCreditCardType());
                }
                payment.setCreditCardNumber(imp.getCreditCardNumber());
                if (imp.getCreditCardExpMM() != 0) {
                    payment.setCreditCardExpMM(imp.getCreditCardExpMM());
                }
                if (imp.getCreditCardExpYY() != 0) {
                    payment.setCreditCardExpYY(imp.getCreditCardExpYY());
                }
                payment.setCreditCardVV(imp.getCreditCardVV());
                payment.setSwipe(imp.getSwipe());
                payment.setDateAcct(imp.getDateTrx());
                payment.setDateTrx(imp.getDateTrx());
                payment.setC_BPartner_ID(imp.getC_BPartner_ID());
                payment.setC_Invoice_ID(imp.getC_Invoice_ID());
                payment.setC_DocType_ID(imp.getC_DocType_ID());
                payment.setC_Currency_ID(imp.getC_Currency_ID());
                payment.setC_Charge_ID(imp.getC_Charge_ID());
                payment.setChargeAmt(imp.getChargeAmt());
                payment.setTaxAmt(imp.getTaxAmt());
                payment.setPayAmt(imp.getPayAmt());
                payment.setWriteOffAmt(imp.getWriteOffAmt());
                payment.setDiscountAmt(imp.getDiscountAmt());
                payment.setWriteOffAmt(imp.getWriteOffAmt());
                payment.setOverUnderAmt(imp.getOverUnderAmt());
                payment.setIsOverUnderPayment(imp.isOverUnderPayment());
                payment.setA_City(imp.getA_City());
                payment.setA_Country(imp.getA_Country());
                payment.setA_EMail(imp.getA_EMail());
                payment.setA_Ident_DL(imp.getA_Ident_DL());
                payment.setA_Ident_SSN(imp.getA_Ident_SSN());
                payment.setA_Name(imp.getA_Name());
                payment.setA_State(imp.getA_State());
                payment.setA_Street(imp.getA_Street());
                payment.setA_Zip(imp.getA_Zip());
                payment.setR_AuthCode(imp.getR_AuthCode());
                payment.setR_Info(imp.getR_Info());
                payment.setR_PnRef(imp.getR_PnRef());
                payment.setR_RespMsg(imp.getR_RespMsg());
                payment.setR_Result(imp.getR_Result());
                payment.setOrig_TrxID(imp.getOrig_TrxID());
                payment.setVoiceAuthCode(imp.getVoiceAuthCode());
                if (!payment.save()) continue;
                imp.setC_Payment_ID(payment.getC_Payment_ID());
                imp.setI_IsImported(true);
                imp.setProcessed(true);
                imp.save();
                ++noInsert;
                if (payment == null || this.m_docAction == null || this.m_docAction.length() <= 0) continue;
                payment.setDocAction(this.m_docAction);
                payment.processIt(this.m_docAction);
                payment.save();
            }
            rs.close();
            pstmt.close();
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        sql = new StringBuffer("UPDATE I_Payment SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_Payment_ID@: @Inserted@");
        return "";
    }
}

