/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import com.f3p.adempiere.riba.model.MEffects;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EffectWriteOff
extends SvrProcess {
    private int p_AD_Org_ID = -1;
    private Timestamp p_StartDate;
    public static final String RIBA_DOC_TYPE = "RIB";
    public static final String RIBA_MOVEMENT_TYPE = "AUT";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateInvoiced")) {
                    this.p_StartDate = (Timestamp)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        if (this.p_AD_Org_ID < 0) {
            this.p_AD_Org_ID = Env.getAD_Org_ID(this.getCtx());
        }
    }

    @Override
    protected String doIt() throws Exception {
        int noInsert;
        block7: {
            this.log.info("CreateEffect=");
            if (this.p_StartDate == null) {
                this.p_StartDate = new Timestamp(System.currentTimeMillis());
            }
            noInsert = 0;
            StringBuilder sbSQL = new StringBuilder("SELECT i.C_Invoice_ID, i.GrandTotal, i.C_BPARTNER_ID,i.C_BP_BankAccount_ID, ").append(" i.C_CURRENCY_ID, i.DATEINVOICED, ").append(" COALESCE(C_InvoicePaySchedule.DUEDATE, PaymentTermDueDate(i.C_PAYMENTTERM_ID, i.DATEINVOICED), i.DATEINVOICED) AS DUEDATE, ").append(" InvoiceOpen(i.C_INVOICE_ID , COALESCE(C_InvoicePaySchedule.C_INVOICEPAYSCHEDULE_ID,0)) AS DUEAMT ,").append(" InvoiceOpen(i.C_INVOICE_ID , COALESCE(C_InvoicePaySchedule.C_INVOICEPAYSCHEDULE_ID,0)) AS DUEAMT1 ,").append("  i.c_conversiontype_id").append(" FROM (C_Invoice i LEFT JOIN C_InvoicePaySchedule ON C_InvoicePaySchedule.C_INVOICE_ID = i.C_INVOICE_ID AND C_InvoicePaySchedule.ISACTIVE = 'Y')").append("WHERE i.IsPaid='N' and i.IsActive = 'Y' and i.issotrx = 'Y' and i.DocStatus in ('CO','CL') and i.RB_Effects_ID <= 0 and i.GrandTotal > 0 ").append("and InvoiceOpen(i.C_INVOICE_ID , COALESCE(C_InvoicePaySchedule.C_INVOICEPAYSCHEDULE_ID,0)) > 0 ").append(" and (0=? or i.AD_Org_ID = ?) ").append(" and TRUNC(i.DATEINVOICED) <=  ? ").append(" and COALESCE(C_InvoicePaySchedule.PaymentRule,i.PaymentRule) = 'R'");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    int index = 1;
                    pstmt = DB.prepareStatement(sbSQL.toString(), this.get_TrxName());
                    pstmt.setInt(index++, this.p_AD_Org_ID);
                    pstmt.setInt(index++, this.p_AD_Org_ID);
                    pstmt.setTimestamp(index++, this.p_StartDate);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.generateEffect(rs);
                        ++noInsert;
                    }
                }
                catch (Exception e) {
                    this.addLog(e.getMessage());
                    this.log.log(Level.SEVERE, sbSQL.toString(), e);
                    DB.close(rs);
                    DB.close(pstmt);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs);
                DB.close(pstmt);
                throw throwable;
            }
            DB.close(rs);
            DB.close(pstmt);
        }
        return "Elaborato #" + noInsert;
    }

    protected void generateEffect(ResultSet rs) throws SQLException {
        MEffects effect = new MEffects(this.getCtx(), 0, this.get_TrxName());
        effect.setC_Invoice_ID(rs.getInt(1));
        effect.setInvoicedAmt(rs.getBigDecimal(2));
        effect.setC_BPartner_ID(rs.getInt(3));
        effect.setC_BP_BankAccount_ID(rs.getInt(4));
        effect.setC_Currency_ID(rs.getInt(5));
        effect.setDateInvoiced(rs.getTimestamp(6));
        effect.setDueDate(rs.getTimestamp(7));
        effect.setAmountVal(rs.getBigDecimal(8));
        effect.setDiscountAmt(rs.getBigDecimal(9));
        effect.setCurrencyType(rs.getInt(10));
        effect.setRB_document_type(RIBA_DOC_TYPE);
        effect.setRB_moviment_type(RIBA_MOVEMENT_TYPE);
        effect.saveEx();
        this.addLog(0, null, new BigDecimal(effect.get_ID()), "@Inserted@");
    }
}

