/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.adempiere.exceptions.BPartnerNoAddressException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDunningLevel;
import org.compiere.model.MDunningRun;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.MDunningRunLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class DunningRunCreate
extends SvrProcess {
    private boolean p_IncludeInDispute = false;
    private boolean p_OnlySOTrx = false;
    private boolean p_IsAllCurrencies = false;
    private int p_SalesRep_ID = 0;
    private int p_C_Currency_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private int p_C_DunningRun_ID = 0;
    private int p_AD_Org_ID = 0;
    private MDunningRun m_run = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("IncludeInDispute")) {
                this.p_IncludeInDispute = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("OnlySOTrx")) {
                this.p_OnlySOTrx = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("IsAllCurrencies")) {
                this.p_IsAllCurrencies = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("SalesRep_ID")) {
                this.p_SalesRep_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_Currency_ID")) {
                this.p_C_Currency_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BP_Group_ID")) {
                this.p_C_BP_Group_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_C_DunningRun_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("C_DunningRun_ID=" + this.p_C_DunningRun_ID + ", Dispute=" + this.p_IncludeInDispute + ", C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID);
        this.m_run = new MDunningRun(this.getCtx(), this.p_C_DunningRun_ID, this.get_TrxName());
        if (this.m_run.get_ID() == 0) {
            throw new IllegalArgumentException("Not found MDunningRun");
        }
        if (!this.m_run.deleteEntries(true)) {
            throw new IllegalArgumentException("Cannot delete existing entries");
        }
        if (this.p_SalesRep_ID == 0) {
            throw new IllegalArgumentException("No SalesRep");
        }
        if (this.p_C_Currency_ID == 0) {
            throw new IllegalArgumentException("No Currency");
        }
        for (MDunningLevel l_level : this.m_run.getLevels()) {
            this.addInvoices(l_level);
            this.addPayments(l_level);
            if (l_level.isChargeFee()) {
                this.addFees(l_level);
            }
            this.checkDunningEntry(l_level);
        }
        int entries = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(*) FROM C_DunningRunEntry WHERE C_DunningRun_ID=?", this.m_run.get_ID());
        return "@C_DunningRunEntry_ID@ #" + entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addInvoices(MDunningLevel level) {
        MDunningLevel[] previousLevels;
        int count = 0;
        String sql = "SELECT i.C_Invoice_ID, i.C_Currency_ID, i.GrandTotal*i.MultiplierAP, invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID)*MultiplierAP, COALESCE(daysBetween(?,ips.DueDate),paymentTermDueDays(i.C_PaymentTerm_ID,i.DateInvoiced,?)), i.IsInDispute, i.C_BPartner_ID, i.C_InvoicePaySchedule_ID FROM C_Invoice_v i  LEFT OUTER JOIN C_InvoicePaySchedule ips ON (i.C_InvoicePaySchedule_ID=ips.C_InvoicePaySchedule_ID) WHERE i.IsPaid='N' AND i.AD_Client_ID=? AND i.DocStatus IN ('CO','CL') AND (i.DunningGrace IS NULL OR i.DunningGrace<?)  AND EXISTS (SELECT * FROM C_DunningLevel dl WHERE dl.C_DunningLevel_ID=? AND dl.C_Dunning_ID IN (SELECT COALESCE(bp.C_Dunning_ID, bpg.C_Dunning_ID) FROM C_BPartner bp INNER JOIN C_BP_Group bpg ON (bp.C_BP_Group_ID=bpg.C_BP_Group_ID) WHERE i.C_BPartner_ID=bp.C_BPartner_ID AND (bp.DunningGrace IS NULL OR bp.DunningGrace<?)))";
        if (this.p_C_BPartner_ID != 0) {
            sql = sql + " AND i.C_BPartner_ID=?";
        } else if (this.p_C_BP_Group_ID != 0) {
            sql = sql + " AND EXISTS (SELECT * FROM C_BPartner bp WHERE i.C_BPartner_ID=bp.C_BPartner_ID AND bp.C_BP_Group_ID=?)";
        }
        if (this.p_OnlySOTrx) {
            sql = sql + " AND i.IsSOTrx='Y'";
        }
        if (!this.p_IsAllCurrencies) {
            sql = sql + " AND i.C_Currency_ID=" + this.p_C_Currency_ID;
        }
        if (this.p_AD_Org_ID != 0) {
            sql = sql + " AND i.AD_Org_ID=" + this.p_AD_Org_ID;
        }
        String sql2 = null;
        if (level.getParent().isCreateLevelsSequentially() && (previousLevels = level.getPreviousLevels()) != null && previousLevels.length > 0) {
            String sqlAppend = "";
            for (MDunningLevel element : previousLevels) {
                sqlAppend = sqlAppend + " AND i.C_Invoice_ID IN (SELECT C_Invoice_ID FROM C_DunningRunLine WHERE C_DunningRunEntry_ID IN (SELECT C_DunningRunEntry_ID FROM C_DunningRunEntry WHERE C_DunningRun_ID IN (SELECT C_DunningRun_ID FROM C_DunningRunEntry WHERE C_DunningLevel_ID=" + element.get_ID() + ")) AND Processed<>'N')";
            }
            sql = sql + sqlAppend;
        }
        sql2 = "SELECT COUNT(*), COALESCE(DAYSBETWEEN(MAX(dr2.DunningDate), MAX(dr.DunningDate)),0)FROM C_DunningRun dr2, C_DunningRun dr INNER JOIN C_DunningRunEntry dre ON (dr.C_DunningRun_ID=dre.C_DunningRun_ID) INNER JOIN C_DunningRunLine drl ON (dre.C_DunningRunEntry_ID=drl.C_DunningRunEntry_ID) WHERE dr2.C_DunningRun_ID=? AND drl.C_Invoice_ID=?";
        BigDecimal DaysAfterDue = level.getDaysAfterDue();
        int DaysBetweenDunning = level.getDaysBetweenDunning();
        CPreparedStatement pstmt = null;
        CPreparedStatement pstmt2 = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setTimestamp(1, this.m_run.getDunningDate());
            pstmt.setTimestamp(2, this.m_run.getDunningDate());
            pstmt.setInt(3, this.m_run.getAD_Client_ID());
            pstmt.setTimestamp(4, this.m_run.getDunningDate());
            pstmt.setInt(5, level.getC_DunningLevel_ID());
            pstmt.setTimestamp(6, this.m_run.getDunningDate());
            if (this.p_C_BPartner_ID != 0) {
                pstmt.setInt(7, this.p_C_BPartner_ID);
            } else if (this.p_C_BP_Group_ID != 0) {
                pstmt.setInt(7, this.p_C_BP_Group_ID);
            }
            pstmt2 = DB.prepareStatement(sql2, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int C_Invoice_ID = rs.getInt(1);
                int C_Currency_ID = rs.getInt(2);
                BigDecimal GrandTotal = rs.getBigDecimal(3);
                BigDecimal Open = rs.getBigDecimal(4);
                int DaysDue = rs.getInt(5);
                boolean IsInDispute = "Y".equals(rs.getString(6));
                int C_BPartner_ID = rs.getInt(7);
                int C_InvoicePaySchedule_ID = rs.getInt(8);
                this.log.fine("DaysAfterDue: " + DaysAfterDue.intValue() + " isShowAllDue: " + level.isShowAllDue());
                this.log.fine("C_Invoice_ID - DaysDue - GrandTotal: " + C_Invoice_ID + " - " + DaysDue + " - " + GrandTotal);
                this.log.fine("C_InvoicePaySchedule_ID: " + C_InvoicePaySchedule_ID);
                if (!this.p_IncludeInDispute && IsInDispute || DaysDue > 0 && DaysDue < DaysAfterDue.intValue() && !level.isShowAllDue() || Env.ZERO.compareTo(Open) == 0) continue;
                int TimesDunned = 0;
                int DaysAfterLast = 0;
                pstmt2.setInt(1, this.m_run.get_ID());
                pstmt2.setInt(2, C_Invoice_ID);
                ResultSet rs2 = pstmt2.executeQuery();
                if (rs2.next()) {
                    TimesDunned = rs2.getInt(1);
                    DaysAfterLast = rs2.getInt(2);
                }
                rs2.close();
                if (DaysBetweenDunning != 0 && TimesDunned > 0 && DaysAfterLast < DaysBetweenDunning && !level.isShowAllDue() && !level.isShowNotDue() || DaysDue < 0 && !level.isShowNotDue()) continue;
                if (DaysAfterLast < DaysBetweenDunning) {
                    TimesDunned *= -1;
                }
                if (!this.createInvoiceLine(C_Invoice_ID, C_InvoicePaySchedule_ID, C_Currency_ID, GrandTotal, Open, DaysDue, IsInDispute, C_BPartner_ID, TimesDunned, DaysAfterLast, level.getC_DunningLevel_ID())) continue;
                ++count;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            pstmt2 = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "addInvoices", e);
            this.getProcessInfo().addLog(this.getProcessInfo().getAD_PInstance_ID(), null, null, e.getLocalizedMessage());
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            pstmt2 = null;
        }
        return count;
    }

    private boolean createInvoiceLine(int C_Invoice_ID, int C_InvoicePaySchedule_ID, int C_Currency_ID, BigDecimal GrandTotal, BigDecimal Open, int DaysDue, boolean IsInDispute, int C_BPartner_ID, int TimesDunned, int DaysAfterLast, int c_DunningLevel_ID) {
        MDunningRunEntry entry = null;
        try {
            entry = this.m_run.getEntry(C_BPartner_ID, this.p_C_Currency_ID, this.p_SalesRep_ID, c_DunningLevel_ID);
        }
        catch (BPartnerNoAddressException e) {
            String msg = "@Skip@ @C_Invoice_ID@ " + MInvoice.get(this.getCtx(), C_Invoice_ID).getDocumentInfo() + ", @C_BPartner_ID@ " + MBPartner.get(this.getCtx(), C_BPartner_ID).getName() + " @No@ @IsActive@ @C_BPartner_Location_ID@";
            this.getProcessInfo().addLog(this.getProcessInfo().getAD_PInstance_ID(), null, null, msg);
            return false;
        }
        if (entry.get_ID() == 0 && !entry.save()) {
            throw new IllegalStateException("Cannot save MDunningRunEntry");
        }
        MDunningRunLine line = new MDunningRunLine(entry);
        line.setInvoice(C_Invoice_ID, C_Currency_ID, GrandTotal, Open, new BigDecimal(0), DaysDue, IsInDispute, TimesDunned, DaysAfterLast);
        line.setC_InvoicePaySchedule_ID(C_InvoicePaySchedule_ID);
        if (!line.save()) {
            throw new IllegalStateException("Cannot save MDunningRunLine");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addPayments(MDunningLevel level) {
        String sql = "SELECT C_Payment_ID, C_Currency_ID, PayAmt, paymentAvailable(C_Payment_ID), C_BPartner_ID FROM C_Payment_v p WHERE AD_Client_ID=? AND IsAllocated='N' AND C_BPartner_ID IS NOT NULL AND C_Charge_ID IS NULL AND DocStatus IN ('CO','CL') AND EXISTS (SELECT * FROM C_DunningLevel dl WHERE dl.C_DunningLevel_ID=? AND dl.C_Dunning_ID IN (SELECT COALESCE(bp.C_Dunning_ID, bpg.C_Dunning_ID) FROM C_BPartner bp INNER JOIN C_BP_Group bpg ON (bp.C_BP_Group_ID=bpg.C_BP_Group_ID) WHERE p.C_BPartner_ID=bp.C_BPartner_ID))";
        if (this.p_C_BPartner_ID != 0) {
            sql = sql + " AND C_BPartner_ID=?";
        } else if (this.p_C_BP_Group_ID != 0) {
            sql = sql + " AND EXISTS (SELECT * FROM C_BPartner bp WHERE p.C_BPartner_ID=bp.C_BPartner_ID AND bp.C_BP_Group_ID=?)";
        }
        if (!level.isStatement()) {
            sql = sql + " AND C_BPartner_ID IN (SELECT C_BPartner_ID FROM C_DunningRunEntry WHERE C_DunningRun_ID=" + this.m_run.get_ID() + ")";
        }
        if (this.p_OnlySOTrx) {
            sql = sql + " AND IsReceipt='Y'";
        }
        if (this.p_AD_Org_ID != 0) {
            sql = sql + " AND p.AD_Org_ID=" + this.p_AD_Org_ID;
        }
        int count = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Client_ID());
            pstmt.setInt(2, level.getC_DunningLevel_ID());
            if (this.p_C_BPartner_ID != 0) {
                pstmt.setInt(3, this.p_C_BPartner_ID);
            } else if (this.p_C_BP_Group_ID != 0) {
                pstmt.setInt(3, this.p_C_BP_Group_ID);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int C_Payment_ID = rs.getInt(1);
                int C_Currency_ID = rs.getInt(2);
                BigDecimal PayAmt = rs.getBigDecimal(3).negate();
                BigDecimal OpenAmt = rs.getBigDecimal(4).negate();
                int C_BPartner_ID = rs.getInt(5);
                if (Env.ZERO.compareTo(OpenAmt) == 0 || !this.createPaymentLine(C_Payment_ID, C_Currency_ID, PayAmt, OpenAmt, C_BPartner_ID, level.getC_DunningLevel_ID())) continue;
                ++count;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
            this.getProcessInfo().addLog(this.getProcessInfo().getAD_PInstance_ID(), null, null, e.getLocalizedMessage());
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return count;
    }

    private boolean createPaymentLine(int C_Payment_ID, int C_Currency_ID, BigDecimal PayAmt, BigDecimal OpenAmt, int C_BPartner_ID, int c_DunningLevel_ID) {
        MDunningRunEntry entry = null;
        try {
            entry = this.m_run.getEntry(C_BPartner_ID, this.p_C_Currency_ID, this.p_SalesRep_ID, c_DunningLevel_ID);
        }
        catch (BPartnerNoAddressException e) {
            MPayment payment = new MPayment(this.getCtx(), C_Payment_ID, null);
            String msg = "@Skip@ @C_Payment_ID@ " + payment.getDocumentInfo() + ", @C_BPartner_ID@ " + MBPartner.get(this.getCtx(), C_BPartner_ID).getName() + " @No@ @IsActive@ @C_BPartner_Location_ID@";
            this.getProcessInfo().addLog(this.getProcessInfo().getAD_PInstance_ID(), null, null, msg);
            return false;
        }
        if (entry.get_ID() == 0 && !entry.save()) {
            throw new IllegalStateException("Cannot save MDunningRunEntry");
        }
        MDunningRunLine line = new MDunningRunLine(entry);
        line.setPayment(C_Payment_ID, C_Currency_ID, PayAmt, OpenAmt);
        if (!line.save()) {
            throw new IllegalStateException("Cannot save MDunningRunLine");
        }
        return true;
    }

    private void addFees(MDunningLevel level) {
        boolean onlyInvoices = level.isStatement();
        MDunningRunEntry[] entries = this.m_run.getEntries(true, onlyInvoices);
        if (entries != null && entries.length > 0) {
            for (MDunningRunEntry element : entries) {
                if (level.isShowAllDue() && level.isShowNotDue() && element.getAmt().compareTo(Env.ZERO) < 0) continue;
                MDunningRunLine line = new MDunningRunLine(element);
                line.setFee(this.p_C_Currency_ID, level.getFeeAmt());
                if (!line.save()) {
                    throw new IllegalStateException("Cannot save MDunningRunLine");
                }
                element.setQty(element.getQty().subtract(new BigDecimal(1)));
            }
        }
    }

    private void checkDunningEntry(MDunningLevel level) {
        MDunningRunEntry[] entries;
        if (level.isShowAllDue() && (entries = this.m_run.getEntries(true)) != null && entries.length > 0) {
            for (MDunningRunEntry element : entries) {
                boolean entryDelete = true;
                MDunningRunLine[] lines = element.getLines(true);
                for (int j = 0; j < lines.length; ++j) {
                    if (lines[j].getTimesDunned() < 0) {
                        lines[j].setTimesDunned(lines[j].getTimesDunned() * -1);
                        if (lines[j].save()) continue;
                        throw new IllegalStateException("Cannot save MDunningRunLine");
                    }
                    entryDelete = false;
                }
                if (!entryDelete) continue;
                element.delete(false);
            }
        }
    }
}

