/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class DistinctWriteOff
extends SvrProcess {
    public static final String RBEFFECTS_TABLE_NAME = "RB_Effects";
    public static final String PRINTFORMAT_NAME = "WSC_Genera_distinta";
    private static int s_iAD_Table_ID_RBEffects = -1;
    private static int s_iAD_Print_Format = -1;
    private int p_AD_Org_ID;
    private int p_C_Bank_ID;
    private Timestamp p_StartDate = null;
    private int p_RB_distinct_number;
    private Timestamp p_RB_DataPresentazione = null;
    private Timestamp p_RB_DataScadenzaDa = null;
    private Timestamp p_RB_DataScadenzaA = null;
    private Timestamp p_DateInvoicedda = null;
    private Timestamp p_DateInvoiceda = null;
    private int p_WSC_ImportoMax;
    private boolean p_WSC_Definitive = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null || para[i].getParameter_To() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Bank_ID")) {
                    this.p_C_Bank_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("RB_DataPresentazione")) {
                    this.p_RB_DataPresentazione = (Timestamp)para[i].getParameter();
                } else if (name.equals("RB_distinct_number")) {
                    this.p_RB_distinct_number = para[i].getParameterAsInt();
                } else if (name.equals("RB_DataScadenza")) {
                    this.p_RB_DataScadenzaDa = (Timestamp)para[i].getParameter();
                    this.p_RB_DataScadenzaA = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("DateInvoiced")) {
                    this.p_DateInvoicedda = (Timestamp)para[i].getParameter();
                    this.p_DateInvoiceda = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("WSC_ImportoMax")) {
                    this.p_WSC_ImportoMax = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("WSC_Definitiva")) {
                    this.p_WSC_Definitive = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        if (s_iAD_Table_ID_RBEffects < 0) {
            MTable mTableEffects = MTable.get(this.getCtx(), RBEFFECTS_TABLE_NAME);
            s_iAD_Table_ID_RBEffects = mTableEffects.getAD_Table_ID();
        }
        if (s_iAD_Print_Format < 0) {
            s_iAD_Print_Format = MPrintFormat.getPrintFormat_ID(PRINTFORMAT_NAME, s_iAD_Table_ID_RBEffects, this.getAD_Client_ID());
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("CreateDistinta=");
        this.p_StartDate = new Timestamp(System.currentTimeMillis());
        if (this.p_RB_DataScadenzaA == null) {
            this.p_RB_DataScadenzaA = new Timestamp(System.currentTimeMillis());
        }
        if (this.p_RB_DataScadenzaDa == null) {
            this.p_RB_DataScadenzaDa = new Timestamp(System.currentTimeMillis());
        }
        if (this.p_DateInvoicedda == null) {
            this.p_DateInvoicedda = Timestamp.valueOf("2001-01-01 00:00:00");
        }
        if (this.p_DateInvoiceda == null) {
            this.p_DateInvoiceda = Timestamp.valueOf("2070-01-01 24:59:59");
        }
        if (this.p_WSC_Definitive) {
            String sql = "UPDATE RB_Effects set C_BANK_ID = ? \t, RB_submission_date = Sysdate  , RB_distinct_number = ? \t, Status = 'PRT'  WHERE  Status='NEW' and (RB_Effects.C_BANK_ID = 0 or RB_Effects.C_BANK_ID is null) and (RB_Effects.RB_distinct_number = 0 or RB_Effects.RB_distinct_number is null)  and AD_Org_ID = ?  and TRUNC(duedate) >= ?  and TRUNC(duedate) <= ?  and TRUNC(dateinvoiced) >= ?  and TRUNC(dateinvoiced) <= ? ";
            Object[] oParams = new Object[]{this.p_C_Bank_ID, this.p_RB_distinct_number, this.p_AD_Org_ID, this.p_RB_DataScadenzaDa, this.p_RB_DataScadenzaA, this.p_DateInvoicedda, this.p_DateInvoiceda};
            int no = DB.executeUpdateEx(sql, oParams, this.get_TrxName());
            if (no == 0) {
                return "nulla da generare :" + no;
            }
            if (no != 0) {
                this.log.info("Inserted #" + no);
            }
        }
        return "Inserted #" + this.p_StartDate;
    }

    @Override
    protected void postProcess(boolean success) {
        super.postProcess(success);
        if (success) {
            String sqlx = " RB_Effects.Status= ";
            if (this.p_WSC_Definitive) {
                sqlx = String.valueOf(sqlx) + "'PRT' ";
            }
            if (!this.p_WSC_Definitive) {
                sqlx = String.valueOf(sqlx) + "'NEW'";
            }
            if (this.p_WSC_Definitive) {
                sqlx = String.valueOf(sqlx) + " and RB_Effects.C_BANK_ID = " + this.p_C_Bank_ID;
            }
            if (!this.p_WSC_Definitive) {
                sqlx = String.valueOf(sqlx) + " and (RB_Effects.C_BANK_ID = 0 or RB_Effects.C_BANK_ID is null)";
            }
            if (this.p_WSC_Definitive) {
                sqlx = String.valueOf(sqlx) + " and RB_Effects.RB_distinct_number = " + this.p_RB_distinct_number;
            }
            if (!this.p_WSC_Definitive) {
                sqlx = String.valueOf(sqlx) + " and (RB_Effects.RB_distinct_number = 0 or RB_Effects.RB_distinct_number is null)";
            }
            sqlx = String.valueOf(sqlx) + " and RB_Effects.AD_Org_ID = " + this.p_AD_Org_ID;
            if (!this.p_WSC_Definitive) {
                sqlx = String.valueOf(sqlx) + " and TRUNC(RB_Effects.duedate) >= " + DB.TO_DATE(this.p_RB_DataScadenzaDa, true);
            }
            if (!this.p_WSC_Definitive) {
                sqlx = String.valueOf(sqlx) + " and TRUNC(RB_Effects.duedate) <= " + DB.TO_DATE(this.p_RB_DataScadenzaA, true);
            }
            if (!this.p_WSC_Definitive) {
                sqlx = String.valueOf(sqlx) + " and TRUNC(RB_Effects.DateInvoiced) >= " + DB.TO_DATE(this.p_DateInvoicedda, true);
            }
            if (!this.p_WSC_Definitive) {
                sqlx = String.valueOf(sqlx) + " and TRUNC(RB_Effects.DateInvoiced) <= " + DB.TO_DATE(this.p_DateInvoiceda, true);
            }
            MClient client = MClient.get(this.getCtx());
            int rb_effects_ID = 0;
            MPrintFormat format = null;
            int C_BPartner_ID = 0;
            int count = 0;
            int errors = 0;
            int copies = 2;
            if (copies == 0) {
                copies = 1;
            }
            String DocumentNo = "Distinta";
            String documentDir = client.getDocumentDir();
            if (documentDir == null || documentDir.length() == 0) {
                documentDir = ".";
            }
            MQuery query = new MQuery(RBEFFECTS_TABLE_NAME);
            query.addRestriction(sqlx);
            PrintInfo info = new PrintInfo(DocumentNo, s_iAD_Table_ID_RBEffects, rb_effects_ID, C_BPartner_ID);
            info.setCopies(copies);
            boolean printed = false;
            MProcess mProcess = MProcess.get(this.getCtx(), this.getProcessInfo().getAD_Process_ID());
            if (mProcess.getJasperReport() == null) {
                if (s_iAD_Print_Format == 0) {
                    this.addLog(rb_effects_ID, null, null, String.valueOf(DocumentNo) + " No Print Format");
                    ++errors;
                } else {
                    format = MPrintFormat.get(this.getCtx(), s_iAD_Print_Format, false);
                }
                ReportEngine re = new ReportEngine(this.getCtx(), format, query, info);
                if (mProcess.isDirectPrint()) {
                    re.print();
                } else {
                    ReportCtl.preview(re);
                }
            }
            ++count;
            printed = true;
        }
    }
}

