/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import com.f3p.adempiere.riba.model.MEffects;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class DistinctContabOff
extends SvrProcess {
    private int p_AD_Org_ID;
    private int p_C_Bank_ID;
    private int p_RB_distinct_number;
    private int p_Contropartita;
    private Timestamp p_RB_DataScadenzaDa;
    private Timestamp p_RB_DataScadenzaA;
    private Timestamp p_DateAcct;
    private Map<BigDecimal, String> m_hmErrors = new HashMap<BigDecimal, String>();
    private Map<BigDecimal, String> m_hmInserted = new HashMap<BigDecimal, String>();
    private static final String QUERY_EFFECTS = "SELECT RB_Effects_ID, C_Invoice_ID , C_BPartner_ID, C_Currency_ID, DueDate,DiscountAmt FROM RB_Effects WHERE Status in ('NEW', 'PRT') and AD_Org_ID = ? and C_BANK_ID = ? and RB_distinct_number = ? ";
    private static final String QUERY_INVOICE_OPEN = "SELECT invoiceOpen( ? ,NULL) FROM dual";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Bank_ID")) {
                    this.p_C_Bank_ID = para[i].getParameterAsInt();
                } else if (name.equals("RB_DataScadenza")) {
                    this.p_RB_DataScadenzaDa = (Timestamp)para[i].getParameter();
                    this.p_RB_DataScadenzaA = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("RB_distinct_number")) {
                    this.p_RB_distinct_number = para[i].getParameterAsInt();
                } else if (name.equals("Contropartita")) {
                    this.p_Contropartita = para[i].getParameterAsInt();
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct = (Timestamp)para[i].getParameter();
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        String sReturn;
        block16: {
            String sSql = QUERY_EFFECTS;
            if (this.p_RB_DataScadenzaDa != null) {
                sSql = String.valueOf(sSql) + " and TRUNC(duedate) >= ? ";
            }
            if (this.p_RB_DataScadenzaA != null) {
                sSql = String.valueOf(sSql) + " and TRUNC(duedate) <= ?";
            }
            ResultSet rs = null;
            CPreparedStatement pstmt = null;
            try {
                try {
                    int index = 1;
                    pstmt = DB.prepareStatement(sSql, this.get_TrxName());
                    pstmt.setInt(index++, this.p_AD_Org_ID);
                    pstmt.setInt(index++, this.p_C_Bank_ID);
                    pstmt.setInt(index++, this.p_RB_distinct_number);
                    if (this.p_RB_DataScadenzaDa != null) {
                        pstmt.setTimestamp(index++, this.p_RB_DataScadenzaDa);
                    }
                    if (this.p_RB_DataScadenzaA != null) {
                        pstmt.setTimestamp(index++, this.p_RB_DataScadenzaA);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int RB_Effects_ID = rs.getInt(1);
                        int C_Invoice_ID = rs.getInt(2);
                        int C_BPartner_ID = rs.getInt(3);
                        int C_Currency_ID = rs.getInt(4);
                        Timestamp tsDueDate = rs.getTimestamp(5);
                        BigDecimal bdAmountVal = rs.getBigDecimal(6);
                        try {
                            this.generateBankTransfer(RB_Effects_ID, C_Invoice_ID, C_BPartner_ID, C_Currency_ID, tsDueDate, bdAmountVal);
                        }
                        catch (AdempiereException e) {
                            MInvoice invoice = MInvoice.get(this.getCtx(), C_Invoice_ID);
                            StringBuilder sb = new StringBuilder(invoice.getDocumentNo());
                            sb.append(" - ").append(tsDueDate).append(" : ").append(e.getMessage());
                            this.m_hmErrors.put(new BigDecimal(RB_Effects_ID), sb.toString());
                        }
                    }
                }
                catch (Exception e) {
                    this.addLog(e.getMessage());
                    this.log.log(Level.SEVERE, sSql, e);
                    DB.close(rs, pstmt);
                    break block16;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        int iErrors = this.m_hmErrors.size();
        int iInserted = this.m_hmInserted.size();
        if (iErrors > 0) {
            this.addLog(0, null, new BigDecimal(iErrors), "@Errors@");
            Set<BigDecimal> ids = this.m_hmErrors.keySet();
            for (BigDecimal id : ids) {
                this.addLog(0, null, id, this.m_hmErrors.get(id));
            }
            sReturn = "@Error@";
        } else {
            this.addLog(0, null, new BigDecimal(iInserted), "@Inserted@");
            Set<BigDecimal> ids = this.m_hmInserted.keySet();
            for (BigDecimal id : ids) {
                this.addLog(0, null, id, this.m_hmInserted.get(id));
            }
            sReturn = "@OK@";
        }
        return sReturn;
    }

    private void generateBankTransfer(int RB_Effects_ID, int C_Invoice_ID, int C_BPartner_ID, int C_Currency_ID, Timestamp tsDueDate, BigDecimal bdAmountVal) throws IllegalStateException, SQLException {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int amountOpen = 0;
        try {
            pstmt = DB.prepareStatement(QUERY_INVOICE_OPEN, this.get_TrxName());
            pstmt.setInt(1, C_Invoice_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                amountOpen = rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        if (amountOpen > 0) {
            String sDocumentNo = "Effetto " + RB_Effects_ID;
            String sDescription = "Scadenza " + tsDueDate;
            MPayment paymentBankTo = new MPayment(this.getCtx(), 0, this.get_TrxName());
            paymentBankTo.setC_BankAccount_ID(this.p_Contropartita);
            paymentBankTo.setDocumentNo(sDocumentNo);
            paymentBankTo.setDateAcct(this.p_DateAcct);
            paymentBankTo.setDateTrx(this.p_DateAcct);
            paymentBankTo.setTenderType("A");
            paymentBankTo.setDescription(sDescription);
            paymentBankTo.setC_BPartner_ID(C_BPartner_ID);
            paymentBankTo.setC_Currency_ID(C_Currency_ID);
            paymentBankTo.setC_Invoice_ID(C_Invoice_ID);
            paymentBankTo.setPayAmt(bdAmountVal);
            paymentBankTo.setOverUnderAmt(Env.ZERO);
            paymentBankTo.setC_DocType_ID(true);
            paymentBankTo.saveEx(this.get_TrxName());
            boolean bProcess = paymentBankTo.processIt("CO");
            if (!bProcess) {
                MInvoice invoice = MInvoice.get(this.getCtx(), C_Invoice_ID);
                StringBuilder sb = new StringBuilder(invoice.getDocumentNo());
                sb.append(" - ").append(tsDueDate).append(" : ").append(paymentBankTo.getProcessMsg());
                this.m_hmErrors.put(new BigDecimal(RB_Effects_ID), sb.toString());
            } else {
                StringBuilder sb = new StringBuilder(Msg.translate(this.getCtx(), "DocumentNo"));
                sb.append(" ").append(paymentBankTo.getDocumentNo());
                sb.append(" - @DocStatus@: ");
                sb.append(paymentBankTo.getDocStatusName());
                this.m_hmInserted.put(new BigDecimal(RB_Effects_ID), sb.toString());
                paymentBankTo.saveEx(this.get_TrxName());
                MEffects effect = new MEffects(this.getCtx(), RB_Effects_ID, this.get_TrxName());
                effect.setStatus("CON");
                effect.saveEx(this.get_TrxName());
            }
        } else {
            MInvoice invoice = MInvoice.get(this.getCtx(), C_Invoice_ID);
            StringBuilder sb = new StringBuilder(invoice.getDocumentNo());
            sb.append(" - ").append(tsDueDate).append(" : ").append(Msg.getMsg(this.getCtx(), "ValidationError")).append(" ").append(invoice.getDocumentNo()).append(" ").append(Msg.translate(this.getCtx(), "IsPaid"));
            this.m_hmErrors.put(new BigDecimal(RB_Effects_ID), sb.toString());
        }
    }
}

