/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import com.qwerty.pa.model.MPAQAccertamenti;
import com.qwerty.pa.model.MPAQCapitoli;
import com.qwerty.pa.model.MPAQLiquidazioniAttive;
import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MCharge;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPNGEntryType;
import org.compiere.model.MTax;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CreaFatturaDaLiquidAttiv
extends SvrProcess {
    private int m_PAQ_LiquidazioniAttive_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("PAQ_LiquidazioniAttive_ID")) {
                    this.m_PAQ_LiquidazioniAttive_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        String m_processMsg = "";
        int To_C_Invoice_ID = this.getRecord_ID();
        this.log.info("From PAQ_LiquidazioniAttive_ID=" + this.m_PAQ_LiquidazioniAttive_ID + " to " + To_C_Invoice_ID);
        if (To_C_Invoice_ID == 0) {
            throw new IllegalArgumentException("Target C_Invoice_ID == 0");
        }
        if (this.m_PAQ_LiquidazioniAttive_ID == 0) {
            throw new IllegalArgumentException("Source PAQ_LiquidazioniAttive_ID == 0");
        }
        MInvoice invoice = this.createInvoice();
        invoice.processIt("PR");
        invoice.saveEx();
        if (!"CO".equals(invoice.getDocStatus())) {
            m_processMsg = invoice.getProcessMsg();
            return invoice.getDocStatus();
        }
        return m_processMsg;
    }

    public MCharge getOrCreateCharge(int Account_ID, int C_Tax_ID, MPAQCapitoli cp) {
        int C_AcctSchema_ID = cp.getC_AcctSchema_ID();
        MTax tax = MTax.get(this.getCtx(), C_Tax_ID);
        MAcctSchema as = MAcctSchema.get(this.getCtx(), C_AcctSchema_ID);
        MAccount acct = MAccount.get(this.getCtx(), Env.getAD_Client_ID(this.getCtx()), Env.getAD_Org_ID(this.getCtx()), as.getC_AcctSchema_ID(), Account_ID, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        acct.save();
        MCharge charge = null;
        String sql = "SELECT c_charge_id FROM C_Charge_Acct c WHERE c.ch_expense_acct=?";
        int i = DB.getSQLValue(this.get_TrxName(), sql, acct.getC_ValidCombination_ID());
        if (i < 0) {
            charge = new MCharge(this.getCtx(), 0, this.get_TrxName());
            charge.setC_TaxCategory_ID(tax.getC_TaxCategory_ID());
            charge.setAD_Org_ID(Env.getAD_Org_ID(this.getCtx()));
            charge.setDescription(acct.getDescription());
            charge.setName(acct.getAccount().getName());
            charge.saveEx();
            StringBuffer sql2 = new StringBuffer("UPDATE C_Charge_Acct ");
            sql2.append("SET CH_Expense_Acct=").append(acct.getC_ValidCombination_ID());
            sql2.append(", CH_Revenue_Acct=").append(acct.getC_ValidCombination_ID());
            sql2.append(" WHERE C_Charge_ID=").append(charge.getC_Charge_ID());
            sql2.append(" AND C_AcctSchema_ID=").append(C_AcctSchema_ID);
            int noAffectedRows = DB.executeUpdate(sql2.toString(), this.get_TrxName());
            if (noAffectedRows != 1) {
                this.log.log(Level.SEVERE, "Update #" + noAffectedRows + "\n" + sql2.toString());
            }
        } else {
            charge = new MCharge(this.getCtx(), i, this.get_TrxName());
        }
        return charge;
    }

    public MInvoice createInvoice() {
        MPAQLiquidazioniAttive from = new MPAQLiquidazioniAttive(this.getCtx(), this.m_PAQ_LiquidazioniAttive_ID, this.get_TrxName());
        MBPartner bp = new MBPartner(this.getCtx(), from.getC_BPartner_ID(), this.get_TrxName());
        MPAQAccertamenti pr = new MPAQAccertamenti(this.getCtx(), from.getPAQ_Accertamenti_ID(), this.get_TrxName());
        MPAQCapitoli cp = new MPAQCapitoli(this.getCtx(), pr.getPAQ_Capitoli_ID(), this.get_TrxName());
        MPNGEntryType ty = new MPNGEntryType(this.getCtx(), from.getpaq_causale(), this.get_TrxName());
        MInvoice realinvoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        realinvoice.setAD_Org_ID(from.getAD_Org_ID());
        realinvoice.setC_BPartner_ID(from.getC_BPartner_ID());
        realinvoice.setC_BPartner_Location_ID(from.getC_BPartner_Location_ID());
        realinvoice.setC_Charge_ID(0);
        realinvoice.setC_Currency_ID(from.getC_Currency_ID());
        realinvoice.setC_DocType_ID(ty.getC_DocType_ID());
        realinvoice.setC_DocTypeTarget_ID(ty.getC_DocType_ID());
        realinvoice.setC_PaymentTerm_ID(from.getC_PaymentTerm_ID());
        realinvoice.setPaymentRule(from.getPaymentRule());
        realinvoice.setSalesRep_ID(bp.getSalesRep_ID());
        realinvoice.setM_PriceList_ID(bp.getM_PriceList_ID());
        realinvoice.setC_Project_ID(0);
        realinvoice.setDateAcct(from.getpaq_data_liquidazione());
        realinvoice.setDateInvoiced(from.getpaq_data_liquidazione());
        realinvoice.set_CustomColumn("VATLedgerDate", from.getpaq_data_liquidazione());
        realinvoice.setDocumentNo(from.getDocumentNo());
        realinvoice.setIsSOTrx(true);
        realinvoice.set_CustomColumn("PAQ_Liquidazioni_Attive_ID", from.getPAQ_Liquidazioni_Attive_ID());
        realinvoice.set_CustomColumn("PAQ_Assegnazioni_Attive_ID", from.getPAQ_Assegnazioni_Attive_ID());
        realinvoice.set_CustomColumn("PAQ_Accertamenti_ID", from.getPAQ_Accertamenti_ID());
        realinvoice.setDescription(from.getDescription());
        realinvoice.saveEx();
        MInvoiceLine iline = new MInvoiceLine(realinvoice);
        iline.setC_Activity_ID(0);
        iline.setC_Project_ID(0);
        iline.setDescription(from.getDescription());
        iline.setLineNetAmt(from.getpaq_liqattive_importo());
        iline.setLineTotalAmt(from.getpaq_liqattive_importo());
        iline.setC_Tax_ID(from.getC_Tax_ID());
        iline.setQty(Env.ONE);
        iline.setPriceEntered(from.getpaq_liqattive_importo());
        iline.setPriceActual(from.getpaq_liqattive_importo());
        iline.setC_Charge_ID(cp.getAccount_ID());
        MCharge charge = this.getOrCreateCharge(cp.getAccount_ID(), from.getC_Tax_ID(), cp);
        iline.setC_Charge_ID(charge.getC_Charge_ID());
        iline.saveEx();
        from.setc_cod_docum_id(realinvoice.getC_Invoice_ID());
        from.set_CustomColumn("PAQ_Processo", "Y");
        from.saveEx();
        return realinvoice;
    }
}

