/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.math.BigDecimal;
import org.compiere.util.Env;

public class PrintDataFunction {
    private BigDecimal m_sum = Env.ZERO;
    private int m_count = 0;
    private int m_totalCount = 0;
    private BigDecimal m_min = null;
    private BigDecimal m_max = null;
    private BigDecimal m_sumSquare = Env.ZERO;
    public static final char F_SUM = 'S';
    public static final char F_MEAN = 'A';
    public static final char F_COUNT = 'C';
    public static final char F_MIN = 'm';
    public static final char F_MAX = 'M';
    public static final char F_VARIANCE = 'V';
    public static final char F_DEVIATION = 'D';
    private static final char[] FUNCTIONS = new char[]{'S', 'A', 'C', 'm', 'M', 'V', 'D'};
    private static final String[] FUNCTION_SYMBOLS = new String[]{" \u03a3", " \u03bc", " \u2116", " \u2193", " \u2191", " \u03c3\u00b2", " \u03c3"};
    private static final String[] FUNCTION_NAMES = new String[]{"Sum", "Mean", "Count", "Min", "Max", "Variance", "Deviation"};

    public void addValue(BigDecimal bd) {
        if (bd != null) {
            this.m_sum = this.m_sum.add(bd);
            ++this.m_count;
            if (this.m_min == null) {
                this.m_min = bd;
            }
            this.m_min = this.m_min.min(bd);
            if (this.m_max == null) {
                this.m_max = bd;
            }
            this.m_max = this.m_max.max(bd);
            this.m_sumSquare = this.m_sumSquare.add(bd.multiply(bd));
        }
        ++this.m_totalCount;
    }

    public BigDecimal getValue(char function) {
        if (function == 'S') {
            return this.m_sum;
        }
        if (function == 'm') {
            return this.m_min;
        }
        if (function == 'M') {
            return this.m_max;
        }
        BigDecimal count = new BigDecimal(this.m_count);
        if (function == 'C') {
            return count;
        }
        if (this.m_count == 0) {
            return Env.ZERO;
        }
        if (function == 'A') {
            BigDecimal mean = this.m_sum.divide(count, 4, 4);
            if (mean.scale() > 4) {
                mean = mean.setScale(4, 4);
            }
            return mean;
        }
        BigDecimal ss = this.m_sum.multiply(this.m_sum);
        ss = ss.divide(count, 4, 4);
        BigDecimal variance = this.m_sumSquare.subtract(ss);
        if (function == 'V') {
            if (variance.scale() > 4) {
                variance = variance.setScale(4, 4);
            }
            return variance;
        }
        BigDecimal deviation = new BigDecimal(Math.sqrt(variance.doubleValue()));
        if (deviation.scale() > 4) {
            deviation = deviation.setScale(4, 4);
        }
        return deviation;
    }

    public void reset() {
        this.m_count = 0;
        this.m_totalCount = 0;
        this.m_sum = Env.ZERO;
        this.m_sumSquare = Env.ZERO;
        this.m_min = null;
        this.m_max = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[").append("Count=").append(this.m_count).append(",").append(this.m_totalCount).append(",Sum=").append(this.m_sum).append(",SumSquare=").append(this.m_sumSquare).append(",Min=").append(this.m_min).append(",Max=").append(this.m_max);
        sb.append("]");
        return sb.toString();
    }

    public static String getFunctionSymbol(char function) {
        for (int i2 = 0; i2 < FUNCTIONS.length; ++i2) {
            if (FUNCTIONS[i2] != function) continue;
            return FUNCTION_SYMBOLS[i2];
        }
        return "UnknownFunction=" + function;
    }

    public static String getFunctionName(char function) {
        for (int i2 = 0; i2 < FUNCTIONS.length; ++i2) {
            if (FUNCTIONS[i2] != function) continue;
            return FUNCTION_NAMES[i2];
        }
        return "UnknownFunction=" + function;
    }

    public static int getFunctionDisplayType(char function, int displayType) {
        if (function == 'S' || function == 'm' || function == 'M') {
            return displayType;
        }
        if (function == 'C') {
            return 11;
        }
        return 22;
    }
}

