/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.compiere.apps.ConfirmPanel;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MWarehousePrice;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class QueryProduct
extends PosSubPanel
implements ActionListener,
MouseListener,
ListSelectionListener {
    private static final long serialVersionUID = 9172276999827406833L;
    private MiniTable m_table;
    private CPanel northPanel;
    private CScrollPane centerScroll;
    private ConfirmPanel confirm;
    private CTextField f_value;
    private CTextField f_name;
    private CTextField f_upc;
    private CTextField f_sku;
    private CButton f_up;
    private CButton f_down;
    private int m_M_Product_ID;
    private String m_ProductName;
    private BigDecimal m_Price;
    private int m_M_PriceList_Version_ID;
    private int m_M_Warehouse_ID;
    private static CLogger log = CLogger.getCLogger(QueryProduct.class);
    private static ColumnInfo[] s_layout = new ColumnInfo[]{new ColumnInfo(" ", "M_Product_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Value"), "Value", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "Name", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "UPC"), "UPC", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "SKU"), "SKU", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyAvailable"), "QtyAvailable", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "QtyOnHand"), "QtyOnHand", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "PriceStd"), "PriceStd", BigDecimal.class)};
    private static String s_sqlFrom = "RV_WarehousePrice";
    private static String s_sqlWhere = "IsActive='Y'";

    public QueryProduct(PosPanel posPanel) {
        super(posPanel);
    }

    @Override
    protected void init() {
        this.setLayout(new BorderLayout(5, 5));
        this.setVisible(false);
        this.northPanel = new CPanel(new GridBagLayout());
        this.add((Component)this.northPanel, "North");
        this.northPanel.setBorder(new TitledBorder(Msg.getMsg(this.p_ctx, "Query")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = PosSubPanel.INSETS2;
        gbc.gridy = 0;
        gbc.gridx = -1;
        CLabel lvalue = new CLabel(Msg.translate(this.p_ctx, "Value"));
        gbc.anchor = 13;
        this.northPanel.add((Component)lvalue, gbc);
        this.f_value = new CTextField(20);
        lvalue.setLabelFor(this.f_value);
        gbc.anchor = 17;
        this.northPanel.add((Component)this.f_value, gbc);
        this.f_value.addActionListener(this);
        CLabel lupc = new CLabel(Msg.translate(this.p_ctx, "UPC"));
        gbc.anchor = 13;
        this.northPanel.add((Component)lupc, gbc);
        this.f_upc = new CTextField(15);
        lupc.setLabelFor(this.f_upc);
        gbc.anchor = 17;
        this.northPanel.add((Component)this.f_upc, gbc);
        this.f_upc.addActionListener(this);
        gbc.gridy = 1;
        CLabel lname = new CLabel(Msg.translate(this.p_ctx, "Name"));
        gbc.anchor = 13;
        this.northPanel.add((Component)lname, gbc);
        this.f_name = new CTextField(20);
        lname.setLabelFor(this.f_name);
        gbc.anchor = 17;
        this.northPanel.add((Component)this.f_name, gbc);
        this.f_name.addActionListener(this);
        CLabel lsku = new CLabel(Msg.translate(this.p_ctx, "SKU"));
        gbc.anchor = 13;
        this.northPanel.add((Component)lsku, gbc);
        this.f_sku = new CTextField(15);
        lsku.setLabelFor(this.f_sku);
        gbc.anchor = 17;
        this.northPanel.add((Component)this.f_sku, gbc);
        this.f_sku.addActionListener(this);
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.anchor = 13;
        gbc.weightx = 0.1;
        this.f_up = this.createButtonAction("Previous", KeyStroke.getKeyStroke(38, 0));
        this.northPanel.add((Component)this.f_up, gbc);
        gbc.weightx = 0.0;
        this.f_down = this.createButtonAction("Next", KeyStroke.getKeyStroke(40, 0));
        this.northPanel.add((Component)this.f_down, gbc);
        this.confirm = new ConfirmPanel(true, true, true, false, false, false, false);
        this.add((Component)this.confirm, "South");
        this.confirm.addActionListener(this);
        this.m_table = new MiniTable();
        String sql = this.m_table.prepareTable(s_layout, s_sqlFrom, s_sqlWhere, false, "RV_WarehousePrice") + " ORDER BY Margin, QtyAvailable";
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setColumnSelectionAllowed(false);
        this.m_table.setMultiSelection(false);
        this.m_table.addMouseListener(this);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.enableButtons();
        this.centerScroll = new CScrollPane(this.m_table);
        this.add((Component)this.centerScroll, "Center");
    }

    @Override
    protected GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 0.1;
        gbc.weighty = 0.5;
        return gbc;
    }

    @Override
    public void dispose() {
        this.removeAll();
        this.northPanel = null;
        this.centerScroll = null;
        this.confirm = null;
        this.m_table = null;
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.f_value.requestFocus();
        }
    }

    public void setQueryData(int M_PriceList_Version_ID, int M_Warehouse_ID) {
        this.m_M_PriceList_Version_ID = M_PriceList_Version_ID;
        this.m_M_Warehouse_ID = M_Warehouse_ID;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info(e.getActionCommand());
        if ("Refresh".equals(e.getActionCommand()) || e.getSource() == this.f_value || e.getSource() == this.f_upc || e.getSource() == this.f_name || e.getSource() == this.f_sku) {
            this.setResults(MWarehousePrice.find(this.p_ctx, this.m_M_PriceList_Version_ID, this.m_M_Warehouse_ID, this.f_value.getText(), this.f_name.getText(), this.f_upc.getText(), this.f_sku.getText(), null));
            return;
        }
        if ("Reset".equals(e.getActionCommand())) {
            this.f_value.setText(null);
            this.f_name.setText(null);
            this.f_sku.setText(null);
            this.f_upc.setText(null);
            this.setResults(new MWarehousePrice[0]);
            return;
        }
        if ("Previous".equalsIgnoreCase(e.getActionCommand())) {
            int rows = this.m_table.getRowCount();
            if (rows == 0) {
                return;
            }
            int row = this.m_table.getSelectedRow();
            if (--row < 0) {
                row = 0;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            return;
        }
        if ("Next".equalsIgnoreCase(e.getActionCommand())) {
            int rows = this.m_table.getRowCount();
            if (rows == 0) {
                return;
            }
            int row = this.m_table.getSelectedRow();
            if (++row >= rows) {
                row = rows - 1;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            return;
        }
        this.close();
    }

    public void setResults(MWarehousePrice[] results) {
        this.m_table.loadTable(results);
        this.enableButtons();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.enableButtons();
    }

    private void enableButtons() {
        Integer ID2;
        boolean enabled;
        this.m_M_Product_ID = -1;
        this.m_ProductName = null;
        this.m_Price = null;
        int row = this.m_table.getSelectedRow();
        boolean bl = enabled = row != -1;
        if (enabled && (ID2 = this.m_table.getSelectedRowKey()) != null) {
            this.m_M_Product_ID = ID2;
            this.m_ProductName = (String)this.m_table.getValueAt(row, 2);
            this.m_Price = (BigDecimal)this.m_table.getValueAt(row, 7);
        }
        this.confirm.getOKButton().setEnabled(enabled);
        log.fine("M_Product_ID=" + this.m_M_Product_ID + " - " + this.m_ProductName + " - " + this.m_Price);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && this.m_table.getSelectedRow() != -1) {
            this.enableButtons();
            this.close();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void close() {
        log.fine("M_Product_ID=" + this.m_M_Product_ID);
        if (this.m_M_Product_ID > 0) {
            this.p_posPanel.f_product.setM_Product_ID(this.m_M_Product_ID);
            this.p_posPanel.f_curLine.setPrice(this.m_Price);
        } else {
            this.p_posPanel.f_product.setM_Product_ID(0);
            this.p_posPanel.f_curLine.setPrice(Env.ZERO);
        }
        this.p_posPanel.closeQuery(this);
    }
}

