/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalButtonUI;
import org.compiere.plaf.CompiereButtonListener;
import org.compiere.plaf.CompiereLookAndFeel;
import org.compiere.plaf.CompiereUtils;

public class CompiereButtonUI
extends MetalButtonUI {
    private static CompiereButtonUI s_buttonUI = new CompiereButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return s_buttonUI;
    }

    @Override
    public void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        b2.setOpaque(false);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            CompiereUtils.fillRectange((Graphics2D)g, c, CompiereLookAndFeel.ROUND);
        }
        this.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean in;
        super.paint(g, c);
        AbstractButton b2 = (AbstractButton)c;
        ButtonModel model = b2.getModel();
        boolean bl = in = model.isPressed() || model.isSelected();
        if (b2.isBorderPainted()) {
            CompiereUtils.paint3Deffect((Graphics2D)g, c, CompiereLookAndFeel.ROUND, !in);
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b2) {
    }

    boolean isToolBarButton(JComponent c) {
        return c.getParent() instanceof JToolBar;
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b2) {
        return new CompiereButtonListener(b2);
    }
}

