/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.model.GridTabWrapper;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MLookupFactory;
import org.compiere.model.PO;
import org.compiere.model.SetGetModel;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;

public class SetGetUtil {
    private static CLogger s_log = CLogger.getCLogger(SetGetUtil.class);

    public static void updateColumns(SetGetModel model, String[] columnNames, String sql, Object[] params, String trxName) {
        SetGetUtil.updateColumns(new SetGetModel[]{model}, columnNames, sql, params, trxName);
    }

    public static void updateColumns(SetGetModel model, String[] columnNames, String sql, String trxName) {
        SetGetUtil.updateColumns(new SetGetModel[]{model}, columnNames, sql, null, trxName);
    }

    public static void updateColumns(SetGetModel[] models, String[] columnNames, String sql, Object[] params, String trxName) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            DB.setParameters((PreparedStatement)pstmt, params);
            rs = pstmt.executeQuery();
            SetGetUtil.updateColumns(models, columnNames, rs);
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    public static void updateColumns(SetGetModel[] models, String[] columnNames, ResultSet rs) throws SQLException {
        for (SetGetModel model : models) {
            if (CLogMgt.isLevelFinest()) {
                s_log.finest("Model: " + model);
            }
            if (rs.next()) {
                if (columnNames == null) {
                    columnNames = SetGetUtil.getColumnNames(rs);
                }
                for (String columnName : columnNames) {
                    if (Util.isEmpty(columnName)) continue;
                    Object obj = null;
                    boolean ok = false;
                    obj = rs.getObject(columnName);
                    if (obj instanceof Date) {
                        obj = new Timestamp(((Date)obj).getTime());
                    } else if (obj instanceof BigDecimal && columnName.endsWith("_ID")) {
                        obj = ((BigDecimal)obj).intValue();
                    }
                    ok = model.set_AttrValue(columnName, obj);
                    if (!CLogMgt.isLevelFinest()) continue;
                    s_log.finest("columnName=" + columnName + ", value=[" + obj + "][" + (obj != null ? obj.getClass().getName() : "null") + "], ok=" + ok);
                }
                continue;
            }
            s_log.finest("@NoResult@");
            break;
        }
    }

    public static void updateColumns(SetGetModel model, String[] columnNames, ResultSet rs) throws SQLException {
        SetGetUtil.updateColumns(new SetGetModel[]{model}, columnNames, rs);
    }

    private static final String[] getColumnNames(ResultSet rs) throws SQLException {
        if (rs == null) {
            return new String[0];
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int no = rsmd.getColumnCount();
        String[] columnNames = new String[no];
        for (int i = 1; i <= no; ++i) {
            columnNames[i - 1] = rsmd.getColumnName(i).toUpperCase();
        }
        return columnNames;
    }

    public static boolean copyValues(PO to, PO from, String[] includeFields, String[] excludeFields) {
        int no = SetGetUtil.copyValues(to, from, includeFields, excludeFields, false);
        return no >= 0;
    }

    public static int copyChangedValues(PO to, PO from) {
        return SetGetUtil.copyValues(to, from, null, null, true);
    }

    private static int copyValues(PO to, PO from, String[] includeFields, String[] excludeFields, boolean trackOnlyChanges) {
        if (CLogMgt.isLevelFinest()) {
            s_log.finest("Entering: From=" + from + " - To=" + to);
        }
        if (to == null || from == null) {
            if (CLogMgt.isLevelFinest()) {
                s_log.finest("Leaving: to == null || from == null");
                Thread.dumpStack();
            }
            return -1;
        }
        if (includeFields != null) {
            excludeFields = null;
        }
        if (includeFields == null && excludeFields == null) {
            excludeFields = new String[]{"#"};
        }
        int copiedFields = 0;
        for (int idx_from = 0; idx_from < from.get_ColumnCount(); ++idx_from) {
            int i$;
            String colName = from.p_info.getColumnName(idx_from);
            boolean isExcluded = false;
            if ("Created".equals(colName) || "CreatedBy".equals(colName) || "Updated".equals(colName) || "UpdatedBy".equals(colName) || "IsActive".equals(colName) || "AD_Client_ID".equals(colName) || "AD_Org_ID".equals(colName)) {
                isExcluded = true;
            } else if (includeFields != null) {
                isExcluded = true;
                String[] arr$ = includeFields;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String incl = arr$[i$];
                    if (!incl.equalsIgnoreCase(colName)) continue;
                    isExcluded = false;
                    break;
                }
            } else if (excludeFields != null) {
                String[] arr$ = excludeFields;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String excl = arr$[i$];
                    if (!excl.equalsIgnoreCase(colName)) continue;
                    isExcluded = true;
                    break;
                }
            }
            if (isExcluded) {
                if (!CLogMgt.isLevelFinest()) continue;
                s_log.finest("Field " + colName + " [SKIP:excluded]");
                continue;
            }
            int idx_to = to.get_ColumnIndex(colName);
            if (idx_to < 0) {
                if (!CLogMgt.isLevelFinest()) continue;
                s_log.finest("Field " + colName + " [SKIP:idx_to < 0]");
                continue;
            }
            if (to.p_info.isVirtualColumn(idx_to) || to.p_info.isKey(idx_to)) {
                if (!CLogMgt.isLevelFinest()) continue;
                s_log.finest("Field " + colName + " [SKIP:virtual or key]");
                continue;
            }
            Object value = from.get_Value(idx_from);
            to.set_Value(idx_to, value);
            if (!trackOnlyChanges || from.is_ValueChanged(idx_from)) {
                ++copiedFields;
            }
            if (!CLogMgt.isLevelFinest()) continue;
            s_log.finest("Field " + colName + "=[" + value + "], idx=" + idx_from + "->" + idx_to);
        }
        if (CLogMgt.isLevelFinest()) {
            s_log.finest("Leaving: to=" + to);
        }
        return copiedFields;
    }

    public static boolean copyValues(SetGetModel to, String from_tableName, int from_id, String[] includeFields) {
        if (to == null || from_tableName == null || from_id <= 0 || includeFields == null || includeFields.length == 0) {
            return false;
        }
        StringBuffer sql = new StringBuffer();
        for (String f : includeFields) {
            if (sql.length() > 0) {
                sql.append(",");
            }
            sql.append(f);
        }
        sql.insert(0, "SELECT ");
        sql.append(" FROM ").append(from_tableName).append(" WHERE ").append(from_tableName).append("_ID=").append(from_id);
        SetGetUtil.updateColumns(to, includeFields, sql.toString(), null);
        return true;
    }

    public static int get_AttrValueAsInt(SetGetModel model, String name) {
        Object o = model.get_AttrValue(name);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return 0;
    }

    public static Timestamp get_AttrValueAsDate(SetGetModel model, String name) {
        Object o = model.get_AttrValue(name);
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        return null;
    }

    public static BigDecimal get_AttrValueAsBigDecimal(SetGetModel model, String name) {
        Object o = model.get_AttrValue(name);
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        return BigDecimal.ZERO;
    }

    public static boolean get_AttrValueAsBoolean(SetGetModel model, String name) {
        Object o = model.get_AttrValue(name);
        if (o != null) {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return "Y".equals(o);
        }
        return false;
    }

    public static String get_AttrValueAsString(SetGetModel model, String name, String valueIfNull) {
        Object o = model.get_AttrValue(name);
        if (o == null) {
            return valueIfNull;
        }
        return o.toString();
    }

    public static void set_AttrValueEx(SetGetModel model, String name, Object value) {
        if (!model.set_AttrValue(name, value)) {
            throw new AdempiereException("Value not set " + name + "=" + value);
        }
    }

    public static boolean is_ValueChanged(SetGetModel model, String ... propertyNames) {
        for (String name : propertyNames) {
            if (!model.is_AttrValueChanged(name)) continue;
            return true;
        }
        return false;
    }

    public static String getTrxName(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof SetGetModel) {
            return ((SetGetModel)o).get_TrxName();
        }
        if (o instanceof PO) {
            return ((PO)o).get_TrxName();
        }
        return null;
    }

    public static boolean isUserEntry(Object o) {
        if (o == null) {
            return false;
        }
        return !(o instanceof PO);
    }

    public static void setLineNo(SetGetModel model, String parentColumnName, String lineColumnName) {
        int lineNo;
        if (lineColumnName == null) {
            lineColumnName = "Line";
        }
        if ((lineNo = SetGetUtil.get_AttrValueAsInt(model, lineColumnName)) != 0) {
            return;
        }
        String tableName = model.get_TableName();
        String idColumnName = tableName + "_ID";
        ArrayList<Comparable<Boolean>> params = new ArrayList<Comparable<Boolean>>();
        StringBuffer sql = new StringBuffer("SELECT COALESCE(MAX(" + lineColumnName + "),0)+10");
        sql.append(" FROM ").append(tableName);
        sql.append(" WHERE IsActive=?");
        params.add(Boolean.valueOf(true));
        sql.append(" AND AD_Client_ID IN (0,?)");
        params.add(Integer.valueOf(SetGetUtil.get_AttrValueAsInt(model, "AD_Client_ID")));
        sql.append(" AND ").append(idColumnName).append("<>?");
        params.add(Integer.valueOf(SetGetUtil.get_AttrValueAsInt(model, idColumnName)));
        if (parentColumnName != null) {
            sql.append(" AND ").append(parentColumnName).append("=?");
            params.add(Integer.valueOf(SetGetUtil.get_AttrValueAsInt(model, parentColumnName)));
        }
        lineNo = DB.getSQLValueEx(model.get_TrxName(), sql.toString(), new Object[]{params});
        model.set_AttrValue(lineColumnName, lineNo);
    }

    public static String getTableName(Class<? extends PO> clazz) {
        try {
            return (String)clazz.getField("Table_Name").get(null);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    public static final boolean isPersistent(Object o) {
        return o != null && o instanceof PO;
    }

    public static Properties getCtx(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof SetGetModel) {
            return ((SetGetModel)o).getCtx();
        }
        if (o instanceof PO) {
            return ((PO)o).getCtx();
        }
        return Env.getCtx();
    }

    public static SetGetModel wrap(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof SetGetModel && !(o instanceof Proxy)) {
            return (SetGetModel)o;
        }
        if (o instanceof Proxy && Proxy.getInvocationHandler(o) instanceof GridTabWrapper) {
            GridTabWrapper gtw = (GridTabWrapper)Proxy.getInvocationHandler(o);
            return new GridTab2SetGetModelWrapper(gtw.getGridTab());
        }
        if (o instanceof GridTab) {
            return new GridTab2SetGetModelWrapper((GridTab)o);
        }
        if (o instanceof PO) {
            final PO po = (PO)o;
            return new SetGetModel(){

                @Override
                public boolean set_AttrValue(String name, Object value) {
                    return po.set_Value(name, value);
                }

                @Override
                public boolean is_AttrValueChanged(String ColumnName) {
                    return po.is_ValueChanged(ColumnName);
                }

                @Override
                public String get_TrxName() {
                    return po.get_TrxName();
                }

                @Override
                public int get_Table_ID() {
                    return po.get_Table_ID();
                }

                @Override
                public String get_TableName() {
                    return po.get_TableName();
                }

                @Override
                public Object get_AttrValue(String name) {
                    return po.get_Value(name);
                }

                @Override
                public Properties getCtx() {
                    return po.getCtx();
                }

                @Override
                public boolean hasColumn(String sColumnName) {
                    boolean bExists = false;
                    int index = po.get_ColumnIndex(sColumnName);
                    if (index >= 0) {
                        bExists = true;
                    }
                    return bExists;
                }
            };
        }
        throw new IllegalArgumentException("Can not wrap to SetGetModel - " + o.getClass());
    }

    public static <T> T newInstance(Properties ctx, Class<T> clazz, String trxName) {
        try {
            return clazz.getConstructor(Properties.class, Integer.TYPE, String.class).newInstance(ctx, 0, trxName);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    public static void appendValue(SetGetModel model, String columnName, String value) {
        if (Util.isEmpty(value, true)) {
            return;
        }
        String valueToAppend = value.trim();
        String valueOld = SetGetUtil.get_AttrValueAsString(model, columnName, null);
        String valueNew = Util.isEmpty(valueOld, true) ? value : valueOld + " | " + valueToAppend;
        model.set_AttrValue(columnName, valueNew);
    }

    public static String getInfoString(Properties ctx, String tableName, int id, String trxName) {
        Language language = Env.getLanguage(ctx);
        String sql = MLookupFactory.getLookup_TableDirEmbed(language, tableName + "_ID", "[?", "?]").replace("[?.?]", "?");
        String docInfo = DB.getSQLValueStringEx(trxName, sql, id);
        if (Util.isEmpty(docInfo)) {
            docInfo = "<" + tableName + ":" + id + ">";
        }
        return docInfo;
    }

    private static class GridTab2SetGetModelWrapper
    implements SetGetModel {
        private final GridTab tab;

        GridTab2SetGetModelWrapper(GridTab tab) {
            this.tab = tab;
        }

        @Override
        public Properties getCtx() {
            return Env.getCtx();
        }

        @Override
        public Object get_AttrValue(String name) {
            return this.tab.getValue(name);
        }

        @Override
        public String get_TableName() {
            return this.tab.getTableName();
        }

        @Override
        public int get_Table_ID() {
            return this.tab.getAD_Table_ID();
        }

        @Override
        public String get_TrxName() {
            return null;
        }

        @Override
        public boolean is_AttrValueChanged(String ColumnName) {
            return false;
        }

        @Override
        public boolean set_AttrValue(String name, Object value) {
            String errmsg = this.tab.setValue(name, value);
            return errmsg == null || errmsg.length() <= 0;
        }

        @Override
        public boolean hasColumn(String sColumnName) {
            boolean bExists = false;
            GridField field = this.tab.getField(sColumnName);
            if (field != null) {
                bExists = true;
            }
            return bExists;
        }
    }
}

