/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.Timestamp;
import org.compiere.model.MQuery;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.ValueNamePair;

class Restriction
implements Serializable {
    private static final long serialVersionUID = -4521978087587321243L;
    protected String DirectWhereClause = null;
    protected String ColumnName;
    protected String InfoName;
    protected String Operator;
    protected Object Code;
    protected String InfoDisplay;
    protected Object Code_to;
    protected String InfoDisplay_to;
    protected boolean andCondition = true;
    protected int joinDepth = 0;

    Restriction(String columnName, String operator, Object code, String infoName, String infoDisplay, boolean andCondition, int depth) {
        this.ColumnName = columnName.trim();
        this.InfoName = infoName != null ? infoName : this.ColumnName;
        this.andCondition = andCondition;
        this.joinDepth = depth < 0 ? 0 : depth;
        this.Operator = operator;
        this.Code = code instanceof Boolean ? ((Boolean)code != false ? "Y" : "N") : (code instanceof KeyNamePair ? new Integer(((KeyNamePair)code).getKey()) : (code instanceof ValueNamePair ? ((ValueNamePair)code).getValue() : code));
        if (this.Code instanceof String) {
            if (this.Code.toString().startsWith("'")) {
                this.Code = this.Code.toString().substring(1);
            }
            if (this.Code.toString().endsWith("'")) {
                this.Code = this.Code.toString().substring(0, this.Code.toString().length() - 2);
            }
        }
        if (infoDisplay != null) {
            this.InfoDisplay = infoDisplay.trim();
        } else if (code != null) {
            this.InfoDisplay = code.toString();
        }
    }

    Restriction(String columnName, Object code, Object code_to, String infoName, String infoDisplay, String infoDisplay_to, boolean andCondition, int depth) {
        this(columnName, " BETWEEN ", code, infoName, infoDisplay, andCondition, depth);
        this.Code_to = code_to;
        if (this.Code_to instanceof String) {
            if (this.Code_to.toString().startsWith("'")) {
                this.Code_to = this.Code_to.toString().substring(1);
            }
            if (this.Code_to.toString().endsWith("'")) {
                this.Code_to = this.Code_to.toString().substring(0, this.Code_to.toString().length() - 2);
            }
        }
        if (infoDisplay_to != null) {
            this.InfoDisplay_to = infoDisplay_to.trim();
        } else if (this.Code_to != null) {
            this.InfoDisplay_to = this.Code_to.toString();
        }
    }

    Restriction(String whereClause, boolean andCondition, int depth) {
        this.DirectWhereClause = whereClause;
        this.andCondition = andCondition;
        this.joinDepth = depth;
    }

    public String getSQL(String tableName) {
        if (this.DirectWhereClause != null) {
            return this.DirectWhereClause;
        }
        StringBuffer sb = new StringBuffer();
        if (tableName != null && tableName.length() > 0) {
            int pos = this.ColumnName.lastIndexOf(40) + 1;
            int end = this.ColumnName.indexOf(41);
            if (pos != -1 && end != -1) {
                sb.append(this.ColumnName.substring(0, pos)).append(tableName).append(".").append(this.ColumnName.substring(pos, end)).append(this.ColumnName.substring(end));
            } else {
                sb.append(tableName).append(".").append(this.ColumnName);
            }
        } else {
            sb.append(this.ColumnName);
        }
        if ((this.Operator.equals("=") || this.Operator.equals("!=")) && (this.Code == null || "NULL".equals(this.Code.toString().toUpperCase()))) {
            if (this.Operator.equals("=")) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" IS NOT NULL ");
            }
        } else {
            sb.append(this.Operator);
            if (this.Code instanceof String) {
                sb.append(DB.TO_STRING(this.Code.toString()));
            } else if (this.Code instanceof Timestamp) {
                sb.append(DB.TO_DATE((Timestamp)this.Code));
            } else {
                sb.append(this.Code);
            }
            if (" BETWEEN ".equals(this.Operator)) {
                sb.append(" AND ");
                if (this.Code_to instanceof String) {
                    sb.append(DB.TO_STRING(this.Code_to.toString()));
                } else if (this.Code_to instanceof Timestamp) {
                    sb.append(DB.TO_DATE((Timestamp)this.Code_to));
                } else {
                    sb.append(this.Code_to);
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.getSQL(null);
    }

    public String getInfoName() {
        return this.InfoName;
    }

    public String getInfoOperator() {
        for (int i2 = 0; i2 < MQuery.OPERATORS.length; ++i2) {
            if (!MQuery.OPERATORS[i2].getValue().equals(this.Operator)) continue;
            return MQuery.OPERATORS[i2].getName();
        }
        return this.Operator;
    }

    public String getInfoDisplayAll() {
        if (this.InfoDisplay_to == null) {
            return this.InfoDisplay;
        }
        StringBuffer sb = new StringBuffer(this.InfoDisplay);
        sb.append(" - ").append(this.InfoDisplay_to);
        return sb.toString();
    }
}

