/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.PaymentProcessor;
import org.compiere.util.CLogMgt;

public class PP_Optimal
extends PaymentProcessor
implements Serializable {
    private static final long serialVersionUID = -3588486265248400291L;
    private boolean m_ok = false;
    private static final String _CLIENT_VERSION = "1.1";
    protected static final String MERCHANT_ID = "merchantId";
    protected static final String MERCHANT_PWD = "merchantPwd";
    protected static final String ACCOUNT_ID = "account";
    protected static final String CIPHER = "Cipher";
    protected static final String PAYMENT_SERVER = "PaymentServerURL";
    protected static final String PAYMENT_SERVER_PORT = "PaymentServerPort";
    protected static final String PROXY_SERVER = "ProxyServer";
    protected static final String PROXY_PORT = "ProxyPort";
    protected static final String PROXY_USERID = "ProxyUserId";
    protected static final String PROXY_PWD = "ProxyPwd";
    protected static final String ACTIVE_RECOVERY = "ActiveRecovery";
    protected static final String HTTPVERSION = "HTTPVersion";
    protected static final String RETRIES = "Retries";
    protected static final String TIMEOUT = "Timeout";
    protected static final String LOGLEVEL = "LogLevel";
    protected static final String LOG_BASE_PATH = "LogBasePath";
    protected static final String LOG_FILENAME = "LogFilename";
    protected static final String LOG_MAX_SIZE = "LogMaxSize";
    protected static final String LOG_MAX_BACKUP = "LogMaxBackupFiles";
    protected static final String MERCHANT_TXN = "merchantTxn";
    protected static final String MERCHANT_DATA = "merchantData";
    protected static final String CLIENT_VERSION = "clientVersion";
    protected static final String TXN_NUMBER = "txnNumber";
    protected static final String CARD_NUMBER = "cardNumber";
    protected static final String CARD_EXPIRATION = "cardExp";
    protected static final String CARD_TYPE = "cardType";
    protected static final String STREET = "streetAddr";
    protected static final String STREET2 = "streetAddr2";
    protected static final String EMAIL = "email";
    protected static final String PHONE = "phone";
    protected static final String PROVINCE = "province";
    protected static final String COUNTRY = "country";
    protected static final String CITY = "city";
    protected static final String ZIP = "zip";
    protected static final String CVD_INDICATOR = "cvdIndicator";
    protected static final String CVD_INDICATOR_None = "0";
    protected static final String CVD_INDICATOR_Provided = "1";
    protected static final String CVD_VALUE = "cvdValue";
    protected static final String CVD_INFO = "cvdInfo";
    protected static final String CUST_NAME1 = "custName1";
    protected static final String CUST_NAME2 = "custName2";
    protected static final String STATUS = "status";
    protected static final String TXN_TYPE = "txnType";
    protected static final String AMOUNT = "amount";
    protected static final String CURRENT_AMOUNT = "curAmount";
    protected static final String ERROR_CODE = "errCode";
    protected static final String ERROR_STRING = "errString";
    protected static final String SUB_ERROR = "subError";
    protected static final String SUB_ERROR_STRING = "subErrorString";
    protected static final String AUTH_CODE = "authCode";
    protected static final String AUTH_TIME = "authTime";
    protected static final String AVS_INFO = "avsInfo";
    protected static final String QUERY_OPERATION = "Q";
    protected static final String FAILURE_LOOKUP_OPERATION = "FT";
    protected static final String OPERATION = "operation";
    protected static final String OPERATION_Purchase = "P";
    protected static final String OPERATION_Authorization = "A";
    protected static final String OPERATION_Settlement = "S";
    protected static final String STATUS_SEARCH_COMPLETED = "status=C";
    protected static final String REQUEST_PENDING = "status=P";
    protected static final String REQUEST_COMPLETE = "status=C";
    protected static final String REQUEST_FAILED = "status=F";
    protected static final String AUTHORIZATION_COMPLETE = "status=A";
    protected static final String AUTHORIZATION_FAILED = "status=AF";
    protected static final String SETTLEMENT_COMPLETE = "status=S";
    protected static final String SETTLEMENT_FAILED = "status=SF";
    protected static final String MANUAL_INTERVENTION = "status=M";
    protected static final String REQUEST_ABORTED = "status=AB";
    protected static final String REQUEST_NOT_FOUND = "status=NF";
    protected static final String UNKNOWN_TYPE = "status=U";
    protected static final String REQUEST_ERROR = "status=E";
    protected static Properties AVSCodes = new Properties();
    protected static Properties CARDTypes = new Properties();
    protected static Properties CVDInfo = new Properties();

    public String getVersion() {
        return "Optimal 1.1";
    }

    @Override
    public boolean processCC() throws IllegalArgumentException {
        this.log.fine(this.p_mpp.getHostAddress() + ":" + this.p_mpp.getHostPort() + ", Timeout=" + this.getTimeout() + "; Proxy=" + this.p_mpp.getProxyAddress() + ":" + this.p_mpp.getProxyPort() + " " + this.p_mpp.getProxyLogon() + " " + this.p_mpp.getProxyPassword());
        this.setEncoded(true);
        String urlString = this.p_mpp.getHostAddress();
        if (this.p_mpp.getHostPort() != 0) {
            urlString = urlString + ":" + this.p_mpp.getHostPort();
        }
        StringBuffer param = new StringBuffer(200);
        param.append(this.createPair(MERCHANT_ID, this.p_mpp.getUserID(), 80)).append('&').append(this.createPair(MERCHANT_PWD, this.p_mpp.getPassword(), 20)).append('&').append(this.createPair(ACCOUNT_ID, this.p_mpp.getPartnerID(), 10));
        param.append('&').append(this.createPair(CARD_TYPE, "VI", 6));
        param.append('&').append(this.createPair(CARD_NUMBER, this.p_mp.getCreditCardNumber(), 19));
        param.append('&').append(this.createPair(CARD_EXPIRATION, this.p_mp.getCreditCardExp("/"), 5));
        param.append('&').append(this.createPair(AMOUNT, this.p_mp.getPayAmtInCents(), 10));
        param.append('&').append(this.createPair(OPERATION, OPERATION_Purchase, 1));
        param.append('&').append(this.createPair(MERCHANT_TXN, this.p_mp.getC_Payment_ID(), 255));
        param.append('&').append(this.createPair(CLIENT_VERSION, _CLIENT_VERSION, 4));
        param.append('&').append(this.createPair(CUST_NAME1, this.p_mp.getA_Name(), 255));
        param.append('&').append(this.createPair(STREET, this.p_mp.getA_Street(), 255));
        param.append('&').append(this.createPair(CITY, this.p_mp.getA_City(), 255));
        param.append('&').append(this.createPair(PROVINCE, this.p_mp.getA_State(), 2));
        param.append('&').append(this.createPair(ZIP, this.p_mp.getA_Zip(), 10));
        param.append('&').append(this.createPair(COUNTRY, this.p_mp.getA_Country(), 2));
        param.append('&').append(this.createPair("&email", this.p_mp.getA_EMail(), 40));
        param.append('&').append(this.createPair(CVD_INDICATOR, CVD_INDICATOR_Provided, 1));
        param.append('&').append(this.createPair(CVD_VALUE, "123", 4));
        try {
            this.log.fine("-> " + param.toString());
            Properties prop = this.getConnectPostProperties(urlString, param.toString());
            boolean bl = this.m_ok = prop != null;
            if (this.m_ok) {
                String status = prop.getProperty(STATUS);
                this.m_ok = status != null && status.equals("SP");
                String authCode = prop.getProperty(AUTH_CODE);
                String authTime = prop.getProperty(AUTH_TIME);
                String errCode = prop.getProperty(ERROR_CODE);
                String errString = prop.getProperty(ERROR_STRING);
                String subError = prop.getProperty(SUB_ERROR);
                String subErrorString = prop.getProperty(SUB_ERROR_STRING);
                String actionCode = prop.getProperty("actionCode");
                String authorisedAmount = prop.getProperty(CURRENT_AMOUNT);
                String amount = prop.getProperty(AMOUNT);
                String avsInfo = prop.getProperty(AVS_INFO);
                String cvdInfo = prop.getProperty(CVD_INFO);
                this.log.fine("<- Status=" + status + ", AuthCode=" + authCode + ", Error=" + errString);
            }
            if (!this.m_ok) {
                this.log.warning("<- " + prop);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, param.toString(), e);
            this.m_ok = false;
        }
        return this.m_ok;
    }

    @Override
    public boolean isProcessedOK() {
        return this.m_ok;
    }

    public static void main(String[] args) {
        CLogMgt.initialize(true);
        CLogMgt.setLevel(Level.ALL);
        PP_Optimal pp = new PP_Optimal();
        pp.processCC();
        pp.isProcessedOK();
    }

    static {
        AVSCodes.put("X", "Exact. Nine digit zip and address match");
        AVSCodes.put("Y", "Yes. Five digit zip and address match");
        AVSCodes.put(OPERATION_Authorization, "Address matches, Zip not");
        AVSCodes.put("W", "Nine digit zip matches, address not");
        AVSCodes.put("Z", "Five digit zip matches, address not");
        AVSCodes.put("N", "No Part matches");
        AVSCodes.put("U", "Address info unabailable");
        AVSCodes.put("R", "Retry");
        AVSCodes.put(OPERATION_Settlement, "AVS not supported");
        AVSCodes.put("E", "AVS not supported for this industry");
        AVSCodes.put("B", "AVS not performed");
        AVSCodes.put(QUERY_OPERATION, "Unknown response from issuer");
        CARDTypes.put("AMEX", "AM");
        CARDTypes.put("DINERS", "DI");
        CARDTypes.put("VISA", "VI");
        CVDInfo.put("M", "Match");
        CVDInfo.put("N", "No Match");
        CVDInfo.put(OPERATION_Purchase, "Not Processed");
        CVDInfo.put(OPERATION_Settlement, "Not Present");
        CVDInfo.put("U", "Issuer not certified");
    }
}

