/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.POInfoColumn;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class POInfo
implements Serializable {
    static final long serialVersionUID = -5976719579744948419L;
    private static CCache<Integer, POInfo> s_cache = new CCache("POInfo", 200);
    private Properties m_ctx = null;
    private int m_AD_Table_ID = 0;
    private String m_TableName = null;
    private String m_AccessLevel = "1";
    private POInfoColumn[] m_columns = null;
    private boolean m_hasKeyColumn = false;
    private boolean m_IsChangeLog = false;

    public static POInfo getPOInfo(Properties ctx, int AD_Table_ID) {
        return POInfo.getPOInfo(ctx, AD_Table_ID, null);
    }

    public static POInfo getPOInfo(Properties ctx, int AD_Table_ID, String trxName) {
        Integer key = new Integer(AD_Table_ID);
        POInfo retValue = s_cache.get(key);
        if (retValue == null) {
            retValue = new POInfo(ctx, AD_Table_ID, false, trxName);
            if (retValue.getColumnCount() == 0) {
                retValue = new POInfo(ctx, AD_Table_ID, true, trxName);
            } else {
                s_cache.put(key, retValue);
            }
        }
        return retValue;
    }

    private POInfo(Properties ctx, int AD_Table_ID, boolean baseLanguageOnly) {
        this(ctx, AD_Table_ID, baseLanguageOnly, null);
    }

    private POInfo(Properties ctx, int AD_Table_ID, boolean baseLanguageOnly, String trxName) {
        this.m_ctx = ctx;
        this.m_AD_Table_ID = AD_Table_ID;
        boolean baseLanguage = baseLanguageOnly ? true : Env.isBaseLanguage(this.m_ctx, "AD_Table");
        this.loadInfo(baseLanguage, trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInfo(boolean baseLanguage, String trxName) {
        ArrayList<POInfoColumn> list = new ArrayList<POInfoColumn>(15);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT t.TableName, c.ColumnName,c.AD_Reference_ID,c.IsMandatory,c.IsUpdateable,c.DefaultValue,e.Name,e.Description, c.AD_Column_ID, c.IsKey,c.IsParent, c.AD_Reference_Value_ID, vr.Code, c.FieldLength, c.ValueMin, c.ValueMax, c.IsTranslated, t.AccessLevel, c.ColumnSQL, c.IsEncrypted, c.IsAllowLogging,t.IsChangeLog ");
        sql.append("FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) LEFT OUTER JOIN AD_Val_Rule vr ON (c.AD_Val_Rule_ID=vr.AD_Val_Rule_ID) INNER JOIN AD_Element");
        if (!baseLanguage) {
            sql.append("_Trl");
        }
        sql.append(" e  ON (c.AD_Element_ID=e.AD_Element_ID) WHERE t.AD_Table_ID=? AND c.IsActive='Y'");
        if (!baseLanguage) {
            sql.append(" AND e.AD_Language='").append(Env.getAD_Language(this.m_ctx)).append("'");
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), trxName);
            pstmt.setInt(1, this.m_AD_Table_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (this.m_TableName == null) {
                    this.m_TableName = rs.getString(1);
                }
                String ColumnName = rs.getString(2);
                int AD_Reference_ID = rs.getInt(3);
                boolean IsMandatory = "Y".equals(rs.getString(4));
                boolean IsUpdateable = "Y".equals(rs.getString(5));
                String DefaultLogic = rs.getString(6);
                String Name2 = rs.getString(7);
                String Description2 = rs.getString(8);
                int AD_Column_ID = rs.getInt(9);
                boolean IsKey = "Y".equals(rs.getString(10));
                if (IsKey) {
                    this.m_hasKeyColumn = true;
                }
                boolean IsParent = "Y".equals(rs.getString(11));
                int AD_Reference_Value_ID = rs.getInt(12);
                String ValidationCode = rs.getString(13);
                int FieldLength = rs.getInt(14);
                String ValueMin = rs.getString(15);
                String ValueMax = rs.getString(16);
                boolean IsTranslated = "Y".equals(rs.getString(17));
                this.m_AccessLevel = rs.getString(18);
                String ColumnSQL = rs.getString(19);
                boolean IsEncrypted = "Y".equals(rs.getString(20));
                boolean IsAllowLogging = "Y".equals(rs.getString(21));
                this.m_IsChangeLog = "Y".equals(rs.getString(22));
                POInfoColumn col = new POInfoColumn(AD_Column_ID, ColumnName, ColumnSQL, AD_Reference_ID, IsMandatory, IsUpdateable, DefaultLogic, Name2, Description2, IsKey, IsParent, AD_Reference_Value_ID, ValidationCode, FieldLength, ValueMin, ValueMax, IsTranslated, IsEncrypted, IsAllowLogging);
                list.add(col);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            CLogger.get().log(Level.SEVERE, sql.toString(), e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_columns = new POInfoColumn[list.size()];
        list.toArray(this.m_columns);
    }

    public String toString() {
        return "POInfo[" + this.getTableName() + ",AD_Table_ID=" + this.getAD_Table_ID() + "]";
    }

    public String toString(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return "POInfo[" + this.getTableName() + "-(InvalidColumnIndex=" + index + ")]";
        }
        return "POInfo[" + this.getTableName() + "-" + this.m_columns[index].toString() + "]";
    }

    public String getTableName() {
        return this.m_TableName;
    }

    public int getAD_Table_ID() {
        return this.m_AD_Table_ID;
    }

    public boolean hasKeyColumn() {
        return this.m_hasKeyColumn;
    }

    public String getAccessLevel() {
        return this.m_AccessLevel;
    }

    public int getColumnCount() {
        return this.m_columns.length;
    }

    public int getColumnIndex(String ColumnName) {
        for (int i2 = 0; i2 < this.m_columns.length; ++i2) {
            if (!ColumnName.equalsIgnoreCase(this.m_columns[i2].ColumnName)) continue;
            return i2;
        }
        return -1;
    }

    public int getColumnIndex(int AD_Column_ID) {
        for (int i2 = 0; i2 < this.m_columns.length; ++i2) {
            if (AD_Column_ID != this.m_columns[i2].AD_Column_ID) continue;
            return i2;
        }
        return -1;
    }

    public int getAD_Column_ID(String columnName) {
        for (int i2 = 0; i2 < this.m_columns.length; ++i2) {
            if (!columnName.equalsIgnoreCase(this.m_columns[i2].ColumnName)) continue;
            return this.m_columns[i2].AD_Column_ID;
        }
        return -1;
    }

    protected POInfoColumn getColumn(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return null;
        }
        return this.m_columns[index];
    }

    public String getColumnName(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return null;
        }
        return this.m_columns[index].ColumnName;
    }

    public String getColumnSQL(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return null;
        }
        if (this.m_columns[index].ColumnSQL != null && this.m_columns[index].ColumnSQL.length() > 0) {
            return this.m_columns[index].ColumnSQL + " AS " + this.m_columns[index].ColumnName;
        }
        return this.m_columns[index].ColumnName;
    }

    public boolean isVirtualColumn(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return true;
        }
        return this.m_columns[index].ColumnSQL != null && this.m_columns[index].ColumnSQL.length() > 0;
    }

    public String getColumnLabel(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return null;
        }
        return this.m_columns[index].ColumnLabel;
    }

    public String getColumnDescription(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return null;
        }
        return this.m_columns[index].ColumnDescription;
    }

    public Class<?> getColumnClass(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return null;
        }
        return this.m_columns[index].ColumnClass;
    }

    public int getColumnDisplayType(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return 10;
        }
        return this.m_columns[index].DisplayType;
    }

    public String getDefaultLogic(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return null;
        }
        return this.m_columns[index].DefaultLogic;
    }

    public boolean isColumnMandatory(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return false;
        }
        return this.m_columns[index].IsMandatory;
    }

    public boolean isColumnUpdateable(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return false;
        }
        return this.m_columns[index].IsUpdateable;
    }

    public void setColumnUpdateable(int index, boolean updateable) {
        if (index < 0 || index >= this.m_columns.length) {
            return;
        }
        this.m_columns[index].IsUpdateable = updateable;
    }

    public void setUpdateable(boolean updateable) {
        for (int i2 = 0; i2 < this.m_columns.length; ++i2) {
            this.m_columns[i2].IsUpdateable = updateable;
        }
    }

    public boolean isColumnLookup(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return false;
        }
        return DisplayType.isLookup(this.m_columns[index].DisplayType);
    }

    public Lookup getColumnLookup(int index) {
        if (!this.isColumnLookup(index)) {
            return null;
        }
        int WindowNo = 0;
        MLookup lookup = null;
        try {
            lookup = MLookupFactory.get(this.m_ctx, WindowNo, this.m_columns[index].AD_Column_ID, this.m_columns[index].DisplayType, Env.getLanguage(this.m_ctx), this.m_columns[index].ColumnName, this.m_columns[index].AD_Reference_Value_ID, this.m_columns[index].IsParent, this.m_columns[index].ValidationCode);
        }
        catch (Exception e) {
            lookup = null;
        }
        return lookup;
    }

    public boolean isKey(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return false;
        }
        return this.m_columns[index].IsKey;
    }

    public boolean isColumnParent(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return false;
        }
        return this.m_columns[index].IsParent;
    }

    public boolean isColumnTranslated(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return false;
        }
        return this.m_columns[index].IsTranslated;
    }

    public boolean isTranslated() {
        for (int i2 = 0; i2 < this.m_columns.length; ++i2) {
            if (!this.m_columns[i2].IsTranslated) continue;
            return true;
        }
        return false;
    }

    public boolean isEncrypted(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return false;
        }
        return this.m_columns[index].IsEncrypted;
    }

    public boolean isAllowLogging(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return false;
        }
        return this.m_columns[index].IsAllowLogging;
    }

    public int getFieldLength(int index) {
        if (index < 0 || index >= this.m_columns.length) {
            return 0;
        }
        return this.m_columns[index].FieldLength;
    }

    public int getFieldLength(String columnName) {
        int index = this.getColumnIndex(columnName);
        if (index >= 0) {
            return this.getFieldLength(index);
        }
        return 0;
    }

    public String validate(int index, Object value) {
        BigDecimal value_BD;
        if (index < 0 || index >= this.m_columns.length) {
            return "RangeError";
        }
        if (this.m_columns[index].IsMandatory && value == null) {
            return "IsMandatory";
        }
        if (value == null) {
            return null;
        }
        if (this.m_columns[index].ValueMin != null) {
            int comp;
            value_BD = null;
            try {
                if (this.m_columns[index].ValueMin_BD != null) {
                    value_BD = new BigDecimal(value.toString());
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.m_columns[index].ValueMin_BD != null && value_BD != null) {
                comp = this.m_columns[index].ValueMin_BD.compareTo(value_BD);
                if (comp > 0) {
                    return "MinValue=" + this.m_columns[index].ValueMin_BD + "(" + this.m_columns[index].ValueMin + ")" + " - compared with Numeric Value=" + value_BD + "(" + value + ")" + " - results in " + comp;
                }
            } else {
                comp = this.m_columns[index].ValueMin.compareTo(value.toString());
                if (comp > 0) {
                    return "MinValue=" + this.m_columns[index].ValueMin + " - compared with String Value=" + value + " - results in " + comp;
                }
            }
        }
        if (this.m_columns[index].ValueMax != null) {
            value_BD = null;
            try {
                if (this.m_columns[index].ValueMax_BD != null) {
                    value_BD = new BigDecimal(value.toString());
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.m_columns[index].ValueMax_BD != null && value_BD != null) {
                int comp = this.m_columns[index].ValueMax_BD.compareTo(value_BD);
                if (comp < 0) {
                    return "MaxValue=" + this.m_columns[index].ValueMax_BD + "(" + this.m_columns[index].ValueMax + ")" + " - compared with Numeric Value=" + value_BD + "(" + value + ")" + " - results in " + comp;
                }
            } else {
                int comp = this.m_columns[index].ValueMax.compareTo(value.toString());
                if (comp < 0) {
                    return "MaxValue=" + this.m_columns[index].ValueMax + " - compared with String Value=" + value + " - results in " + comp;
                }
            }
        }
        return null;
    }

    public StringBuffer buildSelect() {
        StringBuffer sql = new StringBuffer("SELECT ");
        int size = this.getColumnCount();
        for (int i2 = 0; i2 < size; ++i2) {
            if (i2 != 0) {
                sql.append(",");
            }
            sql.append(this.getColumnSQL(i2));
        }
        sql.append(" FROM ").append(this.getTableName());
        return sql;
    }

    public boolean isChangeLog() {
        return this.m_IsChangeLog;
    }
}

