/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import com.f3p.adempiere.util.ActionRegistry;
import com.f3p.adempiere.util.GridTabTrxInfoRegistry;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine_Cash;
import org.compiere.acct.Doc_Cash;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.BPartnerCRDRInfoFactory;
import org.compiere.model.FactsValidator;
import org.compiere.model.I_C_CashLine;
import org.compiere.model.InOutReopenAction;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaGL;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MClient;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPNGJournal;
import org.compiere.model.MPNGJournalLine;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PNGJournalTrxInfo;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_AllocationHdr;
import org.compiere.model.X_C_AllocationLine;
import org.compiere.model.X_Fact_Acct;
import org.compiere.util.CLogger;

public class PNG_Validator
implements ModelValidator,
FactsValidator {
    private static CLogger log = CLogger.getCLogger(PNG_Validator.class);
    private int m_AD_Client_ID = -1;
    private ThreadLocal<Integer> m_allocationHdrID = new ThreadLocal();

    public PNG_Validator() {
        ActionRegistry.register("ReopenInOut", new InOutReopenAction());
        BPartnerCRDRInfoFactory.register();
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(String.valueOf(this.toString()) + " for " + client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Payment", this);
        engine.addFactsValidate("C_Cash", this);
        engine.addDocValidate("C_AllocationHdr", this);
        engine.addDocValidate("C_Cash", this);
        GridTabTrxInfoRegistry.registerTrxInfo(new PNGJournalTrxInfo());
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public static List<MFactAcct> getCashFactLines(MAcctSchema mAcctSchema, MCash mCash) {
        String sWhere = "C_AcctSchema_ID = ? AND AD_Table_ID = ? AND RECORD_ID = ?";
        Query qFactLines = new Query(mCash.getCtx(), "Fact_Acct", sWhere, mCash.get_TrxName());
        qFactLines.setParameters(mAcctSchema.getC_AcctSchema_ID(), mCash.get_Table_ID(), mCash.get_ID());
        List<MFactAcct> lstLines = qFactLines.list();
        return lstLines;
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        if (po.get_TableName().equals("C_Payment") && (type == 2 || type == 1)) {
            MPayment pay = (MPayment)po;
            this.fillPaymentData(pay);
        }
        return null;
    }

    private void fillPaymentData(MPayment pay) {
        if (pay.getC_DocType_ID() == 0 && pay.get_ValueAsInt("PNG_Journal_ID") > 0) {
            MPNGJournal jl = new MPNGJournal(pay.getCtx(), pay.get_ValueAsInt("PNG_Journal_ID"), pay.get_TrxName());
            pay.setC_DocType_ID(jl.getC_DocType().getC_DocType_ID());
        }
    }

    @Override
    public String docValidate(PO model, int timing) {
        if (model instanceof MAllocationHdr && timing == 15) {
            boolean bExit = false;
            boolean bClear = false;
            Doc doc = model.getDoc();
            ArrayList<Fact> facts = doc.getFacts();
            for (Fact fact : facts) {
                FactLine[] factLineArray = fact.getLines();
                int n = factLineArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FactLine line = factLineArray[n2];
                    if (bExit) break;
                    int iC_AllocationLine_ID = line.getDocLine().get_ID();
                    X_C_AllocationLine mAllocLine = new X_C_AllocationLine(model.getCtx(), iC_AllocationLine_ID, model.get_TrxName());
                    I_C_CashLine mCashLine = mAllocLine.getC_CashLine();
                    if (mCashLine != null && MPNGJournal.isGeneratedCash(model.getCtx(), mCashLine.getC_Cash_ID(), model.get_TrxName())) {
                        Integer iCurAllocHdrID = this.m_allocationHdrID.get();
                        if (iCurAllocHdrID != null && iCurAllocHdrID.intValue() == model.get_ID()) {
                            line.setAD_Table_ID(MCash.Table_ID);
                            line.setRecord_ID(mCashLine.getC_Cash_ID());
                            line.setLine_ID(mCashLine.getC_CashLine_ID());
                        } else {
                            MCash mCash = new MCash(model.getCtx(), mCashLine.getC_Cash_ID(), model.get_TrxName());
                            mCash.setPosted(false);
                            mCash.saveEx();
                            bClear = true;
                            bExit = true;
                        }
                    }
                    ++n2;
                }
                if (bExit) break;
            }
            if (bClear) {
                facts.clear();
            }
        } else if (model instanceof MCash && timing == 15) {
            Doc doc = model.getDoc();
            MPNGJournal mJournal = MPNGJournal.getForCash(model.getCtx(), doc.get_ID(), model.get_TrxName());
            if (mJournal != null && mJournal.isCurrencyBalancingCheckNeeded()) {
                ArrayList<Fact> facts = doc.getFacts();
                FactLine factLineBalance = null;
                X_Fact_Acct factLineDestination = null;
                for (Fact fact : facts) {
                    MAcctSchemaGL acctSchemaGL = MAcctSchemaGL.get(model.getCtx(), fact.getAcctSchema().getC_AcctSchema_ID());
                    int CurrencyBalancing_Acct = acctSchemaGL.getCurrencyBalancing_A().getAccount_ID();
                    FactLine[] factLineArray = fact.getLines();
                    int n = factLineArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        FactLine factLine = factLineArray[n3];
                        if (factLine.getAccount_ID() == CurrencyBalancing_Acct) {
                            factLineBalance = factLine;
                        }
                        if (factLine.getLine_ID() > 0) {
                            int C_CashLine_ID = factLine.getLine_ID();
                            if (factLineDestination == null) {
                                MPNGJournalLine mCRLine = MPNGJournalLine.getCrLineFromCashLine(model.getCtx(), C_CashLine_ID, model.get_TrxName());
                                if (mCRLine != null && mCRLine.isCopyDiff()) {
                                    factLineDestination = factLine;
                                } else {
                                    MPNGJournalLine mDRLine = MPNGJournalLine.getDrLineFromCashLine(model.getCtx(), C_CashLine_ID, model.get_TrxName());
                                    if (mDRLine != null && mDRLine.isCopyDiff()) {
                                        factLineDestination = factLine;
                                    }
                                }
                            }
                        }
                        if (factLineBalance != null && factLineDestination != null) {
                            BigDecimal bdCR = factLineDestination.getAmtAcctCr();
                            if (bdCR.signum() > 0) {
                                bdCR = factLineBalance.getAmtAcctCr().signum() > 0 ? bdCR.add(factLineBalance.getAmtAcctCr()) : bdCR.subtract(factLineBalance.getAmtAcctDr());
                                factLineDestination.setAmtAcctCr(bdCR);
                            } else {
                                BigDecimal bdDR = factLineDestination.getAmtAcctDr();
                                bdDR = factLineBalance.getAmtAcctDr().signum() > 0 ? bdDR.add(factLineBalance.getAmtAcctDr()) : bdDR.subtract(factLineBalance.getAmtAcctCr());
                                factLineDestination.setAmtAcctDr(bdDR);
                            }
                            fact.remove(factLineBalance);
                        }
                        ++n3;
                    }
                }
            }
        }
        return null;
    }

    protected List<MFactAcct> forceAllocationHdrPost(MAcctSchema acctSchema, List<Fact> facts, MCash mCash) {
        int n;
        int n2;
        PO[] pOArray;
        if (facts.size() == 0) {
            return null;
        }
        boolean bForcePost = false;
        block3: for (Fact fact : facts) {
            pOArray = fact.getLines();
            n2 = pOArray.length;
            n = 0;
            while (n < n2) {
                FactLine line = pOArray[n];
                if (line.getDocLine() != null) {
                    int C_CashLine_ID = line.getDocLine().get_ID();
                    MPNGJournalLine mCRLine = MPNGJournalLine.getCrLineFromCashLine(mCash.getCtx(), C_CashLine_ID, mCash.get_TrxName());
                    if (mCRLine != null) {
                        bForcePost = true;
                        continue block3;
                    }
                    MPNGJournalLine mDRLine = MPNGJournalLine.getDrLineFromCashLine(mCash.getCtx(), C_CashLine_ID, mCash.get_TrxName());
                    if (mDRLine != null) {
                        bForcePost = true;
                        continue block3;
                    }
                }
                ++n;
            }
        }
        if (bForcePost) {
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(acctSchema.getCtx(), acctSchema.getAD_Client_ID());
            MAllocationHdr[] mAllocationHdrs = MAllocationHdr.getOfCash(mCash.getCtx(), mCash.getC_Cash_ID(), mCash.get_TrxName());
            pOArray = mAllocationHdrs;
            n2 = mAllocationHdrs.length;
            n = 0;
            while (n < n2) {
                PO hdr = pOArray[n];
                if (((X_C_AllocationHdr)hdr).isProcessed()) {
                    String sError = null;
                    try {
                        this.m_allocationHdrID.set(hdr.get_ID());
                        sError = Doc.postImmediate(ass, hdr.get_Table_ID(), hdr.get_ID(), true, mCash.get_TrxName());
                    }
                    finally {
                        this.m_allocationHdrID.set(null);
                    }
                    if (sError != null) {
                        throw new AdempiereException(sError);
                    }
                }
                ++n;
            }
            return PNG_Validator.getCashFactLines(acctSchema, mCash);
        }
        return null;
    }

    protected boolean processCashFactLine(X_Fact_Acct fact, List<FactLine> lstToRemove, int mTransferAcctID, String sTrxName) {
        FactLine fLine;
        MAccount mAccount = MAccount.get(fact);
        int C_CashLine_ID = -1;
        boolean bRemoved = false;
        if (fact instanceof MFactAcct) {
            C_CashLine_ID = fact.getLine_ID();
        } else if (fact instanceof FactLine && (fLine = (FactLine)fact).getDocLine() != null) {
            C_CashLine_ID = fLine.getDocLine().get_ID();
        }
        if (mAccount.getAccount_ID() == mTransferAcctID) {
            bRemoved = true;
            if (fact instanceof FactLine) {
                if (lstToRemove != null) {
                    lstToRemove.add((FactLine)fact);
                }
            } else {
                ((MFactAcct)fact).deleteEx(true);
            }
        } else if (C_CashLine_ID > 0) {
            MPNGJournalLine mCRLine = MPNGJournalLine.getCrLineFromCashLine(fact.getCtx(), C_CashLine_ID, sTrxName);
            if (mCRLine != null) {
                fact.setC_Project_ID(mCRLine.getC_ProjectCr_ID());
                fact.setC_SalesRegion_ID(mCRLine.getC_SalesRegionCr_ID());
                fact.setC_Campaign_ID(mCRLine.getC_CampaignCr_ID());
                fact.setC_Activity_ID(mCRLine.getC_ActivityCr_ID());
                fact.setC_BPartner_ID(mCRLine.getC_BPartnerCr_ID());
                fact.setUser1_ID(mCRLine.getUser1Cr_ID());
                fact.setUser2_ID(mCRLine.getUser2Cr_ID());
                fact.setUserElement1_ID(mCRLine.getUserElement1Cr_ID());
                fact.setUserElement2_ID(mCRLine.getUserElement2Cr_ID());
                MPNGJournal mJournal = mCRLine.getParent();
                if (mJournal.isConvInput()) {
                    fact.setAmtAcctCr(mCRLine.getAmtAcctCr());
                }
            } else {
                MPNGJournalLine mDRLine = MPNGJournalLine.getDrLineFromCashLine(fact.getCtx(), C_CashLine_ID, sTrxName);
                if (mDRLine != null) {
                    fact.setC_Project_ID(mDRLine.getC_ProjectDr_ID());
                    fact.setC_SalesRegion_ID(mDRLine.getC_SalesRegionDr_ID());
                    fact.setC_Campaign_ID(mDRLine.getC_CampaignDr_ID());
                    fact.setC_Activity_ID(mDRLine.getC_ActivityDr_ID());
                    fact.setC_BPartner_ID(mDRLine.getC_BPartnerDr_ID());
                    fact.setUser1_ID(mDRLine.getUser1Dr_ID());
                    fact.setUser2_ID(mDRLine.getUser2Dr_ID());
                    fact.setUserElement1_ID(mDRLine.getUserElement1Dr_ID());
                    fact.setUserElement2_ID(mDRLine.getUserElement2Dr_ID());
                    MPNGJournal mJournal = mDRLine.getParent();
                    if (mJournal.isConvInput()) {
                        fact.setAmtAcctDr(mDRLine.getAmtAcctDr());
                    }
                }
            }
        }
        return bRemoved;
    }

    @Override
    public String factsValidate(MAcctSchema acctSchema, List<Fact> facts, PO model) {
        if (model instanceof MCash) {
            Doc document = model.getDoc();
            if (MPNGJournal.isGeneratedCash(model.getCtx(), document.get_ID(), model.get_TrxName())) {
                MAccount mTransferAcct = document.getAccount(21, acctSchema);
                int iTransferAccountID = mTransferAcct.getAccount_ID();
                for (Fact fact : facts) {
                    ArrayList<FactLine> lstToRemove = new ArrayList<FactLine>();
                    FactLine[] factLineArray = fact.getLines();
                    int n = factLineArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FactLine line = factLineArray[n2];
                        this.processCashFactLine(line, lstToRemove, iTransferAccountID, model.get_TrxName());
                        ++n2;
                    }
                    for (FactLine toRemove : lstToRemove) {
                        fact.remove(toRemove);
                    }
                }
                MCash mCash = (MCash)model;
                List<MFactAcct> lstFactAcct = this.forceAllocationHdrPost(acctSchema, facts, mCash);
                if (lstFactAcct != null) {
                    Fact fact = facts.get(0);
                    for (MFactAcct mFactAcct : lstFactAcct) {
                        MAccount acct = MAccount.get(mFactAcct);
                        FactLine line = new FactLine(mCash.getCtx(), MCash.Table_ID, mFactAcct.getRecord_ID(), mFactAcct.getLine_ID(), mCash.get_TrxName());
                        DocLine_Cash dLine = null;
                        if (line.getLine_ID() > 0) {
                            MCashLine mCashLine = new MCashLine(model.getCtx(), line.getLine_ID(), model.get_TrxName());
                            dLine = new DocLine_Cash(mCashLine, (Doc_Cash)document);
                        }
                        line.setDocumentInfo(document, dLine);
                        line.setAccount(acctSchema, acct);
                        PO.copyValues(mFactAcct, line);
                        if (!this.processCashFactLine(line, null, iTransferAccountID, model.get_TrxName())) {
                            fact.add(line);
                        }
                        mFactAcct.deleteEx(true);
                    }
                }
            }
        }
        return null;
    }
}

