/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import com.f3p.adempiere.util.GridTabTrxInfo;
import java.math.BigDecimal;
import org.compiere.model.GridTabVO;
import org.compiere.model.MPNGJournal;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class PNGJournalTrxInfo
implements GridTabTrxInfo {
    public static final String FORMAT_MSG = "PNG_TRXINFO_FORMAT";
    public static final String FORMAT_MSG_CONV = "PNG_TRXINFO_FORMAT_CONV";

    @Override
    public String getTrxInfo(GridTabVO vo) {
        if (vo.TableName.startsWith("PNG_Journal") || vo.TableName.startsWith("PNG_Invoice") || vo.TableName.startsWith("PNG_Payment")) {
            int PNG_Journal_ID = Env.getContextAsInt(vo.ctx, vo.WindowNo, "PNG_Journal_ID");
            MPNGJournal mJournal = MPNGJournal.get(vo.ctx, PNG_Journal_ID, null);
            if (mJournal != null) {
                BigDecimal bdControlAmt = mJournal.getControlAmt();
                BigDecimal bdCredit = mJournal.getTotalCr();
                BigDecimal bdDebit = mJournal.getTotalDr();
                BigDecimal bdCreditConv = mJournal.getTotalConvCr();
                BigDecimal bdDebitConv = mJournal.getTotalConvDr();
                if (bdControlAmt == null) {
                    bdControlAmt = Env.ZERO;
                }
                if (bdCredit == null) {
                    bdCredit = Env.ZERO;
                }
                if (bdDebit == null) {
                    bdDebit = Env.ZERO;
                }
                if (bdDebitConv == null) {
                    bdDebitConv = Env.ZERO;
                }
                if (bdCreditConv == null) {
                    bdCreditConv = Env.ZERO;
                }
                BigDecimal bdControlAmtDelta = bdControlAmt.subtract(bdDebit);
                BigDecimal bdDelta = bdDebit.subtract(bdCredit);
                BigDecimal bdDeltaConv = bdDebitConv.subtract(bdCreditConv);
                Object[] formatArgs = new Object[]{bdControlAmt, bdControlAmtDelta, bdDebit, bdCredit, bdDelta, bdDebitConv, bdCreditConv, bdDeltaConv};
                String sInfo = null;
                sInfo = mJournal.isConvInput() ? Msg.getMsg(vo.ctx, FORMAT_MSG_CONV, formatArgs) : Msg.getMsg(vo.ctx, FORMAT_MSG, formatArgs);
                return sInfo;
            }
            return "";
        }
        return null;
    }
}

