/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MTax;
import org.compiere.model.Query;
import org.compiere.model.X_C_TaxCategory;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MTaxCategory
extends X_C_TaxCategory {
    private static final long serialVersionUID = -5521670797405300136L;

    public MTaxCategory(Properties ctx, int C_TaxCategory_ID, String trxName) {
        super(ctx, C_TaxCategory_ID, trxName);
        if (C_TaxCategory_ID == 0) {
            this.setIsDefault(false);
        }
    }

    public MTaxCategory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTax getDefaultTax() {
        MTax m_tax = new MTax(this.getCtx(), 0, this.get_TrxName());
        String whereClause = "C_TaxCategory_ID=? AND IsDefault='Y'";
        List list = new Query(this.getCtx(), "C_Tax", "C_TaxCategory_ID=? AND IsDefault='Y'", this.get_TrxName()).setParameters(this.getC_TaxCategory_ID()).setOnlyActiveRecords(true).list();
        if (list.size() == 0) {
            throw new AdempiereException("NoDefaultTaxRate");
        }
        if (list.size() != 1) {
            throw new AdempiereException("TooManyDefaults");
        }
        m_tax = (MTax)list.get(0);
        return m_tax;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.get_ID() + ", Name=" + this.getName() + ", IsDefault=" + this.isDefault() + ", IsActive=" + this.isActive() + "]";
    }

    public boolean afterNew(boolean newRecord) {
        block5: {
            Boolean active = true;
            String sql = "INSERT INTO adempiere.c_taxgroup ( name  , ad_org_id  , c_taxgroup_id , created   , createdby  , description  , updated  , updatedby  , ad_client_id  , value , isactive )VALUES ( ? , ? , ? , ? , ? ,  ? , ? , ? , ? , ? , ?)";
            ResultSet rsv = null;
            CPreparedStatement pstmtv = null;
            try {
                try {
                    int index = 1;
                    pstmtv = DB.prepareStatement(sql, this.get_TrxName());
                    pstmtv.setString(index++, this.getName());
                    pstmtv.setInt(index++, this.getAD_Org_ID());
                    pstmtv.setInt(index++, this.getC_TaxCategory_ID());
                    pstmtv.setTimestamp(index++, this.getCreated());
                    pstmtv.setInt(index++, this.getCreatedBy());
                    pstmtv.setString(index++, this.getDescription());
                    pstmtv.setTimestamp(index++, this.getCreated());
                    pstmtv.setInt(index++, this.getCreatedBy());
                    pstmtv.setInt(index++, this.getAD_Client_ID());
                    pstmtv.setString(index++, this.getName());
                    pstmtv.setString(index++, "Y");
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rsv, pstmtv);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DB.close(rsv, pstmtv);
                throw throwable;
            }
            DB.close(rsv, pstmtv);
        }
        return true;
    }

    public boolean beforeDelete(boolean newRecord) {
        block5: {
            String sql = "DELETE FROM adempiere.c_taxgroup WHERE c_taxgroup_id = ?";
            ResultSet rsv = null;
            CPreparedStatement pstmtv = null;
            try {
                try {
                    int index = 1;
                    pstmtv = DB.prepareStatement(sql, this.get_TrxName());
                    pstmtv.setInt(index++, this.getC_TaxCategory_ID());
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rsv, pstmtv);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DB.close(rsv, pstmtv);
                throw throwable;
            }
            DB.close(rsv, pstmtv);
        }
        return true;
    }

    public boolean afterChange(boolean newRecord) {
        block5: {
            String sql = "UPDATE adempiere.c_taxgroup  SET name  = ? , description = ?, value = ? WHERE c_taxgroup_id = ? ";
            ResultSet rsv = null;
            CPreparedStatement pstmtv = null;
            try {
                try {
                    int index = 1;
                    pstmtv = DB.prepareStatement(sql, this.get_TrxName());
                    pstmtv.setString(index++, this.getName());
                    pstmtv.setString(index++, this.getDescription());
                    pstmtv.setString(index++, this.getName());
                    pstmtv.setInt(index++, this.getC_TaxCategory_ID());
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rsv, pstmtv);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DB.close(rsv, pstmtv);
                throw throwable;
            }
            DB.close(rsv, pstmtv);
        }
        return true;
    }
}

