/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.model.GenericPO;
import org.compiere.model.MColumn;
import org.compiere.model.MEntityType;
import org.compiere.model.MSequence;
import org.compiere.model.M_Element;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Table;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MTable
extends X_AD_Table {
    private static final long serialVersionUID = -2367316254623142732L;
    private static CCache<Integer, MTable> s_cache = new CCache("AD_Table", 20);
    private static CCache<String, Class<?>> s_classCache = new CCache("PO_Class", 20);
    private static CLogger s_log = CLogger.getCLogger(MTable.class);
    private static String[] s_packages = new String[]{"org.compiere.model", "org.compiere.wf", "org.compiere.report", "org.compiere.print", "org.compiere.impexp", "compiere.model", "adempiere.model", "org.adempiere.model"};
    private static final String[] s_special = new String[]{"AD_Element", "org.compiere.model.M_Element", "AD_Registration", "org.compiere.model.M_Registration", "AD_Tree", "org.compiere.model.MTree_Base", "R_Category", "org.compiere.model.MRequestCategory", "GL_Category", "org.compiere.model.MGLCategory", "K_Category", "org.compiere.model.MKCategory", "C_ValidCombination", "org.compiere.model.MAccount", "C_Phase", "org.compiere.model.MProjectTypePhase", "C_Task", "org.compiere.model.MProjectTypeTask", "AD_View_Column", "org.adempiere.model.MViewColumn", "AD_View", "org.adempiere.model.MView", "AD_View_Definition", "org.adempiere.model.MViewDefinition", "AD_Browse", "org.adempiere.model.MBrowse", "AD_Browse_Field", "org.adempiere.model.MBrowseField", "T_Selection", "org.adempiere.model.X_T_Selection"};
    private MColumn[] m_columns = null;

    public static MTable get(Properties ctx, int AD_Table_ID) {
        Integer key = new Integer(AD_Table_ID);
        MTable retValue = s_cache.get(key);
        if (retValue != null && retValue.getCtx() == ctx) {
            return retValue;
        }
        retValue = new MTable(ctx, AD_Table_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MTable get(Properties ctx, String tableName) {
        MTable retValue2;
        if (tableName == null) {
            return null;
        }
        for (MTable retValue2 : s_cache.values()) {
            if (!tableName.equalsIgnoreCase(retValue2.getTableName()) || retValue2.getCtx() != ctx) continue;
            return retValue2;
        }
        retValue2 = null;
        String sql = "SELECT * FROM AD_Table WHERE UPPER(TableName)=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, tableName.toUpperCase());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue2 = new MTable(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue2 != null) {
            Integer key = new Integer(retValue2.getAD_Table_ID());
            s_cache.put(key, retValue2);
        }
        return retValue2;
    }

    public static String getTableName(Properties ctx, int AD_Table_ID) {
        return MTable.get(ctx, AD_Table_ID).getTableName();
    }

    public static Class<?> getClass(String tableName) {
        String className;
        int index;
        MEntityType et;
        String etmodelpackage;
        if (tableName == null || tableName.endsWith("_Trl")) {
            return null;
        }
        Class<?> cache = s_classCache.get(tableName);
        if (cache != null) {
            if (cache.equals(Object.class)) {
                return null;
            }
            return cache;
        }
        MTable table = MTable.get(Env.getCtx(), tableName);
        String entityType = table.getEntityType();
        if (tableName.startsWith("I_")) {
            Class<?> clazz;
            MEntityType et2 = MEntityType.get(Env.getCtx(), entityType);
            String etmodelpackage2 = et2.getModelPackage();
            if (etmodelpackage2 == null || "D".equals(entityType)) {
                etmodelpackage2 = "org.compiere.model";
            }
            if ((clazz = MTable.getPOclass(String.valueOf(etmodelpackage2) + ".X_" + tableName, tableName)) != null) {
                s_classCache.put(tableName, clazz);
                return clazz;
            }
            s_log.warning("No class for table: " + tableName);
            return null;
        }
        int i = 0;
        while (i < s_special.length) {
            if (s_special[i++].equals(tableName)) {
                Class<?> clazz = MTable.getPOclass(s_special[i], tableName);
                if (clazz == null) break;
                s_classCache.put(tableName, clazz);
                return clazz;
            }
            ++i;
        }
        if (!"D".equals(entityType) && (etmodelpackage = (et = MEntityType.get(Env.getCtx(), entityType)).getModelPackage()) != null) {
            Class<?> clazz = null;
            clazz = MTable.getPOclass(String.valueOf(etmodelpackage) + ".M" + Util.replace(tableName, "_", ""), tableName);
            if (clazz != null) {
                s_classCache.put(tableName, clazz);
                return clazz;
            }
            clazz = MTable.getPOclass(String.valueOf(etmodelpackage) + ".X_" + tableName, tableName);
            if (clazz != null) {
                s_classCache.put(tableName, clazz);
                return clazz;
            }
            s_log.warning("No class for table with it entity: " + tableName);
        }
        if ((index = (className = tableName).indexOf(95)) > 0 && index < 3) {
            className = className.substring(index + 1);
        }
        className = Util.replace(className, "_", "");
        int i2 = 0;
        while (i2 < s_packages.length) {
            StringBuffer name = new StringBuffer(s_packages[i2]).append(".M").append(className);
            Class<?> clazz = MTable.getPOclass(name.toString(), tableName);
            if (clazz != null) {
                s_classCache.put(tableName, clazz);
                return clazz;
            }
            ++i2;
        }
        Class<?> clazz = MTable.getPOclass("adempiere.model.X_" + tableName, tableName);
        if (clazz != null) {
            s_classCache.put(tableName, clazz);
            return clazz;
        }
        clazz = MTable.getPOclass("compiere.model.X_" + tableName, tableName);
        if (clazz != null) {
            s_classCache.put(tableName, clazz);
            return clazz;
        }
        clazz = MTable.getPOclass("org.compiere.model.X_" + tableName, tableName);
        if (clazz != null) {
            s_classCache.put(tableName, clazz);
            return clazz;
        }
        s_classCache.put(tableName, Object.class);
        return null;
    }

    private static Class<?> getPOclass(String className) {
        return MTable.getPOclass(className, null);
    }

    private static Class<?> getPOclass(String className, String tableName) {
        Class<?> clazz;
        block5: {
            String classTableName;
            clazz = Class.forName(className);
            if (tableName == null || tableName.equals(classTableName = clazz.getField("Table_Name").get(null).toString())) break block5;
            s_log.finest("Invalid class for table: " + className + " (tableName=" + tableName + ", classTableName=" + classTableName + ")");
            return null;
        }
        try {
            Class<?> superClazz = clazz.getSuperclass();
            while (superClazz != null) {
                if (superClazz == PO.class) {
                    s_log.fine("Use: " + className);
                    return clazz;
                }
                superClazz = superClazz.getSuperclass();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_log.finest("Not found: " + className);
        return null;
    }

    public MTable(Properties ctx, int AD_Table_ID, String trxName) {
        super(ctx, AD_Table_ID, trxName);
        if (AD_Table_ID == 0) {
            this.setAccessLevel("4");
            this.setEntityType("U");
            this.setIsChangeLog(false);
            this.setIsDeleteable(false);
            this.setIsHighVolume(false);
            this.setIsSecurityEnabled(false);
            this.setIsView(false);
            this.setReplicationType("L");
        }
    }

    public MTable(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MColumn[] getColumns(boolean requery) {
        if (this.m_columns != null && !requery) {
            return this.m_columns;
        }
        String sql = "SELECT * FROM AD_Column WHERE AD_Table_ID=? ORDER BY ColumnName";
        ArrayList<MColumn> list = new ArrayList<MColumn>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Table_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MColumn(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_columns = new MColumn[list.size()];
        list.toArray(this.m_columns);
        return this.m_columns;
    }

    public MColumn getColumn(String columnName) {
        if (columnName == null || columnName.length() == 0) {
            return null;
        }
        this.getColumns(false);
        int i = 0;
        while (i < this.m_columns.length) {
            if (columnName.equalsIgnoreCase(this.m_columns[i].getColumnName())) {
                return this.m_columns[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isSingleKey() {
        String[] keys = this.getKeyColumns();
        return keys.length == 1;
    }

    public String[] getKeyColumns() {
        this.getColumns(false);
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < this.m_columns.length) {
            MColumn column = this.m_columns[i];
            if (column.isKey()) {
                return new String[]{column.getColumnName()};
            }
            if (column.isParent()) {
                list.add(column.getColumnName());
            }
            ++i;
        }
        String[] retValue = new String[list.size()];
        retValue = list.toArray(retValue);
        return retValue;
    }

    public PO getPO(int Record_ID, String trxName) {
        PO po;
        block13: {
            String tableName = this.getTableName();
            if (Record_ID != 0 && !this.isSingleKey()) {
                this.log.log(Level.WARNING, "(id) - Multi-Key " + tableName);
                return null;
            }
            Class<?> clazz = MTable.getClass(tableName);
            if (clazz == null) {
                this.log.log(Level.INFO, "Using GenericPO for " + tableName);
                GenericPO po2 = new GenericPO(tableName, this.getCtx(), (int)new Integer(Record_ID), trxName);
                return po2;
            }
            boolean errorLogged = false;
            try {
                Constructor<?> constructor = null;
                try {
                    constructor = clazz.getDeclaredConstructor(Properties.class, Integer.TYPE, String.class);
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = e.toString();
                    }
                    this.log.warning("No transaction Constructor for " + clazz + " (" + msg + ")");
                }
                po = (PO)constructor.newInstance(this.getCtx(), new Integer(Record_ID), trxName);
                if (po == null || po.get_ID() == Record_ID || Record_ID <= 0) break block13;
                return null;
            }
            catch (Exception e) {
                if (e.getCause() != null) {
                    Throwable t = e.getCause();
                    this.log.log(Level.SEVERE, "(id) - Table=" + tableName + ",Class=" + clazz, t);
                    errorLogged = true;
                    if (t instanceof Exception) {
                        this.log.saveError("Error", (Exception)e.getCause());
                    } else {
                        this.log.saveError("Error", "Table=" + tableName + ",Class=" + clazz);
                    }
                } else {
                    this.log.log(Level.SEVERE, "(id) - Table=" + tableName + ",Class=" + clazz, e);
                    errorLogged = true;
                    this.log.saveError("Error", "Table=" + tableName + ",Class=" + clazz);
                }
                if (!errorLogged) {
                    this.log.log(Level.SEVERE, "(id) - Not found - Table=" + tableName + ", Record_ID=" + Record_ID);
                }
                return null;
            }
        }
        return po;
    }

    public PO getPO(ResultSet rs, String trxName) {
        String tableName = this.getTableName();
        Class<?> clazz = MTable.getClass(tableName);
        if (clazz == null) {
            this.log.log(Level.INFO, "Using GenericPO for " + tableName);
            GenericPO po = new GenericPO(tableName, this.getCtx(), rs, trxName);
            return po;
        }
        boolean errorLogged = false;
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(Properties.class, ResultSet.class, String.class);
            PO po = (PO)constructor.newInstance(this.getCtx(), rs, trxName);
            return po;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "(rs) - Table=" + tableName + ",Class=" + clazz, e);
            errorLogged = true;
            this.log.saveError("Error", "Table=" + tableName + ",Class=" + clazz);
            if (!errorLogged) {
                this.log.log(Level.SEVERE, "(rs) - Not found - Table=" + tableName);
            }
            return null;
        }
    }

    public PO getPO(String whereClause, String trxName) {
        return this.getPO(whereClause, null, trxName);
    }

    public PO getPO(String whereClause, Object[] params, String trxName) {
        if (whereClause == null || whereClause.length() == 0) {
            return null;
        }
        PO po = null;
        POInfo info = POInfo.getPOInfo(this.getCtx(), this.getAD_Table_ID(), trxName);
        if (info == null) {
            return null;
        }
        StringBuffer sqlBuffer = info.buildSelect();
        sqlBuffer.append(" WHERE ").append(whereClause);
        String sql = sqlBuffer.toString();
        CPreparedStatement pstmt = null;
        try {
            ResultSet rs;
            pstmt = DB.prepareStatement(sql, trxName);
            if (params != null && params.length > 0) {
                int i = 0;
                while (i < params.length) {
                    pstmt.setObject(i + 1, params[i]);
                    ++i;
                }
            }
            if ((rs = pstmt.executeQuery()).next()) {
                po = this.getPO(rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
            this.log.saveError("Error", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return po;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isView() && this.isDeleteable()) {
            this.setIsDeleteable(false);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord) {
            this.createMandatoryColumns();
            MSequence seq = MSequence.get(this.getCtx(), this.getTableName(), this.get_TrxName());
            if (seq == null || seq.get_ID() == 0) {
                MSequence.createTableSequence(this.getCtx(), this.getTableName(), this.get_TrxName());
            }
        } else {
            MSequence seq = MSequence.get(this.getCtx(), this.getTableName(), this.get_TrxName());
            if (seq == null || seq.get_ID() == 0) {
                MSequence.createTableSequence(this.getCtx(), this.getTableName(), this.get_TrxName());
            } else if (!seq.getName().equals(this.getTableName())) {
                seq.setName(this.getTableName());
                seq.save();
            }
        }
        return success;
    }

    public String getSQLCreate() {
        StringBuffer sb = new StringBuffer("CREATE TABLE ").append(this.getTableName()).append(" (");
        boolean hasPK = false;
        boolean hasParents = false;
        StringBuffer constraints = new StringBuffer();
        this.getColumns(true);
        int i = 0;
        while (i < this.m_columns.length) {
            MColumn column = this.m_columns[i];
            String colSQL = column.getSQLDDL();
            if (colSQL != null) {
                String constraint;
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(column.getSQLDDL());
                if (column.isKey()) {
                    hasPK = true;
                }
                if (column.isParent()) {
                    hasParents = true;
                }
                if ((constraint = column.getConstraint(this.getTableName())) != null && constraint.length() > 0) {
                    constraints.append(", ").append(constraint);
                }
            }
            ++i;
        }
        if (!hasPK && hasParents) {
            StringBuffer cols = new StringBuffer();
            int i2 = 0;
            while (i2 < this.m_columns.length) {
                MColumn column = this.m_columns[i2];
                if (column.isParent()) {
                    if (cols.length() > 0) {
                        cols.append(", ");
                    }
                    cols.append(column.getColumnName());
                }
                ++i2;
            }
            sb.append(", CONSTRAINT ").append(this.getTableName()).append("_Key PRIMARY KEY (").append(cols).append(")");
        }
        sb.append(constraints).append(")");
        return sb.toString();
    }

    public static int getTable_ID(String tableName) {
        int retValue = 0;
        String SQL = "SELECT AD_Table_ID FROM AD_Table WHERE tablename = ?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setString(1, tableName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, SQL, e);
            retValue = -1;
        }
        return retValue;
    }

    public Query createQuery(String whereClause, String trxName) {
        return new Query(this.getCtx(), this, whereClause, trxName);
    }

    public void createMandatoryColumns() {
        MColumn column = null;
        column = new MColumn(this, "AD_Client_ID", 22, 19, "@#AD_Client_ID@");
        column.setUpdateable(false);
        column.setAD_Val_Rule_ID(129);
        column.saveEx();
        column = new MColumn(this, "AD_Org_ID", 22, 19, "@#AD_Org_ID@");
        column.setUpdateable(true);
        column.setAD_Val_Rule_ID(104);
        column.saveEx();
        column = new MColumn(this, "IsActive", 1, 20, "Y");
        column.setUpdateable(true);
        column.saveEx();
        column = new MColumn(this, "Created", 7, 16, "");
        column.saveEx();
        column = new MColumn(this, "Updated", 7, 16, "");
        column.saveEx();
        column = new MColumn(this, "CreatedBy", 22, 19, "");
        column.setAD_Reference_Value_ID(110);
        column.saveEx();
        column = new MColumn(this, "UpdatedBy", 22, 19, "");
        column.setAD_Reference_Value_ID(110);
        column.saveEx();
        if (!this.isView()) {
            if (this.getTableName().endsWith("_Trl") || this.getTableName().endsWith("_Access")) {
                return;
            }
            M_Element element = M_Element.get(this.getCtx(), String.valueOf(this.getTableName()) + "_ID", this.get_TrxName());
            if (element != null) {
                return;
            }
            element = new M_Element(this.getCtx(), 0, this.get_TrxName());
            element.setColumnName(String.valueOf(this.getTableName()) + "_ID");
            element.setName(String.valueOf(this.getName()) + " ID");
            element.setPrintName(String.valueOf(this.getName()) + " ID");
            element.setEntityType(this.getEntityType());
            element.saveEx();
            column = new MColumn(this, element.getColumnName(), 22, 13, "");
            column.setAD_Element_ID(element.get_ID());
            column.setIsKey(true);
            column.setUpdateable(false);
            column.setIsMandatory(true);
            column.saveEx();
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MTable[");
        sb.append(this.get_ID()).append("-").append(this.getTableName()).append("]");
        return sb.toString();
    }

    public static void addCustomPackages(String sNewPackages) {
        String[] tmp = new String[s_packages.length + 1];
        System.arraycopy(s_packages, 0, tmp, 1, s_packages.length);
        tmp[0] = sNewPackages;
        s_packages = tmp;
    }
}

