/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MDocType;
import org.compiere.model.MMPJobStandardTask;
import org.compiere.model.MMPOTTask;
import org.compiere.model.Query;
import org.compiere.model.X_MP_JobStandar_Resource;
import org.compiere.model.X_MP_OT;
import org.compiere.model.X_MP_OT_Resource;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class MPRequestOT {
    public boolean createOT(int Job_ID, Timestamp Datetrx, String description, int Asset_ID, int Req_ID) {
        X_MP_OT newOT = new X_MP_OT(Env.getCtx(), 0, null);
        newOT.setDateTrx(Datetrx);
        newOT.setDescription(description);
        newOT.setA_Asset_ID(Asset_ID);
        newOT.setMP_JobStandar_ID(Job_ID);
        newOT.setDocStatus("DR");
        newOT.setDocAction("CO");
        newOT.setMP_OT_Request_ID(Req_ID);
        newOT.setC_DocType_ID(MDocType.getOfDocBaseType(Env.getCtx(), "MOF")[0].getC_DocType_ID());
        if (!newOT.save()) {
            return false;
        }
        return this.createOTTaskDetail(Job_ID, newOT);
    }

    public boolean createOTTaskDetail(int Job_ID, X_MP_OT OT) {
        List list = new Query(Env.getCtx(), "MP_JobStandar_Task", "MP_JobStandar_ID=?", null).setParameters(Job_ID).list();
        for (MMPJobStandardTask task : list) {
            MMPOTTask ta = new MMPOTTask(Env.getCtx(), 0, null);
            ta.setAD_Org_ID(task.getAD_Org_ID());
            ta.setMP_OT_ID(OT.getMP_OT_ID());
            ta.setDescription(task.getDescription());
            ta.setDuration(task.getDuration());
            ta.setC_UOM_ID(task.getC_UOM_ID());
            ta.setStatus("NS");
            ta.saveEx();
            this.createOTResourceDetail(task.getMP_JobStandar_Task_ID(), ta.getMP_OT_Task_ID());
        }
        return true;
    }

    public boolean createOTResourceDetail(int oldTask_ID, int newTask_ID) {
        List list = new Query(Env.getCtx(), "MP_JobStandar_Resource", "MP_JobStandar_Task_ID=?", null).setParameters("").list();
        for (X_MP_JobStandar_Resource job : list) {
            X_MP_OT_Resource re = new X_MP_OT_Resource(Env.getCtx(), 0, null);
            re.setAD_Org_ID(job.getAD_Org_ID());
            re.setMP_OT_Task_ID(newTask_ID);
            re.setCostAmt(job.getCostAmt());
            re.setS_Resource_ID(job.getS_Resource_ID());
            re.setM_BOM_ID(job.getM_BOM_ID());
            re.setResourceQty(job.getResourceQty());
            re.setResourceType(job.getResourceType());
            re.set_ValueOfColumn("M_Product_ID", (Object)job.getM_Product_ID());
            re.saveEx();
        }
        return true;
    }

    public void voidData(TableModel prognosis) {
        int rows = prognosis.getRowCount();
        int i = 0;
        while (i < rows) {
            if (((Boolean)prognosis.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)prognosis.getValueAt(i, 3);
                int Req_ID = pp.getKey();
                String sql = "Update MP_OT_REQUEST set DocStatus='VO' where MP_OT_REQUEST_ID=" + Req_ID;
                DB.executeUpdate(sql);
            }
            ++i;
        }
    }

    public MiniTable loadMP(MiniTable requestTable, CLogger log) {
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer("select rt.DATEDOC,rt.DATEREQUIRED,rt.DOCUMENTNO,rt.MP_OT_REQUEST_ID, rt.AD_Org_ID, rt.AD_User_ID, rt.A_Asset_ID, rt.MP_JOBSTANDAR_ID, rt.Description, u.name, a.name as AssetName, jo.name as jobName,rl.name as PriorityRule, rt.OT_Request_Type from MP_OT_REQUEST rt inner join AD_User u on (rt.AD_User_ID=u.AD_User_ID) inner join A_Asset a on (rt.A_Asset_ID=a.A_Asset_ID) left outer join MP_JOBSTANDAR jo on (rt.MP_JOBSTANDAR_ID=jo.MP_JOBSTANDAR_ID) inner join AD_Ref_List rl on (rt.PriorityRule=rl.value and rl. AD_Reference_ID=154) where rt.DocStatus='WC' and rt.processed='Y'");
        log.config("Prognosis=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            String tipo = new String();
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                if (rs.getString(14).equals("RV")) {
                    tipo = "Revision";
                }
                if (rs.getString(14).equals("RP")) {
                    tipo = "Reparacion";
                }
                if (rs.getString(14).equals("CN")) {
                    tipo = "Completar Niveles";
                }
                line.add(tipo);
                line.add(rs.getTimestamp(2));
                KeyNamePair pp = new KeyNamePair(rs.getInt(4), rs.getString(3));
                line.add(pp);
                line.add(rs.getTimestamp(1));
                KeyNamePair pp2 = new KeyNamePair(rs.getInt(6), rs.getString(10));
                line.add(pp2);
                KeyNamePair pp3 = new KeyNamePair(rs.getInt(7), rs.getString(11));
                line.add(pp3);
                line.add(rs.getString(9));
                line.add(rs.getString(13));
                KeyNamePair pp4 = new KeyNamePair(rs.getInt(8), rs.getString(12));
                line.add(pp4);
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        requestTable.getModel().removeTableModelListener((TableModelListener)((Object)this));
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg(Env.getCtx(), "Selected"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Type"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Date Programed"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Request No"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Date Request"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "AD_User_ID"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Asset"));
        columnNames.add("Descripcion");
        columnNames.add(Msg.getMsg(Env.getCtx(), "Priority"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Standard Job"));
        DefaultTableModel modelP = new DefaultTableModel(data, columnNames);
        modelP.addTableModelListener((TableModelListener)((Object)this));
        requestTable.setModel(modelP);
        int i = 0;
        requestTable.setColumnClass(i++, Boolean.class, false);
        requestTable.setColumnClass(i++, String.class, true);
        requestTable.setColumnClass(i++, Timestamp.class, false);
        requestTable.setColumnClass(i++, String.class, true);
        requestTable.setColumnClass(i++, Timestamp.class, true);
        requestTable.setColumnClass(i++, String.class, true);
        requestTable.setColumnClass(i++, String.class, true);
        requestTable.setColumnClass(i++, String.class, true);
        requestTable.setColumnClass(i++, String.class, true);
        requestTable.setColumnClass(i++, String.class, true);
        requestTable.autoSize();
        requestTable.setColumnReadOnly(1, false);
        return requestTable;
    }
}

