/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.model.MPNGJournal;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_PNG_JrLine_Invoice;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MPNGJrLineInvoice
extends X_PNG_JrLine_Invoice {
    private static final long serialVersionUID = 7882164408984136167L;

    public MPNGJrLineInvoice(Properties ctx, int PNG_JrLine_Invoice_ID, String trxName) {
        super(ctx, PNG_JrLine_Invoice_ID, trxName);
    }

    public MPNGJrLineInvoice(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setInvoice(X_C_Invoice mInvoice) {
        this.setC_Invoice_ID(mInvoice.getC_Invoice_ID());
        MPNGJrLineInvoice.setInvoiceInfo(SetGetUtil.wrap(this), mInvoice.getC_Invoice_ID(), this.getPNG_Journal_ID());
    }

    public static void setInvoiceInfo(SetGetModel mJrLineInvoice, int C_Invoice_ID, int PNG_Journal_ID) {
        String sSQL = "SELECT currencyConvert (invoiceopen(iv.c_invoice_id,NULL)*IV.MULTIPLIER*IV.MULTIPLIERAP, iv.C_Currency_ID, pg.C_Currency_ID, pg.DateAcct, pg.C_ConversionType_ID, iv.AD_Client_ID, iv.AD_Org_ID)  as InvoiceAmt,  currencyConvert (invoiceopen(iv.c_invoice_id,NULL)*IV.MULTIPLIER*IV.MULTIPLIERAP, iv.C_Currency_ID, pg.C_Currency_ID, pg.DateAcct, pg.C_ConversionType_ID, iv.AD_Client_ID, iv.AD_Org_ID) as Amount,  invoiceopen(iv.c_invoice_id,NULL)*IV.MULTIPLIER*IV.MULTIPLIERAP AS InvoiceAmt_Cur,  iv.C_Currency_ID AS C_Currency_ID  from c_invoice_v iv, PNG_Journal pg  where iv.c_invoice_id = ?  and pg.PNG_Journal_ID = ?";
        CPreparedStatement pstmt = DB.prepareStatement("SELECT currencyConvert (invoiceopen(iv.c_invoice_id,NULL)*IV.MULTIPLIER*IV.MULTIPLIERAP, iv.C_Currency_ID, pg.C_Currency_ID, pg.DateAcct, pg.C_ConversionType_ID, iv.AD_Client_ID, iv.AD_Org_ID)  as InvoiceAmt,  currencyConvert (invoiceopen(iv.c_invoice_id,NULL)*IV.MULTIPLIER*IV.MULTIPLIERAP, iv.C_Currency_ID, pg.C_Currency_ID, pg.DateAcct, pg.C_ConversionType_ID, iv.AD_Client_ID, iv.AD_Org_ID) as Amount,  invoiceopen(iv.c_invoice_id,NULL)*IV.MULTIPLIER*IV.MULTIPLIERAP AS InvoiceAmt_Cur,  iv.C_Currency_ID AS C_Currency_ID  from c_invoice_v iv, PNG_Journal pg  where iv.c_invoice_id = ?  and pg.PNG_Journal_ID = ?", null);
        ResultSet rs = null;
        try {
            try {
                pstmt.setInt(1, C_Invoice_ID);
                pstmt.setInt(2, PNG_Journal_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    BigDecimal bdInvoiceAmt = rs.getBigDecimal("InvoiceAmt");
                    BigDecimal bdAmount = rs.getBigDecimal("Amount");
                    BigDecimal bdInvoiceAmt_Cur = rs.getBigDecimal("InvoiceAmt_Cur");
                    int C_Currency_ID = rs.getInt("C_Currency_ID");
                    mJrLineInvoice.set_AttrValue("InvoiceAmt", bdInvoiceAmt);
                    mJrLineInvoice.set_AttrValue("Amount", bdAmount);
                    mJrLineInvoice.set_AttrValue("InvoiceAmt_Cur", bdInvoiceAmt_Cur);
                    mJrLineInvoice.set_AttrValue("C_Currency_ID", C_Currency_ID);
                }
            }
            catch (SQLException e) {
                throw new AdempiereException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
    }

    public int getPNG_Journal_ID() {
        return DB.getSQLValueEx(this.get_TrxName(), "SELECT PNG_Journal_ID FROM PNG_JournalLine WHERE PNG_JournalLine_ID = ?", this.getPNG_JournalLine_ID());
    }

    public static void calcValues(int PNG_Journal_ID, SetGetModel line) {
        MPNGJrLineInvoice.calcValues(PNG_Journal_ID, line, null);
    }

    public static void calcValues(int PNG_Journal_ID, SetGetModel line, BigDecimal bdInvoiceAmt_CurOrig) {
        Properties ctx = line.getCtx();
        Integer C_Invoice_ID = (Integer)line.get_AttrValue("C_Invoice_ID");
        if (C_Invoice_ID == null || C_Invoice_ID <= 0) {
            return;
        }
        MInvoice mInv = MInvoice.get(line.getCtx(), C_Invoice_ID);
        MPNGJournal mJournal = new MPNGJournal(line.getCtx(), PNG_Journal_ID, null);
        BigDecimal bdAmount = SetGetUtil.get_AttrValueAsBigDecimal(line, "Amount");
        BigDecimal bdDiscountAmt = SetGetUtil.get_AttrValueAsBigDecimal(line, "DiscountAmt");
        BigDecimal bdWriteOffAmt = SetGetUtil.get_AttrValueAsBigDecimal(line, "WriteOffAmt");
        BigDecimal bdOverUnderAmt = SetGetUtil.get_AttrValueAsBigDecimal(line, "OverUnderAmt");
        BigDecimal bdInvoiceAmt_Cur = bdInvoiceAmt_CurOrig;
        if (bdInvoiceAmt_Cur == null) {
            bdInvoiceAmt_Cur = DB.getSQLValueBD(null, "SELECT invoiceopen(iv.c_invoice_id,NULL)*IV.MULTIPLIER*IV.MULTIPLIERAP FROM c_invoice_v iv WHERE iv.C_Invoice_ID = ?", C_Invoice_ID);
        }
        BigDecimal bdAmount_Cur = Env.ZERO;
        BigDecimal bdDiscountAmt_Cur = Env.ZERO;
        BigDecimal bdWriteOffAmt_Cur = Env.ZERO;
        BigDecimal bdOverUnderAmt_Cur = Env.ZERO;
        int iDeltaVal = 0;
        if (bdAmount.signum() != 0) {
            bdAmount_Cur = MConversionRate.convert(ctx, bdAmount, mJournal.getC_Currency_ID(), mInv.getC_Currency_ID(), mJournal.getDateAcct(), mJournal.getC_ConversionType_ID(), Env.getAD_Client_ID(line.getCtx()), Env.getAD_Org_ID(ctx));
        }
        if (bdDiscountAmt.signum() != 0) {
            bdDiscountAmt_Cur = MConversionRate.convert(ctx, bdDiscountAmt, mJournal.getC_Currency_ID(), mInv.getC_Currency_ID(), mJournal.getDateAcct(), mJournal.getC_ConversionType_ID(), Env.getAD_Client_ID(line.getCtx()), Env.getAD_Org_ID(ctx));
            iDeltaVal = 1;
        }
        if (bdWriteOffAmt.signum() != 0) {
            bdWriteOffAmt_Cur = MConversionRate.convert(ctx, bdWriteOffAmt, mJournal.getC_Currency_ID(), mInv.getC_Currency_ID(), mJournal.getDateAcct(), mJournal.getC_ConversionType_ID(), Env.getAD_Client_ID(line.getCtx()), Env.getAD_Org_ID(ctx));
            iDeltaVal = 2;
        }
        if (bdOverUnderAmt.signum() != 0) {
            bdOverUnderAmt_Cur = MConversionRate.convert(ctx, bdOverUnderAmt, mJournal.getC_Currency_ID(), mInv.getC_Currency_ID(), mJournal.getDateAcct(), mJournal.getC_ConversionType_ID(), Env.getAD_Client_ID(ctx), Env.getAD_Org_ID(ctx));
            iDeltaVal = 3;
        }
        BigDecimal bdTotal_Cur = bdAmount_Cur.add(bdDiscountAmt_Cur).add(bdWriteOffAmt_Cur).add(bdOverUnderAmt_Cur);
        BigDecimal bdDelta = bdInvoiceAmt_Cur.subtract(bdTotal_Cur);
        switch (iDeltaVal) {
            case 1: {
                bdDiscountAmt_Cur = bdDiscountAmt_Cur.add(bdDelta);
                break;
            }
            case 2: {
                bdWriteOffAmt_Cur = bdWriteOffAmt_Cur.add(bdDelta);
                break;
            }
            case 3: {
                bdOverUnderAmt_Cur = bdOverUnderAmt_Cur.add(bdDelta);
                break;
            }
            default: {
                bdAmount_Cur = bdAmount_Cur.add(bdDelta);
            }
        }
        if (bdInvoiceAmt_CurOrig == null) {
            BigDecimal bdCurrentInvoiceAmt_Cur = SetGetUtil.get_AttrValueAsBigDecimal(line, "InvoiceAmt_Cur");
            if (bdCurrentInvoiceAmt_Cur == null || bdCurrentInvoiceAmt_Cur.signum() == 0) {
                line.set_AttrValue("InvoiceAmt_Cur", bdInvoiceAmt_Cur);
            }
        } else {
            line.set_AttrValue("InvoiceAmt_Cur", bdInvoiceAmt_CurOrig);
        }
        line.set_AttrValue("Amount_Cur", bdAmount_Cur);
        line.set_AttrValue("DiscountAmt_Cur", bdDiscountAmt_Cur);
        line.set_AttrValue("WriteOffAmt_Cur", bdWriteOffAmt_Cur);
        line.set_AttrValue("OverUnderAmt_Cur", bdOverUnderAmt_Cur);
    }
}

