/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MCharge;
import org.compiere.model.MCurrency;
import org.compiere.model.MPNGEntryTypeJrLine;
import org.compiere.model.MPNGJournal;
import org.compiere.model.MPNGJrLineInvoice;
import org.compiere.model.MPeriod;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_PNG_JournalLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MPNGJournalLine
extends X_PNG_JournalLine {
    private static final long serialVersionUID = -703167299243783463L;

    public MPNGJournalLine(Properties ctx, int PNG_JournalLine_ID, String trxName) {
        super(ctx, PNG_JournalLine_ID, trxName);
    }

    public MPNGJournalLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPNGJournalLine(MPNGJournal mParent, MPNGEntryTypeJrLine mDefaults) {
        super(mParent.getCtx(), 0, mParent.get_TrxName());
        PO.copyValues(mDefaults, this);
        this.setPNG_Journal_ID(mParent.getPNG_Journal_ID());
        this.setDescription(mParent);
        this.setIsGenerated(false);
    }

    public void setDescription(MPNGJournal journal) {
        if (Util.isEmpty(this.getDescription(), true)) {
            this.setDescription(journal.getDescription());
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isInvEntryCr() && this.isInvEntryDr()) {
            throw new AdempiereException("@PNG_OnlyOneOfIsInvCrDr@");
        }
        MPNGJournal journal = this.getParent();
        this.setDescription(journal);
        this.setDateAcct(journal.getDateAcct());
        if (this.getC_Period_ID() <= 0 || this.is_ValueChanged("DateAcct")) {
            MPeriod mPeriod = MPeriod.get(this.getCtx(), this.getDateAcct(), this.getAD_Org_ID());
            if (mPeriod == null) {
                throw new AdempiereException("@C_Period_ID@ @not.found@");
            }
            this.setC_Period_ID(mPeriod.getC_Period_ID());
        }
        return super.beforeSave(newRecord);
    }

    public MPNGJrLineInvoice[] getInvoiceLines(boolean requery) {
        String whereClause = "PNG_JournalLine_ID=?";
        List<MPNGJrLineInvoice> list = new Query(this.getCtx(), "PNG_JrLine_Invoice", "PNG_JournalLine_ID=?", this.get_TrxName()).setParameters(this.getPNG_JournalLine_ID()).setOrderBy("PNG_JrLine_Invoice_ID").list();
        MPNGJrLineInvoice[] retValue = new MPNGJrLineInvoice[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void updateAmtConversion(MPNGJournal mJournal) {
        if (!mJournal.isConvInput()) {
            this.setAmountConv(Env.ZERO);
            this.setAmtAcctCr(Env.ZERO);
            this.setAmtAcctDr(Env.ZERO);
        } else {
            int iPrecision = MCurrency.getStdPrecision(mJournal.getCtx(), mJournal.getC_Currency_ID());
            BigDecimal bdRate = mJournal.getPNGConversionRate();
            BigDecimal bdConvAmt = this.getAmount().divide(bdRate, iPrecision, RoundingMode.HALF_UP);
            this.setAmountConv(bdConvAmt);
            if (this.getAccountCr_ID() > 0) {
                this.setAmtAcctCr(bdConvAmt);
            }
            if (this.getAccountDr_ID() > 0) {
                this.setAmtAcctDr(bdConvAmt);
            }
        }
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        MPNGJournalLine[] lines;
        if (!success) {
            return success;
        }
        MPNGJournal journal = this.getParent();
        BigDecimal bdTotalCR = Env.ZERO;
        BigDecimal bdTotalDR = Env.ZERO;
        BigDecimal bdTotalAcctCR = Env.ZERO;
        BigDecimal bdTotalAcctDR = Env.ZERO;
        boolean bUpdTotalAcct = journal.isConvInput();
        MPNGJournalLine[] mPNGJournalLineArray = lines = journal.getLines(false);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MPNGJournalLine line = mPNGJournalLineArray[n2];
            bdTotalCR = bdTotalCR.add(line.getAmtSourceCr());
            bdTotalDR = bdTotalDR.add(line.getAmtSourceDr());
            bdTotalAcctCR = bdTotalAcctCR.add(line.getAmtAcctCr());
            bdTotalAcctDR = bdTotalAcctDR.add(line.getAmtAcctDr());
            ++n2;
        }
        journal.setTotalDr(bdTotalDR);
        journal.setTotalCr(bdTotalCR);
        if (bUpdTotalAcct) {
            journal.setTotalConvDr(bdTotalAcctDR);
            journal.setTotalConvCr(bdTotalAcctCR);
        }
        journal.saveEx();
        if (journal.isJournal() || journal.isCashJournal()) {
            this.updateParentTotals();
            MAccount acct = null;
            int C_AcctSchema_ID = journal.getC_AcctSchema_ID();
            MAcctSchema as = MAcctSchema.get(this.getCtx(), C_AcctSchema_ID);
            if (this.getAccountDr_ID() != 0) {
                acct = MAccount.get(this.getCtx(), Env.getAD_Client_ID(this.getCtx()), Env.getAD_Org_ID(this.getCtx()), as.getC_AcctSchema_ID(), this.getAccountDr_ID(), 0, 0, this.getC_BPartnerDr_ID(), 0, 0, 0, 0, this.getC_ProjectDr_ID(), 0, 0, 0, 0, 0, 0);
                acct.save();
            }
            if (this.getAccountCr_ID() != 0) {
                MAccount acct2 = null;
                acct2 = MAccount.get(this.getCtx(), Env.getAD_Client_ID(this.getCtx()), Env.getAD_Org_ID(this.getCtx()), as.getC_AcctSchema_ID(), this.getAccountCr_ID(), 0, 0, this.getC_BPartnerCr_ID(), 0, 0, 0, 0, this.getC_ProjectCr_ID(), 0, 0, 0, 0, 0, 0);
                acct2.save();
            }
        }
        return true;
    }

    protected void updateParentTotals() {
        String sql = new String("UPDATE PNG_Journal j SET (TotalDr, TotalCr) = (SELECT COALESCE(SUM(AmtSourceDr),0), COALESCE(SUM(AmtSourceCr),0) FROM PNG_JournalLine jl WHERE jl.IsActive='Y' AND j.PNG_Journal_ID=jl.PNG_Journal_ID) WHERE PNG_Journal_ID=" + this.getPNG_Journal_ID());
        int no = DB.executeUpdate(sql, this.get_TrxName());
        this.log.fine("Lines -> #" + no);
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        this.updateParentTotals();
        return true;
    }

    public static MPNGJournalLine getJournalLine(Properties ctx, int PNG_JournalLine_ID, String sTrx) {
        Query qJL = new Query(ctx, "PNG_JournalLine", "PNG_JournalLine_ID = ?", sTrx);
        qJL.setParameters(PNG_JournalLine_ID);
        return (MPNGJournalLine)qJL.firstOnly();
    }

    public static MPNGJournalLine getDrLineFromCashLine(Properties ctx, int C_CashLine_ID, String sTrx) {
        Query qDR = new Query(ctx, "PNG_JournalLine", "C_CashLineDr_ID = ?", sTrx);
        qDR.setParameters(C_CashLine_ID);
        return (MPNGJournalLine)qDR.firstOnly();
    }

    public static MPNGJournalLine getCrLineFromCashLine(Properties ctx, int C_CashLine_ID, String sTrx) {
        Query qCR = new Query(ctx, "PNG_JournalLine", "C_CashLineCr_ID = ?", sTrx);
        qCR.setParameters(C_CashLine_ID);
        return (MPNGJournalLine)qCR.firstOnly();
    }

    public static void clearCashLineFromJournalLines(int C_CashLine_ID, String sTrx) {
        String sClearCR = "UPDATE PNG_JournalLine SET C_CashLineCr_ID = null where C_CashLineCr_ID = ?";
        String sClearDR = "UPDATE PNG_JournalLine SET C_CashLineDr_ID = null where C_CashLineDr_ID = ?";
        DB.executeUpdate("UPDATE PNG_JournalLine SET C_CashLineCr_ID = null where C_CashLineCr_ID = ?", C_CashLine_ID, sTrx);
        DB.executeUpdate("UPDATE PNG_JournalLine SET C_CashLineDr_ID = null where C_CashLineDr_ID = ?", C_CashLine_ID, sTrx);
    }

    public MPNGJournal getParent() {
        Query qJ = new Query(this.getCtx(), "PNG_Journal", "PNG_Journal_ID = ?", this.get_TrxName());
        qJ.setParameters(this.getPNG_Journal_ID());
        return (MPNGJournal)qJ.firstOnly();
    }

    public MCashLine createCashLine(MCash mCash, MTax mTax, boolean bDR) {
        int Account_ID = bDR ? this.getAccountDr_ID() : this.getAccountCr_ID();
        BigDecimal bdAmount = null;
        bdAmount = bDR ? this.getAmtSourceDr().negate() : this.getAmtSourceCr();
        MPNGJournal mParent = this.getParent();
        MCashLine mCashLine = new MCashLine(mCash);
        mCashLine.setDescription(this.getDescription());
        MBankAccount mBankAccount = mParent.getBankAccount(Account_ID);
        if (mBankAccount != null) {
            mCashLine.setC_BankAccount_ID(mBankAccount.getC_BankAccount_ID());
            mCashLine.setCashType("T");
        } else {
            MCharge mCharge = mParent.getOrCreateCharge(Account_ID, mTax.getC_Tax_ID());
            mCashLine.setC_Charge_ID(mCharge.getC_Charge_ID());
            mCashLine.setCashType("C");
        }
        mCashLine.setC_Currency_ID(mParent.getC_Currency_ID());
        mCashLine.setAmount(bdAmount);
        return mCashLine;
    }

    public static boolean isConvInput(SetGetModel mJournalLine) {
        Integer PNG_Journal_ID = SetGetUtil.get_AttrValueAsInt(mJournalLine, "PNG_Journal_ID");
        if (PNG_Journal_ID > 0) {
            MPNGJournal mJournal = MPNGJournal.get(mJournalLine.getCtx(), PNG_Journal_ID, mJournalLine.get_TrxName());
            return mJournal.isConvInput();
        }
        return false;
    }

    public static MPNGJournal getJournal(SetGetModel mJournalLine) {
        Integer PNG_Journal_ID = SetGetUtil.get_AttrValueAsInt(mJournalLine, "PNG_Journal_ID");
        return MPNGJournal.get(mJournalLine.getCtx(), PNG_Journal_ID, mJournalLine.get_TrxName());
    }
}

